/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import timetable.data.Activity;
import timetable.data.ActivityDependenceInterface;
import timetable.data.ActivityGroup;

public abstract class AbstractActivityDependence
implements ActivityDependenceInterface {
    protected Activity first;
    protected Activity second;
    protected int type = 0;

    public AbstractActivityDependence() {
        this(null, null);
    }

    public AbstractActivityDependence(Activity first, Activity second) {
        this.first = first;
        this.second = second;
    }

    public abstract boolean isOK(int var1, int var2);

    public abstract String getDependenceName();

    public abstract String[] getTypes();

    public int getType() {
        return this.type;
    }

    public boolean isOK() {
        return this.isOK(this.first.start, this.second.start);
    }

    public boolean isOK(Activity a, int start) {
        if (a == this.first) {
            return this.isOK(start, this.second.start);
        }
        if (a == this.second) {
            return this.isOK(this.first.start, start);
        }
        return true;
    }

    public Activity getFirstActivity() {
        return this.first;
    }

    public Activity getSecondActivity() {
        return this.second;
    }

    public Activity getAnotherActivity(Activity a) {
        if (a == this.first) {
            return this.second;
        }
        if (a == this.second) {
            return this.first;
        }
        return null;
    }

    public boolean participate(Activity a) {
        return a == this.first || a == this.second;
    }

    public abstract void write(ObjectOutputStream var1, ActivityGroup var2) throws IOException;

    public abstract ActivityDependenceInterface read(ObjectInputStream var1, ActivityGroup var2) throws IOException, ClassNotFoundException;

    public void setFirstActivity(Activity a) {
        this.first = a;
    }

    public void setSecondActivity(Activity b) {
        this.second = b;
    }

    public void setType(int i) {
        this.type = i;
    }
}

