/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import timetable.util.Config;
import timetable.util.TimetableException;

public class TimePreference
implements Serializable {
    protected int[] slots = null;
    Config config = null;
    public static int FREE = 0;
    public static int HARD = 1;
    public static int SOFT = 2;

    public TimePreference(Config config) throws TimetableException {
        this.config = config;
        this.slots = new int[config.getInt(Config.NR_SLOTS)];
        int i = 0;
        while (i < this.slots.length) {
            this.slots[i] = FREE;
            ++i;
        }
    }

    public void set(int slot, int type) {
        this.slots[slot] = type;
    }

    public int get(int slot) {
        return this.slots[slot];
    }

    public void setFREE(int slot) {
        this.set(slot, FREE);
    }

    public void setSOFT(int slot) {
        this.set(slot, SOFT);
    }

    public void setHARD(int slot) {
        this.set(slot, HARD);
    }

    public void set(int startSlot, int endSlot, int type) {
        int i = startSlot;
        while (i <= endSlot) {
            this.set(i, type);
            ++i;
        }
    }

    public boolean isHARD(int slot) {
        return this.get(slot) == HARD;
    }

    public boolean isFREE(int slot) {
        return this.get(slot) == FREE;
    }

    public boolean isSOFT(int slot) {
        return this.get(slot) == SOFT;
    }

    public String toString(int type) throws TimetableException {
        int slot = 0;
        int nrDays = this.config.getInt(Config.NR_DAYS);
        int nrSlots = this.config.getInt(Config.NR_SLOTS);
        int nrSlotsPerDay = nrSlots / nrDays;
        StringBuffer r = new StringBuffer();
        do {
            if (this.get(slot) == type) {
                int j = slot;
                int day = slot / nrSlotsPerDay;
                while (j < nrSlots && this.get(j) == type && j / nrSlotsPerDay == day) {
                    ++j;
                }
                if (slot == --j) {
                    r.append("" + this.config.dayOfWeek(j) + " " + (j % nrSlotsPerDay + 1) + ",");
                } else {
                    r.append("" + this.config.dayOfWeek(slot) + " " + (slot % nrSlotsPerDay + 1) + "-" + (j % nrSlotsPerDay + 1) + ",");
                }
                slot = j + 1;
                continue;
            }
            ++slot;
        } while (slot < nrSlots);
        if (r.toString().length() > 0) {
            r.deleteCharAt(r.toString().length() - 1);
        }
        return r.toString();
    }

    public Object clone() {
        try {
            TimePreference p = new TimePreference(this.config);
            int i = 0;
            while (i < p.slots.length) {
                p.slots[i] = this.slots[i];
                ++i;
            }
            return p;
        }
        catch (TimetableException timetableException) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.slots);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.slots = (int[])in.readObject();
    }
}

