/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.util.Vector;
import javax.swing.JTable;
import timetable.data.Activity;
import timetable.data.ActivityResources;
import timetable.data.Problem;
import timetable.data.Resource;
import timetable.gui.DNDEvent;
import timetable.gui.DNDListener;
import timetable.gui.DNDTableEngine;
import timetable.gui.TimeTableModel;
import timetable.school.gui.ActivityModelInterface;
import timetable.school.gui.DNDDataTable;
import timetable.solver.Solver;

public class DNDActivityEngine
implements DNDTableEngine {
    private Activity dActivity = null;
    private JTable dSource = null;
    private Solver solver = null;
    private Problem problem = null;
    protected Vector listenerList = new Vector();

    public DNDActivityEngine(Problem problem, Solver solver) {
        this.problem = problem;
        this.solver = solver;
    }

    public boolean canDrag(int row, int column, JTable source) {
        if (source.getModel() instanceof TimeTableModel) {
            boolean ret = ((TimeTableModel)source.getModel()).getActivityAt(row, column) != null;
            return ret;
        }
        if (source instanceof DNDDataTable) {
            boolean ret = row >= 0;
            return ret;
        }
        return false;
    }

    public boolean canDrag(int slot, Activity a, Resource r) {
        return a != null;
    }

    public void drag(int row, int column, JTable source) {
        if (source.getModel() instanceof TimeTableModel) {
            this.dActivity = ((TimeTableModel)source.getModel()).getActivityAt(row, column);
        }
        if (source instanceof DNDDataTable) {
            this.dActivity = ((ActivityModelInterface)((Object)source.getModel())).getActivities().get(row);
        }
        this.dSource = source;
        this.fireDNDListenerDrag(source, row, column);
    }

    public void drag(int slot, Activity a, Object source) {
        this.dActivity = a;
        this.dSource = null;
        this.fireDNDListenerDrag(source, slot);
    }

    public boolean canDrop(int row, int column, JTable target) {
        if (target.getModel() instanceof TimeTableModel) {
            TimeTableModel m = (TimeTableModel)target.getModel();
            if (m.resources == null || column == 0) {
                return false;
            }
            try {
                boolean ret = this.dActivity.resources.contains(m.resources.get(row)) >= 0 && m.resources.get(row).canBeFreeAt(column - 1, this.dActivity.length) && this.dActivity.canScheduleAt(column - 1, this.problem.dependences);
                return ret;
            }
            catch (Exception e) {
                System.err.println("canDrop(row=" + row + ",column=" + column + ")=false (exception " + e.getMessage() + ")");
                return false;
            }
        }
        return target instanceof DNDDataTable;
    }

    public boolean canDrop(int slot, Activity a, Resource r) {
        try {
            boolean ret = this.dActivity.resources.contains(r) >= 0 && r.canBeFreeAt(slot, this.dActivity.length) && this.dActivity.canScheduleAt(slot, this.problem.dependences);
            return ret;
        }
        catch (Exception e) {
            System.err.println("canDrop(slot=" + slot + ")=false (exception " + e.getMessage() + ")");
            return false;
        }
    }

    public void drop(int row, int column, JTable target) {
        if (this.dSource == null) {
            this.dActivity.remove(this.dActivity);
        } else if (this.dSource.getModel() instanceof TimeTableModel && target.getModel() instanceof TimeTableModel) {
            TimeTableModel m = (TimeTableModel)target.getModel();
            Resource resource = m.resources.get(row);
            ActivityResources selectedResources = (ActivityResources)this.dActivity.selectedResources.clone();
            int start = this.dActivity.start;
            this.dActivity.remove(this.dActivity);
            boolean ret = false;
            try {
                ret = this.solver.schedule(this.dActivity, column - 1, resource);
                if (!ret) {
                    this.dActivity.schedule(start, selectedResources);
                }
            }
            catch (Exception e) {
                System.err.println("  exception " + e.getMessage());
            }
        } else if (this.dSource.getModel() instanceof TimeTableModel && target instanceof DNDDataTable) {
            this.dActivity.remove(this.dActivity);
        } else if (this.dSource instanceof DNDDataTable && target.getModel() instanceof TimeTableModel) {
            TimeTableModel m = (TimeTableModel)target.getModel();
            Resource resource = m.resources.get(row);
            boolean ret = false;
            try {
                ret = this.solver.schedule(this.dActivity, column - 1, resource);
            }
            catch (Exception e) {
                System.err.println("  exception " + e.getMessage());
            }
        }
        this.fireDNDListenerDrop(target, row, column);
    }

    public void drop(int slot, Resource r, Object source) {
        if (this.dActivity.isScheduled()) {
            ActivityResources selectedResources = (ActivityResources)this.dActivity.selectedResources.clone();
            int start = this.dActivity.start;
            this.dActivity.remove(this.dActivity);
            boolean ret = false;
            try {
                ret = this.solver.schedule(this.dActivity, slot, r);
                if (!ret) {
                    this.dActivity.schedule(start, selectedResources);
                }
            }
            catch (Exception e) {
                System.err.println("  exception " + e.getMessage());
            }
        } else {
            try {
                this.solver.schedule(this.dActivity, slot, r);
            }
            catch (Exception e) {
                System.err.println("  exception " + e.getMessage());
            }
        }
        this.fireDNDListenerDrop(source, slot);
    }

    public void done() {
        this.dActivity = null;
    }

    public void addDNDListener(DNDListener l) {
        this.listenerList.add(l);
    }

    public void removeDNDListener(DNDListener l) {
        this.listenerList.remove(l);
    }

    protected void fireDNDListenerDrop(Object source, int slot) {
        DNDEvent dndEvent = null;
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            if (dndEvent == null) {
                dndEvent = new DNDEvent(source, slot);
            }
            ((DNDListener)this.listenerList.get(i)).drop(dndEvent);
            --i;
        }
    }

    protected void fireDNDListenerDrag(Object source, int slot) {
        DNDEvent dndEvent = null;
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            if (dndEvent == null) {
                dndEvent = new DNDEvent(source, slot);
            }
            ((DNDListener)this.listenerList.get(i)).drag(dndEvent);
            --i;
        }
    }

    protected void fireDNDListenerDrop(Object source, int row, int column) {
        DNDEvent dndEvent = null;
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            if (dndEvent == null) {
                dndEvent = new DNDEvent(source, row, column);
            }
            ((DNDListener)this.listenerList.get(i)).drop(dndEvent);
            --i;
        }
    }

    protected void fireDNDListenerDrag(Object source, int row, int column) {
        DNDEvent dndEvent = null;
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            if (dndEvent == null) {
                dndEvent = new DNDEvent(source, row, column);
            }
            ((DNDListener)this.listenerList.get(i)).drag(dndEvent);
            --i;
        }
    }
}

