/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Cursor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import timetable.gui.DNDTableEngine;
import timetable.gui.DefaultDNDTableEngine;

public class DNDTable
extends JTable
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    protected DNDTableEngine dndEngine = null;
    protected Cursor cursor;
    DropTarget dropTarget = null;
    DragSource dragSource = null;

    public void setDNDTableEngine(DNDTableEngine dndEngine) {
        this.dndEngine = dndEngine;
    }

    public DNDTable() {
        this.init();
    }

    public DNDTable(TableModel model) {
        super(model);
        this.init();
    }

    public void init() {
        this.dndEngine = new DefaultDNDTableEngine();
        this.cursor = this.getCursor();
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void dragEnter(DropTargetDragEvent event) {
    }

    public void dragExit(DropTargetEvent event) {
        this.setCursor(this.cursor);
    }

    public void dragOver(DropTargetDragEvent event) {
        if (this.dndEngine.canDrop(this.rowAtPoint(event.getLocation()), this.columnAtPoint(event.getLocation()), this)) {
            event.acceptDrag(2);
            this.setCursor(DragSource.DefaultMoveDrop);
        } else {
            event.rejectDrag();
            this.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public void drop(DropTargetDropEvent event) {
        int row = this.rowAtPoint(event.getLocation());
        int column = this.columnAtPoint(event.getLocation());
        if (row >= 0 && column >= 0 && this.dndEngine.canDrop(row, column, this)) {
            this.dndEngine.drop(row, column, this);
            this.updateUI();
        } else {
            event.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent event) {
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        if (this.dndEngine.canDrag(this.getSelectedRow(), this.getSelectedColumn(), this)) {
            StringSelection text = new StringSelection("DNDTable Drag & Drop Feature");
            this.cursor = this.getCursor();
            this.dragSource.startDrag(event, null, text, this);
            this.dndEngine.drag(this.getSelectedRow(), this.getSelectedColumn(), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        this.setCursor(this.cursor);
        this.dndEngine.done();
    }

    public void dragEnter(DragSourceDragEvent event) {
    }

    public void dragExit(DragSourceEvent event) {
        this.setCursor(this.cursor);
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dropActionChanged(DragSourceDragEvent event) {
    }
}

