/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import timetable.util.Config;
import timetable.util.Loc;

public class SolverRightsPanel
extends JPanel {
    private Config config = null;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JSlider valueSoftActivitySld;
    private JSlider valueSoftResourceSld;
    private JSlider valueNrRemovesSld;
    private JSlider valueCycleSld;
    private JSlider valueColisionSld;
    private JSlider valueRemovedActHasConflictSld;
    private JSlider valueAnotherPlaceSld;
    private JPanel jPanel5;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JSlider tabuLengthSld;
    private JSlider topLengthSld;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JLabel jLabel15;
    private JCheckBox jCheckBox1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JCheckBox jCheckBox2;
    private JSlider nrFreePlacesSld;
    private JSlider nrPlacesSld;
    private JSlider nrRemovesSld;
    private JSlider nrDependencesSld;
    private JPanel jPanel4;
    private JSlider maxNrIterationsSld;

    public SolverRightsPanel() {
        this.initComponents();
        this.init(this);
    }

    public void setConfig(Config config) {
        this.config = config;
        this.loadData();
        this.updateUI();
    }

    private void loadData(Container container) {
        try {
            int n = 0;
            while (n < container.getComponentCount()) {
                Component component = container.getComponent(n);
                if (component instanceof Container) {
                    this.loadData((Container)component);
                }
                if (component instanceof JTextField && component.getName() != null) {
                    ((JTextField)component).setText(this.config.get(component.getName()));
                }
                if (component instanceof JCheckBox && component.getName() != null) {
                    ((JCheckBox)component).setSelected(this.config.getInt(component.getName()) > 0);
                }
                if (component instanceof JSlider && component.getName() != null) {
                    ((JSlider)component).setValue(this.config.getInt(component.getName()));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Error:" + exception);
        }
    }

    public void loadData() {
        this.loadData(this);
        this.updateEnable();
    }

    private void storeData(Container container) {
        try {
            int n = 0;
            while (n < container.getComponentCount()) {
                Component component = container.getComponent(n);
                if (component instanceof Container) {
                    this.storeData((Container)component);
                }
                if (component instanceof JTextField && component.getName() != null) {
                    this.config.set(component.getName(), Integer.parseInt(((JTextField)component).getText()));
                }
                if (component instanceof JCheckBox && component.getName() != null) {
                    this.config.set(component.getName(), ((JCheckBox)component).isSelected() ? 1 : 0);
                }
                if (component instanceof JSlider && component.getName() != null) {
                    this.config.set(component.getName(), ((JSlider)component).getValue());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Error:" + exception);
        }
    }

    public void storeData() {
        try {
            this.storeData(this);
        }
        catch (Exception exception) {
            System.err.println("Error:" + exception);
        }
    }

    private void init(Container container) {
        try {
            int n = 0;
            while (n < container.getComponentCount()) {
                JComponent jComponent;
                Component component = container.getComponent(n);
                if (component instanceof JSlider) {
                    jComponent = (JSlider)component;
                    ((JSlider)jComponent).addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            try {
                                ((JSlider)changeEvent.getSource()).setToolTipText(String.valueOf(((JSlider)changeEvent.getSource()).getValue()));
                                SolverRightsPanel.this.config.set(((JSlider)changeEvent.getSource()).getName(), ((JSlider)changeEvent.getSource()).getValue());
                            }
                            catch (Exception exception) {
                                System.err.println("Error: " + exception);
                                exception.printStackTrace();
                            }
                        }
                    });
                } else if (component instanceof JCheckBox) {
                    jComponent = (JCheckBox)component;
                    ((AbstractButton)jComponent).addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            try {
                                SolverRightsPanel.this.config.set(((JCheckBox)changeEvent.getSource()).getName(), ((JCheckBox)changeEvent.getSource()).isSelected() ? 1 : 0);
                            }
                            catch (Exception exception) {
                                System.err.println("Error: " + exception);
                                exception.printStackTrace();
                            }
                        }
                    });
                } else if (component instanceof Container) {
                    if (component instanceof JPanel && (jComponent = (JPanel)component).getBorder() instanceof TitledBorder) {
                        TitledBorder titledBorder = (TitledBorder)jComponent.getBorder();
                        titledBorder.setTitle(Loc.get(titledBorder.getTitle()));
                    }
                    this.init((Container)component);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Error:" + exception);
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.valueSoftActivitySld = new JSlider();
        this.valueSoftResourceSld = new JSlider();
        this.valueNrRemovesSld = new JSlider();
        this.valueCycleSld = new JSlider();
        this.valueColisionSld = new JSlider();
        this.valueRemovedActHasConflictSld = new JSlider();
        this.valueAnotherPlaceSld = new JSlider();
        this.jPanel5 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.tabuLengthSld = new JSlider();
        this.topLengthSld = new JSlider();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.nrFreePlacesSld = new JSlider();
        this.nrPlacesSld = new JSlider();
        this.nrRemovesSld = new JSlider();
        this.nrDependencesSld = new JSlider();
        this.jPanel4 = new JPanel();
        this.maxNrIterationsSld = new JSlider();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("timetable.weight.value"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("timetable.weight.value.price"));
        this.jLabel2.setText(Loc.get("timetable.weight.value.soft.activity"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(Loc.get("timetable.weight.value.soft.resource"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(Loc.get("timetable.weight.value.nrremoves"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(Loc.get("timetable.weight.value.cycle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setText(Loc.get("timetable.weight.value.remove.another"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setText(Loc.get("timetable.weight.value.remove.activity.conflict"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel8.setText(Loc.get("timetable.weight.value.another.place"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.valueSoftActivitySld.setPreferredSize(new Dimension(100, 16));
        this.valueSoftActivitySld.setName("OHODNOCENI_VAHA_SOFT_AKTIVITY");
        this.valueSoftActivitySld.setMaximum(50);
        this.valueSoftActivitySld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueSoftActivitySld, gridBagConstraints);
        this.valueSoftResourceSld.setPreferredSize(new Dimension(100, 16));
        this.valueSoftResourceSld.setName("OHODNOCENI_VAHA_SOFT_ZDROJE");
        this.valueSoftResourceSld.setMaximum(50);
        this.valueSoftResourceSld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueSoftResourceSld, gridBagConstraints);
        this.valueNrRemovesSld.setPreferredSize(new Dimension(100, 16));
        this.valueNrRemovesSld.setName("OHODNOCENI_VAHA_POCTU_VYHOZENI");
        this.valueNrRemovesSld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueNrRemovesSld, gridBagConstraints);
        this.valueCycleSld.setPreferredSize(new Dimension(100, 16));
        this.valueCycleSld.setName("OHODNOCENI_VAHA_CYKLUS");
        this.valueCycleSld.setMaximum(2000);
        this.valueCycleSld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueCycleSld, gridBagConstraints);
        this.valueColisionSld.setPreferredSize(new Dimension(100, 16));
        this.valueColisionSld.setName("OHODNOCENI_VAHA_JINA_AKTIVITA");
        this.valueColisionSld.setMaximum(500);
        this.valueColisionSld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueColisionSld, gridBagConstraints);
        this.valueRemovedActHasConflictSld.setPreferredSize(new Dimension(100, 16));
        this.valueRemovedActHasConflictSld.setName("OHODNOCENI_VAHA_VYHOZENA_VYHODI_JINOU");
        this.valueRemovedActHasConflictSld.setMaximum(500);
        this.valueRemovedActHasConflictSld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueRemovedActHasConflictSld, gridBagConstraints);
        this.valueAnotherPlaceSld.setPreferredSize(new Dimension(100, 16));
        this.valueAnotherPlaceSld.setName("OHODNOCENI_VAHA_JINAM");
        this.valueAnotherPlaceSld.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.jPanel1.add((Component)this.valueAnotherPlaceSld, gridBagConstraints);
        this.jPanel5.setPreferredSize(new Dimension(340, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.ipadx = 2;
        gridBagConstraints2.ipady = 2;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints2);
        this.jLabel9.setText(Loc.get("timetable.weight.tabu.length"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.ipadx = 2;
        gridBagConstraints2.ipady = 2;
        gridBagConstraints2.anchor = 17;
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints2);
        this.jLabel10.setText(Loc.get("timetable.weight.top.selection.size"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.ipadx = 2;
        gridBagConstraints2.ipady = 2;
        gridBagConstraints2.anchor = 17;
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints2);
        this.tabuLengthSld.setPreferredSize(new Dimension(100, 16));
        this.tabuLengthSld.setName("DELKA_TABU");
        this.tabuLengthSld.setMaximum(200);
        this.tabuLengthSld.setValue(0);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.ipadx = 2;
        gridBagConstraints2.ipady = 2;
        this.jPanel2.add((Component)this.tabuLengthSld, gridBagConstraints2);
        this.topLengthSld.setPreferredSize(new Dimension(100, 16));
        this.topLengthSld.setName("VYBER_HODNOTY_POCET_TOP");
        this.topLengthSld.setMaximum(20);
        this.topLengthSld.setValue(0);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.ipadx = 2;
        gridBagConstraints2.ipady = 2;
        this.jPanel2.add((Component)this.topLengthSld, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.ipadx = 2;
        gridBagConstraints3.ipady = 2;
        this.add((Component)this.jPanel2, gridBagConstraints3);
        this.jLabel1.setBorder(new EmptyBorder(new Insets(0, 5, 0, 0)));
        this.jLabel1.setText(Loc.get("timetable.weight.max.iterations"));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.ipadx = 3;
        gridBagConstraints3.ipady = 10;
        this.add((Component)this.jLabel1, gridBagConstraints3);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(new TitledBorder("timetable.weight.variable"));
        this.jLabel15.setText(Loc.get("timetable.weight.variable.randomly"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 17;
        this.jPanel3.add((Component)this.jLabel15, gridBagConstraints4);
        this.jCheckBox1.setToolTipText("P\u0159edm\u011bt bude vybr\u00e1n n\u00e1hodn\u011b.");
        this.jCheckBox1.setName("VYBER_PROM_NAHODNE");
        this.jCheckBox1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SolverRightsPanel.this.jCheckBox1MouseClicked(mouseEvent);
            }
        });
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        this.jPanel3.add((Component)this.jCheckBox1, gridBagConstraints4);
        this.jLabel11.setText(Loc.get("timetable.weight.variable.number.free.places"));
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 17;
        this.jPanel3.add((Component)this.jLabel11, gridBagConstraints4);
        this.jLabel12.setText(Loc.get("timetable.weight.variable.number.places"));
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 17;
        this.jPanel3.add((Component)this.jLabel12, gridBagConstraints4);
        this.jLabel13.setText(Loc.get("timetable.weight.variable.number.removes"));
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 17;
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints4);
        this.jLabel14.setText(Loc.get("timetable.weight.variable.number.dependencies"));
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 17;
        this.jPanel3.add((Component)this.jLabel14, gridBagConstraints4);
        this.jLabel16.setText(Loc.get("timetable.weight.variable.select.from.all"));
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 17;
        this.jPanel3.add((Component)this.jLabel16, gridBagConstraints4);
        this.jCheckBox2.setToolTipText("V\u00fdb\u011br se provede ze v\u0161ech neza\u0159azen\u00fdch p\u0159edm\u011bt\u016f nebo pouze z pom\u011brn\u00e9 \u010d\u00e1sti (cca 20 %).");
        this.jCheckBox2.setName("VYBER_PROM_VSECHNY");
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 5;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        this.jPanel3.add((Component)this.jCheckBox2, gridBagConstraints4);
        this.nrFreePlacesSld.setPreferredSize(new Dimension(100, 16));
        this.nrFreePlacesSld.setName("VYBER_PROM_VAHA_MISTA_BEZ_KONFLIKTU");
        this.nrFreePlacesSld.setMaximum(2000);
        this.nrFreePlacesSld.setValue(0);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        this.jPanel3.add((Component)this.nrFreePlacesSld, gridBagConstraints4);
        this.nrPlacesSld.setPreferredSize(new Dimension(100, 16));
        this.nrPlacesSld.setName("VYBER_PROM_VAHA_MISTA");
        this.nrPlacesSld.setMaximum(250);
        this.nrPlacesSld.setValue(0);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        this.jPanel3.add((Component)this.nrPlacesSld, gridBagConstraints4);
        this.nrRemovesSld.setPreferredSize(new Dimension(100, 16));
        this.nrRemovesSld.setName("VYBER_PROM_VAHA_VYHOZENI");
        this.nrRemovesSld.setMinimum(-20);
        this.nrRemovesSld.setValue(0);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        this.jPanel3.add((Component)this.nrRemovesSld, gridBagConstraints4);
        this.nrDependencesSld.setPreferredSize(new Dimension(100, 16));
        this.nrDependencesSld.setName("VYBER_PROM_VAHA_ZAVISLOSTI");
        this.nrDependencesSld.setMaximum(250);
        this.nrDependencesSld.setValue(0);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        this.jPanel3.add((Component)this.nrDependencesSld, gridBagConstraints4);
        this.jPanel4.setPreferredSize(new Dimension(350, 0));
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridwidth = 2;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints4);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.ipadx = 2;
        gridBagConstraints3.ipady = 2;
        gridBagConstraints3.anchor = 11;
        this.add((Component)this.jPanel3, gridBagConstraints3);
        this.maxNrIterationsSld.setPreferredSize(new Dimension(100, 16));
        this.maxNrIterationsSld.setName("POCET_ITERACI");
        this.maxNrIterationsSld.setMaximum(10000);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.ipadx = 2;
        gridBagConstraints3.ipady = 2;
        this.add((Component)this.maxNrIterationsSld, gridBagConstraints3);
    }

    private void jCheckBox1MouseClicked(MouseEvent mouseEvent) {
        this.updateEnable();
    }

    private void updateEnable() {
        this.nrFreePlacesSld.setEnabled(!this.jCheckBox1.isSelected());
        this.nrPlacesSld.setEnabled(!this.jCheckBox1.isSelected());
        this.nrRemovesSld.setEnabled(!this.jCheckBox1.isSelected());
        this.nrDependencesSld.setEnabled(!this.jCheckBox1.isSelected());
        this.jCheckBox2.setEnabled(!this.jCheckBox1.isSelected());
    }
}

