/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Vector;

public class TableLayout
implements LayoutManager2 {
    private Vector components;
    private Vector sizes;
    private int rows;
    private int cols;
    private int vgap;
    private int hgap;
    private boolean resizable = false;

    public TableLayout() {
        this(1, 1, 0, 0);
    }

    public TableLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap) {
        if (rows == 0 || cols == 0) {
            throw new IllegalArgumentException("rows or cols cannot be zero");
        }
        this.rows = rows;
        this.cols = cols;
        this.components = new Vector();
        this.sizes = new Vector();
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 || this.cols == 0) {
            throw new IllegalArgumentException("rows or cols cannot be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (this.rows == 0 || cols == 0) {
            throw new IllegalArgumentException("rows or cols cannot be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean getResizable() {
        return this.resizable;
    }

    public Component getComponentAt(int row, int col) {
        int i = 0;
        while (i < this.sizes.size()) {
            Rectangle rect = (Rectangle)this.sizes.get(i);
            if (rect.x >= col && col < rect.x + rect.width && rect.y >= row && row < rect.y + rect.height) {
                return (Component)this.components.get(i);
            }
            ++i;
        }
        return null;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public Component getComponent(int i) {
        return (Component)this.components.get(i);
    }

    public void addLayoutComponent(String str, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        Rectangle rect = null;
        if (constraints instanceof Rectangle) {
            rect = (Rectangle)constraints;
        } else if (constraints instanceof Dimension) {
            int i = 0;
            while (this.getComponentAt(i / this.cols, i % this.cols) != null && i < this.rows * this.cols) {
                ++i;
            }
            if (i >= this.rows * this.cols) {
                return;
            }
            Dimension d = (Dimension)constraints;
            rect = new Rectangle(i % this.cols, i / this.cols, d.width, d.height);
        } else {
            int i = 0;
            while (this.getComponentAt(i / this.cols, i % this.cols) != null && i < this.rows * this.cols) {
                ++i;
            }
            if (i >= this.rows * this.cols) {
                return;
            }
            rect = new Rectangle(i % this.cols, i / this.cols, 1, 1);
        }
        if (rect == null) {
            return;
        }
        this.components.add(comp);
        this.sizes.add(rect);
    }

    public void removeLayoutComponent(Component component) {
        if (this.components.indexOf(component) >= 0) {
            this.sizes.remove(this.components.indexOf(component));
            this.components.remove(this.components.indexOf(component));
        }
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (ncomponents == 0) {
                return;
            }
            int width = parent.getWidth() - (insets.left + insets.right);
            int height = parent.getHeight() - (insets.top + insets.bottom);
            width -= (ncols - 1) * this.hgap;
            height -= (nrows - 1) * this.vgap;
            int[] w = new int[this.cols];
            int i = 0;
            while (i < w.length) {
                w[i] = 0;
                ++i;
            }
            int[] h = new int[this.rows];
            int i2 = 0;
            while (i2 < h.length) {
                h[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.components.size()) {
                Rectangle rect = (Rectangle)this.sizes.get(i2);
                Component comp = (Component)this.components.get(i2);
                Dimension d = comp.getPreferredSize();
                int dw = d.width / rect.width;
                int dh = d.height / rect.height;
                int c = rect.x;
                while (c < rect.x + rect.width) {
                    int r = rect.y;
                    while (r < rect.y + rect.height) {
                        w[c] = this.max2(w[c], dw);
                        h[r] = this.max2(h[r], dh);
                        ++r;
                    }
                    ++c;
                }
                ++i2;
            }
            int maxw = 0;
            int i3 = 0;
            while (i3 < w.length) {
                maxw += w[i3];
                if (i3 > 0) {
                    int n = i3;
                    w[n] = w[n] + (w[i3 - 1] + i3 * this.hgap);
                }
                ++i3;
            }
            int maxh = 0;
            int i4 = 0;
            while (i4 < h.length) {
                maxh += h[i4];
                if (i4 > 0) {
                    int n = i4;
                    h[n] = h[n] + (h[i4 - 1] + i4 * this.vgap);
                }
                ++i4;
            }
            if (this.resizable) {
                double wMx = (double)width / (double)maxw;
                double hMx = (double)height / (double)maxh;
                int i5 = 0;
                while (i5 < this.components.size()) {
                    Rectangle rect = (Rectangle)this.sizes.get(i5);
                    Component comp = (Component)this.components.get(i5);
                    comp.setBounds(insets.left + (int)(wMx * (double)(rect.x <= 0 ? 0 : w[rect.x - 1]) + 0.5), insets.top + (int)(hMx * (double)(rect.y <= 0 ? 0 : h[rect.y - 1]) + 0.5), (int)(wMx * (double)comp.getPreferredSize().width + 0.5), (int)(hMx * (double)comp.getPreferredSize().height + 0.5));
                    ++i5;
                }
            } else {
                i4 = 0;
                while (i4 < this.components.size()) {
                    Rectangle rect = (Rectangle)this.sizes.get(i4);
                    Component comp = (Component)this.components.get(i4);
                    comp.setBounds(insets.left + (rect.x <= 0 ? 0 : w[rect.x - 1]), insets.top + (rect.y <= 0 ? 0 : h[rect.y - 1]), comp.getPreferredSize().width, comp.getPreferredSize().height);
                    ++i4;
                }
            }
        }
    }

    private int min2(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private int max2(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int[] w = new int[this.cols];
            int i = 0;
            while (i < w.length) {
                w[i] = 0;
                ++i;
            }
            int[] h = new int[this.rows];
            int i2 = 0;
            while (i2 < h.length) {
                h[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.components.size()) {
                Rectangle rect = (Rectangle)this.sizes.get(i2);
                Component comp = (Component)this.components.get(i2);
                Dimension d = comp.getMinimumSize();
                int dw = d.width / rect.width;
                int dh = d.height / rect.height;
                int c = rect.x;
                while (c < rect.x + rect.width) {
                    int r = rect.y;
                    while (r < rect.y + rect.height) {
                        w[c] = this.max2(w[c], dw);
                        h[r] = this.max2(h[r], dh);
                        ++r;
                    }
                    ++c;
                }
                ++i2;
            }
            int maxw = 0;
            int i3 = 0;
            while (i3 < w.length) {
                maxw += w[i3];
                ++i3;
            }
            int maxh = 0;
            int i4 = 0;
            while (i4 < h.length) {
                maxh += h[i4];
                ++i4;
            }
            return new Dimension(insets.left + insets.right + maxw + (this.cols - 1) * this.hgap, insets.top + insets.bottom + maxh + (this.rows - 1) * this.vgap);
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int[] w = new int[this.cols];
            int i = 0;
            while (i < w.length) {
                w[i] = 0;
                ++i;
            }
            int[] h = new int[this.rows];
            int i2 = 0;
            while (i2 < h.length) {
                h[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.components.size()) {
                Rectangle rect = (Rectangle)this.sizes.get(i2);
                Component comp = (Component)this.components.get(i2);
                Dimension d = comp.getPreferredSize();
                int dw = d.width / rect.width;
                int dh = d.height / rect.height;
                int c = rect.x;
                while (c < rect.x + rect.width) {
                    int r = rect.y;
                    while (r < rect.y + rect.height) {
                        w[c] = this.max2(w[c], dw);
                        h[r] = this.max2(h[r], dh);
                        ++r;
                    }
                    ++c;
                }
                ++i2;
            }
            int maxw = 0;
            int i3 = 0;
            while (i3 < w.length) {
                maxw += w[i3];
                ++i3;
            }
            int maxh = 0;
            int i4 = 0;
            while (i4 < h.length) {
                maxh += h[i4];
                ++i4;
            }
            return new Dimension(insets.left + insets.right + maxw + (this.cols - 1) * this.hgap, insets.top + insets.bottom + maxh + (this.rows - 1) * this.vgap);
        }
    }

    public Dimension maximumLayoutSize(Container parent) {
        System.out.println("maximumLayoutSize(" + parent + ")");
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int[] w = new int[this.cols];
            int i = 0;
            while (i < w.length) {
                w[i] = 0;
                ++i;
            }
            int[] h = new int[this.rows];
            int i2 = 0;
            while (i2 < h.length) {
                h[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.components.size()) {
                Rectangle rect = (Rectangle)this.sizes.get(i2);
                Component comp = (Component)this.components.get(i2);
                Dimension d = comp.getMaximumSize();
                int dw = d.width / rect.width;
                int dh = d.height / rect.height;
                int c = rect.x;
                while (c < rect.x + rect.width) {
                    int r = rect.y;
                    while (r < rect.y + rect.height) {
                        w[c] = this.max2(w[c], dw);
                        h[r] = this.max2(h[r], dh);
                        ++r;
                    }
                    ++c;
                }
                ++i2;
            }
            int maxw = 0;
            int i3 = 0;
            while (i3 < w.length) {
                maxw += w[i3];
                ++i3;
            }
            int maxh = 0;
            int i4 = 0;
            while (i4 < h.length) {
                maxh += h[i4];
                ++i4;
            }
            return new Dimension(insets.left + insets.right + maxw + (this.cols - 1) * this.hgap, insets.top + insets.bottom + maxh + (this.rows - 1) * this.vgap);
        }
    }

    public void invalidateLayout(Container p1) {
    }

    public float getLayoutAlignmentY(Container p1) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container p1) {
        return 0.5f;
    }
}

