/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import timetable.data.Problem;
import timetable.data.ResourceGroup;
import timetable.gui.DNDActivityEngine;
import timetable.gui.TimeTableModel;
import timetable.gui.TimeTableTable;
import timetable.solver.Solver;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.price.SingleActivityEvaluation;
import timetable.solver.strategy.value.MinValueSelection;
import timetable.solver.strategy.variable.WorstFirstVariableSelection;
import timetable.test.SmartGenerator;
import timetable.util.Config;
import timetable.util.TimetableException;

public class TimeTable2Dlg
extends JDialog {
    TimeTableModel tmodel;
    TimeTableTable ttable;
    Problem problem;
    int NrResource = 0;
    private JScrollPane jScrollPane1;
    private JComboBox jComboBox1;

    public TimeTable2Dlg(Frame parent, boolean modal, Config k, Problem p) throws TimetableException {
        super(parent, modal);
        try {
            this.initComponents();
            this.pack();
            this.problem = p;
            int i = 0;
            while (i < this.problem.resources.length) {
                this.jComboBox1.addItem(this.problem.resources[i].name);
                ++i;
            }
            this.jComboBox1.addActionListener(new 1());
            this.tmodel = new TimeTableModel(k, new ResourceGroup());
            Solver s = new Solver(k, p);
            s.setValueSelection(new MinValueSelection(k, new Tabu(k), new SingleActivityEvaluation(k)));
            s.setVariableSelection(new WorstFirstVariableSelection(k));
            this.ttable = new TimeTableTable(this.tmodel, this.jScrollPane1, new DNDActivityEngine(this.problem, s));
            this.ttable.updateUI();
        }
        catch (Exception e) {
            System.err.println("Nastala chyba: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jComboBox1 = new JComboBox();
        this.addWindowListener(new 2());
        this.jScrollPane1.setPreferredSize(new Dimension(500, 200));
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jComboBox1, "South");
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            Config k = new Config();
            if (args.length == 0) {
                SmartGenerator sg = new SmartGenerator(k, false);
                new TimeTable2Dlg((Frame)new JFrame(), true, k, sg.generujCele()).show();
            } else {
                int i = 0;
                while (i < args.length) {
                    Problem p = new Problem(k);
                    p = Problem.load(args[i]);
                    System.out.println("Problem: " + p);
                    new TimeTable2Dlg((Frame)new JFrame(), true, k, p).show();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
    }

    static /* synthetic */ void access$1(TimeTable2Dlg accsParam$0, JScrollPane accParam$1) {
        accsParam$0.jScrollPane1 = accParam$1;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            TimeTable2Dlg.this.NrResource = ((JComboBox)evt.getSource()).getSelectedIndex();
            TimeTable2Dlg.this.tmodel.setResources(TimeTable2Dlg.this.problem.resources[TimeTable2Dlg.this.NrResource]);
            TimeTable2Dlg.this.jScrollPane1.updateUI();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            TimeTable2Dlg.this.closeDialog(evt);
        }

        /* synthetic */ 2() {
        }
    }
}

