/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import timetable.data.Activity;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.gui.DNDActivityEngine;
import timetable.gui.TableLayout;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.TimetableException;

public class TimeTablePanel
extends JPanel
implements ActionListener {
    JPopupMenu menu;
    JCheckBoxMenuItem mPin;
    private OneTimeTablePanel selected = null;
    protected DNDActivityEngine dndEngine = null;
    public Activity selectedActivity;
    public static LineBorder BORDER_DEFAULT = new LineBorder(Color.darkGray, 1);
    public static LineBorder BORDER_PIN = new LineBorder(Color.red, 2);
    public static LineBorder BORDER_PIN_SELECTED = new LineBorder(Color.blue, 2);
    public static LineBorder BORDER_SELECTED = new LineBorder(Color.blue, 1);
    public static Color COLOR_DEFAULT = new Color(255, 255, 255);
    public static Color COLOR_HEAD = new Color(120, 120, 255);
    public static Color COLOR_SELECTED = new Color(130, 130, 255);
    public static Color COLOR_NULL = new Color(170, 170, 170);
    public static Color TEXT_NORMAL = new Color(0, 0, 0);
    public static Color BG_HARD = new Color(210, 150, 150);
    public static Color BG_SOFT = new Color(200, 200, 150);
    public static Color BG_SCH_SOFT = new Color(255, 255, 200);
    public Resource resource = null;
    public ResourceGroup resources = null;
    private Config config = null;
    private int slotsPerDay = 0;
    private int days = 0;
    private int slots = 0;
    private TableLayout tableLayout;

    public void setConfig(Config config) throws TimetableException {
        this.config = config;
        this.days = config.getInt(Config.NR_DAYS);
        if (this.days == 0) {
            this.days = 5;
        }
        this.slots = config.getInt(Config.NR_SLOTS);
        this.slotsPerDay = this.slots / this.days;
    }

    public void addMenuItem(JMenuItem item) {
        this.menu.add(item);
    }

    public void setDNDEngine(DNDActivityEngine dndEngine) {
        this.dndEngine = dndEngine;
    }

    public void addMenuSeparator() {
        this.menu.add(new JPopupMenu.Separator());
    }

    public TimeTablePanel(Config config) throws TimetableException {
        this.config = config;
        this.days = config.getInt(Config.NR_DAYS);
        if (this.days == 0) {
            this.days = 5;
        }
        this.slots = config.getInt(Config.NR_SLOTS);
        this.slotsPerDay = this.slots / this.days;
        this.menu = new JPopupMenu();
        this.mPin = new JCheckBoxMenuItem(Loc.get("timetable.gui.pin"));
        this.mPin.addActionListener(this);
        this.menu.add(this.mPin);
        this.tableLayout = new TableLayout();
        this.setLayout(this.tableLayout);
    }

    public TimeTablePanel(Config config, Resource resource) throws TimetableException {
        this(config);
        this.setResource(resource);
    }

    public TimeTablePanel(Config config, ResourceGroup resources) throws TimetableException {
        this(config);
        this.setResources(resources);
    }

    public void setResources(ResourceGroup resources) throws TimetableException {
        OneTimeTablePanel p;
        this.resources = resources;
        this.resource = null;
        this.tableLayout.setRows(resources.size() + 2);
        this.tableLayout.setColumns(this.slots + 1);
        int width = 1;
        if (resources == null) {
            return;
        }
        int col = -1;
        while (col < this.slots) {
            p = new OneTimeTablePanel(col < 0 ? null : String.valueOf(Config.DAY_OF_WEEK[col / this.slotsPerDay]) + " " + (col % this.slotsPerDay + 1), true);
            this.add((Component)p, new Rectangle(col + 1, 0, 1, 1));
            ++col;
        }
        int row = 0;
        while (row < resources.size()) {
            OneTimeTablePanel ph = new OneTimeTablePanel(resources.get((int)row).shortCut, false);
            this.add((Component)ph, new Rectangle(0, row + 1, 1, 1));
            int col2 = 0;
            while (col2 < this.slots) {
                Activity a = resources.get(row).getActivityAt(col2);
                width = a == null ? 1 : a.length;
                int s = col2;
                if (width + col2 >= this.slots) {
                    width = this.slots - col2;
                    col2 = this.slots;
                } else {
                    col2 += width;
                }
                OneTimeTablePanel p2 = new OneTimeTablePanel(this.config, a, resources.get(row), s, width);
                this.add((Component)p2, new Rectangle(s + 1, row + 1, width, 1));
            }
            ++row;
        }
        col = -1;
        while (col < this.slots) {
            p = new OneTimeTablePanel(col < 0 ? null : String.valueOf(Config.DAY_OF_WEEK[col / this.slotsPerDay]) + " " + (col % this.slotsPerDay + 1), true);
            this.add((Component)p, new Rectangle(col + 1, resources.size() + 1, 1, 1));
            ++col;
        }
    }

    public void setResource(Resource resource) throws TimetableException {
        this.resource = resource;
        this.resources = null;
        this.removeAll();
        this.tableLayout.setRows(this.days + 1);
        this.tableLayout.setColumns(this.slotsPerDay + 1);
        int width = 1;
        if (resource == null) {
            return;
        }
        int col = -1;
        while (col < this.slotsPerDay) {
            OneTimeTablePanel p = new OneTimeTablePanel(col < 0 ? null : " " + (col + 1), true);
            this.add((Component)p, new Rectangle(col + 1, 0, 1, 1));
            ++col;
        }
        int row = 0;
        while (row < this.days) {
            OneTimeTablePanel ph = new OneTimeTablePanel(Config.DAY_OF_WEEK[row], false);
            this.add((Component)ph, new Rectangle(0, row + 1, 1, 1));
            int col2 = 0;
            while (col2 < this.slotsPerDay) {
                int c = col2;
                int s = this.slotsPerDay * row + col2;
                Activity a = resource.getActivityAt(s);
                width = a == null ? 1 : a.length;
                if (width + col2 >= this.slotsPerDay) {
                    width = this.slotsPerDay - col2;
                    col2 = this.slotsPerDay;
                } else {
                    col2 += width;
                }
                OneTimeTablePanel p = new OneTimeTablePanel(this.config, a, resource, s, width);
                this.add((Component)p, new Rectangle(c + 1, row + 1, width, 1));
            }
            ++row;
        }
    }

    public void updateUI() {
        super.updateUI();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mPin) {
            ((OneTimeTablePanel)this.menu.getInvoker()).changePin();
        }
    }

    public static int max2(int a, int b) {
        if (a < b) {
            return b;
        }
        return a;
    }

    public class OneTimeTablePanel
    extends JTextArea
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private Config config;
        private Activity activity;
        private int slot;
        private boolean pin;
        private boolean pinIsChangable = false;
        protected Cursor cursor;
        protected DropTarget dropTarget = null;
        protected DragSource dragSource = null;

        public Activity getActivity() {
            return this.activity;
        }

        public OneTimeTablePanel(String text, boolean header) {
            this.setEditable(false);
            this.setAlignmentX(0.5f);
            this.setAlignmentY(0.5f);
            this.setBorder(BORDER_DEFAULT);
            int width = 55;
            int height = 55;
            if (text != null) {
                this.setText(" " + text);
            } else {
                width = 30;
            }
            if (header) {
                height = 20;
            } else {
                width = 30;
            }
            this.setPreferredSize(new Dimension(width, height));
            this.setBackground(COLOR_HEAD);
            this.slot = -1;
        }

        public OneTimeTablePanel(Config config, Activity activity, Resource resource, int slot, int width) throws TimetableException {
            this.config = config;
            this.activity = activity;
            this.slot = slot;
            this.setEditable(false);
            this.setAlignmentX(0.5f);
            this.setAlignmentY(0.5f);
            this.setBorder(BORDER_DEFAULT);
            this.setPreferredSize(new Dimension(55 * width, 55));
            if (activity == null) {
                this.setText("");
                if (resource == null) {
                    this.setBackground(COLOR_NULL);
                } else if (resource.getPreference().isHARD(slot)) {
                    this.setBackground(BG_HARD);
                } else if (resource.getPreference().isSOFT(slot)) {
                    this.setBackground(BG_SOFT);
                } else {
                    this.setBackground(COLOR_NULL);
                }
            } else {
                StringBuffer r = new StringBuffer(" ");
                if (!activity.canReschedule) {
                    this.setBorder(BORDER_PIN);
                }
                r.append(activity.shortCut);
                int i = 0;
                while (i < activity.selectedResources.size()) {
                    if (activity.selectedResources.isGroup(i)) {
                        boolean isInGroup = false;
                        int k = 0;
                        while (k < activity.selectedResources.getResources(i).size()) {
                            if (activity.selectedResources.getResources(i).get(k) == resource) {
                                isInGroup = true;
                            }
                            ++k;
                        }
                        if (!isInGroup) {
                            r.append("\n ");
                            r.append(activity.selectedResources.getResources((int)i).shortCut);
                        }
                    } else if (activity.selectedResources.getResource(i) != resource) {
                        r.append("\n ");
                        r.append(activity.selectedResources.getResource((int)i).shortCut);
                    }
                    ++i;
                }
                this.setText(r.toString());
                int soft = 0;
                int i2 = 0;
                while (i2 < activity.length) {
                    int s = activity.start + i2;
                    if (activity.getPreference().isSOFT(s)) {
                        ++soft;
                    }
                    int j = 0;
                    while (j < activity.selectedResources.size()) {
                        if (activity.selectedResources.isGroup(j)) {
                            int k = 0;
                            while (k < activity.selectedResources.getResources(j).size()) {
                                if (activity.selectedResources.getResources(j).get(k) != null && activity.selectedResources.getResources(j).get(k).getPreference().isSOFT(s)) {
                                    ++soft;
                                }
                                ++k;
                            }
                        } else if (activity.selectedResources.getResource(j) != null && activity.selectedResources.getResource(j).getPreference().isSOFT(s)) {
                            ++soft;
                        }
                        ++j;
                    }
                    ++i2;
                }
                if (soft > 0) {
                    this.setBackground(new Color(255, 255, TimeTablePanel.max2(0, 255 - 30 * soft)));
                } else {
                    this.setBackground(COLOR_DEFAULT);
                }
                this.pin = !activity.canReschedule;
                this.pinIsChangable = true;
                this.addMouseListener(new 1());
                this.setBorder();
            }
            this.initDND();
        }

        public void changePin() {
            this.pin = this.activity.canReschedule;
            this.activity.canReschedule = !this.activity.canReschedule;
            this.setBorder();
        }

        public void setSelected(boolean selected) {
            if (selected) {
                TimeTablePanel.this.selectedActivity = this.activity;
                this.setBackground(COLOR_SELECTED);
            } else {
                if (this.activity == TimeTablePanel.this.selectedActivity) {
                    TimeTablePanel.this.selectedActivity = null;
                }
                int soft = 0;
                int i = 0;
                while (i < this.activity.length) {
                    int s = this.activity.start + i;
                    if (this.activity.getPreference().isSOFT(s)) {
                        ++soft;
                    }
                    int j = 0;
                    while (j < this.activity.selectedResources.size()) {
                        if (this.activity.selectedResources.isGroup(j)) {
                            int k = 0;
                            while (k < this.activity.selectedResources.getResources(j).size()) {
                                if (this.activity.selectedResources.getResources(j).get(k) != null && this.activity.selectedResources.getResources(j).get(k).getPreference().isSOFT(s)) {
                                    ++soft;
                                }
                                ++k;
                            }
                        } else if (this.activity.selectedResources.getResource(j) != null && this.activity.selectedResources.getResource(j).getPreference().isSOFT(s)) {
                            ++soft;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (soft > 0) {
                    this.setBackground(new Color(255, 255, TimeTablePanel.max2(0, 255 - 30 * soft)));
                } else {
                    this.setBackground(COLOR_DEFAULT);
                }
            }
        }

        public void setBorder() {
            if (this.pin) {
                this.setBorder(BORDER_PIN);
            } else {
                this.setBorder(BORDER_DEFAULT);
            }
        }

        public void initDND() {
            this.cursor = this.getCursor();
            this.dropTarget = new DropTarget(this, this);
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }

        public void dragOver(DropTargetDragEvent event) {
            if (this.slot >= 0 && TimeTablePanel.this.dndEngine.canDrop(this.slot + (int)event.getLocation().getX() / 55, this.activity, TimeTablePanel.this.resource)) {
                event.acceptDrag(2);
                this.setCursor(DragSource.DefaultMoveDrop);
            } else {
                event.rejectDrag();
                this.setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        public void dropActionChanged(DropTargetDragEvent p1) {
        }

        public void dragEnter(DropTargetDragEvent p1) {
        }

        public void drop(DropTargetDropEvent event) {
            if (this.slot >= 0 && TimeTablePanel.this.dndEngine.canDrop(this.slot + (int)event.getLocation().getX() / 55, this.activity, TimeTablePanel.this.resource)) {
                TimeTablePanel.this.dndEngine.drop(this.slot + (int)event.getLocation().getX() / 55, TimeTablePanel.this.resource, this);
            } else {
                event.rejectDrop();
            }
        }

        public void dragExit(DropTargetEvent p1) {
            this.setCursor(this.cursor);
        }

        public void dragExit(DragSourceEvent p1) {
        }

        public void dragDropEnd(DragSourceDropEvent p1) {
            this.setCursor(this.cursor);
            TimeTablePanel.this.dndEngine.done();
        }

        public void dropActionChanged(DragSourceDragEvent p1) {
        }

        public void dragOver(DragSourceDragEvent p1) {
        }

        public void dragEnter(DragSourceDragEvent p1) {
        }

        public void dragGestureRecognized(DragGestureEvent event) {
            if (this.slot >= 0 && TimeTablePanel.this.dndEngine.canDrag(this.slot, this.activity, TimeTablePanel.this.resource)) {
                StringSelection text = new StringSelection("DNDTable Drag & Drop Feature");
                this.cursor = this.getCursor();
                this.dragSource.startDrag(event, null, text, this);
                TimeTablePanel.this.dndEngine.drag(this.slot, this.activity, this);
            }
        }

        static /* synthetic */ void access$1(OneTimeTablePanel accsParam$0, boolean accParam$1) {
            accsParam$0.pinIsChangable = accParam$1;
        }

        static /* synthetic */ void access$3(OneTimeTablePanel accsParam$0, boolean accParam$1) {
            accsParam$0.pin = accParam$1;
        }

        static /* synthetic */ void access$5(OneTimeTablePanel accsParam$0, Activity accParam$1) {
            accsParam$0.activity = accParam$1;
        }

        private final class 1
        extends MouseAdapter {
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 4) > 0 && OneTimeTablePanel.this.pinIsChangable) {
                    ((OneTimeTablePanel)OneTimeTablePanel.this).TimeTablePanel.this.mPin.setSelected(OneTimeTablePanel.this.pin);
                    ((OneTimeTablePanel)OneTimeTablePanel.this).TimeTablePanel.this.selectedActivity = ((OneTimeTablePanel)e.getSource()).activity;
                    ((OneTimeTablePanel)OneTimeTablePanel.this).TimeTablePanel.this.menu.show(OneTimeTablePanel.this, e.getX(), e.getY());
                }
                if ((e.getModifiers() & 0x10) > 0) {
                    if (TimeTablePanel.this.selected != null) {
                        TimeTablePanel.this.selected.setSelected(false);
                    }
                    TimeTablePanel.this.selected = OneTimeTablePanel.this;
                    OneTimeTablePanel.this.setSelected(true);
                }
            }

            /* synthetic */ 1() {
            }
        }
    }
}

