/*
 * Decompiled with CFR 0.152.
 */
package timetable.school;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import timetable.data.Activity;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.data.TimePreference;
import timetable.gui.TimePreferencePanel;
import timetable.school.data.SchoolProblem;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.Math;
import timetable.util.MessageDlg;
import timetable.util.TimetableException;

public class EditActivityDlg
extends JDialog {
    private Activity activity;
    private SchoolProblem problem;
    private boolean returnStatus = false;
    private TimePreference preference;
    private ResourceGroup rooms = null;
    private ResourceGroup specRes = null;
    private AllRoomsModel allRooms;
    private SelRoomsModel selRooms;
    private AllSpecResModel allSpecRes;
    private SelSpecResModel selSpecRes;
    private JList roomList;
    private JList allRoomList;
    private JList specResList;
    private JList allSpecResList;
    private JPanel commandPanel;
    private JButton okButton;
    private JButton stornoButton;
    private JTabbedPane jTabbedPane1;
    private JPanel dataPanel;
    private JLabel jLabel4;
    private JTextField shortCutField;
    private JLabel jLabel5;
    private JTextField nameField;
    private JLabel jLabel6;
    private JTextField lengthField;
    private JLabel jLabel7;
    private JTextArea noteArea;
    private JLabel jLabel8;
    private JPanel resourcePanel;
    private JLabel jLabel9;
    private JComboBox teacherCombo;
    private JLabel jLabel10;
    private JComboBox classCombo;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JScrollPane roomScrollPane;
    private JPanel jPanel4;
    private JButton addAllButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private JScrollPane allRoomScrollPane;
    private JPanel specResPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel11;
    private JScrollPane specResScrollPane;
    private JPanel jPanel2;
    private JButton addAllSpecResButton;
    private JButton addSpecResButton;
    private JButton removeSpecResButton;
    private JButton removeAllSpecResButton;
    private JScrollPane allSpecResScrollPane;

    public EditActivityDlg(Frame parent, String title, Config config, Activity activity, SchoolProblem _problem) throws TimetableException {
        super(parent != null ? parent : new JFrame(), true);
        this.activity = activity;
        this.problem = _problem;
        if (activity == null) {
            return;
        }
        this.initComponents();
        this.jTabbedPane1.setTitleAt(0, Loc.get("timetable.school.gui.tab.general"));
        this.jTabbedPane1.setTitleAt(1, Loc.get("timetable.school.gui.tab.resources"));
        this.jTabbedPane1.setTitleAt(2, Loc.get("timetable.school.gui.tab.otherres"));
        this.pack();
        this.setTitle(title);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.preference = (TimePreference)activity.getPreference().clone();
        this.dataPanel.add((Component)new TimePreferencePanel(config, this.preference), c);
        this.shortCutField.setText(activity.shortCut);
        this.nameField.setText(activity.name);
        this.noteArea.setText(activity.note);
        this.lengthField.setText(String.valueOf(activity.length));
        int i = 0;
        while (i < this.problem.getAllTeachers().size()) {
            this.teacherCombo.addItem(this.problem.getAllTeachers().get((int)i).name);
            ++i;
        }
        i = 0;
        while (i < this.problem.getAllClasses().size()) {
            this.classCombo.addItem(this.problem.getAllClasses().get((int)i).name);
            ++i;
        }
        i = 0;
        while (i < this.problem.groupedClasses.size()) {
            this.classCombo.addItem(this.problem.groupedClasses.getResources((int)i).name);
            ++i;
        }
        this.rooms = activity.resources == null || activity.resources.size() <= 0 ? new ResourceGroup() : activity.resources.getResources(2);
        if (this.rooms == null) {
            this.rooms = new ResourceGroup();
        }
        this.specRes = activity.resources == null || activity.resources.size() < 4 ? new ResourceGroup() : activity.resources.getResources(3);
        this.specRes.conjunctive = true;
        this.allRooms = new AllRoomsModel();
        this.selRooms = new SelRoomsModel();
        this.allSpecRes = new AllSpecResModel();
        this.selSpecRes = new SelSpecResModel();
        if (this.problem.getAllSpecRes().size() == 0) {
            this.jTabbedPane1.setEnabledAt(2, false);
        }
        this.roomList = new JList(this.selRooms);
        this.allRoomList = new JList(this.allRooms);
        this.specResList = new JList(this.selSpecRes);
        this.allSpecResList = new JList(this.allSpecRes);
        this.roomScrollPane.getViewport().setView(this.roomList);
        this.allRoomScrollPane.getViewport().setView(this.allRoomList);
        this.specResScrollPane.getViewport().setView(this.specResList);
        this.allSpecResScrollPane.getViewport().setView(this.allSpecResList);
        this.teacherCombo.setSelectedIndex(this.problem.getAllTeachers().indexOf(activity.resources.getResource(1)));
        if (activity.resources != null && activity.resources.size() >= 3) {
            if (activity.resources.isGroup(0)) {
                this.classCombo.setSelectedIndex(this.problem.getAllClasses().size() + this.problem.groupedClasses.indexOf(activity.resources.getResources(0)));
            } else {
                this.classCombo.setSelectedIndex(this.problem.getAllClasses().indexOf(activity.resources.getResource(0)));
            }
        } else {
            this.classCombo.setSelectedIndex(-1);
        }
        ((Component)this).setSize(Math.max2(200, 20 * (config.getInt(Config.NR_SLOTS) / config.getInt(Config.NR_DAYS))) + 160, 360);
        ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 2);
    }

    public void show() {
        if (this.activity != null) {
            super.show();
        }
    }

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.commandPanel = new JPanel();
        this.okButton = new JButton();
        this.stornoButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.dataPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.shortCutField = new JTextField();
        this.jLabel5 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel6 = new JLabel();
        this.lengthField = new JTextField();
        this.jLabel7 = new JLabel();
        this.noteArea = new JTextArea();
        this.jLabel8 = new JLabel();
        this.resourcePanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.teacherCombo = new JComboBox();
        this.jLabel10 = new JLabel();
        this.classCombo = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.roomScrollPane = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.allRoomScrollPane = new JScrollPane();
        this.specResPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel11 = new JLabel();
        this.specResScrollPane = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.addAllSpecResButton = new JButton();
        this.addSpecResButton = new JButton();
        this.removeSpecResButton = new JButton();
        this.removeAllSpecResButton = new JButton();
        this.allSpecResScrollPane = new JScrollPane();
        this.addWindowListener(new 1());
        this.commandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.okButton.setText(Loc.get("timetable.button.ok"));
        this.okButton.addActionListener(new 2());
        this.commandPanel.add(this.okButton);
        this.stornoButton.setText(Loc.get("timetable.button.cancel"));
        this.stornoButton.addActionListener(new 3());
        this.commandPanel.add(this.stornoButton);
        this.getContentPane().add((Component)this.commandPanel, "South");
        this.dataPanel.setLayout(new GridBagLayout());
        this.jLabel4.setText(Loc.get("timetable.school.model.shortcut"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel4, gridBagConstraints1);
        this.shortCutField.setPreferredSize(new Dimension(50, 20));
        this.shortCutField.setText("Zkratka");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.shortCutField, gridBagConstraints1);
        this.jLabel5.setText(Loc.get("timetable.school.model.name"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel5, gridBagConstraints1);
        this.nameField.setPreferredSize(new Dimension(200, 20));
        this.nameField.setText("jTextField2");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.nameField, gridBagConstraints1);
        this.jLabel6.setText(Loc.get("timetable.school.model.length"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel6, gridBagConstraints1);
        this.lengthField.setPreferredSize(new Dimension(50, 20));
        this.lengthField.setText("jTextField3");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.lengthField, gridBagConstraints1);
        this.jLabel7.setText(Loc.get("timetable.school.model.note"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel7, gridBagConstraints1);
        this.noteArea.setPreferredSize(new Dimension(200, 50));
        this.noteArea.setBorder(new EtchedBorder());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.noteArea, gridBagConstraints1);
        this.jLabel8.setText(Loc.get("timetable.school.model.timepreference"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel8, gridBagConstraints1);
        this.jTabbedPane1.addTab("Z\u00e1kladn\u00ed \u00fadaje", this.dataPanel);
        this.resourcePanel.setLayout(new GridBagLayout());
        this.jLabel9.setText(Loc.get("timetable.school.model.teacher"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jLabel9, gridBagConstraints2);
        this.teacherCombo.setPreferredSize(new Dimension(200, 25));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.teacherCombo, gridBagConstraints2);
        this.jLabel10.setText(Loc.get("timetable.school.model.class"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jLabel10, gridBagConstraints2);
        this.classCombo.setPreferredSize(new Dimension(200, 25));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.classCombo, gridBagConstraints2);
        this.jLabel12.setText(Loc.get("timetable.school.model.rooms"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jLabel12, gridBagConstraints2);
        this.jLabel13.setText(Loc.get("timetable.school.gui.selected"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jLabel13, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jLabel14, gridBagConstraints2);
        this.jLabel15.setText(Loc.get("timetable.school.gui.notselected"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jLabel15, gridBagConstraints2);
        this.roomScrollPane.setPreferredSize(new Dimension(100, 120));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.roomScrollPane, gridBagConstraints2);
        this.jPanel4.setLayout(new GridLayout(4, 1));
        this.jPanel4.setPreferredSize(new Dimension(110, 100));
        this.addAllButton.setText(Loc.get("timetable.school.button.addall"));
        this.addAllButton.addActionListener(new 4());
        this.jPanel4.add(this.addAllButton);
        this.addButton.setText(Loc.get("timetable.school.button.add"));
        this.addButton.addActionListener(new 5());
        this.jPanel4.add(this.addButton);
        this.removeButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeButton.addActionListener(new 6());
        this.jPanel4.add(this.removeButton);
        this.removeAllButton.setText(Loc.get("timetable.school.button.removeall"));
        this.removeAllButton.addActionListener(new 7());
        this.jPanel4.add(this.removeAllButton);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.jPanel4, gridBagConstraints2);
        this.allRoomScrollPane.setPreferredSize(new Dimension(100, 120));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.resourcePanel.add((Component)this.allRoomScrollPane, gridBagConstraints2);
        this.jTabbedPane1.addTab("Zdroje", this.resourcePanel);
        this.specResPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(Loc.get("timetable.school.model.otherres"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.jLabel1, gridBagConstraints3);
        this.jLabel2.setText(Loc.get("timetable.school.gui.selected"));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.jLabel2, gridBagConstraints3);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.jLabel3, gridBagConstraints3);
        this.jLabel11.setText(Loc.get("timetable.school.gui.notselected"));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.jLabel11, gridBagConstraints3);
        this.specResScrollPane.setPreferredSize(new Dimension(100, 120));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.specResScrollPane, gridBagConstraints3);
        this.jPanel2.setLayout(new GridLayout(4, 1));
        this.jPanel2.setPreferredSize(new Dimension(110, 100));
        this.addAllSpecResButton.setLabel(Loc.get("timetable.school.button.addall"));
        this.addAllSpecResButton.setText("P\u0159idat v\u0161e");
        this.addAllSpecResButton.addActionListener(new 8());
        this.jPanel2.add(this.addAllSpecResButton);
        this.addSpecResButton.setLabel(Loc.get("timetable.school.button.add"));
        this.addSpecResButton.setText("P\u0159idat");
        this.addSpecResButton.addActionListener(new 9());
        this.jPanel2.add(this.addSpecResButton);
        this.removeSpecResButton.setLabel(Loc.get("timetable.school.button.remove"));
        this.removeSpecResButton.setText("Odebrat");
        this.removeSpecResButton.addActionListener(new 10());
        this.jPanel2.add(this.removeSpecResButton);
        this.removeAllSpecResButton.setLabel(Loc.get("timetable.school.button.removeall"));
        this.removeAllSpecResButton.setText("Odebrat v\u0161e");
        this.removeAllSpecResButton.addActionListener(new 11());
        this.jPanel2.add(this.removeAllSpecResButton);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.jPanel2, gridBagConstraints3);
        this.allSpecResScrollPane.setPreferredSize(new Dimension(100, 120));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.specResPanel.add((Component)this.allSpecResScrollPane, gridBagConstraints3);
        this.jTabbedPane1.addTab("Ostatn\u00ed", this.specResPanel);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
    }

    private void removeAllSpecResButtonActionPerformed(ActionEvent evt) {
        this.specRes.removeAll();
        this.allSpecResList.updateUI();
        this.specResList.updateUI();
    }

    private void removeSpecResButtonActionPerformed(ActionEvent evt) {
        if (this.specResList.getSelectedIndex() < 0 || this.specResList.getSelectedIndex() >= this.selSpecRes.getSize()) {
            return;
        }
        this.specRes.remove(this.selSpecRes.getResourceAt(this.specResList.getSelectedIndex()));
        this.allSpecResList.updateUI();
        this.specResList.updateUI();
    }

    private void addSpecResButtonActionPerformed(ActionEvent evt) {
        if (this.allSpecResList.getSelectedIndex() < 0 || this.allSpecResList.getSelectedIndex() >= this.allSpecRes.getSize()) {
            return;
        }
        this.specRes.add(this.allSpecRes.getResourceAt(this.allSpecResList.getSelectedIndex()));
        this.allSpecResList.updateUI();
        this.specResList.updateUI();
    }

    private void addAllSpecResButtonActionPerformed(ActionEvent evt) {
        while (this.allSpecRes.getSize() > 0) {
            this.specRes.add(this.allSpecRes.getResourceAt(0));
        }
        this.allSpecResList.updateUI();
        this.specResList.updateUI();
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.rooms.removeAll();
        this.allRoomList.updateUI();
        this.roomList.updateUI();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        if (this.roomList.getSelectedIndex() < 0 || this.roomList.getSelectedIndex() >= this.selRooms.getSize()) {
            return;
        }
        this.rooms.remove(this.selRooms.getResourceAt(this.roomList.getSelectedIndex()));
        this.allRoomList.updateUI();
        this.roomList.updateUI();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.allRoomList.getSelectedIndex() < 0 || this.allRoomList.getSelectedIndex() >= this.allRooms.getSize()) {
            return;
        }
        this.rooms.add(this.allRooms.getResourceAt(this.allRoomList.getSelectedIndex()));
        this.allRoomList.updateUI();
        this.roomList.updateUI();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        while (this.allRooms.getSize() > 0) {
            this.rooms.add(this.allRooms.getResourceAt(0));
        }
        this.allRoomList.updateUI();
        this.roomList.updateUI();
    }

    private void stornoButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = false;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            String msg = null;
            if (Integer.parseInt(this.lengthField.getText()) <= 0) {
                msg = "Chybn\u011b zad\u00e1na d\u00e9lka p\u0159edm\u011btu.";
            } else if (this.teacherCombo.getSelectedIndex() < 0) {
                msg = "Nezad\u00e1n vyu\u010duj\u00edc\u00ed.";
            } else if (this.classCombo.getSelectedIndex() < 0) {
                msg = "Nezad\u00e1na t\u0159\u00edda.";
            } else if (this.rooms.size() <= 0) {
                msg = "Nezad\u00e1ny u\u010debny.";
            }
            if (msg != null) {
                new MessageDlg("Chyba", msg, MessageDlg.OK).show();
                return;
            }
        }
        catch (Exception exception) {
            new MessageDlg("Chyba", "Chybn\u011b zad\u00e1na d\u00e9lka p\u0159edm\u011btu.", MessageDlg.OK).show();
            return;
        }
        this.activity.shortCut = this.shortCutField.getText();
        this.activity.name = this.nameField.getText();
        this.activity.note = this.noteArea.getText();
        this.activity.length = Integer.parseInt(this.lengthField.getText());
        this.activity.setPreference(this.preference);
        this.activity.resources.removeAll();
        if (this.classCombo.getSelectedIndex() < this.problem.getAllClasses().size()) {
            this.activity.resources.add(this.problem.getAllClasses().get(this.classCombo.getSelectedIndex()));
        } else {
            this.activity.resources.add(this.problem.groupedClasses.getResources(this.classCombo.getSelectedIndex() - this.problem.getAllClasses().size()));
        }
        this.activity.resources.add(this.problem.getAllTeachers().get(this.teacherCombo.getSelectedIndex()));
        this.activity.resources.add(this.rooms);
        if (this.specRes.size() != 0) {
            this.activity.resources.add(this.specRes);
        }
        this.returnStatus = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnStatus = false;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    static /* synthetic */ void access$1(EditActivityDlg accsParam$0, ResourceGroup accParam$1) {
        accsParam$0.rooms = accParam$1;
    }

    static /* synthetic */ void access$3(EditActivityDlg accsParam$0, SchoolProblem accParam$1) {
        accsParam$0.problem = accParam$1;
    }

    static /* synthetic */ void access$5(EditActivityDlg accsParam$0, ResourceGroup accParam$1) {
        accsParam$0.specRes = accParam$1;
    }

    class SelRoomsModel
    extends AbstractListModel {
        public int getSize() {
            return EditActivityDlg.this.rooms.size();
        }

        public Object getElementAt(int index) {
            return ((EditActivityDlg)EditActivityDlg.this).rooms.get((int)index).name;
        }

        public Resource getResourceAt(int index) {
            return EditActivityDlg.this.rooms.get(index);
        }

        SelRoomsModel() {
        }
    }

    class AllRoomsModel
    extends AbstractListModel {
        public int getSize() {
            return EditActivityDlg.this.problem.getAllRooms().size() - EditActivityDlg.this.rooms.size();
        }

        public Object getElementAt(int index) {
            int i = 0;
            while (index >= 0 && i < EditActivityDlg.this.problem.getAllRooms().size()) {
                if (EditActivityDlg.this.rooms.indexOf(EditActivityDlg.this.problem.getAllRooms().get(i)) < 0) {
                    --index;
                }
                ++i;
            }
            return ((EditActivityDlg)EditActivityDlg.this).problem.getAllRooms().get((int)(i - 1)).name;
        }

        public Resource getResourceAt(int index) {
            int i = 0;
            while (index >= 0 && i < EditActivityDlg.this.problem.getAllRooms().size()) {
                if (EditActivityDlg.this.rooms.indexOf(EditActivityDlg.this.problem.getAllRooms().get(i)) < 0) {
                    --index;
                }
                ++i;
            }
            return EditActivityDlg.this.problem.getAllRooms().get(i - 1);
        }

        AllRoomsModel() {
        }
    }

    class SelSpecResModel
    extends AbstractListModel {
        public int getSize() {
            return EditActivityDlg.this.specRes.size();
        }

        public Object getElementAt(int index) {
            return ((EditActivityDlg)EditActivityDlg.this).specRes.get((int)index).name;
        }

        public Resource getResourceAt(int index) {
            return EditActivityDlg.this.specRes.get(index);
        }

        SelSpecResModel() {
        }
    }

    class AllSpecResModel
    extends AbstractListModel {
        public int getSize() {
            return EditActivityDlg.this.problem.getAllSpecRes().size() - EditActivityDlg.this.specRes.size();
        }

        public Object getElementAt(int index) {
            int i = 0;
            while (index >= 0 && i < EditActivityDlg.this.problem.getAllSpecRes().size()) {
                if (EditActivityDlg.this.specRes.indexOf(EditActivityDlg.this.problem.getAllSpecRes().get(i)) < 0) {
                    --index;
                }
                ++i;
            }
            return ((EditActivityDlg)EditActivityDlg.this).problem.getAllSpecRes().get((int)(i - 1)).name;
        }

        public Resource getResourceAt(int index) {
            int i = 0;
            while (index >= 0 && i < EditActivityDlg.this.problem.getAllSpecRes().size()) {
                if (EditActivityDlg.this.specRes.indexOf(EditActivityDlg.this.problem.getAllSpecRes().get(i)) < 0) {
                    --index;
                }
                ++i;
            }
            return EditActivityDlg.this.problem.getAllSpecRes().get(i - 1);
        }

        AllSpecResModel() {
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            EditActivityDlg.this.closeDialog(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.okButtonActionPerformed(evt);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.stornoButtonActionPerformed(evt);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.addAllButtonActionPerformed(evt);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.addButtonActionPerformed(evt);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.removeButtonActionPerformed(evt);
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.removeAllButtonActionPerformed(evt);
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.addAllSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.addSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.removeSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditActivityDlg.this.removeAllSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 11() {
        }
    }
}

