/*
 * Decompiled with CFR 0.152.
 */
package timetable.school;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import timetable.data.Activity;
import timetable.data.ActivityDependenceInterface;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.data.TimeActivityDependence;
import timetable.gui.DNDActivityEngine;
import timetable.gui.DNDEvent;
import timetable.gui.DNDListener;
import timetable.gui.SolverRightsPanel;
import timetable.gui.TimeTableModel;
import timetable.gui.TimeTablePanel;
import timetable.gui.TimeTableTable;
import timetable.school.EditActivityDlg;
import timetable.school.EditDependenceDlg;
import timetable.school.EditResourceDlg;
import timetable.school.EditResourceGroupDlg;
import timetable.school.data.SchoolProblem;
import timetable.school.gui.ActivityTableModel;
import timetable.school.gui.AllResourcesTableModel;
import timetable.school.gui.DNDDataTable;
import timetable.school.gui.DataTable;
import timetable.school.gui.DependenceTableModel;
import timetable.school.gui.GroupedClassTableModel;
import timetable.school.gui.NotScheduledActivityTableModel;
import timetable.school.gui.ProblemActivityTableModel;
import timetable.school.gui.ResourceTableModel;
import timetable.school.gui.SchoolRightsPanel;
import timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation;
import timetable.solver.Solver;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.value.HumanValueSelection;
import timetable.solver.strategy.value.MinValueSelection;
import timetable.solver.strategy.variable.WorstFirstVariableSelection;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.MessageDlg;
import timetable.util.MessageTableDlg;
import timetable.util.TimetableException;

public class SchoolTimetable
extends JFrame {
    public boolean solving = false;
    private String fileName = null;
    private Solver solver = null;
    private SolverThread solverThread = null;
    private UpdateThread updateThread = null;
    private SchoolProblem problem = null;
    private Config config;
    private DNDActivityEngine engine;
    private DNDActivityEngine engine2;
    private DataTable teachersTable;
    private DataTable roomsTable;
    private DataTable specResTable;
    private DataTable classesTable;
    private DataTable groupedClassesTable;
    private DataTable activitiesTable;
    private DataTable dependencesTable;
    private DataTable allResourcesTable;
    private DNDDataTable notScheduledActivitiesTable;
    private DNDDataTable oneResNotScheduledActivitiesTable;
    private JPopupMenu activitiesMenu;
    private JMenuItem addActMenuItem;
    private JMenuItem editActMenuItem;
    private JMenuItem removeActMenuItem;
    private JMenuItem scheduleActMenuItem;
    private JMenuItem removeActFromTableMenuItem;
    private JMenuItem removeActFromORPanelMenuItem;
    private TimeTableTable allResourcesScheduleTable;
    private TimeTableModel allResourcesScheduleModel;
    private SolverRightsPanel solverRightsPanel;
    private SchoolRightsPanel schoolRightsPanel;
    private NotScheduledActivityTableModel notScheduledActivityTableModel;
    private NotScheduledActivityTableModel oneResNotScheduledActivityTableModel;
    private AllResourcesTableModel allResourcesTableModel;
    private TimeTablePanel oneResourceSchedulePanel;
    private JButton solveButton = new JButton();
    private JButton newActivityButton = new JButton();
    private JLabel statusLabel = new JLabel();
    private JMenuBar menu;
    private JMenu fileMenu;
    private JMenuItem newTimetableMenuItem;
    private JMenuItem loadTimetableMenuItem;
    private JMenuItem saveTimetableMenuItem;
    private JMenuItem saveAsTimetableMenuItem;
    private JSeparator separator1;
    private JMenuItem resetMenuItem;
    private JSeparator separator2;
    private JMenuItem closeMenuItem;
    private JToolBar toolBar;
    private JTabbedPane mainTab;
    private JPanel resourcesPanel;
    private JTabbedPane resourcesTab;
    private JPanel teachersPanel;
    private JScrollPane teachersScrollPane;
    private JPanel teachersCommandPanel;
    private JButton addTeacherButton;
    private JButton editTeacherButton;
    private JButton removeTeacherButton;
    private JPanel classesPanel;
    private JTabbedPane classesTab;
    private JPanel singleClassesPanel;
    private JPanel classesCommandPanel;
    private JButton addClassButton;
    private JButton editClassButton;
    private JButton removeClassButton;
    private JScrollPane classesScrollPane;
    private JPanel groupedClassesPanel;
    private JPanel groupedClassesCommandPanel;
    private JButton addClassGroupButton;
    private JButton editClassGroupButton;
    private JButton removeClassGroupButton;
    private JScrollPane groupedClassesScrollPane;
    private JPanel roomsPanel;
    private JScrollPane roomsScrollPane;
    private JPanel roomsCommandPanel;
    private JButton addRoomButton;
    private JButton editRoomButton;
    private JButton removeRoomButton;
    private JPanel specResPanel;
    private JScrollPane specResScrollPane;
    private JPanel specResCommandPanel;
    private JButton addSpecResButton;
    private JButton editSpecResButton;
    private JButton removeSpecResButton;
    private JPanel activitiesAndDependancesPanel;
    private JTabbedPane activitiesTab;
    private JPanel activitiesPanel;
    private JScrollPane activitiesScrollPane;
    private JPanel activitiesCommandPanel;
    private JButton addActivityButtom;
    private JButton editActivityButton;
    private JButton removeActivityButton;
    private JPanel dependencesPanel;
    private JScrollPane dependencesScrollPane;
    private JPanel dependencesCommandPanel;
    private JButton addDependenceButton;
    private JButton editDependenceButton;
    private JButton removeDependenceButton;
    private JPanel timetablePanel;
    private JTabbedPane timetableTab;
    private JPanel fullTimetablePabel;
    private JPanel fullTimetableCommandPanel;
    private JLabel jLabel1;
    private JComboBox resourceCombo;
    private JSplitPane fullTimetableSplitPane;
    private JScrollPane fullScheduleScrollPane;
    private JPanel notScheduledActivitiesPanel;
    private JLabel jLabel2;
    private JScrollPane notScheduledActivitiesScrollPane;
    private JPanel resourceTimetablePanel;
    private JSplitPane oneResourceSplitPane;
    private JScrollPane oneResourceScheduleScrollPane;
    private JSplitPane resourceVsUnschedActivitiesSplitPane;
    private JPanel notScheduledActivitiesScrollPane2;
    private JLabel jLabel4;
    private JScrollPane oneResNotScheduledActivitiesScrollPane;
    private JPanel resourceTimetableCommandPanel;
    private JLabel jLabel3;
    private JScrollPane allResourcesScrollPane;
    private JPanel rightsPanel;
    private JTabbedPane rightsTab;
    private JScrollPane basicRightsScrollPane;
    private JScrollPane specRightsScrollPane;

    public SchoolTimetable() {
        this((String)null);
    }

    public SchoolTimetable(String fileName) {
        try {
            this.config = new Config();
            Loc.addLocalization(this.config.get("LOC_SCHOOL"));
            this.initComponents();
            this.pack();
            this.fileName = fileName;
            this.setTitle(String.valueOf(Loc.get("timetable.school.title")) + "   [" + Loc.get("timetable.school.title.new") + "]");
            this.problem = new SchoolProblem(this.config);
            if (fileName != null) {
                this.problem = (SchoolProblem)SchoolProblem.load(fileName);
                this.config = this.problem.config;
                this.setTitle(String.valueOf(Loc.get("timetable.school.title")) + "   [" + fileName + "]");
            }
            this.solveButton.setText(Loc.get("timetable.school.button.solve"));
            this.newActivityButton.setText(Loc.get("timetable.school.button.addNewLecture"));
            this.statusLabel.setText(Loc.get("timetable.school.text.state"));
            this.mainTab.setTitleAt(0, Loc.get("timetable.school.tab.resources"));
            this.mainTab.setTitleAt(1, Loc.get("timetable.school.tab.activities"));
            this.mainTab.setTitleAt(2, Loc.get("timetable.school.tab.timetable"));
            this.resourcesTab.setTitleAt(0, Loc.get("timetable.school.tab.teachers"));
            this.resourcesTab.setTitleAt(1, Loc.get("timetable.school.tab.classes"));
            this.resourcesTab.setTitleAt(2, Loc.get("timetable.school.tab.rooms"));
            this.resourcesTab.setTitleAt(3, Loc.get("timetable.school.tab.others"));
            this.classesTab.setTitleAt(0, Loc.get("timetable.school.tab.classes.single"));
            this.classesTab.setTitleAt(1, Loc.get("timetable.school.tab.classes.group"));
            this.activitiesTab.setTitleAt(0, Loc.get("timetable.school.tab.lecture"));
            this.activitiesTab.setTitleAt(1, Loc.get("timetable.school.tab.dependence"));
            this.timetableTab.setTitleAt(0, Loc.get("timetable.school.tab.wholeschedule"));
            this.timetableTab.setTitleAt(1, Loc.get("timetable.school.tab.singleschedule"));
            this.timetableTab.setTitleAt(2, Loc.get("timetable.school.tab.rights"));
            this.rightsTab.setTitleAt(0, Loc.get("timetable.school.tab.rights.general"));
            this.rightsTab.setTitleAt(1, Loc.get("timetable.school.tab.rights.specific"));
            this.toolBar.add(this.newActivityButton);
            this.toolBar.add(this.solveButton);
            this.toolBar.addSeparator();
            this.toolBar.add(this.statusLabel);
            this.newActivityButton.addActionListener(new 1());
            this.solveButton.addActionListener(new 2());
            this.teachersTable = new DataTable(new ResourceTableModel(this.problem.getAllTeachers()), this.teachersScrollPane);
            this.teachersTable.addMouseListener(new 3());
            this.specResTable = new DataTable(new ResourceTableModel(this.problem.getAllSpecRes()), this.specResScrollPane);
            this.specResTable.addMouseListener(new 4());
            this.roomsTable = new DataTable(new ResourceTableModel(this.problem.getAllRooms()), this.roomsScrollPane);
            this.roomsTable.addMouseListener(new 5());
            this.classesTable = new DataTable(new ResourceTableModel(this.problem.getAllClasses()), this.classesScrollPane);
            this.classesTable.addMouseListener(new 6());
            this.groupedClassesTable = new DataTable(new GroupedClassTableModel(this.problem.groupedClasses), this.groupedClassesScrollPane);
            this.groupedClassesTable.addMouseListener(new 7());
            this.activitiesTable = new DataTable(new ActivityTableModel(this.problem.activities), this.activitiesScrollPane);
            this.activitiesTable.addMouseListener(new 8());
            this.dependencesTable = new DataTable(new DependenceTableModel(this.problem.dependences), this.dependencesScrollPane);
            this.dependencesTable.addMouseListener(new 9());
            Solver s = new Solver(this.config, this.problem);
            s.setValueSelection(new HumanValueSelection(this.config, new SchoolSingleActivityEvaluation(this.config)));
            s.setVariableSelection(new WorstFirstVariableSelection(this.config));
            this.engine = new DNDActivityEngine(this.problem, s);
            this.engine2 = new DNDActivityEngine(this.problem, s);
            this.oneResNotScheduledActivityTableModel = new NotScheduledActivityTableModel(this.problem);
            this.oneResNotScheduledActivitiesTable = new DNDDataTable(this.oneResNotScheduledActivityTableModel, this.oneResNotScheduledActivitiesScrollPane, this.engine2);
            this.oneResNotScheduledActivitiesTable.addMouseListener(new 10());
            this.notScheduledActivityTableModel = new NotScheduledActivityTableModel(this.problem);
            this.notScheduledActivitiesTable = new DNDDataTable(this.notScheduledActivityTableModel, this.notScheduledActivitiesScrollPane, this.engine);
            this.notScheduledActivitiesTable.addMouseListener(new 11());
            this.activitiesMenu = new JPopupMenu();
            this.addActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.activity.add"));
            this.editActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.activity.update"));
            this.removeActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.activity.remove"));
            this.scheduleActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.solve"));
            this.activitiesMenu.add(this.addActMenuItem);
            this.activitiesMenu.add(this.editActMenuItem);
            this.activitiesMenu.add(this.removeActMenuItem);
            this.activitiesMenu.add(new JPopupMenu.Separator());
            this.activitiesMenu.add(this.scheduleActMenuItem);
            this.scheduleActMenuItem.addActionListener(new 12());
            this.addActMenuItem.addActionListener(new 13());
            this.editActMenuItem.addActionListener(new 14());
            this.removeActMenuItem.addActionListener(new 15());
            this.allResourcesTableModel = new AllResourcesTableModel(this.problem.resources);
            this.allResourcesTable = new DataTable(this.allResourcesTableModel, this.allResourcesScrollPane);
            this.allResourcesTable.getSelectionModel().addListSelectionListener(new 16());
            this.oneResourceSchedulePanel = new TimeTablePanel(this.config);
            this.oneResourceScheduleScrollPane.setViewportView(this.oneResourceSchedulePanel);
            this.oneResourceSchedulePanel.setResource(this.allResourcesTableModel.getResource(this.allResourcesTable.getSelectedRow()));
            this.resourceCombo.addItem(Loc.get("timetable.school.resource.classes"));
            this.resourceCombo.addItem(Loc.get("timetable.school.resource.teachers"));
            this.resourceCombo.addItem(Loc.get("timetable.school.resource.rooms"));
            this.resourceCombo.setSelectedIndex(0);
            this.resourceCombo.addActionListener(new 17());
            this.allResourcesScheduleModel = new TimeTableModel(this.config, this.problem.resources[this.resourceCombo.getSelectedIndex()]);
            this.allResourcesScheduleTable = new TimeTableTable(this.allResourcesScheduleModel, this.fullScheduleScrollPane, this.engine);
            this.removeActFromTableMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.remove"));
            this.removeActFromORPanelMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.remove"));
            this.allResourcesScheduleModel.addMenuSeparator();
            this.allResourcesScheduleModel.addMenuItem(this.removeActFromTableMenuItem);
            this.oneResourceSchedulePanel.addMenuSeparator();
            this.oneResourceSchedulePanel.addMenuItem(this.removeActFromORPanelMenuItem);
            this.removeActFromORPanelMenuItem.addActionListener(new 18());
            this.removeActFromTableMenuItem.addActionListener(new 19());
            this.oneResourceSchedulePanel.setDNDEngine(this.engine2);
            this.engine2.addDNDListener(new 20());
            this.engine.addDNDListener(new 21());
            this.solverRightsPanel = new SolverRightsPanel();
            this.basicRightsScrollPane.setViewportView(this.solverRightsPanel);
            this.solverRightsPanel.setConfig(this.config);
            this.schoolRightsPanel = new SchoolRightsPanel();
            this.specRightsScrollPane.setViewportView(this.schoolRightsPanel);
            this.schoolRightsPanel.setConfig(this.config);
            ((Component)this).setSize(604, 543);
            ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 2);
        }
        catch (Exception e) {
            this.dispError(e);
            System.exit(1);
        }
    }

    public void dispError(Exception e) {
        System.err.println("Error: " + e);
        e.printStackTrace(System.err);
        new MessageDlg((Frame)this, Loc.get("timetable.school.error"), String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), MessageDlg.OK).show();
    }

    private void initComponents() {
        this.menu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newTimetableMenuItem = new JMenuItem();
        this.loadTimetableMenuItem = new JMenuItem();
        this.saveTimetableMenuItem = new JMenuItem();
        this.saveAsTimetableMenuItem = new JMenuItem();
        this.separator1 = new JSeparator();
        this.resetMenuItem = new JMenuItem();
        this.separator2 = new JSeparator();
        this.closeMenuItem = new JMenuItem();
        this.toolBar = new JToolBar();
        this.mainTab = new JTabbedPane();
        this.resourcesPanel = new JPanel();
        this.resourcesTab = new JTabbedPane();
        this.teachersPanel = new JPanel();
        this.teachersScrollPane = new JScrollPane();
        this.teachersCommandPanel = new JPanel();
        this.addTeacherButton = new JButton();
        this.editTeacherButton = new JButton();
        this.removeTeacherButton = new JButton();
        this.classesPanel = new JPanel();
        this.classesTab = new JTabbedPane();
        this.singleClassesPanel = new JPanel();
        this.classesCommandPanel = new JPanel();
        this.addClassButton = new JButton();
        this.editClassButton = new JButton();
        this.removeClassButton = new JButton();
        this.classesScrollPane = new JScrollPane();
        this.groupedClassesPanel = new JPanel();
        this.groupedClassesCommandPanel = new JPanel();
        this.addClassGroupButton = new JButton();
        this.editClassGroupButton = new JButton();
        this.removeClassGroupButton = new JButton();
        this.groupedClassesScrollPane = new JScrollPane();
        this.roomsPanel = new JPanel();
        this.roomsScrollPane = new JScrollPane();
        this.roomsCommandPanel = new JPanel();
        this.addRoomButton = new JButton();
        this.editRoomButton = new JButton();
        this.removeRoomButton = new JButton();
        this.specResPanel = new JPanel();
        this.specResScrollPane = new JScrollPane();
        this.specResCommandPanel = new JPanel();
        this.addSpecResButton = new JButton();
        this.editSpecResButton = new JButton();
        this.removeSpecResButton = new JButton();
        this.activitiesAndDependancesPanel = new JPanel();
        this.activitiesTab = new JTabbedPane();
        this.activitiesPanel = new JPanel();
        this.activitiesScrollPane = new JScrollPane();
        this.activitiesCommandPanel = new JPanel();
        this.addActivityButtom = new JButton();
        this.editActivityButton = new JButton();
        this.removeActivityButton = new JButton();
        this.dependencesPanel = new JPanel();
        this.dependencesScrollPane = new JScrollPane();
        this.dependencesCommandPanel = new JPanel();
        this.addDependenceButton = new JButton();
        this.editDependenceButton = new JButton();
        this.removeDependenceButton = new JButton();
        this.timetablePanel = new JPanel();
        this.timetableTab = new JTabbedPane();
        this.fullTimetablePabel = new JPanel();
        this.fullTimetableCommandPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.resourceCombo = new JComboBox();
        this.fullTimetableSplitPane = new JSplitPane();
        this.fullScheduleScrollPane = new JScrollPane();
        this.notScheduledActivitiesPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.notScheduledActivitiesScrollPane = new JScrollPane();
        this.resourceTimetablePanel = new JPanel();
        this.oneResourceSplitPane = new JSplitPane();
        this.oneResourceScheduleScrollPane = new JScrollPane();
        this.resourceVsUnschedActivitiesSplitPane = new JSplitPane();
        this.notScheduledActivitiesScrollPane2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.oneResNotScheduledActivitiesScrollPane = new JScrollPane();
        this.resourceTimetableCommandPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.allResourcesScrollPane = new JScrollPane();
        this.rightsPanel = new JPanel();
        this.rightsTab = new JTabbedPane();
        this.basicRightsScrollPane = new JScrollPane();
        this.specRightsScrollPane = new JScrollPane();
        this.fileMenu.setActionCommand("Rozvrh");
        this.fileMenu.setText(Loc.get("timetable.school.menu.file"));
        this.newTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.new"));
        this.newTimetableMenuItem.addActionListener(new 22());
        this.fileMenu.add(this.newTimetableMenuItem);
        this.loadTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.open"));
        this.loadTimetableMenuItem.addActionListener(new 23());
        this.fileMenu.add(this.loadTimetableMenuItem);
        this.saveTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.save"));
        this.saveTimetableMenuItem.addActionListener(new 24());
        this.fileMenu.add(this.saveTimetableMenuItem);
        this.saveAsTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.saveas"));
        this.saveAsTimetableMenuItem.addActionListener(new 25());
        this.fileMenu.add(this.saveAsTimetableMenuItem);
        this.fileMenu.add(this.separator1);
        this.resetMenuItem.setText(Loc.get("timetable.school.menu.file.reset"));
        this.resetMenuItem.addActionListener(new 26());
        this.fileMenu.add(this.resetMenuItem);
        this.fileMenu.add(this.separator2);
        this.closeMenuItem.setText(Loc.get("timetable.school.menu.file.exit"));
        this.closeMenuItem.addActionListener(new 27());
        this.fileMenu.add(this.closeMenuItem);
        this.menu.add(this.fileMenu);
        this.addComponentListener(new 28());
        this.addWindowListener(new 29());
        ((Container)this.toolBar).setLayout(new FlowLayout(0, 5, 0));
        this.toolBar.setPreferredSize(new Dimension(600, 25));
        this.toolBar.setFloatable(false);
        this.getContentPane().add((Component)this.toolBar, "South");
        this.mainTab.setPreferredSize(new Dimension(600, 400));
        this.mainTab.addChangeListener(new 30());
        this.resourcesPanel.setLayout(new BorderLayout());
        this.teachersPanel.setLayout(new BorderLayout());
        this.teachersPanel.add((Component)this.teachersScrollPane, "Center");
        this.teachersCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addTeacherButton.setText(Loc.get("timetable.school.button.add"));
        this.addTeacherButton.addActionListener(new 31());
        this.teachersCommandPanel.add(this.addTeacherButton);
        this.editTeacherButton.setText(Loc.get("timetable.school.button.edit"));
        this.editTeacherButton.addActionListener(new 32());
        this.teachersCommandPanel.add(this.editTeacherButton);
        this.removeTeacherButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeTeacherButton.addActionListener(new 33());
        this.teachersCommandPanel.add(this.removeTeacherButton);
        this.teachersPanel.add((Component)this.teachersCommandPanel, "South");
        this.resourcesTab.addTab("Vyu\u010duj\u00edc\u00ed", this.teachersPanel);
        this.classesPanel.setLayout(new BorderLayout());
        this.singleClassesPanel.setLayout(new BorderLayout());
        this.classesCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addClassButton.setText(Loc.get("timetable.school.button.add"));
        this.addClassButton.addActionListener(new 34());
        this.classesCommandPanel.add(this.addClassButton);
        this.editClassButton.setText(Loc.get("timetable.school.button.edit"));
        this.editClassButton.addActionListener(new 35());
        this.classesCommandPanel.add(this.editClassButton);
        this.removeClassButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeClassButton.addActionListener(new 36());
        this.classesCommandPanel.add(this.removeClassButton);
        this.singleClassesPanel.add((Component)this.classesCommandPanel, "South");
        this.singleClassesPanel.add((Component)this.classesScrollPane, "Center");
        this.classesTab.addTab("Jednotliv\u00e9 t\u0159\u00eddy, podt\u0159\u00eddy", this.singleClassesPanel);
        this.groupedClassesPanel.setLayout(new BorderLayout());
        this.groupedClassesCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addClassGroupButton.setText(Loc.get("timetable.school.button.add"));
        this.addClassGroupButton.addActionListener(new 37());
        this.groupedClassesCommandPanel.add(this.addClassGroupButton);
        this.editClassGroupButton.setText(Loc.get("timetable.school.button.edit"));
        this.editClassGroupButton.addActionListener(new 38());
        this.groupedClassesCommandPanel.add(this.editClassGroupButton);
        this.removeClassGroupButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeClassGroupButton.addActionListener(new 39());
        this.groupedClassesCommandPanel.add(this.removeClassGroupButton);
        this.groupedClassesPanel.add((Component)this.groupedClassesCommandPanel, "South");
        this.groupedClassesPanel.add((Component)this.groupedClassesScrollPane, "Center");
        this.classesTab.addTab("Skupiny t\u0159\u00edd", this.groupedClassesPanel);
        this.classesPanel.add((Component)this.classesTab, "Center");
        this.resourcesTab.addTab("T\u0159\u00eddy", this.classesPanel);
        this.roomsPanel.setLayout(new BorderLayout());
        this.roomsPanel.add((Component)this.roomsScrollPane, "Center");
        this.roomsCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addRoomButton.setText(Loc.get("timetable.school.button.add"));
        this.addRoomButton.addActionListener(new 40());
        this.roomsCommandPanel.add(this.addRoomButton);
        this.editRoomButton.setText(Loc.get("timetable.school.button.edit"));
        this.editRoomButton.addActionListener(new 41());
        this.roomsCommandPanel.add(this.editRoomButton);
        this.removeRoomButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeRoomButton.addActionListener(new 42());
        this.roomsCommandPanel.add(this.removeRoomButton);
        this.roomsPanel.add((Component)this.roomsCommandPanel, "South");
        this.resourcesTab.addTab("U\u010debny", this.roomsPanel);
        this.specResPanel.setLayout(new BorderLayout());
        this.specResPanel.add((Component)this.specResScrollPane, "Center");
        this.specResCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addSpecResButton.setText(Loc.get("timetable.school.button.add"));
        this.addSpecResButton.addActionListener(new 43());
        this.specResCommandPanel.add(this.addSpecResButton);
        this.editSpecResButton.setText(Loc.get("timetable.school.button.edit"));
        this.editSpecResButton.addActionListener(new 44());
        this.specResCommandPanel.add(this.editSpecResButton);
        this.removeSpecResButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeSpecResButton.addActionListener(new 45());
        this.specResCommandPanel.add(this.removeSpecResButton);
        this.specResPanel.add((Component)this.specResCommandPanel, "South");
        this.resourcesTab.addTab("Ostatn\u00ed", this.specResPanel);
        this.resourcesPanel.add((Component)this.resourcesTab, "Center");
        this.mainTab.addTab("Zdroje", this.resourcesPanel);
        this.activitiesAndDependancesPanel.setLayout(new BorderLayout());
        this.activitiesPanel.setLayout(new BorderLayout());
        this.activitiesPanel.add((Component)this.activitiesScrollPane, "Center");
        this.activitiesCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addActivityButtom.setText(Loc.get("timetable.school.button.add"));
        this.addActivityButtom.addActionListener(new 46());
        this.activitiesCommandPanel.add(this.addActivityButtom);
        this.editActivityButton.setText(Loc.get("timetable.school.button.edit"));
        this.editActivityButton.addActionListener(new 47());
        this.activitiesCommandPanel.add(this.editActivityButton);
        this.removeActivityButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeActivityButton.addActionListener(new 48());
        this.activitiesCommandPanel.add(this.removeActivityButton);
        this.activitiesPanel.add((Component)this.activitiesCommandPanel, "South");
        this.activitiesTab.addTab("P\u0159edm\u011bty", this.activitiesPanel);
        this.dependencesPanel.setLayout(new BorderLayout());
        this.dependencesPanel.add((Component)this.dependencesScrollPane, "Center");
        this.dependencesCommandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addDependenceButton.setText(Loc.get("timetable.school.button.add"));
        this.addDependenceButton.addActionListener(new 49());
        this.dependencesCommandPanel.add(this.addDependenceButton);
        this.editDependenceButton.setText(Loc.get("timetable.school.button.edit"));
        this.editDependenceButton.addActionListener(new 50());
        this.dependencesCommandPanel.add(this.editDependenceButton);
        this.removeDependenceButton.setText(Loc.get("timetable.school.button.remove"));
        this.removeDependenceButton.addActionListener(new 51());
        this.dependencesCommandPanel.add(this.removeDependenceButton);
        this.dependencesPanel.add((Component)this.dependencesCommandPanel, "South");
        this.activitiesTab.addTab("Z\u00e1vislosti mezi p\u0159edm\u011bty", this.dependencesPanel);
        this.activitiesAndDependancesPanel.add((Component)this.activitiesTab, "Center");
        this.mainTab.addTab("Vyu\u010dovan\u00e9 p\u0159edm\u011bty", this.activitiesAndDependancesPanel);
        this.timetablePanel.setLayout(new BorderLayout());
        this.fullTimetablePabel.setLayout(new BorderLayout());
        this.fullTimetableCommandPanel.setLayout(new FlowLayout(0, 5, 5));
        this.jLabel1.setText(Loc.get("timetable.school.label.selectres"));
        this.fullTimetableCommandPanel.add(this.jLabel1);
        this.fullTimetableCommandPanel.add(this.resourceCombo);
        this.fullTimetablePabel.add((Component)this.fullTimetableCommandPanel, "North");
        this.fullTimetableSplitPane.setDividerLocation(200);
        this.fullTimetableSplitPane.setResizeWeight(0.5);
        this.fullTimetableSplitPane.setOrientation(0);
        this.fullTimetableSplitPane.setOneTouchExpandable(true);
        this.fullTimetableSplitPane.setTopComponent(this.fullScheduleScrollPane);
        this.notScheduledActivitiesPanel.setLayout(new BorderLayout());
        this.jLabel2.setText(Loc.get("timetable.school.label.unschedactivities"));
        this.notScheduledActivitiesPanel.add((Component)this.jLabel2, "North");
        this.notScheduledActivitiesScrollPane.setPreferredSize(new Dimension(200, 150));
        this.notScheduledActivitiesPanel.add((Component)this.notScheduledActivitiesScrollPane, "Center");
        this.fullTimetableSplitPane.setBottomComponent(this.notScheduledActivitiesPanel);
        this.fullTimetablePabel.add((Component)this.fullTimetableSplitPane, "Center");
        this.timetableTab.addTab("Cel\u00fd rozvrh", this.fullTimetablePabel);
        this.resourceTimetablePanel.setLayout(new BorderLayout());
        this.oneResourceSplitPane.setDividerLocation(100);
        this.oneResourceSplitPane.setOrientation(0);
        this.oneResourceSplitPane.setBottomComponent(this.oneResourceScheduleScrollPane);
        this.resourceVsUnschedActivitiesSplitPane.setDividerLocation(0);
        this.resourceVsUnschedActivitiesSplitPane.setLastDividerLocation(0);
        this.resourceVsUnschedActivitiesSplitPane.setOneTouchExpandable(true);
        this.notScheduledActivitiesScrollPane2.setLayout(new BorderLayout());
        this.jLabel4.setText(Loc.get("timetable.school.label.unschedactivities"));
        this.notScheduledActivitiesScrollPane2.add((Component)this.jLabel4, "North");
        this.oneResNotScheduledActivitiesScrollPane.setPreferredSize(new Dimension(200, 150));
        this.notScheduledActivitiesScrollPane2.add((Component)this.oneResNotScheduledActivitiesScrollPane, "Center");
        this.resourceVsUnschedActivitiesSplitPane.setLeftComponent(this.notScheduledActivitiesScrollPane2);
        this.resourceTimetableCommandPanel.setLayout(new BorderLayout());
        this.jLabel3.setText(Loc.get("timetable.school.label.resource"));
        this.resourceTimetableCommandPanel.add((Component)this.jLabel3, "North");
        this.allResourcesScrollPane.setPreferredSize(new Dimension(200, 150));
        this.resourceTimetableCommandPanel.add((Component)this.allResourcesScrollPane, "Center");
        this.resourceVsUnschedActivitiesSplitPane.setRightComponent(this.resourceTimetableCommandPanel);
        this.oneResourceSplitPane.setTopComponent(this.resourceVsUnschedActivitiesSplitPane);
        this.resourceTimetablePanel.add((Component)this.oneResourceSplitPane, "Center");
        this.timetableTab.addTab("Rozvrh jednotliv\u00fdch zdroj\u016f", this.resourceTimetablePanel);
        this.rightsPanel.setLayout(new BorderLayout());
        this.basicRightsScrollPane.setAlignmentX(0.0f);
        this.rightsTab.addTab("Obecn\u00e9", this.basicRightsScrollPane);
        this.specRightsScrollPane.setAlignmentX(0.0f);
        this.rightsTab.addTab("Specifick\u00e9", this.specRightsScrollPane);
        this.rightsPanel.add((Component)this.rightsTab, "Center");
        this.timetableTab.addTab("Pravidla", this.rightsPanel);
        this.timetablePanel.add((Component)this.timetableTab, "Center");
        this.mainTab.addTab("Rozvrh", this.timetablePanel);
        this.getContentPane().add((Component)this.mainTab, "Center");
        this.setJMenuBar(this.menu);
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void resetMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.problem.reset();
            this.updateScheduleTables();
            this.clearStatus();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void removeSpecResButtonActionPerformed(ActionEvent evt) {
        try {
            Resource r = this.problem.getAllSpecRes().get(this.specResTable.getSelectedRow());
            if (this.problem.activities.containsResource(r) >= 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.resource.cannotremove"), Loc.get("timetable.school.message.resource.cannotremove.used", this.problem.activities.get((int)this.problem.activities.containsResource((Resource)r)).name), MessageDlg.OK).show();
                return;
            }
            if (r != null) {
                MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.message.question.resource.remove", r.name), MessageDlg.YESNO);
                md.show();
                if (md.getReturnStatus() == MessageDlg.YES) {
                    this.problem.getAllSpecRes().remove(r);
                    this.specResTable.updateUI();
                }
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editSpecResButtonActionPerformed(ActionEvent evt) {
        try {
            new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.updateresource"), this.config, this.problem.getAllSpecRes().get(this.specResTable.getSelectedRow())).show();
            this.specResTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addSpecResButtonActionPerformed(ActionEvent evt) {
        try {
            Resource resource = new Resource(this.config);
            EditResourceDlg dialog = new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.newresource"), this.config, resource);
            dialog.show();
            if (dialog.getReturnStatus()) {
                this.problem.getAllSpecRes().add(resource);
            }
            this.specResTable.updateUI();
            this.specResTable.gotoLast();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void cancelRightsButtonActionPerformed(ActionEvent evt) {
        this.solverRightsPanel.loadData();
        this.schoolRightsPanel.loadData();
    }

    private void setRightsButtonActionPerformed(ActionEvent evt) {
        this.solverRightsPanel.storeData();
        this.schoolRightsPanel.storeData();
    }

    private void updateScheduleTables() throws TimetableException {
        this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
        this.oneResNotScheduledActivitiesTable.updateUI();
        this.notScheduledActivityTableModel.forceActivitiesChanged();
        this.allResourcesScheduleTable.updateUI();
        this.notScheduledActivitiesTable.updateUI();
        this.oneResourceSchedulePanel.setResource(this.allResourcesTableModel.getResource(this.allResourcesTable.getSelectedRow()));
        this.oneResourceSchedulePanel.updateUI();
        this.allResourcesTable.updateUI();
    }

    private void mainTabStateChanged(ChangeEvent evt) {
        try {
            if (this.mainTab.getModel().getSelectedIndex() == 2) {
                this.problem.checkConsistency();
                this.updateScheduleTables();
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    public void setStatus(String status) {
        this.statusLabel.setText(String.valueOf(Loc.get("timetable.school.text.state")) + " " + status);
        this.toolBar.repaint();
    }

    public void clearStatus() {
        this.setStatus("");
    }

    private void removeDependenceButtonActionPerformed(ActionEvent evt) {
        try {
            ActivityDependenceInterface d = this.problem.dependences.get(this.dependencesTable.getSelectedRow());
            if (d != null && this.question(Loc.get("timetable.school.message.question.dependence.remove", new String[]{d.getFirstActivity().name, d.getSecondActivity().name}))) {
                this.problem.dependences.remove(d);
                this.dependencesTable.updateUI();
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editDependenceButtonActionPerformed(ActionEvent evt) {
        try {
            new EditDependenceDlg(this, Loc.get("timetable.school.dependencedlg.title.updatedependence"), this.config, this.problem.dependences.get(this.dependencesTable.getSelectedRow()), this.problem).show();
            this.dependencesTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addDependenceButtonActionPerformed(ActionEvent evt) {
        try {
            TimeActivityDependence dependence = new TimeActivityDependence(null, 0, null);
            EditDependenceDlg dialog = new EditDependenceDlg(this, Loc.get("timetable.school.dependencedlg.title.newdependence"), this.config, dependence, this.problem);
            dialog.show();
            if (dialog.getReturnStatus()) {
                this.problem.dependences.add(dependence);
            }
            this.dependencesTable.updateUI();
            this.dependencesTable.gotoLast();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void removeClassGroupButtonActionPerformed(ActionEvent evt) {
        try {
            ResourceGroup r = this.problem.groupedClasses.getResources(this.groupedClassesTable.getSelectedRow());
            if (this.problem.activities.containsResources(r) >= 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.resource.cannotremove"), Loc.get("timetable.school.message.resourcegroupisused", this.problem.activities.get((int)this.problem.activities.containsResources((ResourceGroup)r)).name), MessageDlg.OK).show();
                return;
            }
            if (r != null && this.question(Loc.get("timetable.school.message.resourcegroup.remove", r.name))) {
                this.problem.groupedClasses.remove(r);
                this.groupedClassesTable.updateUI();
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editClassGroupButtonActionPerformed(ActionEvent evt) {
        try {
            new EditResourceGroupDlg(this, Loc.get("timetable.school.editresourcegroupdlg.title.updateclassgroup"), this.config, this.problem.groupedClasses.getResources(this.groupedClassesTable.getSelectedRow()), this.problem.getAllClasses()).show();
            this.groupedClassesTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addClassGroupButtonActionPerformed(ActionEvent evt) {
        try {
            ResourceGroup resources = new ResourceGroup();
            EditResourceGroupDlg dialog = new EditResourceGroupDlg(this, Loc.get("timetable.school.editresourcegroupdlg.title.newclassgroup"), this.config, resources, this.problem.getAllClasses());
            dialog.show();
            if (dialog.getReturnStatus()) {
                resources.conjunctive = true;
                this.problem.groupedClasses.add(resources);
            }
            this.groupedClassesTable.updateUI();
            this.groupedClassesTable.gotoLast();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    public boolean question(String msg) {
        MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), msg, MessageDlg.YESNO);
        md.show();
        return md.getReturnStatus() == MessageDlg.YES;
    }

    private void removeActivityButtonActionPerformed(ActionEvent evt) {
        try {
            Activity a = this.problem.activities.get(this.activitiesTable.getSelectedRow());
            if (this.problem.dependences.countDependences(a) > 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.activity.cannotremove"), Loc.get("timetable.school.message.activity.cannotremove.dependence"), MessageDlg.OK).show();
                return;
            }
            if (a != null && this.question(Loc.get("timetable.school.message.question.deleteactivity", a.name))) {
                this.problem.activities.remove(a);
                this.activitiesTable.updateUI();
                this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                this.oneResNotScheduledActivitiesTable.updateUI();
                this.notScheduledActivityTableModel.forceActivitiesChanged();
                this.notScheduledActivitiesTable.updateUI();
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editActivityButtonActionPerformed(ActionEvent evt) {
        try {
            new EditActivityDlg(this, Loc.get("timetable.school.editactivitydlg.title.updatelecture"), this.config, this.problem.activities.get(this.activitiesTable.getSelectedRow()), this.problem).show();
            this.activitiesTable.updateUI();
            this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
            this.oneResNotScheduledActivitiesTable.updateUI();
            this.notScheduledActivityTableModel.forceActivitiesChanged();
            this.notScheduledActivitiesTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addActivityButtomActionPerformed(ActionEvent evt) {
        try {
            Activity activity = new Activity(this.config);
            EditActivityDlg dialog = new EditActivityDlg(this, Loc.get("timetable.school.editactivitydlg.title.newlecture"), this.config, activity, this.problem);
            dialog.show();
            if (dialog.getReturnStatus()) {
                this.problem.activities.add(activity);
            }
            this.activitiesTable.updateUI();
            this.activitiesTable.gotoLast();
            this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
            this.oneResNotScheduledActivitiesTable.updateUI();
            this.notScheduledActivityTableModel.forceActivitiesChanged();
            this.notScheduledActivitiesTable.updateUI();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void removeRoomButtonActionPerformed(ActionEvent evt) {
        try {
            Resource r = this.problem.getAllRooms().get(this.roomsTable.getSelectedRow());
            if (this.problem.activities.containsResource(r) >= 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.resource.cannotremove"), Loc.get("timetable.school.message.room.cannotremove.used", this.problem.activities.get((int)this.problem.activities.containsResource((Resource)r)).name), MessageDlg.OK).show();
                return;
            }
            if (r != null) {
                MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.message.room.remove", r.name), MessageDlg.YESNO);
                md.show();
                if (md.getReturnStatus() == MessageDlg.YES) {
                    this.problem.getAllRooms().remove(r);
                    this.roomsTable.updateUI();
                }
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void removeClassButtonActionPerformed(ActionEvent evt) {
        try {
            Resource r = this.problem.getAllClasses().get(this.classesTable.getSelectedRow());
            if (this.problem.groupedClasses.contains(r) >= 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.resource.cannotremove"), Loc.get("timetable.school.message.class.cannotremove.ingroup", this.problem.groupedClasses.getResources((int)this.problem.groupedClasses.contains((Resource)r)).name), MessageDlg.OK).show();
                return;
            }
            if (this.problem.activities.containsResource(r) >= 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.resource.cannotremove"), Loc.get("timetable.school.message.class.cannotremove.activity", this.problem.activities.get((int)this.problem.activities.containsResource((Resource)r)).name), MessageDlg.OK).show();
                return;
            }
            if (r != null) {
                MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.message.question.deleteclass", r.name), MessageDlg.YESNO);
                md.show();
                if (md.getReturnStatus() == MessageDlg.YES) {
                    this.problem.getAllClasses().remove(r);
                    this.classesTable.updateUI();
                }
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editRoomButtonActionPerformed(ActionEvent evt) {
        try {
            new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.updateroom"), this.config, this.problem.getAllRooms().get(this.roomsTable.getSelectedRow())).show();
            this.roomsTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editClassButtonActionPerformed(ActionEvent evt) {
        try {
            new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.updateclass"), this.config, this.problem.getAllClasses().get(this.classesTable.getSelectedRow())).show();
            this.classesTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addRoomButtonActionPerformed(ActionEvent evt) {
        try {
            Resource resource = new Resource(this.config);
            EditResourceDlg dialog = new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.newroom"), this.config, resource);
            dialog.show();
            if (dialog.getReturnStatus()) {
                this.problem.getAllRooms().add(resource);
            }
            this.roomsTable.updateUI();
            this.roomsTable.gotoLast();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addClassButtonActionPerformed(ActionEvent evt) {
        try {
            Resource resource = new Resource(this.config);
            EditResourceDlg dialog = new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.newclass"), this.config, resource);
            dialog.show();
            if (dialog.getReturnStatus()) {
                this.problem.getAllClasses().add(resource);
            }
            this.classesTable.updateUI();
            this.classesTable.gotoLast();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void editTeacherButtonActionPerformed(ActionEvent evt) {
        try {
            new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.updateteacher"), this.config, this.problem.getAllTeachers().get(this.teachersTable.getSelectedRow())).show();
            this.teachersTable.updateUI();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void removeTeacherButtonActionPerformed(ActionEvent evt) {
        try {
            Resource r = this.problem.getAllTeachers().get(this.teachersTable.getSelectedRow());
            if (this.problem.activities.containsResource(r) >= 0) {
                new MessageDlg((Frame)this, Loc.get("timetable.school.message.resource.cannotremove"), Loc.get("timetable.school.message.teacher.cannotremove.activity", this.problem.activities.get((int)this.problem.activities.containsResource((Resource)r)).name), MessageDlg.OK).show();
                return;
            }
            if (r != null) {
                MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.message.question.deleteteacher", r.name), MessageDlg.YESNO);
                md.show();
                if (md.getReturnStatus() == MessageDlg.YES) {
                    this.problem.getAllTeachers().remove(r);
                    this.teachersTable.updateUI();
                }
            }
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void addTeacherButtonActionPerformed(ActionEvent evt) {
        try {
            Resource resource = new Resource(this.config);
            EditResourceDlg dialog = new EditResourceDlg((Frame)this, Loc.get("timetable.school.editresourcedlg.title.newteacher"), this.config, resource);
            dialog.show();
            if (dialog.getReturnStatus()) {
                this.problem.getAllTeachers().add(resource);
            }
            this.teachersTable.updateUI();
            this.teachersTable.gotoLast();
            this.repaint();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    private void saveAsTimetableMenuItemActionPerformed(ActionEvent evt) {
        this.save(true);
    }

    public void save(boolean saveAs) {
        try {
            String newFileName = this.fileName;
            if (this.fileName == null || saveAs) {
                JFileChooser fc = new JFileChooser(".");
                fc.addChoosableFileFilter(new TimetableFilter(".shld .shd .tt .st", Loc.get("timetable.school.title")));
                fc.setDialogTitle(Loc.get("timetable.school.saveasdlg.title"));
                fc.showSaveDialog(this);
                if (fc.getSelectedFile() == null) {
                    return;
                }
                newFileName = fc.getSelectedFile().toString();
                if (fc.getSelectedFile().getName().indexOf(46) == -1) {
                    newFileName = String.valueOf(newFileName) + ".shd";
                }
            }
            this.problem.save(newFileName);
            this.setTitle(String.valueOf(Loc.get("timetable.school.title")) + "   [" + newFileName + "]");
            this.fileName = newFileName;
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            this.dispError(e);
        }
    }

    public void updateModels() {
        this.teachersTable.setModel(new ResourceTableModel(this.problem.getAllTeachers()));
        this.roomsTable.setModel(new ResourceTableModel(this.problem.getAllRooms()));
        this.specResTable.setModel(new ResourceTableModel(this.problem.getAllSpecRes()));
        this.classesTable.setModel(new ResourceTableModel(this.problem.getAllClasses()));
        this.activitiesTable.setModel(new ActivityTableModel(this.problem.activities));
        this.groupedClassesTable.setModel(new GroupedClassTableModel(this.problem.groupedClasses));
        this.dependencesTable.setModel(new DependenceTableModel(this.problem.dependences));
        this.oneResNotScheduledActivityTableModel = new NotScheduledActivityTableModel(this.problem);
        this.oneResNotScheduledActivitiesTable.setModel(this.oneResNotScheduledActivityTableModel);
        this.notScheduledActivityTableModel = new NotScheduledActivityTableModel(this.problem);
        this.notScheduledActivitiesTable.setModel(this.notScheduledActivityTableModel);
        this.allResourcesTableModel = new AllResourcesTableModel(this.problem.resources);
        this.allResourcesTable.setModel(this.allResourcesTableModel);
        this.allResourcesScheduleModel.setResources(this.problem.resources[this.resourceCombo.getSelectedIndex()]);
    }

    public void load(boolean selectFile) {
        try {
            String newFileName = this.fileName;
            if (selectFile) {
                JFileChooser fc = new JFileChooser(".");
                fc.setDialogTitle(Loc.get("timetable.school.opendlg.title"));
                fc.addChoosableFileFilter(new TimetableFilter(".shld .shd .tt .st", Loc.get("timetable.school.title")));
                fc.showOpenDialog(this);
                if (fc.getSelectedFile() != null) {
                    newFileName = fc.getSelectedFile().toString();
                } else {
                    return;
                }
            }
            SchoolProblem newProblem = (SchoolProblem)SchoolProblem.load(newFileName);
            this.config = newProblem.config;
            this.solverRightsPanel.setConfig(this.config);
            this.schoolRightsPanel.setConfig(this.config);
            this.oneResourceSchedulePanel.setConfig(this.config);
            Solver s = new Solver(this.config, this.problem);
            s.setValueSelection(new HumanValueSelection(this.config, new SchoolSingleActivityEvaluation(this.config)));
            s.setVariableSelection(new WorstFirstVariableSelection(this.config));
            this.engine = new DNDActivityEngine(this.problem, s);
            this.engine2 = new DNDActivityEngine(this.problem, s);
            this.oneResNotScheduledActivitiesTable.setDNDTableEngine(this.engine2);
            this.notScheduledActivitiesTable.setDNDTableEngine(this.engine);
            this.allResourcesScheduleModel = new TimeTableModel(this.config, this.problem.resources[this.resourceCombo.getSelectedIndex()]);
            this.allResourcesScheduleTable = new TimeTableTable(this.allResourcesScheduleModel, this.fullScheduleScrollPane, this.engine);
            this.allResourcesScheduleModel.addMenuSeparator();
            this.allResourcesScheduleModel.addMenuItem(this.removeActFromTableMenuItem);
            this.oneResourceSchedulePanel.setDNDEngine(this.engine2);
            this.engine2.addDNDListener(new 52());
            this.engine.addDNDListener(new 53());
            this.setTitle(String.valueOf(Loc.get("timetable.school.title")) + "   [" + newFileName + "]");
            this.fileName = newFileName;
            this.problem.setProblem(newProblem);
            this.updateModels();
        }
        catch (Exception e) {
            this.dispError(e);
        }
    }

    public void save() {
        this.save(false);
    }

    private void saveTimetableMenuItemActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void loadTimetableMenuItemActionPerformed(ActionEvent evt) {
        this.load(true);
    }

    private void newTimetableMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.problem.setProblem(new SchoolProblem(new Config()));
            this.config = this.problem.config;
            this.solverRightsPanel.setConfig(this.config);
            this.schoolRightsPanel.setConfig(this.config);
            this.oneResourceSchedulePanel.setConfig(this.config);
            Solver s = new Solver(this.config, this.problem);
            s.setValueSelection(new HumanValueSelection(this.config, new SchoolSingleActivityEvaluation(this.config)));
            s.setVariableSelection(new WorstFirstVariableSelection(this.config));
            this.engine = new DNDActivityEngine(this.problem, s);
            this.engine2 = new DNDActivityEngine(this.problem, s);
            this.oneResNotScheduledActivitiesTable.setDNDTableEngine(this.engine2);
            this.notScheduledActivitiesTable.setDNDTableEngine(this.engine);
            this.allResourcesScheduleModel = new TimeTableModel(this.config, this.problem.resources[this.resourceCombo.getSelectedIndex()]);
            this.allResourcesScheduleTable = new TimeTableTable(this.allResourcesScheduleModel, this.fullScheduleScrollPane, this.engine);
            this.allResourcesScheduleModel.addMenuSeparator();
            this.allResourcesScheduleModel.addMenuItem(this.removeActFromTableMenuItem);
            this.oneResourceSchedulePanel.setDNDEngine(this.engine2);
            this.engine2.addDNDListener(new 54());
            this.engine.addDNDListener(new 55());
            this.setTitle(String.valueOf(Loc.get("timetable.school.title")) + "   [" + Loc.get("timetable.school.title.new") + "]");
            this.fileName = null;
            this.updateModels();
        }
        catch (Exception e) {
            this.dispError(e);
            System.exit(1);
        }
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        if (this.problem.isChanged()) {
            MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.message.saveonexit"), MessageDlg.YESNO + MessageDlg.CANCEL);
            md.show();
            if (md.getReturnStatus() == MessageDlg.YES) {
                this.save();
            }
            if (md.getReturnStatus() == MessageDlg.CANCEL) {
                return;
            }
        }
        this.dispose();
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        if (this.problem.isChanged()) {
            MessageDlg md = new MessageDlg((Frame)this, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.message.saveonexit"), MessageDlg.YESNO);
            md.show();
            if (md.getReturnStatus() == MessageDlg.YES) {
                this.save();
            }
        }
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args != null && args.length >= 1) {
            new SchoolTimetable(args[0]).show();
        } else {
            new SchoolTimetable().show();
        }
    }

    static /* synthetic */ void access$3(SchoolTimetable accsParam$0, SchoolProblem accParam$1) {
        accsParam$0.problem = accParam$1;
    }

    static /* synthetic */ void access$5(SchoolTimetable accsParam$0, JButton accParam$1) {
        accsParam$0.solveButton = accParam$1;
    }

    static /* synthetic */ void access$9(SchoolTimetable accsParam$0, NotScheduledActivityTableModel accParam$1) {
        accsParam$0.oneResNotScheduledActivityTableModel = accParam$1;
    }

    static /* synthetic */ void access$11(SchoolTimetable accsParam$0, DNDDataTable accParam$1) {
        accsParam$0.oneResNotScheduledActivitiesTable = accParam$1;
    }

    static /* synthetic */ void access$13(SchoolTimetable accsParam$0, NotScheduledActivityTableModel accParam$1) {
        accsParam$0.notScheduledActivityTableModel = accParam$1;
    }

    static /* synthetic */ void access$15(SchoolTimetable accsParam$0, TimeTableTable accParam$1) {
        accsParam$0.allResourcesScheduleTable = accParam$1;
    }

    static /* synthetic */ void access$17(SchoolTimetable accsParam$0, DNDDataTable accParam$1) {
        accsParam$0.notScheduledActivitiesTable = accParam$1;
    }

    static /* synthetic */ void access$21(SchoolTimetable accsParam$0, JTabbedPane accParam$1) {
        accsParam$0.mainTab = accParam$1;
    }

    static /* synthetic */ void access$23(SchoolTimetable accsParam$0, JTabbedPane accParam$1) {
        accsParam$0.timetableTab = accParam$1;
    }

    static /* synthetic */ void access$25(SchoolTimetable accsParam$0, Config accParam$1) {
        accsParam$0.config = accParam$1;
    }

    static /* synthetic */ void access$29(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.teachersTable = accParam$1;
    }

    static /* synthetic */ void access$31(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.specResTable = accParam$1;
    }

    static /* synthetic */ void access$33(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.roomsTable = accParam$1;
    }

    static /* synthetic */ void access$35(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.classesTable = accParam$1;
    }

    static /* synthetic */ void access$37(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.groupedClassesTable = accParam$1;
    }

    static /* synthetic */ void access$39(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.activitiesTable = accParam$1;
    }

    static /* synthetic */ void access$41(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.dependencesTable = accParam$1;
    }

    static /* synthetic */ void access$43(SchoolTimetable accsParam$0, JPopupMenu accParam$1) {
        accsParam$0.activitiesMenu = accParam$1;
    }

    static /* synthetic */ void access$45(SchoolTimetable accsParam$0, TimeTablePanel accParam$1) {
        accsParam$0.oneResourceSchedulePanel = accParam$1;
    }

    static /* synthetic */ void access$47(SchoolTimetable accsParam$0, AllResourcesTableModel accParam$1) {
        accsParam$0.allResourcesTableModel = accParam$1;
    }

    static /* synthetic */ void access$49(SchoolTimetable accsParam$0, DataTable accParam$1) {
        accsParam$0.allResourcesTable = accParam$1;
    }

    static /* synthetic */ void access$51(SchoolTimetable accsParam$0, TimeTableModel accParam$1) {
        accsParam$0.allResourcesScheduleModel = accParam$1;
    }

    static /* synthetic */ void access$53(SchoolTimetable accsParam$0, JComboBox accParam$1) {
        accsParam$0.resourceCombo = accParam$1;
    }

    private class SolverThread
    extends Thread {
        public void run() {
            try {
                if (SchoolTimetable.this.solver != null) {
                    SchoolTimetable.this.solver.getProblem().clearCounts();
                    SchoolTimetable.this.solver.solve();
                }
                SchoolTimetable.this.solving = false;
                if (SchoolTimetable.this.problem.unscheduledActivities().size() == 0) {
                    SchoolTimetable.this.setStatus(Loc.get("timetable.school.state.done"));
                } else {
                    SchoolTimetable.this.setStatus(Loc.get("timetable.school.state.solving"));
                    MessageDlg md = new MessageDlg(null, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.question.returnToPrevSched"), MessageDlg.YESNO);
                    md.show();
                    if (md.getReturnStatus() == MessageDlg.YES) {
                        SchoolTimetable.this.problem.restoreLastState();
                    } else {
                        SchoolTimetable.this.problem.restoreBestState();
                    }
                    new MessageTableDlg(Loc.get("timetable.school.solver.fail"), Loc.get("timetable.school.solver.fail"), MessageTableDlg.OK, new JTable(new ProblemActivityTableModel(SchoolTimetable.this.problem))).show();
                }
                SchoolTimetable.this.solveButton.setText(Loc.get("timetable.school.button.solve"));
            }
            catch (Exception e) {
                SchoolTimetable.this.dispError(e);
            }
        }

        SolverThread() {
        }
    }

    private class UpdateThread
    extends Thread {
        public void run() {
            try {
                while (SchoolTimetable.this.solverThread.isAlive()) {
                    SchoolTimetable.this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                    SchoolTimetable.this.oneResNotScheduledActivitiesTable.updateUI();
                    SchoolTimetable.this.notScheduledActivityTableModel.forceActivitiesChanged();
                    SchoolTimetable.this.allResourcesScheduleTable.updateUI();
                    SchoolTimetable.this.notScheduledActivitiesTable.updateUI();
                    Thread.sleep(1000L);
                }
                SchoolTimetable.this.updateScheduleTables();
                SchoolTimetable.this.clearStatus();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                SchoolTimetable.this.dispError(e);
            }
        }

        UpdateThread() {
        }
    }

    class TimetableFilter
    extends FileFilter {
        private String ext;
        private String desc;

        public TimetableFilter(String ext, String desc) {
            this.ext = ext;
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            int i = name.lastIndexOf(46);
            if (i < 0) {
                return false;
            }
            return this.ext.indexOf(name.substring(i).toLowerCase()) != -1;
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addActivityButtomActionPerformed(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            try {
                if (!SchoolTimetable.this.solving) {
                    SchoolTimetable.this.mainTab.getModel().setSelectedIndex(2);
                    SchoolTimetable.this.timetableTab.getModel().setSelectedIndex(0);
                    SchoolTimetable.this.solveButton.setText(Loc.get("timetable.school.button.stop"));
                    SchoolTimetable.this.setStatus(Loc.get("timetable.school.state.solving"));
                    SchoolTimetable.this.problem.saveState();
                    SchoolTimetable.this.solver = new Solver(SchoolTimetable.this.config, SchoolTimetable.this.problem);
                    SchoolTimetable.this.solver.setValueSelection(new MinValueSelection(SchoolTimetable.this.config, new Tabu(SchoolTimetable.this.config), new SchoolSingleActivityEvaluation(SchoolTimetable.this.config)));
                    SchoolTimetable.this.solver.setVariableSelection(new WorstFirstVariableSelection(SchoolTimetable.this.config));
                    SchoolTimetable.this.solverThread = new SolverThread();
                    SchoolTimetable.this.updateThread = new UpdateThread();
                    SchoolTimetable.this.solverThread.start();
                    SchoolTimetable.this.updateThread.start();
                    SchoolTimetable.this.solving = true;
                } else {
                    SchoolTimetable.this.solving = false;
                    SchoolTimetable.this.solverThread.stop();
                    SchoolTimetable.this.updateThread.stop();
                    SchoolTimetable.this.setStatus(Loc.get("timetable.school.state.stopped"));
                    SchoolTimetable.this.solveButton.setText(Loc.get("timetable.school.button.solve"));
                    MessageDlg md = new MessageDlg(null, Loc.get("timetable.school.message.question.title"), Loc.get("timetable.school.question.returnToPrevSched"), MessageDlg.YESNO);
                    md.show();
                    if (md.getReturnStatus() == MessageDlg.YES) {
                        SchoolTimetable.this.problem.restoreLastState();
                    }
                    SchoolTimetable.this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                    SchoolTimetable.this.oneResNotScheduledActivitiesTable.updateUI();
                    SchoolTimetable.this.notScheduledActivityTableModel.forceActivitiesChanged();
                    SchoolTimetable.this.allResourcesScheduleTable.updateUI();
                    SchoolTimetable.this.notScheduledActivitiesTable.updateUI();
                }
            }
            catch (Exception e) {
                SchoolTimetable.this.dispError(e);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditResourceDlg(null, Loc.get("timetable.school.editresourcedlg.title.updateteacher"), SchoolTimetable.this.config, SchoolTimetable.this.problem.getAllTeachers().get(SchoolTimetable.this.teachersTable.getSelectedRow())).show();
                    SchoolTimetable.this.teachersTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditResourceDlg(null, Loc.get("timetable.school.editresourcedlg.title.updateresource"), SchoolTimetable.this.config, SchoolTimetable.this.problem.getAllSpecRes().get(SchoolTimetable.this.specResTable.getSelectedRow())).show();
                    SchoolTimetable.this.specResTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditResourceDlg(null, Loc.get("timetable.school.editresourcedlg.title.updateroom"), SchoolTimetable.this.config, SchoolTimetable.this.problem.getAllRooms().get(SchoolTimetable.this.roomsTable.getSelectedRow())).show();
                    SchoolTimetable.this.roomsTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditResourceDlg(null, Loc.get("timetable.school.editresourcedlg.title.updateclass"), SchoolTimetable.this.config, SchoolTimetable.this.problem.getAllClasses().get(SchoolTimetable.this.classesTable.getSelectedRow())).show();
                    SchoolTimetable.this.classesTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditResourceGroupDlg(null, Loc.get("timetable.school.editresourcegroupdlg.title.updateclassgroup"), SchoolTimetable.this.config, ((SchoolTimetable)SchoolTimetable.this).problem.groupedClasses.getResources(SchoolTimetable.this.groupedClassesTable.getSelectedRow()), SchoolTimetable.this.problem.getAllClasses()).show();
                    SchoolTimetable.this.groupedClassesTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditActivityDlg(null, Loc.get("timetable.school.editactivitydlg.title.updatelecture"), SchoolTimetable.this.config, ((SchoolTimetable)SchoolTimetable.this).problem.activities.get(SchoolTimetable.this.activitiesTable.getSelectedRow()), SchoolTimetable.this.problem).show();
                    SchoolTimetable.this.activitiesTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2) {
                try {
                    new EditDependenceDlg(null, Loc.get("timetable.school.dependencedlg.title.updatedependence"), SchoolTimetable.this.config, ((SchoolTimetable)SchoolTimetable.this).problem.dependences.get(SchoolTimetable.this.dependencesTable.getSelectedRow()), SchoolTimetable.this.problem).show();
                    SchoolTimetable.this.dependencesTable.updateUI();
                }
                catch (Exception e) {
                    SchoolTimetable.this.dispError(e);
                }
            }
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) > 0) {
                SchoolTimetable.this.activitiesMenu.show(SchoolTimetable.this.oneResNotScheduledActivitiesTable, e.getX(), e.getY());
            }
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) > 0) {
                SchoolTimetable.this.activitiesMenu.show(SchoolTimetable.this.notScheduledActivitiesTable, e.getX(), e.getY());
            }
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                Solver s = new Solver(SchoolTimetable.this.config, SchoolTimetable.this.problem);
                s.setValueSelection(new HumanValueSelection(SchoolTimetable.this.config, new SchoolSingleActivityEvaluation(SchoolTimetable.this.config)));
                s.setVariableSelection(new WorstFirstVariableSelection(SchoolTimetable.this.config));
                Activity a = ((NotScheduledActivityTableModel)((DNDDataTable)SchoolTimetable.this.activitiesMenu.getInvoker()).getModel()).getActivities().get(((DNDDataTable)SchoolTimetable.this.activitiesMenu.getInvoker()).getSelectedRow());
                s.schedule(a);
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SchoolTimetable.this.addActivityButtomActionPerformed(e);
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                new EditActivityDlg(null, Loc.get("timetable.school.editactivitydlg.title.updatelecture"), SchoolTimetable.this.config, ((NotScheduledActivityTableModel)((DNDDataTable)SchoolTimetable.this.activitiesMenu.getInvoker()).getModel()).getActivities().get(((DNDDataTable)SchoolTimetable.this.activitiesMenu.getInvoker()).getSelectedRow()), SchoolTimetable.this.problem).show();
                SchoolTimetable.this.activitiesTable.updateUI();
                SchoolTimetable.this.notScheduledActivityTableModel.forceActivitiesChanged();
                SchoolTimetable.this.notScheduledActivitiesTable.updateUI();
                SchoolTimetable.this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                SchoolTimetable.this.oneResNotScheduledActivitiesTable.updateUI();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                Activity a = ((NotScheduledActivityTableModel)((DNDDataTable)SchoolTimetable.this.activitiesMenu.getInvoker()).getModel()).getActivities().get(((DNDDataTable)SchoolTimetable.this.activitiesMenu.getInvoker()).getSelectedRow());
                if (((SchoolTimetable)SchoolTimetable.this).problem.dependences.countDependences(a) > 0) {
                    new MessageDlg(null, Loc.get("timetable.school.message.activity.cannotremove"), Loc.get("timetable.school.message.activity.cannotremove.dependence"), MessageDlg.OK).show();
                    return;
                }
                if (a != null && SchoolTimetable.this.question(Loc.get("timetable.school.message.question.deleteactivity", a.name))) {
                    ((SchoolTimetable)SchoolTimetable.this).problem.activities.remove(a);
                    SchoolTimetable.this.activitiesTable.updateUI();
                    SchoolTimetable.this.oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                    SchoolTimetable.this.oneResNotScheduledActivitiesTable.updateUI();
                    SchoolTimetable.this.notScheduledActivityTableModel.forceActivitiesChanged();
                    SchoolTimetable.this.notScheduledActivitiesTable.updateUI();
                }
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            try {
                SchoolTimetable.this.oneResourceSchedulePanel.setResource(SchoolTimetable.this.allResourcesTableModel.getResource(SchoolTimetable.this.allResourcesTable.getSelectedRow()));
                SchoolTimetable.this.oneResourceSchedulePanel.updateUI();
            }
            catch (TimetableException err) {
                SchoolTimetable.this.dispError(err);
            }
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.allResourcesScheduleModel.setResources(((SchoolTimetable)SchoolTimetable.this).problem.resources[SchoolTimetable.this.resourceCombo.getSelectedIndex()]);
            SchoolTimetable.this.allResourcesScheduleTable.updateUI();
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                Activity a = ((SchoolTimetable)SchoolTimetable.this).oneResourceSchedulePanel.selectedActivity;
                if (a != null) {
                    a.remove(a);
                }
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        /* synthetic */ 18() {
        }
    }

    private final class 19
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                Activity a = SchoolTimetable.this.allResourcesScheduleModel.getActivityAt(((SchoolTimetable)SchoolTimetable.this).allResourcesScheduleModel.menuRow, ((SchoolTimetable)SchoolTimetable.this).allResourcesScheduleModel.menuColumn);
                a.remove(a);
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        /* synthetic */ 19() {
        }
    }

    private final class 20
    implements DNDListener {
        public void drop(DNDEvent e) {
            try {
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        public void drag(DNDEvent e) {
        }

        /* synthetic */ 20() {
        }
    }

    private final class 21
    implements DNDListener {
        public void drop(DNDEvent e) {
            try {
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        public void drag(DNDEvent e) {
        }

        /* synthetic */ 21() {
        }
    }

    private final class 22
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.newTimetableMenuItemActionPerformed(evt);
        }

        /* synthetic */ 22() {
        }
    }

    private final class 23
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.loadTimetableMenuItemActionPerformed(evt);
        }

        /* synthetic */ 23() {
        }
    }

    private final class 24
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.saveTimetableMenuItemActionPerformed(evt);
        }

        /* synthetic */ 24() {
        }
    }

    private final class 25
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.saveAsTimetableMenuItemActionPerformed(evt);
        }

        /* synthetic */ 25() {
        }
    }

    private final class 26
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.resetMenuItemActionPerformed(evt);
        }

        /* synthetic */ 26() {
        }
    }

    private final class 27
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.closeMenuItemActionPerformed(evt);
        }

        /* synthetic */ 27() {
        }
    }

    private final class 28
    extends ComponentAdapter {
        public void componentResized(ComponentEvent evt) {
            SchoolTimetable.this.formComponentResized(evt);
        }

        /* synthetic */ 28() {
        }
    }

    private final class 29
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            SchoolTimetable.this.exitForm(evt);
        }

        /* synthetic */ 29() {
        }
    }

    private final class 30
    implements ChangeListener {
        public void stateChanged(ChangeEvent evt) {
            SchoolTimetable.this.mainTabStateChanged(evt);
        }

        /* synthetic */ 30() {
        }
    }

    private final class 31
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addTeacherButtonActionPerformed(evt);
        }

        /* synthetic */ 31() {
        }
    }

    private final class 32
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editTeacherButtonActionPerformed(evt);
        }

        /* synthetic */ 32() {
        }
    }

    private final class 33
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeTeacherButtonActionPerformed(evt);
        }

        /* synthetic */ 33() {
        }
    }

    private final class 34
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addClassButtonActionPerformed(evt);
        }

        /* synthetic */ 34() {
        }
    }

    private final class 35
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editClassButtonActionPerformed(evt);
        }

        /* synthetic */ 35() {
        }
    }

    private final class 36
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeClassButtonActionPerformed(evt);
        }

        /* synthetic */ 36() {
        }
    }

    private final class 37
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addClassGroupButtonActionPerformed(evt);
        }

        /* synthetic */ 37() {
        }
    }

    private final class 38
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editClassGroupButtonActionPerformed(evt);
        }

        /* synthetic */ 38() {
        }
    }

    private final class 39
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeClassGroupButtonActionPerformed(evt);
        }

        /* synthetic */ 39() {
        }
    }

    private final class 40
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addRoomButtonActionPerformed(evt);
        }

        /* synthetic */ 40() {
        }
    }

    private final class 41
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editRoomButtonActionPerformed(evt);
        }

        /* synthetic */ 41() {
        }
    }

    private final class 42
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeRoomButtonActionPerformed(evt);
        }

        /* synthetic */ 42() {
        }
    }

    private final class 43
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 43() {
        }
    }

    private final class 44
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 44() {
        }
    }

    private final class 45
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeSpecResButtonActionPerformed(evt);
        }

        /* synthetic */ 45() {
        }
    }

    private final class 46
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addActivityButtomActionPerformed(evt);
        }

        /* synthetic */ 46() {
        }
    }

    private final class 47
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editActivityButtonActionPerformed(evt);
        }

        /* synthetic */ 47() {
        }
    }

    private final class 48
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeActivityButtonActionPerformed(evt);
        }

        /* synthetic */ 48() {
        }
    }

    private final class 49
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.addDependenceButtonActionPerformed(evt);
        }

        /* synthetic */ 49() {
        }
    }

    private final class 50
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.editDependenceButtonActionPerformed(evt);
        }

        /* synthetic */ 50() {
        }
    }

    private final class 51
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchoolTimetable.this.removeDependenceButtonActionPerformed(evt);
        }

        /* synthetic */ 51() {
        }
    }

    private final class 52
    implements DNDListener {
        public void drop(DNDEvent e) {
            try {
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        public void drag(DNDEvent e) {
        }

        /* synthetic */ 52() {
        }
    }

    private final class 53
    implements DNDListener {
        public void drop(DNDEvent e) {
            try {
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        public void drag(DNDEvent e) {
        }

        /* synthetic */ 53() {
        }
    }

    private final class 54
    implements DNDListener {
        public void drop(DNDEvent e) {
            try {
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        public void drag(DNDEvent e) {
        }

        /* synthetic */ 54() {
        }
    }

    private final class 55
    implements DNDListener {
        public void drop(DNDEvent e) {
            try {
                SchoolTimetable.this.updateScheduleTables();
            }
            catch (Exception ex) {
                SchoolTimetable.this.dispError(ex);
            }
        }

        public void drag(DNDEvent e) {
        }

        /* synthetic */ 55() {
        }
    }
}

