/*
 * Decompiled with CFR 0.152.
 */
package timetable.school.data;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import timetable.data.ActivityResources;
import timetable.data.Problem;
import timetable.data.ResourceGroup;
import timetable.util.Config;
import timetable.util.TimetableException;

public class SchoolProblem
extends Problem {
    public ActivityResources groupedClasses = new ActivityResources();
    public static final int RES_ROOMS = 2;
    public static final int RES_TEACHERS = 1;
    public static final int RES_CLASSES = 0;
    public static final int RES_SPEC = 3;

    public SchoolProblem(Config config) throws TimetableException {
        super(config);
        this.resources = new ResourceGroup[]{new ResourceGroup(), new ResourceGroup(), new ResourceGroup(), new ResourceGroup()};
    }

    public void setProblem(Problem problem) {
        super.setProblem(problem);
        this.groupedClasses = ((SchoolProblem)problem).groupedClasses;
    }

    public SchoolProblem(Problem problem) throws TimetableException {
        super(problem);
    }

    public ResourceGroup getAllSpecRes() {
        return this.resources[3];
    }

    public ResourceGroup getAllRooms() {
        return this.resources[2];
    }

    public ResourceGroup getAllTeachers() {
        return this.resources[1];
    }

    public ResourceGroup getAllClasses() {
        return this.resources[0];
    }

    public void save(String file) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        try {
            oos.writeObject(new Problem(this));
            ResourceGroup allResources = new ResourceGroup();
            int i = 0;
            while (i < this.resources.length) {
                int j = 0;
                while (j < this.resources[i].size()) {
                    allResources.add(this.resources[i].get(j));
                    ++j;
                }
                ++i;
            }
            this.groupedClasses.write(oos, allResources);
        }
        finally {
            Object var7_6 = null;
            oos.flush();
            oos.close();
        }
    }

    public static Problem load(String file) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        SchoolProblem p = null;
        try {
            int j;
            p = new SchoolProblem((Problem)ois.readObject());
            if (ois.available() > 0) {
                ResourceGroup allResources = new ResourceGroup();
                int i = 0;
                while (i < p.resources.length) {
                    j = 0;
                    while (j < p.resources[i].size()) {
                        allResources.add(p.resources[i].get(j));
                        ++j;
                    }
                    ++i;
                }
                p.groupedClasses = ActivityResources.read(ois, allResources);
            }
            int i = 0;
            while (i < p.groupedClasses.size()) {
                ResourceGroup g = p.groupedClasses.getResources(i);
                j = 0;
                while (j < p.activities.size()) {
                    int k = 0;
                    while (k < p.activities.get((int)j).resources.size()) {
                        if (p.activities.get((int)j).resources.isGroup(k) && g.equals(p.activities.get((int)j).resources.getResources(k))) {
                            p.activities.get((int)j).resources.setAt(k, g);
                        }
                        ++k;
                    }
                    if (p.activities.get((int)j).selectedResources != null) {
                        k = 0;
                        while (k < p.activities.get((int)j).selectedResources.size()) {
                            if (p.activities.get((int)j).selectedResources.isGroup(k) && g.equals(p.activities.get((int)j).selectedResources.getResources(k))) {
                                p.activities.get((int)j).selectedResources.setAt(k, g);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        finally {
            Object var8_9 = null;
            ois.close();
        }
        return p;
    }
}

