/*
 * Decompiled with CFR 0.152.
 */
package timetable.school.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import timetable.gui.GlobalTimePreferencePanel;
import timetable.util.Config;
import timetable.util.Loc;

public class SchoolRightsPanel
extends JPanel {
    private Config config = null;
    private JPanel timePreferencePanel;
    private JLabel jLabel1;
    private JSlider jSlider1;

    public SchoolRightsPanel() {
        this.initComponents();
        this.timePreferencePanel.setBorder(new TitledBorder(Loc.get("timetable.school.gui.rights.timeprefweight.panel")));
        this.init(this);
    }

    public void setConfig(Config config) {
        try {
            this.config = config;
            this.timePreferencePanel.removeAll();
            this.timePreferencePanel.add(new GlobalTimePreferencePanel(config, config.getGlobalPref()));
            this.loadData();
            this.updateUI();
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
    }

    private void init(Container container) {
        try {
            int i = 0;
            while (i < container.getComponentCount()) {
                Component c = container.getComponent(i);
                if (c instanceof JSlider) {
                    JSlider s = (JSlider)c;
                    s.addChangeListener(new 1());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            e.printStackTrace();
        }
    }

    private void loadData(Container container) {
        try {
            int i = 0;
            while (i < container.getComponentCount()) {
                Component c = container.getComponent(i);
                if (c instanceof Container) {
                    this.loadData((Container)c);
                }
                if (c instanceof JTextField && c.getName() != null) {
                    ((JTextField)c).setText(this.config.get(c.getName()));
                }
                if (c instanceof JCheckBox && c.getName() != null) {
                    ((JCheckBox)c).setSelected(this.config.getInt(c.getName()) > 0);
                }
                if (c instanceof JSlider && c.getName() != null) {
                    ((JSlider)c).setValue(this.config.getInt(c.getName()));
                    ((JSlider)c).setToolTipText(String.valueOf(this.config.getInt(c.getName())));
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            e.printStackTrace();
        }
    }

    public void loadData() {
        this.loadData(this);
    }

    private void storeData(Container container) {
        try {
            int i = 0;
            while (i < container.getComponentCount()) {
                Component c = container.getComponent(i);
                if (c instanceof Container) {
                    this.storeData((Container)c);
                }
                if (c instanceof JTextField && c.getName() != null) {
                    this.config.set(c.getName(), Integer.parseInt(((JTextField)c).getText()));
                }
                if (c instanceof JCheckBox && c.getName() != null) {
                    this.config.set(c.getName(), !((JCheckBox)c).isSelected() ? 0 : 1);
                }
                if (c instanceof JSlider && c.getName() != null) {
                    this.config.set(c.getName(), ((JSlider)c).getValue());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            e.printStackTrace();
        }
    }

    public void storeData() {
        try {
            this.storeData(this);
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.timePreferencePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSlider1 = new JSlider();
        this.setLayout(new GridBagLayout());
        this.timePreferencePanel.setBorder(new TitledBorder("\u010casov\u00e9 preference"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 2;
        this.add((Component)this.timePreferencePanel, gridBagConstraints1);
        this.jLabel1.setText(Loc.get("timetable.school.gui.rights.timeprefweight"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints1);
        this.jSlider1.setPreferredSize(new Dimension(100, 16));
        this.jSlider1.setName("VAHA_CASOVA_PREFERENCE");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.jSlider1, gridBagConstraints1);
    }

    static /* synthetic */ void access$1(SchoolRightsPanel accsParam$0, Config accParam$1) {
        accsParam$0.config = accParam$1;
    }

    private final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            try {
                ((JSlider)e.getSource()).setToolTipText(String.valueOf(((JSlider)e.getSource()).getValue()));
                SchoolRightsPanel.this.config.set(((JSlider)e.getSource()).getName(), ((JSlider)e.getSource()).getValue());
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex);
                ex.printStackTrace();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

