/*
 * Decompiled with CFR 0.152.
 */
package timetable.solver.strategy;

public class Top10 {
    protected int maximum = 10;
    protected int[] top = null;
    protected int count = 0;
    protected Object[] value = null;

    public Top10(int maximum) {
        this.maximum = maximum;
        this.top = new int[maximum];
        this.value = new Object[maximum];
        this.reset();
    }

    public Top10() {
        this(10);
    }

    public int size() {
        return this.count;
    }

    public void reset() {
        int i = 0;
        while (i < this.maximum) {
            this.top[i] = -1;
            this.value[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public boolean willBeAdded(int top) {
        return this.top[this.maximum - 1] == -1 || this.top[this.maximum - 1] > top;
    }

    public void add(int top, Object value) {
        if (this.top[this.maximum - 1] != -1 && this.top[this.maximum - 1] <= top) {
            return;
        }
        int pos = 0;
        while (pos < this.maximum && this.top[pos] != -1 && this.top[pos] < top) {
            ++pos;
        }
        int i = this.maximum - 2;
        while (i >= pos) {
            this.top[i + 1] = this.top[i];
            this.value[i + 1] = this.value[i];
            --i;
        }
        this.top[pos] = top;
        this.value[pos] = value;
        if (this.count < this.maximum) {
            ++this.count;
        }
    }

    public void addMax(int top, Object value) {
        if (this.top[this.maximum - 1] != -1 && this.top[this.maximum - 1] > top) {
            return;
        }
        int pos = 0;
        while (pos < this.maximum && this.top[pos] != -1 && this.top[pos] > top) {
            ++pos;
        }
        int i = this.maximum - 2;
        while (i >= pos) {
            this.top[i + 1] = this.top[i];
            this.value[i + 1] = this.value[i];
            --i;
        }
        this.top[pos] = top;
        this.value[pos] = value;
        if (this.count < this.maximum) {
            ++this.count;
        }
    }

    public Object get(int i) {
        return this.value[i];
    }

    public int top(int i) {
        return this.top[i];
    }

    public static int random(int limit) {
        return (int)(Math.random() * (double)limit);
    }

    public int countInteresting() {
        int i = 1;
        while (i < this.count) {
            if (this.top(i) > 2 * this.top(0)) {
                return i - 1;
            }
            ++i;
        }
        return this.count;
    }
}

