/*
 * Decompiled with CFR 0.152.
 */
package timetable.test;

import java.util.Vector;
import timetable.data.Activity;
import timetable.data.ActivityResources;
import timetable.data.Problem;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.data.TimeActivityDependence;
import timetable.util.Config;
import timetable.util.TimetableException;

public class SmartGenerator {
    protected Config config = null;
    protected int UCEBEN = 20;
    protected int VYUCUJICICH = 20;
    protected int TRID = 20;
    protected int SKUPIN_UCEBEN = 20;
    protected int UCEBEN_VE_SKUPINE_MIN = 1;
    protected int UCEBEN_VE_SKUPINE_MAX = 5;
    protected int UCEBNA_VE_SKUPINACH_MIN = 1;
    protected int DELKA_AKTIVITY_MIN = 1;
    protected int DELKA_AKTIVITY_MAX = 5;
    protected int ZAPLNENI_UCEBEN_PROC = 70;
    protected int HARD_VE_VOLNYCH_ZDROJICH_PROC = 30;
    protected int SOFT_VE_VOLNYCH_ZDROJICH_PROC = 20;
    protected int SOFT_V_POUZITYCH_ZDROJICH_PROC = 5;
    protected int HARD_VE_VOLNYCH_AKTIVITACH_PROC = 30;
    protected int SOFT_VE_VOLNYCH_AKTIVITACH_PROC = 20;
    protected int POCET_BINARNICH_PODMINEK = 1000;
    int celkemDelka = 0;
    public ResourceGroup ucebny = new ResourceGroup();
    public ResourceGroup vyucujici = new ResourceGroup();
    public ResourceGroup tridy = new ResourceGroup();
    public Problem problem;
    public Problem partProblem;

    int random(int limit) {
        return (int)(Math.random() * (double)limit);
    }

    protected void init() throws TimetableException {
        this.UCEBEN = this.config.getInt("GEN_UCEBEN");
        this.VYUCUJICICH = this.config.getInt("GEN_VYUCUJICICH");
        this.TRID = this.config.getInt("GEN_TRID");
        this.SKUPIN_UCEBEN = this.config.getInt("GEN_SKUPIN_UCEBEN");
        this.UCEBEN_VE_SKUPINE_MIN = this.config.getInt("GEN_UCEBEN_VE_SKUPINE_MIN");
        this.UCEBEN_VE_SKUPINE_MAX = this.config.getInt("GEN_UCEBEN_VE_SKUPINE_MAX");
        this.UCEBNA_VE_SKUPINACH_MIN = this.config.getInt("GEN_UCEBNA_VE_SKUPINACH_MIN");
        this.DELKA_AKTIVITY_MIN = this.config.getInt("GEN_DELKA_AKTIVITY_MIN");
        this.DELKA_AKTIVITY_MAX = this.config.getInt("GEN_DELKA_AKTIVITY_MAX");
        this.ZAPLNENI_UCEBEN_PROC = this.config.getInt("GEN_ZAPLNENI_UCEBEN_PROC");
        this.HARD_VE_VOLNYCH_ZDROJICH_PROC = this.config.getInt("GEN_HARD_VE_VOLNYCH_ZDROJICH_PROC");
        this.SOFT_VE_VOLNYCH_ZDROJICH_PROC = this.config.getInt("GEN_SOFT_VE_VOLNYCH_ZDROJICH_PROC");
        this.SOFT_V_POUZITYCH_ZDROJICH_PROC = this.config.getInt("GEN_SOFT_V_POUZITYCH_ZDROJICH_PROC");
        this.HARD_VE_VOLNYCH_AKTIVITACH_PROC = this.config.getInt("GEN_HARD_VE_VOLNYCH_AKTIVITACH_PROC");
        this.SOFT_VE_VOLNYCH_AKTIVITACH_PROC = this.config.getInt("GEN_SOFT_VE_VOLNYCH_AKTIVITACH_PROC");
        this.POCET_BINARNICH_PODMINEK = this.config.getInt("GEN_POCET_CASOVYCH_ZAVISLOSTI");
    }

    public SmartGenerator(Config k) throws TimetableException {
        this(k, true);
    }

    /*
     * Unable to fully structure code
     */
    public SmartGenerator(Config k, boolean reset) throws TimetableException {
        super();
        this.config = k;
        this.init();
        this.ucebny.name = "Ucebny";
        this.vyucujici.name = "Vyucujici";
        this.tridy.name = "Tridy";
        this.problem = new Problem(this.config);
        u = new Resource[this.UCEBEN];
        uc2sk = new Vector[this.UCEBEN];
        i = 0;
        while (i < this.UCEBEN) {
            u[i] = new Resource(this.config, "U" + (1 + i));
            this.ucebny.add(u[i]);
            uc2sk[i] = new Vector<E>();
            ++i;
        }
        v = new Resource[this.VYUCUJICICH];
        i = 0;
        while (i < this.VYUCUJICICH) {
            v[i] = new Resource(this.config, "V" + (1 + i));
            this.vyucujici.add(v[i]);
            ++i;
        }
        t = new Resource[this.TRID];
        i = 0;
        while (i < this.TRID) {
            t[i] = new Resource(this.config, "T" + (i + 1));
            this.tridy.add(t[i]);
            ++i;
        }
        sz = new ResourceGroup[this.SKUPIN_UCEBEN];
        i = 0;
        while (i < this.SKUPIN_UCEBEN) {
            sz[i] = new ResourceGroup();
            j = 0;
            while (j < this.random(1 + this.UCEBEN_VE_SKUPINE_MAX - this.UCEBEN_VE_SKUPINE_MIN) + this.UCEBEN_VE_SKUPINE_MIN) {
                uc = 0;
                while (sz[i].isInGroup(u[uc = this.random(this.UCEBEN)])) {
                }
                sz[i].add(u[uc]);
                uc2sk[uc].add(sz[i]);
                ++j;
            }
            ++i;
        }
        i = 0;
        ** GOTO lbl80
        {
            sk = 0;
            while (sz[sk = this.random(this.SKUPIN_UCEBEN)].isInGroup(u[i])) {
            }
            sz[sk].add(u[i]);
            uc2sk[i].add(sz[sk]);
            do {
                if (uc2sk[i].size() < this.UCEBNA_VE_SKUPINACH_MIN) continue block6;
                ++i;
lbl80:
                // 2 sources

            } while (i < this.UCEBEN);
        }
        rozvrhU = new int[this.config.getInt("POCET_SLOTU")][this.UCEBEN];
        rozvrhV = new int[this.config.getInt("POCET_SLOTU")][this.VYUCUJICICH];
        rozvrhT = new int[this.config.getInt("POCET_SLOTU")][this.TRID];
        i = 0;
        while (i < this.config.getInt("POCET_SLOTU")) {
            j = 0;
            while (j < this.UCEBEN) {
                rozvrhU[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.config.getInt("POCET_SLOTU")) {
            j = 0;
            while (j < this.VYUCUJICICH) {
                rozvrhV[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.config.getInt("POCET_SLOTU")) {
            j = 0;
            while (j < this.TRID) {
                rozvrhT[i][j] = 0;
                ++j;
            }
            ++i;
        }
        celkem = this.config.getInt("POCET_SLOTU") * this.UCEBEN;
        zaplneno = 0;
        aktivita = 1;
        pokus = 0;
        nrSlotsPerDay = this.config.getInt(Config.NR_SLOTS) / this.config.getInt(Config.NR_DAYS);
        do {
            zacatek = this.random(this.config.getInt("POCET_SLOTU"));
            ucebna = this.random(this.UCEBEN);
            if (pokus < 500) {
                pokus = 0;
                while (rozvrhU[zacatek][ucebna] == 0 && pokus < 500) {
                    zacatek = this.random(this.config.getInt("POCET_SLOTU"));
                    ucebna = this.random(this.UCEBEN);
                    ++pokus;
                }
            }
            if (pokus == 500) {
                do {
                    zacatek = this.random(this.config.getInt("POCET_SLOTU"));
                    uc = ucebna = this.random(this.UCEBEN);
                    while (zacatek < this.config.getInt("POCET_SLOTU") && rozvrhU[zacatek][uc] != 0) {
                        if (++uc < this.UCEBEN) continue;
                        uc = ucebna;
                        ++zacatek;
                    }
                    ucebna = uc;
                } while (zacatek >= this.config.getInt("POCET_SLOTU") || rozvrhU[zacatek][ucebna] != 0);
            }
            delka = this.DELKA_AKTIVITY_MAX;
            Adelka = 0;
            pokusP = 0;
            do {
                vyucujici = this.random(this.VYUCUJICICH);
                trida = this.random(this.TRID);
            } while (pokusP < 500 && (rozvrhV[zacatek][vyucujici] != 0 || rozvrhT[zacatek][trida] != 0));
            if (pokusP >= 500) continue;
            zac = zacatek;
            first = true;
            while (delka > 0 && (first || zacatek % nrSlotsPerDay != 0) && zacatek < this.config.getInt("POCET_SLOTU") && rozvrhU[zacatek][ucebna] == 0 && rozvrhV[zacatek][vyucujici] == 0 && rozvrhT[zacatek][trida] == 0) {
                rozvrhU[zacatek][ucebna] = aktivita;
                rozvrhV[zacatek][vyucujici] = aktivita;
                rozvrhT[zacatek][trida] = aktivita;
                first = false;
                ++zacatek;
                --delka;
                ++zaplneno;
                ++Adelka;
            }
            akt = new Activity(this.config, "a" + aktivita, Adelka);
            akt.resources.add(t[trida]);
            akt.resources.add(v[vyucujici]);
            akt.resources.add((ResourceGroup)uc2sk[ucebna].get(this.random(uc2sk[ucebna].size())));
            akt.selectedResources = new ActivityResources();
            akt.selectedResources.add(t[trida]);
            akt.selectedResources.add(v[vyucujici]);
            akt.selectedResources.add(u[ucebna]);
            akt.schedule(zac, akt.selectedResources);
            ++aktivita;
            this.problem.activities.add(akt);
            this.celkemDelka += Adelka;
        } while (100 * zaplneno / celkem < this.ZAPLNENI_UCEBEN_PROC);
        soft_plny = 0;
        soft_volny = 0;
        hard_volny = 0;
        i = 0;
        while (i < this.config.getInt("POCET_SLOTU")) {
            j = 0;
            while (j < this.UCEBEN) {
                if (rozvrhU[i][j] == 0) {
                    if (this.random(100) < this.HARD_VE_VOLNYCH_ZDROJICH_PROC) {
                        ++hard_volny;
                        u[j].getPreference().setHARD(i);
                    } else if (this.random(100) < 100 * this.SOFT_VE_VOLNYCH_ZDROJICH_PROC / (100 - this.HARD_VE_VOLNYCH_ZDROJICH_PROC)) {
                        ++soft_volny;
                        u[j].getPreference().setSOFT(i);
                    }
                } else if (this.random(100) < this.SOFT_V_POUZITYCH_ZDROJICH_PROC) {
                    ++soft_plny;
                    u[j].getPreference().setSOFT(i);
                }
                ++j;
            }
            j = 0;
            while (j < this.TRID) {
                if (rozvrhT[i][j] == 0) {
                    if (this.random(100) < this.HARD_VE_VOLNYCH_ZDROJICH_PROC) {
                        ++hard_volny;
                        t[j].getPreference().setHARD(i);
                    } else if (this.random(100) < 100 * this.SOFT_VE_VOLNYCH_ZDROJICH_PROC / (100 - this.HARD_VE_VOLNYCH_ZDROJICH_PROC)) {
                        ++soft_volny;
                        t[j].getPreference().setSOFT(i);
                    }
                } else if (this.random(100) < this.SOFT_V_POUZITYCH_ZDROJICH_PROC) {
                    ++soft_plny;
                    t[j].getPreference().setSOFT(i);
                }
                ++j;
            }
            j = 0;
            while (j < this.VYUCUJICICH) {
                if (rozvrhV[i][j] == 0) {
                    if (this.random(100) < this.HARD_VE_VOLNYCH_ZDROJICH_PROC) {
                        ++hard_volny;
                        v[j].getPreference().setHARD(i);
                    } else if (this.random(100) < 100 * this.SOFT_VE_VOLNYCH_ZDROJICH_PROC / (100 - this.HARD_VE_VOLNYCH_ZDROJICH_PROC)) {
                        ++soft_volny;
                        v[j].getPreference().setSOFT(i);
                    }
                } else if (this.random(100) < this.SOFT_V_POUZITYCH_ZDROJICH_PROC) {
                    ++soft_plny;
                    v[j].getPreference().setSOFT(i);
                }
                ++j;
            }
            ++i;
        }
        soft_akt = 0;
        hard_akt = 0;
        i = 0;
        while (i < this.problem.activities.size()) {
            j = 0;
            while (j < this.config.getInt("POCET_SLOTU")) {
                if (j < this.problem.activities.get((int)i).start || j >= this.problem.activities.get((int)i).start + this.problem.activities.get((int)i).length) {
                    if (this.random(100) < this.HARD_VE_VOLNYCH_AKTIVITACH_PROC) {
                        ++hard_akt;
                        this.problem.activities.get(i).getPreference().setHARD(j);
                    } else if (this.random(100) < 100 * this.SOFT_VE_VOLNYCH_AKTIVITACH_PROC / (100 - this.HARD_VE_VOLNYCH_AKTIVITACH_PROC)) {
                        ++soft_akt;
                        this.problem.activities.get(i).getPreference().setSOFT(j);
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.POCET_BINARNICH_PODMINEK) {
            a1 = this.problem.activities.get(this.random(this.problem.activities.size()));
            while (a1 == (a2 = this.problem.activities.get(this.random(this.problem.activities.size())))) {
            }
            tad = null;
            if (a1.start < a2.start) {
                if (a1.start + a1.length == a2.start) {
                    tad = new TimeActivityDependence(a1, TimeActivityDependence.CLOSELY_BEFORE, a2);
                } else if (a1.start + a1.length < a2.start) {
                    tad = new TimeActivityDependence(a1, TimeActivityDependence.BEFORE, a2);
                }
            } else if (a2.start == a1.start + a1.length) {
                tad = new TimeActivityDependence(a1, TimeActivityDependence.CLOSELY_AFTER, a2);
            } else if (a2.start > a1.start + a1.length) {
                tad = new TimeActivityDependence(a1, TimeActivityDependence.AFTER, a2);
            }
            if (tad == null) continue;
            this.problem.dependences.add(tad);
            ++i;
        }
        System.out.println("Celkem je " + (aktivita - 1) + " aktivit. ");
        System.out.println("Zaplneno " + zaplneno + " slotu, to je " + 100 * zaplneno / celkem + "%");
        System.out.println("Prumerna delka je " + (float)this.celkemDelka / (float)(aktivita - 1) + " slotu.");
        System.out.println("HARD podminek u zdoju je " + 100 * hard_volny / (this.UCEBEN * this.config.getInt("POCET_SLOTU") + this.VYUCUJICICH * this.config.getInt("POCET_SLOTU") + this.TRID * this.config.getInt("POCET_SLOTU") - 3 * zaplneno) + " %");
        System.out.println("SOFT podminek u volnych zdoju je " + 100 * soft_volny / (this.UCEBEN * this.config.getInt("POCET_SLOTU") + this.VYUCUJICICH * this.config.getInt("POCET_SLOTU") + this.TRID * this.config.getInt("POCET_SLOTU") - 3 * zaplneno) + " %");
        System.out.println("SOFT podminek u zaplnenych zdoju je " + 100 * soft_plny / (3 * zaplneno) + " %");
        System.out.println("HARD podminek u volnych aktivit je " + 100 * hard_akt / (this.problem.activities.size() * this.config.getInt("POCET_SLOTU") - zaplneno) + " %");
        System.out.println("SOFT podminek u volnych aktivit je " + 100 * soft_akt / (this.problem.activities.size() * this.config.getInt("POCET_SLOTU") - zaplneno) + " %");
        System.out.println("V zadani je " + this.problem.dependences.size() + " casovych zavislosti.");
        System.out.println("--------------------------------------------------------------------------------");
        this.problem.resources = new ResourceGroup[]{this.tridy, this.vyucujici, this.ucebny, new ResourceGroup()};
        this.problem.print("GenRozU.txt", this.tridy, 0, 3);
        this.problem.print("GenRozV.txt", this.vyucujici, 1, 3);
        this.problem.print("GenRozT.txt", this.ucebny, 2, 3);
        this.partProblem = new Problem(this.config);
        if (reset) {
            this.problem.reset();
        }
    }

    public Problem generujCele() {
        return this.problem;
    }

    public Problem generuj() {
        if (this.problem.activities.size() == 0) {
            return this.partProblem;
        }
        int akt = this.random(this.problem.activities.size());
        this.partProblem.activities.add(this.problem.activities.get(akt));
        this.problem.activities.remove(this.problem.activities.get(akt));
        return this.partProblem;
    }

    void odeber(Activity a) {
        a.remove(null);
        this.partProblem.activities.remove(a);
        this.problem.activities.add(a);
    }

    void odeber() {
        this.odeber(this.partProblem.activities.get(this.partProblem.activities.size() - 1));
    }

    void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: SmartGenerator [config_file] output_file");
            return;
        }
        try {
            String cfg = null;
            String outfile = null;
            if (args.length == 1) {
                outfile = args[0];
            }
            if (args.length == 2) {
                cfg = args[0];
                outfile = args[1];
            }
            Config k = cfg != null ? new Config(cfg) : new Config();
            SmartGenerator g = new SmartGenerator(k);
            Problem p = g.generujCele();
            p.save(outfile);
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            e.printStackTrace();
        }
    }
}

