/*
 * Decompiled with CFR 0.152.
 */
package timetable.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import timetable.util.Loc;
import timetable.util.TimetableException;

public class Config
implements Serializable {
    public static String NR_SLOTS = "POCET_SLOTU";
    public static String NR_DAYS = "POCET_DNU";
    public static String NR_TRIES = "POCET_ITERACI";
    public static String[] DAY_OF_WEEK = new String[]{"Po", "Ut", "St", "Ct", "Pa", "So", "Ne"};
    public Hashtable configuration = new Hashtable();
    public static String LOG_FILE = "debug.log";
    protected OutputStreamWriter osw = null;
    protected FileOutputStream fos = null;
    protected String file = null;
    private int[] globalPref = null;

    public Config() throws TimetableException {
        this("konfig.cfg");
    }

    public Config(String file) throws TimetableException {
        FileInputStream fis = null;
        this.file = file;
        try {
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            int line_no = 0;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("#") == 0 || line.length() <= 0) continue;
                ++line_no;
                if (line.indexOf("=") < 0) {
                    throw new TimetableException("Error in configuration file \"" + file + "\" on line " + line_no + ".");
                }
                this.configuration.put(line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1));
            }
            fis.close();
            if (this.existKey("DEBUG_LOG")) {
                this.fos = new FileOutputStream(this.get("DEBUG_LOG"));
                this.osw = new OutputStreamWriter(this.fos);
            }
            this.globalPref = new int[this.getInt(NR_SLOTS)];
            int i = 0;
            while (i < this.globalPref.length) {
                this.globalPref[i] = 0;
                ++i;
            }
        }
        catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
        Loc.addLocalization(this.get("LOC_SOLVER"));
        Config.DAY_OF_WEEK[0] = Loc.get("timetable.config.dayOfWeek.mon");
        Config.DAY_OF_WEEK[1] = Loc.get("timetable.config.dayOfWeek.tue");
        Config.DAY_OF_WEEK[2] = Loc.get("timetable.config.dayOfWeek.wed");
        Config.DAY_OF_WEEK[3] = Loc.get("timetable.config.dayOfWeek.thu");
        Config.DAY_OF_WEEK[4] = Loc.get("timetable.config.dayOfWeek.fri");
        Config.DAY_OF_WEEK[5] = Loc.get("timetable.config.dayOfWeek.sat");
        Config.DAY_OF_WEEK[6] = Loc.get("timetable.config.dayOfWeek.san");
    }

    public void save() throws TimetableException {
        FileOutputStream sfos = null;
        try {
            sfos = new FileOutputStream(this.file);
            OutputStreamWriter sosw = new OutputStreamWriter(sfos);
            Enumeration e = this.configuration.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sosw.write(String.valueOf(key) + "=" + this.get(key) + "\n");
            }
            sosw.flush();
            sosw.close();
            sfos.close();
        }
        catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
    }

    public OutputStreamWriter getLogWriter() {
        return this.osw;
    }

    public int[] getGlobalPref() {
        return this.globalPref;
    }

    public void log(String s) throws TimetableException {
        try {
            if (this.existKey("DEBUG_LOG")) {
                this.osw.write(String.valueOf(s) + "\n");
            }
            if (this.getInt("DEBUG") > 0) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
    }

    public void closeLog() throws TimetableException {
        try {
            if (this.existKey("DEBUG_LOG")) {
                this.osw.flush();
                this.osw.close();
                this.fos.close();
            }
        }
        catch (Exception e) {
            throw new TimetableException(e.getMessage());
        }
    }

    public String get(String key) throws TimetableException {
        String val = (String)this.configuration.get(key);
        if (val == null) {
            throw new TimetableException("Key \"" + key + "\" not found.");
        }
        return val;
    }

    public boolean existKey(String key) throws TimetableException {
        return this.configuration.get(key) != null;
    }

    public int getInt(String key) throws TimetableException {
        if (!this.existKey(key)) {
            throw new TimetableException("Key \"" + key + "\" not found.");
        }
        return Integer.parseInt(this.get(key));
    }

    public void set(String key, int val) throws TimetableException {
        this.set(key, String.valueOf(val));
    }

    public void set(String key, String val) throws TimetableException {
        this.configuration.put(key, val);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        Enumeration e = this.configuration.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!first) {
                s.append('\n');
            }
            s.append(String.valueOf(key) + "=" + this.configuration.get(key));
            first = false;
        }
        return s.toString();
    }

    public String dayOfWeek(int slot) throws TimetableException {
        return DAY_OF_WEEK[slot / (this.getInt(NR_SLOTS) / this.getInt(NR_DAYS))];
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.configuration);
        out.writeObject(this.globalPref);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, TimetableException {
        this.configuration = (Hashtable)in.readObject();
        this.globalPref = (int[])in.readObject();
        if (this.existKey("DEBUG_LOG")) {
            this.fos = new FileOutputStream(this.get("DEBUG_LOG"));
            this.osw = new OutputStreamWriter(this.fos);
        }
    }
}

