/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.plugin.AppletViewer;
import sun.plugin.security.PluginClassLoader;

public class ExtensionInstallationImpl
implements ExtensionInstallationProvider {
    public boolean installExtension(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) throws ExtensionInstallationException {
        this.trace("Plugin requested to install " + extensionInfo);
        String string = this.makePlatformDependent(this.extractJarFileName(extensionInfo.url));
        String string2 = this.makePlatformDependent(extensionInfo.url);
        if (!this.askUserForAknowledgment(extensionInfo, extensionInfo2)) {
            throw new ExtensionInstallationException("User denied installation of " + string2);
        }
        try {
            ClassLoader classLoader = this.checkForSignature(new URL(string2));
            if (classLoader == null) {
                throw new ExtensionInstallationException(string2 + ": Jar File not signed");
            }
            URL uRL = new URL("jar:" + string2 + "!/");
            this.trace("Downloading " + string2 + " filename " + string);
            URLConnection uRLConnection = uRL.openConnection();
            JarFile jarFile = ((JarURLConnection)uRLConnection).getJarFile();
            this.installJarFile(classLoader, string2, string, jarFile);
        }
        catch (SocketException socketException) {
            this.trace("Cannot download the jar File " + string2);
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            this.trace("Cannot download the jar File " + string2);
            return false;
        }
        return true;
    }

    private ClassLoader checkForSignature(final URL uRL) throws IOException, ExtensionInstallationException {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JarFile jarFile;
                Object object;
                URL uRL3;
                Object object2;
                try {
                    object2 = uRL.getHost();
                    uRL3 = new URL(uRL.getProtocol(), (String)object2, uRL.getPort(), "");
                    ExtensionInstallationImpl.this.trace("Host url is " + uRL3);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                object2 = new PluginClassLoader(uRL3);
                ((PluginClassLoader)((Object)object2)).addMyJar(uRL3, uRL.toString());
                try {
                    URL uRL2 = new URL("jar:" + uRL + "!/");
                    object = uRL2.openConnection();
                    jarFile = ((JarURLConnection)object).getJarFile();
                    ExtensionInstallationImpl.this.trace("Jar file is " + jarFile.getName());
                }
                catch (IOException iOException) {
                    return null;
                }
                boolean bl = true;
                object = jarFile.entries();
                while (object.hasMoreElements()) {
                    Object object3;
                    Object object4;
                    JarEntry jarEntry = (JarEntry)object.nextElement();
                    ExtensionInstallationImpl.this.trace("Entry " + jarEntry.getName());
                    if (jarEntry.getName().endsWith(".class")) {
                        ExtensionInstallationImpl.this.trace("Class " + jarEntry.getName());
                        object4 = jarEntry.getName().substring(0, jarEntry.getName().lastIndexOf(".class"));
                        object4 = ((String)object4).replace('/', '.');
                        ExtensionInstallationImpl.this.trace("Trying to load " + (String)object4);
                        try {
                            object3 = ((ClassLoader)object2).loadClass((String)object4);
                            ExtensionInstallationImpl.this.trace(object3 + " signers " + ((Class)object3).getSigners());
                            if (!((Class)object3).isInterface() && ((Class)object3).getSigners() == null) {
                                bl = false;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (jarEntry.getName().startsWith("META-INF")) continue;
                    try {
                        int n;
                        object4 = jarFile.getInputStream(jarEntry);
                        object3 = new byte[8192];
                        while ((n = ((InputStream)object4).read((byte[])object3, 0, ((byte[])object3).length)) != -1) {
                        }
                        ((InputStream)object4).close();
                        Certificate[] certificateArray = jarEntry.getCertificates();
                        ExtensionInstallationImpl.this.trace("For entry " + jarEntry.getName() + " certs are: ");
                        if (certificateArray != null) {
                            int n2 = 0;
                            while (n2 < certificateArray.length) {
                                ExtensionInstallationImpl.this.trace(certificateArray[n2]);
                                ++n2;
                            }
                            continue;
                        }
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                }
                if (bl) {
                    return object2;
                }
                return null;
            }
        });
        return classLoader;
    }

    private boolean askUserForAknowledgment(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) {
        String string;
        if (extensionInfo2 != null) {
            int n = extensionInfo2.isCompatibleWith(extensionInfo);
            switch (n) {
                case 1: {
                    string = "The applet requires a newer version (specification" + extensionInfo.specVersion + ") of extension " + extensionInfo2.title;
                    break;
                }
                case 2: {
                    string = "The applet requires a newer version (implementation " + extensionInfo.implementationVersion + ") of extension " + extensionInfo2.title;
                    break;
                }
                case 3: {
                    string = "The applet require the " + extensionInfo.vendor + "(" + extensionInfo.vendorId + ") extension " + extensionInfo2.title;
                    break;
                }
                default: {
                    string = "The applet require the installation of " + extensionInfo.name + " from " + extensionInfo.url;
                    break;
                }
            }
        } else {
            string = "The applet require the installation of " + extensionInfo.name;
        }
        string = string + "\n from " + this.makePlatformDependent(extensionInfo.url);
        Object[] objectArray = new Object[]{ExtensionInstallationImpl.getMessage("security_dialog.buttonYes"), ExtensionInstallationImpl.getMessage("security_dialog.buttonNo"), ExtensionInstallationImpl.getMessage("security_dialog.buttonAlways")};
        int n = JOptionPane.showOptionDialog(null, string, ExtensionInstallationImpl.getMessage("security_dialog.caption"), -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            this.trace("Starting download from " + extensionInfo.url);
        } else {
            this.trace("Download not granted by user");
        }
        return n == 0;
    }

    private void installJarFile(ClassLoader classLoader, String string, String string2, JarFile jarFile) throws IOException {
        this.trace("Starting the installation of " + jarFile.getName());
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.ext.dirs");
                }
            });
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            String string4 = stringTokenizer.nextToken();
            this.trace("Raw Extension in " + string4);
            Attributes attributes = manifest.getMainAttributes();
            if (attributes != null) {
                String string5 = attributes.getValue(Attributes.Name.MAIN_CLASS);
                if (string5 != null) {
                    this.trace("Require java install ");
                    this.launchJavaInstaller(classLoader, string5, string4);
                    return;
                }
                string5 = attributes.getValue(Attributes.Name.EXTENSION_INSTALLATION);
                if (string5 != null) {
                    this.trace("Require native installation");
                    this.launchNativeInstallation(string5, jarFile, string4);
                    return;
                }
                this.installRawExtension(string, string2, string4);
            }
        }
    }

    private boolean installRawExtension(final String string, String string2, String string3) throws IOException {
        String string4 = string3 + File.separatorChar + string2;
        final File file = new File(string4);
        this.trace("Dest File would be " + file);
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL = null;
                URLConnection uRLConnection = null;
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    uRL = new URL(string);
                    uRLConnection = uRL.openConnection();
                    inputStream = uRLConnection.getInputStream();
                    fileOutputStream = new FileOutputStream(file);
                    ExtensionInstallationImpl.this.Copy(inputStream, fileOutputStream);
                    inputStream.close();
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    private boolean launchJavaInstaller(final ClassLoader classLoader, final String string, final String string2) {
        Boolean bl;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class array$Ljava$lang$String;

                public Object run() {
                    try {
                        ExtensionInstallationImpl.this.trace("Trying to load " + string);
                        Class<?> clazz = classLoader.loadClass(string);
                        ExtensionInstallationImpl.this.trace("Success " + clazz);
                        Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = 4.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                        String[] stringArray = new String[]{string2};
                        Method method = clazz.getMethod("main", classArray);
                        Object[] objectArray = new Object[]{stringArray};
                        method.invoke(null, objectArray);
                        ExtensionInstallationImpl.this.trace("Done !");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }

                static /* synthetic */ Class class$(String string3) {
                    try {
                        return Class.forName(string3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return bl;
    }

    private boolean launchNativeInstallation(final String string, final JarFile jarFile, String string2) {
        Boolean bl;
        this.trace("Launching " + string);
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string3 = System.getProperty("user.dir");
                        InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(string));
                        String string2 = string3 + File.separator + string;
                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                        ExtensionInstallationImpl.this.Copy(inputStream, fileOutputStream);
                        Process process = Runtime.getRuntime().exec(string2);
                        JProgressBar jProgressBar = new JProgressBar(0, 100);
                        JDialog jDialog = new JDialog((Frame)null, "Java Extension Installation", false);
                        JPanel jPanel = new JPanel();
                        jPanel.add(new JLabel("   Waiting for installation    "));
                        jPanel.add(new JLabel(string));
                        jPanel.add(new JLabel("       to finish        "));
                        jPanel.add(jProgressBar);
                        jDialog.getContentPane().add(jPanel);
                        jProgressBar.setVisible(true);
                        ((Component)jDialog).setSize(250, 150);
                        ((Component)jDialog).setLocation(200, 200);
                        jDialog.show();
                        int n = 0;
                        boolean bl = true;
                        while (bl) {
                            try {
                                process.exitValue();
                                bl = false;
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                                if ((n += 10) == 110) {
                                    n = 0;
                                }
                                jProgressBar.setValue(n);
                                System.out.print(" ");
                                System.out.flush();
                            }
                        }
                        jDialog.dispatchEvent(new WindowEvent(jDialog, 201));
                        System.out.println("");
                        File file = new File(string2);
                        file.delete();
                        return Boolean.TRUE;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return Boolean.FALSE;
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return bl;
    }

    private String extractJarFileName(String string) {
        int n;
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            n = string.lastIndexOf(47);
            if (n < string.lastIndexOf(92)) {
                n = string.lastIndexOf(92);
            }
        } else {
            n = string.lastIndexOf(47, n2);
            if (n < string.lastIndexOf(92, n2)) {
                // empty if block
            }
            n = string.lastIndexOf(92, n2);
        }
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private void Copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        do {
            if ((n = inputStream.read(byArray)) == -1) continue;
            outputStream.write(byArray, 0, n);
        } while (n != -1);
        inputStream.close();
        outputStream.close();
    }

    private String makePlatformDependent(String string) {
        String string2 = "$(os.name)$";
        int n = string.indexOf(string2);
        String string3 = string;
        if (n != -1) {
            String string4 = System.getProperty("os.name");
            String string5 = string4.replace(' ', '-');
            string3 = string.substring(0, n) + string5 + string.substring(n + string2.length(), string.length());
        }
        return string3;
    }

    void trace(Object object) {
        AppletViewer.debugTrace(object);
    }

    private static String getMessage(String string) {
        return AppletViewer.getMessage(string);
    }
}

