/*
 * ActivityDepenedenceGroup.java
 *
 * Created on 21. jen 2000, 15:52
 * Documented 8.7.2001
 */

package timetable.data;

import java.util.Vector;
/** Reprezentace skupiny zvislost mezi aktivitami.
 *
 * @author  Tom Mller
 * @version 1.0
 */
public class ActivityDependenceGroup extends Object {
    /** Zvislosti reprezentovan jako java.util.Vector */
    protected Vector dependences = new Vector();
    
    /** Konstruktor. */
    public ActivityDependenceGroup() {
    }
    
    /** Konstruktor.
     * @param dep po vytvoen skupiny se do n vlo zvislost dep
     */
    public ActivityDependenceGroup(ActivityDependenceInterface dep) {
        dependences.add(dep);
    }

    /** Konstruktor.
     * @param dep po vytvoen skupiny se do n vlo zvislosti dep
     */
    public ActivityDependenceGroup(ActivityDependenceInterface[] dep) {
        for (int i=0;i<dep.length;i++)
            dependences.add(dep[i]);
    }
        
    /** Pidn nov zvislosti
     * @param dep zvislost
     */
    public void add(ActivityDependenceInterface dep) {
        dependences.add(dep);
    }
    
    /** Odebrn zvislosti ze skupiny
     * @param deo zvislost
     */
    public void remove(ActivityDependenceInterface dep) {
        dependences.remove(dep);
    }
    
    /** Odebrn vech zvislost ze skupiny */
    public void removeAll() {
        dependences.clear();
    }
    
    /** Vrt poet zvislost ve skupin.
     * @return poet zvislost
     */
    public int size() {
        return dependences.size();
    }
    
    /** Vrt i-tou zvislost
     * @param i index do skupiny zvislost
     * @return i-t zvislost
     */
    public ActivityDependenceInterface get(int i) {
        try {
            return (ActivityDependenceInterface) dependences.get(i);
        } catch (java.lang.ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
    
    /** Spot poet zvislost, ve kterch se vyskytuje dan aktivita.
     * @param a aktivita
     */
    public int countDependences(Activity a) {
        int sum=0;
        for (int i=0;i<size();i++)
            if (get(i).participate(a)) sum++;
        return sum;
    }
    
    /** Otestuje vechny zvislosti.
     * @return true, pokud jsou vechny splnny
     */
    public boolean isOK() {
        for (int i=0;i<size();i++) 
            if (!get(i).isOK()) return false;
        return true;
    }
    
    /** Otestuje vechny zvislosti s danou aktivitou.
     * @param a aktivita
     * @param start zatek aktivity
     * @return true, pokud jsou splnny
     */
    public boolean isOK(Activity a, int start) {
        for (int i=0;i<size();i++) 
            if (!get(i).isOK(a,start)) {
                return false;
            }
        return true;
    }
    
    /** Otestuje vechny zvislosti s danou aktivitou, kde druh aktivita nelze peplnovat. Pouze tyto zvislosti musej bt splny, ostatn lze eit vyhozenm druh z aktivit z rozvrhu.
     * @param a aktivita
     * @param start zatek aktivity
     * @return true, pokud jsou splnny
     */
    public boolean isFixedOK(Activity a, int start) {
        for (int i=0;i<size();i++) {
            Activity b = get(i).getAnotherActivity(a);
            if (b!=null && !b.canReschedule && !get(i).isOK(a,start)) 
                return false;
        }
        return true;
    }

    /** Vrt vechny aktivity kter jsouv v konfliktu s danou aktivitou kvli nkter ze zvislost. 
     * @param a aktivita
     * @param start zatek aktivity
     * @return mnoina konfliktnch aktivit
     */
    public ActivityGroup getConflictActivities(Activity a, int start) {
        ActivityGroup g = new ActivityGroup();
        for (int i=0;i<size();i++) {
            if (!get(i).isOK(a,start))
                g.addIfIsNot( get(i).getAnotherActivity(a));
        }
        return g;
    }
    
    /** Zpis skupiny zvislosti do streamu
     * @param out stream
     * @param allActivities mnoina vech aktivit
     */
   public void write(java.io.ObjectOutputStream out, ActivityGroup allActivities) throws java.io.IOException {
       out.writeInt(size());
       for (int i=0;i<size();i++) {
           out.writeObject(get(i).getClass().getName());
           get(i).write(out, allActivities);
       }
   }

   /** Peten skupiny zvislost ze streamu.
     * @param in stream
     * @param allActivities mnoina vech aktivit
     * @return naten skupina zvislost
     */
   public static ActivityDependenceGroup read(java.io.ObjectInputStream in, ActivityGroup allActivities) throws java.io.IOException, java.lang.ClassNotFoundException, java.lang.NoSuchMethodException, java.lang.InstantiationException, java.lang.IllegalAccessException, java.lang.reflect.InvocationTargetException {
       int size = in.readInt();
       ActivityDependenceGroup g = new ActivityDependenceGroup();
       for (int i=0;i<size;i++) {
           String className = (String) in.readObject();
           Class c = Class.forName(className);
           Object o = c.getConstructor(new Class[] {}).newInstance(new Object[] {});
           g.add(((ActivityDependenceInterface)o).read(in, allActivities));
       }
       return g;
   }

}