/*
 * ActivityDependenceInterface.java
 *
 * Created on 17. prosinec 2000, 12:00
 * Documented 8.7.2001
 */

package timetable.data;

/** Tda poskytujc zkladn rozhran, kter mus kad zvislost mezi aktivitami splovat.
 * <br>
 * Abychom mohli vyjdit napklad, e jedna aktivita mus bt ped druhou, je nutn urit poad aktivit.
 * Proto m rozhran dvmetody pro nastaven aktivity, tj. nastaven prvn a druh z nich.
 *
 * @author Tom Mller
 * @version 1.0
 */
public interface ActivityDependenceInterface {
    /** Nastaven prvn aktivity zvislosti. 
     * @param a aktivita
     */
    public void setFirstActivity(Activity a);
    
    /** Nastaven druh aktivity zvislosti
     * @param b aktivita
     */
    public void setSecondActivity(Activity b);
    
    /** Zjitn prvn aktivity zvislosti
     * @return prvn aktivita zvislosti
     */
    public Activity getFirstActivity();
    
    /** Zjitn druh aktivity zvislosti
     * @return druh aktivia zvislosti
     */
    public Activity getSecondActivity();

    /** Zjitn spln zvislosti
     * @return true, pokud je zvislost splnna
     */
    public boolean isOK();
    
    /** Zjitn spln zvislosti, pokud bude mt jedna z aktivit zmnn poten as.
     * @param a aktivita (prvn nebo druh)
     * @param start zatek aktivity a
     * @return true, pokud bude podmnka splna
     */
    public boolean isOK(Activity a, int start);
    
    /** Zjitn splnn podmnky
     * @param activityStart1 zatek prvn aktivity
     * @param activityStart2 zatek druh aktivity
     * @return true, pokud bude podmnka splna
     */
    public abstract boolean isOK(int activityStart1,int activityStart2);
    
    /** nastaven typu podmnky. Tmto lze umonit implementaci vce podmnek jednou tdou. 
     * @param i typ podmnky     
     */
    public void setType(int i);
    
    /** Zjitn typu podmnky
     * @return typ podmnky
     */
    public int getType();

    /** Metoda vracejc druhou z aktivit.
     * @param a jedna z aktivit
     * @return druh z aktivit
     */
    public Activity getAnotherActivity(Activity a);
    
    /** Vrt pole jmen jednotlivch typ podmnky - pro vizualizaci ! 
     * @return pole jmen typ
     */
    public String [] getTypes();
    
    /** Vrt jmno zvislosti - pro vizualizaci. Nap: asov zvislots
     * @return jmno zvislosti
     */
    public String getDependenceName();
    
    /** Zjist, zda-li se njak aktivita astn podmnky.
     * @param a aktivita
     * @return true, pokud se aktivita a astn podmnky
     */
   public boolean participate(Activity a);

   /** Zape objekt do streamu
    * @param out stream
    * @param allActivities mnoina vech aktivit
    */
   public abstract void write(java.io.ObjectOutputStream out,ActivityGroup allActivites) throws java.io.IOException ;
   
   /** Nate objekt ze streamu
    * @param in stream
    * @param allActivities mnoina vech aktivit
    * @return naten objekt
    */  
   public abstract ActivityDependenceInterface read(java.io.ObjectInputStream in, ActivityGroup allActivities) throws java.io.IOException, java.lang.ClassNotFoundException ;
}

