/*
 * ActivityGroup.java
 *
 * Created 12.10.2000
 * Documented 7.7.2001
 */

package timetable.data;

import java.util.Vector;
import timetable.util.*;
/** Reprezntace skupiny aktivit v rozvrhovacm problmu. Tato tda tak umouje dynamick pidvn a odebrn activit.
 * @see timetable.data.Activity
 * @author  Tom Mller
 * @version 1.0
 */
public class ActivityGroup extends java.lang.Object implements java.io.Serializable{
    /** Mnoina aktivit, reprezentovan pomoc tdy java.util.Vector */
    protected Vector activities = new Vector();
    /** Pznak urujc zmnu */
    public boolean changed = false;
    
    /** Konstruktor. */
    public ActivityGroup() {
    }
    
    /** Konstruktor.
     * @param activity po vytvoen tdy vlo activitu <CODE>activity</CODE>
     */
    public ActivityGroup(Activity activity) {
        activities.add(activity);
    }
    
    /** Konstruktor.
     * @param activity po vytvoen tdy vlo pole activit <CODE>activity</CODE>
     */
    public ActivityGroup(Activity[] activity) {
        for (int i=0; i<activity.length;i++)
            activities.add(activity[i]);
    }
    
    
    /** Pidn activity do seznamu.
     * @param activity pidvan activita
     */
    public void add(Activity activity) {
        activities.add(activity);
        changed = true;
    }
    
    /** Zmnila se mnoina aktivit?
     * @return <code>true</code> pokud ano
     */    
    public boolean isChanged() {
        return changed;
    }
    
    /** Pidn aktivity do seznamu, pokud tato activita jet v seznamu nen.
     * @param activity pidvan activita
     */
    public void addIfIsNot(Activity activity) {
        if (indexOf(activity)<0) add(activity);
    }
    
    /** Pidn aktivit do seznamu, pokud tyto activity jet v seznamu nejsou.
     * @param activities seznam pidvanch activit
     */
    public void addIfIsNot(ActivityGroup activities) {
        for (int i=0;i<activities.size();i++)
            addIfIsNot(activities.get(i));
    }

    /** Odebrn aktivity ye seznamu.
     * @param activity odebran aktivita
     */
    public void remove(Activity activity) {
        activities.remove(activity);
        changed = true;
    }
    
    /** Odebrn vech aktivit ze seznamu. */
    public void removeAll() {
        activities.clear();
    }
    
    /** Zskn potu aktivit v seznamu 
     * @return poet aktivit v seznamu
     **/
    public int size() {
        return activities.size();
    }
        
    /** Vrt aktivitu s poadovm slem i. (sla jdou od <CODE>0</CODE> do <CODE>size()-1</CODE>).
     * @param i poadov slo aktivity
     * @return dan aktivita
     */
    public Activity get(int i) {
        try {
            return (Activity) activities.get(i);
        } catch (java.lang.ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
    
    /** Vrt index aktivity.
     * @param actitivy hledan aktivita
     * @return index aktivity v seznamu, -1 pokud tam nen.
     */
    public int indexOf(Activity activity) {
        return activities.indexOf(activity);
    }
    
    /** Vrt jinou instanci tto tdy obsahujc stejnou skupinu aktivit.
     * @return jin skupina stejnch aktivit
     */
    public Object clone() {
        ActivityGroup g = new ActivityGroup();
        for (int i=0;i<size();i++)
          g.add(get(i));
        return g;
    }
    
    /** Zjituje, zda-li nkter z aktivit vyaduje pslun zdroj.
     * @param resource zdroj
     * @return index prvn aktivity, kter zdroj vyaduje. -1 pokud takov aktivita neexistuje.
     */
    public int containsResource(Resource resource) {
        for (int i=0;i<size();i++) 
            if (get(i).resources.contains(resource)>=0) return i;
        return -1;
    }

    /** Zjiuje, zda-li nkter z aktivity vyaduje skupinu zdroj.
     * @param resource skupina zdroj
     * @return index prvn aktivity, kter danou skupinu vyaduje. -1 pokud takov aktivita neexistuje.
     */    
    public int containsResources(ResourceGroup resources) {
        for (int i=0;i<size();i++) 
            if (get(i).resources.indexOf(resources)>=0) return i;
        return -1;
    }

    /** Vrt etzec, rkami oddlen seznam jmen aktivit.
     * @return seznam jmen aktivit
     */
    public String toString() {
        java.lang.StringBuffer s = new java.lang.StringBuffer();
        for (int i=0;i<size();i++) {
            if (i>0) s.append(",");
            s.append(get(i).name);
        };
        return s.toString();
    }
    
    /** Zpis seznamu aktivit do streamu
     * @param out stream
     */
   private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
       out.writeObject(activities);
   }

   /** Peten seznamu aktivit ze streamu
    * @param in stream
    * @return peten seznam aktivit
    */
   private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
       activities = (Vector) in.readObject();
   }
   
  /** Zpis seznamu aktivit do streamu. Vol metodu Activity.write pro zpis aktivity. Mae pzank zmny <code>changed</code>.
   * @param out stream
   * @param allResources mnoina vech zdroj
   */
   protected void write(java.io.ObjectOutputStream out, ResourceGroup allResources) throws java.io.IOException {
       out.writeInt(size());
       for (int i=0;i<size();i++)
           get(i).write(out,allResources);
       changed = false;
   }
   
   /** Peten seznamu aktivit ze streamu. Vol metodu Activity.read pro ten aktivity.
    * @param in stream
    * @param config globln konfigurace
    * @param allResources mnoina vech zdroj
    * @return peten seznam aktivit
    */
   protected static ActivityGroup read(java.io.ObjectInputStream in, Config config, ResourceGroup allResources) throws java.io.IOException, java.lang.ClassNotFoundException, TimetableException {
       ActivityGroup g = new ActivityGroup();
       int size = in.readInt();
       for (int i=0;i<size;i++)
           g.add(Activity.read(in,config,allResources));
       return g;
   }
    
}
