/*
 * ActivityDependenceInterface.java
 *
 * Created on 21. jen 2000, 15:31
 * Documented 8.7.2001
 */

package timetable.data;

import timetable.util.*;
/** Zkladn asov zvislosti mezi pedmty.
 * <BR>Mezi tyto zvislosti pat: (dle typu)
 * <ul><il> 0 .. bez zvislosti </li>
 * <li> 1 .. prvn aktivita ped druhou </li>
 * <li> 2 .. prvn aktivta tsn ped druhou </li>
 * <li> 3 .. prvn aktivita za druhou</li>
 * <li> 4 .. prvn aktivita tsn za druhou</li>
 * <li> 5 .. soubn bh aktivit</li></ul>
 *
 * @author Tom Mller
 * @version 1.0 
 */
public class TimeActivityDependence extends AbstractActivityDependence {
    /** typ zvislosti - bez zvislosti */
    public static int NO_DEPENDENCE = 0;
    /** typ zvislosti - prvn ped druhou */
    public static int BEFORE = 1;
    /** typ zvislosti - prvn tsn ped druhou */
    public static int CLOSELY_BEFORE = 2;
    /** typ zvislosti - prvn za druhou*/
    public static int AFTER = 3;
    /** typ zvislosti - prvn tsn za druhou*/
    public static int CLOSELY_AFTER = 4;
    /** typ zvislosti - soubn*/
    public static int CONCURRENCY = 5;
    /** jmno zvislost */
    public static String DEPENDENCE_NAME = Loc.get("timetable.dependence.timedep"); 
    /** jmna zvislost */
    protected static String [] TYPES = {Loc.get("timetable.dependence.timedep.no"),Loc.get("timetable.dependence.timedep.before"),Loc.get("timetable.dependence.timedep.closelybefore"),Loc.get("timetable.dependence.timedep.after"),Loc.get("timetable.dependence.timedep.closelyafter"),Loc.get("timetable.dependence.timedep.concurrently")};

    /**Konstruktor.*/
    public TimeActivityDependence() {
        super();
    }
      
    /** Vrt jmno zvislosti - pro vizualizaci. Nap: asov zvislots
     * @return jmno zvislosti
     */
    public String getDependenceName() { return DEPENDENCE_NAME; }

    /** Vrt pole jmen jednotlivch typ podmnky - pro vizualizaci ! 
     * @return pole jmen typ
     */
    public String[] getTypes() { return TYPES; }
    
    /** Konstruktor.
     * @param first prvn aktyvita
     * @param type typ zvislosti
     * @param second druh aktivita
     */
    public TimeActivityDependence(Activity first,int type,Activity second) {
        super(first,second);
        this.type = type;
    }
    
    /** Zjitn splnn podmnky
     * @param activityStart1 zatek prvn aktivity
     * @param activityStart2 zatek druh aktivity
     * @return true, pokud bude podmnka splna
     */
    public boolean isOK(int activityStart1,int activityStart2) {
        if (type==NO_DEPENDENCE || activityStart1==-1 || activityStart2==-1) return true;
        if (type==BEFORE) return activityStart1+first.length<=activityStart2; 
        if (type==CLOSELY_BEFORE) return activityStart1+first.length==activityStart2; 
        if (type==AFTER) return activityStart2+second.length<=activityStart1; 
        if (type==CLOSELY_AFTER) return activityStart2+second.length==activityStart1; 
        if (type==CONCURRENCY) return (activityStart1<=activityStart2 && activityStart2+second.length<=activityStart1+first.length) ||
                                      (activityStart2<=activityStart1 && activityStart1+first.length<=activityStart2+second.length);
        return false;
    }
    
    /** Vrt etzec popisujc zvislost. Tvar: "DEP " + zkratka prvn aktivity + jmno typu zvislosti + zkratka druh aktivity
     * @return popis zvislosti
     */
    public String toString() {
         return "DEP "+first.shortCut+" "+TYPES[type]+" "+second.shortCut;
    }

  /** Zape objekt do streamu
    * @param out stream
    * @param allActivities mnoina vech aktivit
    */
    public void write(java.io.ObjectOutputStream out, ActivityGroup allActivites) throws java.io.IOException {
       out.writeInt(allActivites.indexOf(first));
       out.writeInt(type);
       out.writeInt(allActivites.indexOf(second));
    }

   /** Nate objekt ze streamu
    * @param in stream
    * @param allActivities mnoina vech aktivit
    * @return naten objekt
    */  
    public ActivityDependenceInterface read(java.io.ObjectInputStream in, ActivityGroup allActivities) throws java.io.IOException,java.lang.ClassNotFoundException {
       TimeActivityDependence tad = new TimeActivityDependence(
           allActivities.get(in.readInt()),in.readInt(),
           allActivities.get(in.readInt())
       );
       return tad;
    }    
}
