/*
 * DefaultDNDTableContraints.java
 *
 * Created on 24. nor 2001, 11:38
 */

package timetable.gui;

/**
 *
 * @author  Administrator
 * @version 
 */
public class DefaultDNDTableEngine implements DNDTableEngine {
    protected Object dValue;
    protected int dRow,dColumn;
    protected javax.swing.JTable dSource;

    /** Creates new DefaultDNDTableContraints */
    public DefaultDNDTableEngine() {
    }

    public boolean canDrag(int row,int column, javax.swing.JTable source) {
        return source.getValueAt(row,column)!=null;
    }
    
    public void drag(int row,int column,javax.swing.JTable source) {
        dRow=row;
        dColumn=column;
        dValue=source.getValueAt(row,column);
        dSource=source;
        fireDNDListenerDrag(source,row,column);
    }
    
    public boolean canDrop(int row,int column,javax.swing.JTable target) {
        return dValue!=null;
    }
        
    public void drop(int row,int column,javax.swing.JTable target) {
        target.setValueAt(dValue,row,column);
        dSource.setValueAt(null,dRow,dColumn);
        dValue=null;
        fireDNDListenerDrop(target,row,column);
    }
    
    public void done() {
        dValue=null;
    }
    
    protected javax.swing.event.EventListenerList listenerList = new javax.swing.event.EventListenerList();
    
    public void addDNDListener(DNDListener l) {
        listenerList.add(DNDListener.class, l);
    }
    
    public void removeDNDListener(DNDListener l) {
        listenerList.remove(DNDListener.class, l);
    }
    
    protected void fireDNDListenerDrop(Object source, int row, int column) {
        DNDEvent dndEvent = null;
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==DNDListener.class) {
             // Lazily create the event:
             if (dndEvent == null)
                 dndEvent = new DNDEvent(source,row,column);
             ((DNDListener)listeners[i]).drop(dndEvent);
            }
        }
    }

    protected void fireDNDListenerDrag(Object source, int row, int column) {
        DNDEvent dndEvent = null;
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==DNDListener.class) {
             // Lazily create the event:
             if (dndEvent == null)
                 dndEvent = new DNDEvent(source,row,column);
             ((DNDListener)listeners[i]).drag(dndEvent);
            }
        }
    }

}
