/*
 * PreferencePanel.java
 *
 * Created on 6. prosinec 2000, 9:21
 */

package timetable.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import timetable.data.*;
import timetable.util.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class GlobalTimePreferencePanel extends javax.swing.JPanel implements ActionListener {

//    private int NrColumns =0;
//    private int NrRows=0;
    
    public static Color BG_PREF[] = new Color[] {
        new Color(200, 30,20),
        new Color(240,100,40),
        new Color(240,170,40),
        new Color(240,240,40), // stred
        new Color(150,240,40),
        new Color( 50,200,40), 
        new Color( 10,160,40)};
    public static javax.swing.border.LineBorder BORDER_DEFAULT = new javax.swing.border.LineBorder(java.awt.Color.darkGray,1);
    public static Color COLOR_HEAD = new Color(120,120,255);
    public int[] preference;
    static int PREF_MIN=-3;
    static int PREF_MID=0;
    static int PREF_MAX=3;
    static int PREF_MOVE=3;
    
    private JPopupMenu menu;
    private JMenuItem mRed,mRem,mYellow,mAdd,mGreen;
    
    
    /** Creates new form PreferencePanel */
    public GlobalTimePreferencePanel(Config config,int [] preference) throws TimetableException {
//        this.config=config;
//        this.preference=preference;
        int NrRows = config.getInt(Config.NR_DAYS);
        if (NrRows==0) NrRows=5;
        int slots = config.getInt(Config.NR_SLOTS);
        int NrColumns = slots/NrRows;
        menu = new JPopupMenu();
        mRed = new JMenuItem(Loc.get("timetable.gui.preferrence.min"));
        mRem = new JMenuItem(Loc.get("timetable.gui.preferrence.dec"));
        mYellow = new JMenuItem(Loc.get("timetable.gui.preferrence.middle"));
        mAdd = new JMenuItem(Loc.get("timetable.gui.preferrence.inc"));
        mGreen = new JMenuItem(Loc.get("timetable.gui.preferrence.max"));
        menu.add(mRed);
        menu.add(mRem);
        menu.add(mYellow);
        menu.add(mAdd);
        menu.add(mGreen);
        mRed.addActionListener(this);
        mRem.addActionListener(this);
        mYellow.addActionListener(this);
        mAdd.addActionListener(this);
        mGreen.addActionListener(this);

        setLayout(new java.awt.GridLayout(NrRows+1,NrColumns+1,0,0));
        this.add(new OnePrefPanel(""));
        for (int i=0;i<NrColumns;i++) 
            this.add(new OnePrefPanel(""+(i+1)));
        for (int i=0;i<slots;i++) {
            if (i%NrColumns==0) this.add(new OnePrefPanel(config.dayOfWeek(i)));
            this.add(new OnePrefPanel(preference,i));
        };
//        initComponents ();
        this.setPreferredSize(new java.awt.Dimension((1+NrColumns)*20,(1+NrRows)*20));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        setLayout(new java.awt.GridLayout(5, 10));
    }//GEN-END:initComponents

    public void actionPerformed(final java.awt.event.ActionEvent e) {
        if (e.getSource()==mRed) ((OnePrefPanel)(menu.getInvoker())).setMin();
        if (e.getSource()==mRem) ((OnePrefPanel)(menu.getInvoker())).setRem();
        if (e.getSource()==mYellow) ((OnePrefPanel)(menu.getInvoker())).setMiddle();
        if (e.getSource()==mAdd) ((OnePrefPanel)(menu.getInvoker())).setAdd();
        if (e.getSource()==mGreen) ((OnePrefPanel)(menu.getInvoker())).setMax();
    }    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    public class OnePrefPanel extends JPanel {
        private int[] preference;
        private int slot;
        private boolean selected=false;
        

        public OnePrefPanel(String text) {
            preference=null;
            this.setPreferredSize(new java.awt.Dimension(20,20));
            this.setBorder(BORDER_DEFAULT);
            this.setBackground(COLOR_HEAD);
            this.add(new javax.swing.JLabel(text));
        }
            
        public OnePrefPanel(int[] _preference,int slot) {
            this.preference=_preference;
            this.slot=slot;
            
            this.setBackground(BG_PREF[preference[slot]+PREF_MOVE]);
            this.setPreferredSize(new java.awt.Dimension(20,20));
            this.setBorder(BORDER_DEFAULT);
            this.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(MouseEvent e) {
                    if ((e.getModifiers()&e.BUTTON3_MASK)>0) {
                        menu.show(OnePrefPanel.this,e.getX(),e.getY());
                    };
                    if ((e.getModifiers()&e.BUTTON1_MASK)>0) {
                        if (e.isControlDown()) setAdd(); else 
                            if  (e.isAltDown()) setRem(); else {
                                if (getPref()==PREF_MID) setMax(); 
                                    else if (getPref()==PREF_MAX) setMin();
                                    else setMiddle();
                            }
                    };
                }
                
            });
        }
        
        public int getPref() { return preference[slot];}
        
        public void setMiddle() {
          preference[slot]=PREF_MID;
          this.setBackground(BG_PREF[preference[slot]+PREF_MOVE]);
        }
        public void setMax() {
          preference[slot]=PREF_MAX;
          this.setBackground(BG_PREF[preference[slot]+PREF_MOVE]);
        }
        public void setMin() {
          preference[slot]=PREF_MIN;
          this.setBackground(BG_PREF[preference[slot]+PREF_MOVE]);
        }
        public void setAdd() {
          preference[slot]=(preference[slot]<PREF_MAX?preference[slot]+1:PREF_MAX);
          this.setBackground(BG_PREF[preference[slot]+PREF_MOVE]);
        }
        public void setRem() {
          preference[slot]=(preference[slot]>PREF_MIN?preference[slot]-1:PREF_MIN);
          this.setBackground(BG_PREF[preference[slot]+PREF_MOVE]);
        }
        
    }
}
