/*
 * SolverRightsPanel.java
 *
 * Created on 24. bezen 2001, 14:15
 */

package timetable.gui;

/**
 *
 * @author  administrator
 * @version 
 */
import timetable.util.Config;
import timetable.util.Loc;

public class SolverRightsPanel extends javax.swing.JPanel {
    private Config config = null;

    /** Creates new form SolverRightsPanel */
    public SolverRightsPanel() {
        initComponents ();
        init(this);
    }
    
    public void setConfig(Config config) {
        this.config=config;
        loadData();
        updateUI();
    }
    
    private void loadData(java.awt.Container container) {
        try {
            for (int i=0;i<container.getComponentCount();i++) {
                java.awt.Component c = container.getComponent(i);
                if (c instanceof java.awt.Container) loadData((java.awt.Container)c);
                if (c instanceof javax.swing.JTextField && c.getName()!=null)
                   ((javax.swing.JTextField)c).setText(config.get(c.getName()));
                if (c instanceof javax.swing.JCheckBox && c.getName()!=null)
                   ((javax.swing.JCheckBox)c).setSelected(config.getInt(c.getName())>0);
                if (c instanceof javax.swing.JSlider && c.getName()!=null) {
                    ((javax.swing.JSlider)c).setValue(config.getInt(c.getName()));
//                    ((javax.swing.JSlider)c).setToolTipText(String.valueOf(config.getInt(c.getName())));
                }
            }
        } catch (Exception e) {
            System.err.println("Error:"+e);
        }
    }
    
    public void loadData() {
      loadData(this);   
      updateEnable();
    }
    
    private void storeData(java.awt.Container container) {
        try {
            for (int i=0;i<container.getComponentCount();i++) {
                java.awt.Component c = container.getComponent(i);
                if (c instanceof java.awt.Container) storeData((java.awt.Container)c);
                if (c instanceof javax.swing.JTextField && c.getName()!=null)
                    config.set(c.getName(),Integer.parseInt(((javax.swing.JTextField)c).getText()));
                if (c instanceof javax.swing.JCheckBox && c.getName()!=null)
                    config.set(c.getName(),(((javax.swing.JCheckBox)c).isSelected()?1:0));
                if (c instanceof javax.swing.JSlider && c.getName()!=null)
                    config.set(c.getName(),(((javax.swing.JSlider)c).getValue()));
            }
        } catch (Exception e) {
            System.err.println("Error:"+e);
        }
    }

    public void storeData() {
        try { 
          storeData(this);
//          config.save();
        } catch (Exception e) {
            System.err.println("Error:"+e);
        }
    }
    
    private void init(java.awt.Container container) {
        try {
            for (int i=0;i<container.getComponentCount();i++) {
                java.awt.Component c = container.getComponent(i);
                if (c instanceof javax.swing.JSlider) {
                    javax.swing.JSlider s = (javax.swing.JSlider)c;
                    s.addChangeListener(new javax.swing.event.ChangeListener() {
                        public void stateChanged(javax.swing.event.ChangeEvent e) {
                            try {
//                              System.err.println("Slider "+((javax.swing.JSlider)e.getSource()).getName()+"="+((javax.swing.JSlider)e.getSource()).getValue());
                              ((javax.swing.JSlider)e.getSource()).setToolTipText(String.valueOf(((javax.swing.JSlider)e.getSource()).getValue()));
                              config.set(((javax.swing.JSlider)e.getSource()).getName(),((javax.swing.JSlider)e.getSource()).getValue());
                            } catch (Exception ex) {
                                System.err.println("Error: "+ex);ex.printStackTrace();
                            }
                        }
                    });
                } else if (c instanceof javax.swing.JCheckBox) {
                    javax.swing.JCheckBox ch = (javax.swing.JCheckBox)c;
                    ch.addChangeListener(new javax.swing.event.ChangeListener() {
                        public void stateChanged(javax.swing.event.ChangeEvent e) {
                            try {
//                              System.err.println("CheckBox "+((javax.swing.JCheckBox)e.getSource()).getName()+"="+((javax.swing.JCheckBox)e.getSource()).isSelected());
                              config.set(((javax.swing.JCheckBox)e.getSource()).getName(),(((javax.swing.JCheckBox)e.getSource()).isSelected()?1:0));
                            } catch (Exception ex) {
                                System.err.println("Error: "+ex);ex.printStackTrace();
                            }
                        }
                    });
                } else if (c instanceof java.awt.Container) {
                    if (c instanceof javax.swing.JPanel) {
                        javax.swing.JPanel p = (javax.swing.JPanel) c;
                        if (p.getBorder() instanceof javax.swing.border.TitledBorder) {
                            javax.swing.border.TitledBorder tb = (javax.swing.border.TitledBorder) p.getBorder();
                            tb.setTitle(Loc.get(tb.getTitle()));
                        }
                    }
                    init((java.awt.Container) c);
                }
            }
        } catch (Exception e) {
            System.err.println("Error:"+e);e.printStackTrace();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
private void initComponents() {//GEN-BEGIN:initComponents
jPanel2 = new javax.swing.JPanel();
jPanel1 = new javax.swing.JPanel();
jLabel2 = new javax.swing.JLabel();
jLabel3 = new javax.swing.JLabel();
jLabel4 = new javax.swing.JLabel();
jLabel5 = new javax.swing.JLabel();
jLabel7 = new javax.swing.JLabel();
jLabel6 = new javax.swing.JLabel();
jLabel8 = new javax.swing.JLabel();
valueSoftActivitySld = new javax.swing.JSlider();
valueSoftResourceSld = new javax.swing.JSlider();
valueNrRemovesSld = new javax.swing.JSlider();
valueCycleSld = new javax.swing.JSlider();
valueColisionSld = new javax.swing.JSlider();
valueRemovedActHasConflictSld = new javax.swing.JSlider();
valueAnotherPlaceSld = new javax.swing.JSlider();
jPanel5 = new javax.swing.JPanel();
jLabel9 = new javax.swing.JLabel();
jLabel10 = new javax.swing.JLabel();
tabuLengthSld = new javax.swing.JSlider();
topLengthSld = new javax.swing.JSlider();
jLabel1 = new javax.swing.JLabel();
jPanel3 = new javax.swing.JPanel();
jLabel15 = new javax.swing.JLabel();
jCheckBox1 = new javax.swing.JCheckBox();
jLabel11 = new javax.swing.JLabel();
jLabel12 = new javax.swing.JLabel();
jLabel13 = new javax.swing.JLabel();
jLabel14 = new javax.swing.JLabel();
jLabel16 = new javax.swing.JLabel();
jCheckBox2 = new javax.swing.JCheckBox();
nrFreePlacesSld = new javax.swing.JSlider();
nrPlacesSld = new javax.swing.JSlider();
nrRemovesSld = new javax.swing.JSlider();
nrDependencesSld = new javax.swing.JSlider();
jPanel4 = new javax.swing.JPanel();
maxNrIterationsSld = new javax.swing.JSlider();
setLayout(new java.awt.GridBagLayout());
java.awt.GridBagConstraints gridBagConstraints1;

jPanel2.setLayout(new java.awt.GridBagLayout());
java.awt.GridBagConstraints gridBagConstraints2;
jPanel2.setBorder(new javax.swing.border.TitledBorder("timetable.weight.value"));

jPanel1.setLayout(new java.awt.GridBagLayout());
  java.awt.GridBagConstraints gridBagConstraints3;
  jPanel1.setBorder(new javax.swing.border.TitledBorder("timetable.weight.value.price"));
  
  jLabel2.setText(Loc.get("timetable.weight.value.soft.activity"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel2, gridBagConstraints3);
    
    
  jLabel3.setText(Loc.get("timetable.weight.value.soft.resource"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel3, gridBagConstraints3);
    
    
  jLabel4.setText(Loc.get("timetable.weight.value.nrremoves"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel4, gridBagConstraints3);
    
    
  jLabel5.setText(Loc.get("timetable.weight.value.cycle"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel5, gridBagConstraints3);
    
    
  jLabel7.setText(Loc.get("timetable.weight.value.remove.another"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel7, gridBagConstraints3);
    
    
  jLabel6.setText(Loc.get("timetable.weight.value.remove.activity.conflict"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel6, gridBagConstraints3);
    
    
  jLabel8.setText(Loc.get("timetable.weight.value.another.place"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
    jPanel1.add(jLabel8, gridBagConstraints3);
    
    
  valueSoftActivitySld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueSoftActivitySld.setName("OHODNOCENI_VAHA_SOFT_AKTIVITY");
    valueSoftActivitySld.setMaximum(50);
    valueSoftActivitySld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 0;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueSoftActivitySld, gridBagConstraints3);
    
    
  valueSoftResourceSld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueSoftResourceSld.setName("OHODNOCENI_VAHA_SOFT_ZDROJE");
    valueSoftResourceSld.setMaximum(50);
    valueSoftResourceSld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 1;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueSoftResourceSld, gridBagConstraints3);
    
    
  valueNrRemovesSld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueNrRemovesSld.setName("OHODNOCENI_VAHA_POCTU_VYHOZENI");
    valueNrRemovesSld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 2;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueNrRemovesSld, gridBagConstraints3);
    
    
  valueCycleSld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueCycleSld.setName("OHODNOCENI_VAHA_CYKLUS");
    valueCycleSld.setMaximum(2000);
    valueCycleSld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 3;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueCycleSld, gridBagConstraints3);
    
    
  valueColisionSld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueColisionSld.setName("OHODNOCENI_VAHA_JINA_AKTIVITA");
    valueColisionSld.setMaximum(500);
    valueColisionSld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 4;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueColisionSld, gridBagConstraints3);
    
    
  valueRemovedActHasConflictSld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueRemovedActHasConflictSld.setName("OHODNOCENI_VAHA_VYHOZENA_VYHODI_JINOU");
    valueRemovedActHasConflictSld.setMaximum(500);
    valueRemovedActHasConflictSld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 5;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueRemovedActHasConflictSld, gridBagConstraints3);
    
    
  valueAnotherPlaceSld.setPreferredSize(new java.awt.Dimension(100, 16));
    valueAnotherPlaceSld.setName("OHODNOCENI_VAHA_JINAM");
    valueAnotherPlaceSld.setValue(0);
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 6;
    gridBagConstraints3.ipadx = 2;
    gridBagConstraints3.ipady = 2;
    jPanel1.add(valueAnotherPlaceSld, gridBagConstraints3);
    
    
  jPanel5.setPreferredSize(new java.awt.Dimension(340, 0));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.gridwidth = 2;
    jPanel1.add(jPanel5, gridBagConstraints3);
    
    gridBagConstraints2 = new java.awt.GridBagConstraints();
  gridBagConstraints2.gridx = 0;
  gridBagConstraints2.gridy = 0;
  gridBagConstraints2.gridwidth = 2;
  gridBagConstraints2.ipadx = 2;
  gridBagConstraints2.ipady = 2;
  jPanel2.add(jPanel1, gridBagConstraints2);
  
  
jLabel9.setText(Loc.get("timetable.weight.tabu.length"));
  gridBagConstraints2 = new java.awt.GridBagConstraints();
  gridBagConstraints2.gridx = 0;
  gridBagConstraints2.ipadx = 2;
  gridBagConstraints2.ipady = 2;
  gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
  jPanel2.add(jLabel9, gridBagConstraints2);
  
  
jLabel10.setText(Loc.get("timetable.weight.top.selection.size"));
  gridBagConstraints2 = new java.awt.GridBagConstraints();
  gridBagConstraints2.gridx = 0;
  gridBagConstraints2.ipadx = 2;
  gridBagConstraints2.ipady = 2;
  gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
  jPanel2.add(jLabel10, gridBagConstraints2);
  
  
tabuLengthSld.setPreferredSize(new java.awt.Dimension(100, 16));
  tabuLengthSld.setName("DELKA_TABU");
  tabuLengthSld.setMaximum(200);
  tabuLengthSld.setValue(0);
  gridBagConstraints2 = new java.awt.GridBagConstraints();
  gridBagConstraints2.gridx = 1;
  gridBagConstraints2.gridy = 1;
  gridBagConstraints2.ipadx = 2;
  gridBagConstraints2.ipady = 2;
  jPanel2.add(tabuLengthSld, gridBagConstraints2);
  
  
topLengthSld.setPreferredSize(new java.awt.Dimension(100, 16));
  topLengthSld.setName("VYBER_HODNOTY_POCET_TOP");
  topLengthSld.setMaximum(20);
  topLengthSld.setValue(0);
  gridBagConstraints2 = new java.awt.GridBagConstraints();
  gridBagConstraints2.gridx = 1;
  gridBagConstraints2.gridy = 2;
  gridBagConstraints2.ipadx = 2;
  gridBagConstraints2.ipady = 2;
  jPanel2.add(topLengthSld, gridBagConstraints2);
  
  
gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridx = 0;
gridBagConstraints1.gridy = 0;
gridBagConstraints1.gridwidth = 2;
gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
gridBagConstraints1.ipadx = 2;
gridBagConstraints1.ipady = 2;
add(jPanel2, gridBagConstraints1);


jLabel1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 5, 0, 0)));
jLabel1.setText(Loc.get("timetable.weight.max.iterations"));

gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridx = 0;
gridBagConstraints1.gridy = 1;
gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
gridBagConstraints1.ipadx = 3;
gridBagConstraints1.ipady = 10;
add(jLabel1, gridBagConstraints1);


jPanel3.setLayout(new java.awt.GridBagLayout());
java.awt.GridBagConstraints gridBagConstraints4;
jPanel3.setBorder(new javax.swing.border.TitledBorder("timetable.weight.variable"));

jLabel15.setText(Loc.get("timetable.weight.variable.randomly"));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
  jPanel3.add(jLabel15, gridBagConstraints4);
  
  
jCheckBox1.setToolTipText("P\u0159edm\u011bt bude vybr\u00e1n n\u00e1hodn\u011b.");
  jCheckBox1.setName("VYBER_PROM_NAHODNE");
  jCheckBox1.addMouseListener(new java.awt.event.MouseAdapter() {
  public void mouseClicked(java.awt.event.MouseEvent evt) {
  jCheckBox1MouseClicked(evt);
  }
  }
  );
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridy = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  jPanel3.add(jCheckBox1, gridBagConstraints4);
  
  
jLabel11.setText(Loc.get("timetable.weight.variable.number.free.places"));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
  jPanel3.add(jLabel11, gridBagConstraints4);
  
  
jLabel12.setText(Loc.get("timetable.weight.variable.number.places"));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
  jPanel3.add(jLabel12, gridBagConstraints4);
  
  
jLabel13.setText(Loc.get("timetable.weight.variable.number.removes"));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
  jPanel3.add(jLabel13, gridBagConstraints4);
  
  
jLabel14.setText(Loc.get("timetable.weight.variable.number.dependencies"));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
  jPanel3.add(jLabel14, gridBagConstraints4);
  
  
jLabel16.setText(Loc.get("timetable.weight.variable.select.from.all"));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
  jPanel3.add(jLabel16, gridBagConstraints4);
  
  
jCheckBox2.setToolTipText("V\u00fdb\u011br se provede ze v\u0161ech neza\u0159azen\u00fdch p\u0159edm\u011bt\u016f nebo pouze z pom\u011brn\u00e9 \u010d\u00e1sti (cca 20 %).");
  jCheckBox2.setName("VYBER_PROM_VSECHNY");
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridy = 5;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  jPanel3.add(jCheckBox2, gridBagConstraints4);
  
  
nrFreePlacesSld.setPreferredSize(new java.awt.Dimension(100, 16));
  nrFreePlacesSld.setName("VYBER_PROM_VAHA_MISTA_BEZ_KONFLIKTU");
  nrFreePlacesSld.setMaximum(2000);
  nrFreePlacesSld.setValue(0);
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 1;
  gridBagConstraints4.gridy = 1;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  jPanel3.add(nrFreePlacesSld, gridBagConstraints4);
  
  
nrPlacesSld.setPreferredSize(new java.awt.Dimension(100, 16));
  nrPlacesSld.setName("VYBER_PROM_VAHA_MISTA");
  nrPlacesSld.setMaximum(250);
  nrPlacesSld.setValue(0);
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 1;
  gridBagConstraints4.gridy = 2;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  jPanel3.add(nrPlacesSld, gridBagConstraints4);
  
  
nrRemovesSld.setPreferredSize(new java.awt.Dimension(100, 16));
  nrRemovesSld.setName("VYBER_PROM_VAHA_VYHOZENI");
  nrRemovesSld.setMinimum(-20);
  nrRemovesSld.setValue(0);
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 1;
  gridBagConstraints4.gridy = 3;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  jPanel3.add(nrRemovesSld, gridBagConstraints4);
  
  
nrDependencesSld.setPreferredSize(new java.awt.Dimension(100, 16));
  nrDependencesSld.setName("VYBER_PROM_VAHA_ZAVISLOSTI");
  nrDependencesSld.setMaximum(250);
  nrDependencesSld.setValue(0);
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 1;
  gridBagConstraints4.gridy = 4;
  gridBagConstraints4.ipadx = 2;
  gridBagConstraints4.ipady = 2;
  jPanel3.add(nrDependencesSld, gridBagConstraints4);
  
  
jPanel4.setPreferredSize(new java.awt.Dimension(350, 0));
  gridBagConstraints4 = new java.awt.GridBagConstraints();
  gridBagConstraints4.gridx = 0;
  gridBagConstraints4.gridwidth = 2;
  jPanel3.add(jPanel4, gridBagConstraints4);
  
  
gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridx = 0;
gridBagConstraints1.gridy = 2;
gridBagConstraints1.gridwidth = 2;
gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
gridBagConstraints1.ipadx = 2;
gridBagConstraints1.ipady = 2;
gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTH;
add(jPanel3, gridBagConstraints1);


maxNrIterationsSld.setPreferredSize(new java.awt.Dimension(100, 16));
maxNrIterationsSld.setName("POCET_ITERACI");
maxNrIterationsSld.setMaximum(10000);

gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridx = 1;
gridBagConstraints1.gridy = 1;
gridBagConstraints1.ipadx = 2;
gridBagConstraints1.ipady = 2;
add(maxNrIterationsSld, gridBagConstraints1);

}//GEN-END:initComponents

  private void jCheckBox1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCheckBox1MouseClicked
    updateEnable();
  }//GEN-LAST:event_jCheckBox1MouseClicked

  private void updateEnable() {
    this.nrFreePlacesSld.setEnabled(!this.jCheckBox1.isSelected());
    this.nrPlacesSld.setEnabled(!this.jCheckBox1.isSelected());
    this.nrRemovesSld.setEnabled(!this.jCheckBox1.isSelected());
    this.nrDependencesSld.setEnabled(!this.jCheckBox1.isSelected());
    this.jCheckBox2.setEnabled(!this.jCheckBox1.isSelected());
  }

// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel jPanel2;
private javax.swing.JPanel jPanel1;
private javax.swing.JLabel jLabel2;
private javax.swing.JLabel jLabel3;
private javax.swing.JLabel jLabel4;
private javax.swing.JLabel jLabel5;
private javax.swing.JLabel jLabel7;
private javax.swing.JLabel jLabel6;
private javax.swing.JLabel jLabel8;
private javax.swing.JSlider valueSoftActivitySld;
private javax.swing.JSlider valueSoftResourceSld;
private javax.swing.JSlider valueNrRemovesSld;
private javax.swing.JSlider valueCycleSld;
private javax.swing.JSlider valueColisionSld;
private javax.swing.JSlider valueRemovedActHasConflictSld;
private javax.swing.JSlider valueAnotherPlaceSld;
private javax.swing.JPanel jPanel5;
private javax.swing.JLabel jLabel9;
private javax.swing.JLabel jLabel10;
private javax.swing.JSlider tabuLengthSld;
private javax.swing.JSlider topLengthSld;
private javax.swing.JLabel jLabel1;
private javax.swing.JPanel jPanel3;
private javax.swing.JLabel jLabel15;
private javax.swing.JCheckBox jCheckBox1;
private javax.swing.JLabel jLabel11;
private javax.swing.JLabel jLabel12;
private javax.swing.JLabel jLabel13;
private javax.swing.JLabel jLabel14;
private javax.swing.JLabel jLabel16;
private javax.swing.JCheckBox jCheckBox2;
private javax.swing.JSlider nrFreePlacesSld;
private javax.swing.JSlider nrPlacesSld;
private javax.swing.JSlider nrRemovesSld;
private javax.swing.JSlider nrDependencesSld;
private javax.swing.JPanel jPanel4;
private javax.swing.JSlider maxNrIterationsSld;
// End of variables declaration//GEN-END:variables

}
