/*
 * EditActivityDlg.java
 *
 * Created on 26. prosinec 2000, 11:33
 */

package timetable.school;

import timetable.data.*;
import timetable.util.*;
import timetable.gui.*;
import timetable.school.data.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class EditActivityDlg extends javax.swing.JDialog {
    private Activity activity;
    private SchoolProblem problem;
    private boolean returnStatus = false;
    private TimePreference preference;
    private ResourceGroup rooms = null;
    private ResourceGroup specRes = null;
    private AllRoomsModel allRooms;
    private SelRoomsModel selRooms;
    private AllSpecResModel allSpecRes;
    private SelSpecResModel selSpecRes;
    private javax.swing.JList roomList,allRoomList,specResList,allSpecResList;

    /** Creates new form EditActivityDlg */
    public EditActivityDlg(java.awt.Frame parent,String title,Config config,Activity activity,SchoolProblem _problem ) throws TimetableException {
        super ((parent==null?new javax.swing.JFrame():parent), true);
        this.activity = activity;
        this.problem = _problem;
        if (activity==null) return;
        initComponents ();
        this.jTabbedPane1.setTitleAt(0,Loc.get("timetable.school.gui.tab.general"));
        this.jTabbedPane1.setTitleAt(1,Loc.get("timetable.school.gui.tab.resources"));
        this.jTabbedPane1.setTitleAt(2,Loc.get("timetable.school.gui.tab.otherres"));
        pack ();
        setTitle(title);
        java.awt.GridBagConstraints c = new java.awt.GridBagConstraints();
        c.gridx=1;
        c.gridheight=c.gridwidth=1;c.weightx=c.weighty=1;
        this.preference = (TimePreference)activity.getPreference().clone();
        this.dataPanel.add(new TimePreferencePanel(config,preference),c);
        this.shortCutField.setText(activity.shortCut);
        this.nameField.setText(activity.name);
        this.noteArea.setText(activity.note);
        this.lengthField.setText(String.valueOf(activity.length));
        for (int i=0;i<problem.getAllTeachers().size();i++)
          this.teacherCombo.addItem(problem.getAllTeachers().get(i).name);
        for (int i=0;i<problem.getAllClasses().size();i++)
          this.classCombo.addItem(problem.getAllClasses().get(i).name);
        for (int i=0;i<problem.groupedClasses.size();i++)
          this.classCombo.addItem(problem.groupedClasses.getResources(i).name);
        if (activity.resources==null || activity.resources.size()<=0)
            rooms= new ResourceGroup();
        else rooms = (ResourceGroup)activity.resources.getResources(SchoolProblem.RES_ROOMS);//.clone();
        if (rooms==null) rooms = new ResourceGroup();
        if (activity.resources==null || activity.resources.size()<4)
            specRes = new ResourceGroup();
        else specRes = (ResourceGroup)activity.resources.getResources(SchoolProblem.RES_SPEC);//.clone();
        specRes.conjunctive = true;
        allRooms = new AllRoomsModel();
        selRooms = new SelRoomsModel();
        allSpecRes = new AllSpecResModel();
        selSpecRes = new SelSpecResModel();
        if (problem.getAllSpecRes().size()==0) this.jTabbedPane1.setEnabledAt(2,false);
        roomList = new javax.swing.JList(selRooms);
        allRoomList = new javax.swing.JList(allRooms);
        specResList = new javax.swing.JList(selSpecRes);
        allSpecResList = new javax.swing.JList(allSpecRes);
        roomScrollPane.getViewport().setView(roomList);
        allRoomScrollPane.getViewport().setView(allRoomList);
        specResScrollPane.getViewport().setView(specResList);
        allSpecResScrollPane.getViewport().setView(allSpecResList);
        this.teacherCombo.setSelectedIndex(problem.getAllTeachers().indexOf(activity.resources.getResource(SchoolProblem.RES_TEACHERS)));
        if (activity.resources!=null && activity.resources.size()>=3) {
            if (activity.resources.isGroup(SchoolProblem.RES_CLASSES)) 
                this.classCombo.setSelectedIndex(problem.getAllClasses().size()+problem.groupedClasses.indexOf(activity.resources.getResources(SchoolProblem.RES_CLASSES)));
            else
                this.classCombo.setSelectedIndex(problem.getAllClasses().indexOf(activity.resources.getResource(SchoolProblem.RES_CLASSES)));
        } else this.classCombo.setSelectedIndex(-1);
        this.setSize(timetable.util.Math.max2(200,20*(config.getInt(config.NR_SLOTS)/config.getInt(config.NR_DAYS)))+160,360);
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
//        this.setResizable(false);
    }
    
    public void show() {
       if (activity!=null) super.show();
    }
    
    public boolean getReturnStatus() { return returnStatus; }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
private void initComponents() {//GEN-BEGIN:initComponents
commandPanel = new javax.swing.JPanel();
okButton = new javax.swing.JButton();
stornoButton = new javax.swing.JButton();
jTabbedPane1 = new javax.swing.JTabbedPane();
dataPanel = new javax.swing.JPanel();
jLabel4 = new javax.swing.JLabel();
shortCutField = new javax.swing.JTextField();
jLabel5 = new javax.swing.JLabel();
nameField = new javax.swing.JTextField();
jLabel6 = new javax.swing.JLabel();
lengthField = new javax.swing.JTextField();
jLabel7 = new javax.swing.JLabel();
noteArea = new javax.swing.JTextArea();
jLabel8 = new javax.swing.JLabel();
resourcePanel = new javax.swing.JPanel();
jLabel9 = new javax.swing.JLabel();
teacherCombo = new javax.swing.JComboBox();
jLabel10 = new javax.swing.JLabel();
classCombo = new javax.swing.JComboBox();
jLabel12 = new javax.swing.JLabel();
jLabel13 = new javax.swing.JLabel();
jLabel14 = new javax.swing.JLabel();
jLabel15 = new javax.swing.JLabel();
roomScrollPane = new javax.swing.JScrollPane();
jPanel4 = new javax.swing.JPanel();
addAllButton = new javax.swing.JButton();
addButton = new javax.swing.JButton();
removeButton = new javax.swing.JButton();
removeAllButton = new javax.swing.JButton();
allRoomScrollPane = new javax.swing.JScrollPane();
specResPanel = new javax.swing.JPanel();
jLabel1 = new javax.swing.JLabel();
jLabel2 = new javax.swing.JLabel();
jLabel3 = new javax.swing.JLabel();
jLabel11 = new javax.swing.JLabel();
specResScrollPane = new javax.swing.JScrollPane();
jPanel2 = new javax.swing.JPanel();
addAllSpecResButton = new javax.swing.JButton();
addSpecResButton = new javax.swing.JButton();
removeSpecResButton = new javax.swing.JButton();
removeAllSpecResButton = new javax.swing.JButton();
allSpecResScrollPane = new javax.swing.JScrollPane();
addWindowListener(new java.awt.event.WindowAdapter() {
public void windowClosing(java.awt.event.WindowEvent evt) {
closeDialog(evt);
}
}
);

commandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));

okButton.setText(Loc.get("timetable.button.ok"));
  okButton.addActionListener(new java.awt.event.ActionListener() {
  public void actionPerformed(java.awt.event.ActionEvent evt) {
  okButtonActionPerformed(evt);
  }
  }
  );
  commandPanel.add(okButton);
  
  
stornoButton.setText(Loc.get("timetable.button.cancel"));
  stornoButton.addActionListener(new java.awt.event.ActionListener() {
  public void actionPerformed(java.awt.event.ActionEvent evt) {
  stornoButtonActionPerformed(evt);
  }
  }
  );
  commandPanel.add(stornoButton);
  
  
getContentPane().add(commandPanel, java.awt.BorderLayout.SOUTH);



dataPanel.setLayout(new java.awt.GridBagLayout());
  java.awt.GridBagConstraints gridBagConstraints1;
  
  jLabel4.setText(Loc.get("timetable.school.model.shortcut"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel4, gridBagConstraints1);
    
    
  shortCutField.setPreferredSize(new java.awt.Dimension(50, 20));
    shortCutField.setText("Zkratka");
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(shortCutField, gridBagConstraints1);
    
    
  jLabel5.setText(Loc.get("timetable.school.model.name"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel5, gridBagConstraints1);
    
    
  nameField.setPreferredSize(new java.awt.Dimension(200, 20));
    nameField.setText("jTextField2");
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(nameField, gridBagConstraints1);
    
    
  jLabel6.setText(Loc.get("timetable.school.model.length"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel6, gridBagConstraints1);
    
    
  lengthField.setPreferredSize(new java.awt.Dimension(50, 20));
    lengthField.setText("jTextField3");
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(lengthField, gridBagConstraints1);
    
    
  jLabel7.setText(Loc.get("timetable.school.model.note"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel7, gridBagConstraints1);
    
    
  noteArea.setPreferredSize(new java.awt.Dimension(200, 50));
    noteArea.setBorder(new javax.swing.border.EtchedBorder());
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(noteArea, gridBagConstraints1);
    
    
  jLabel8.setText(Loc.get("timetable.school.model.timepreference"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel8, gridBagConstraints1);
    
    jTabbedPane1.addTab("Zkladn daje", dataPanel);
  
  
resourcePanel.setLayout(new java.awt.GridBagLayout());
  java.awt.GridBagConstraints gridBagConstraints2;
  
  jLabel9.setText(Loc.get("timetable.school.model.teacher"));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jLabel9, gridBagConstraints2);
    
    
  teacherCombo.setPreferredSize(new java.awt.Dimension(200, 25));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridwidth = 2;
    gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(teacherCombo, gridBagConstraints2);
    
    
  jLabel10.setText(Loc.get("timetable.school.model.class"));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jLabel10, gridBagConstraints2);
    
    
  classCombo.setPreferredSize(new java.awt.Dimension(200, 25));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 1;
    gridBagConstraints2.gridwidth = 2;
    gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(classCombo, gridBagConstraints2);
    
    
  jLabel12.setText(Loc.get("timetable.school.model.rooms"));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.gridwidth = 3;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jLabel12, gridBagConstraints2);
    
    
  jLabel13.setText(Loc.get("timetable.school.gui.selected"));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jLabel13, gridBagConstraints2);
    
    
  gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 1;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jLabel14, gridBagConstraints2);
    
    
  jLabel15.setText(Loc.get("timetable.school.gui.notselected"));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 2;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jLabel15, gridBagConstraints2);
    
    
  roomScrollPane.setPreferredSize(new java.awt.Dimension(100, 120));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(roomScrollPane, gridBagConstraints2);
    
    
  jPanel4.setLayout(new java.awt.GridLayout(4, 1));
    jPanel4.setPreferredSize(new java.awt.Dimension(110, 100));
    
    addAllButton.setText(Loc.get("timetable.school.button.addall"));
      addAllButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      addAllButtonActionPerformed(evt);
      }
      }
      );
      jPanel4.add(addAllButton);
      
      
    addButton.setText(Loc.get("timetable.school.button.add"));
      addButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      addButtonActionPerformed(evt);
      }
      }
      );
      jPanel4.add(addButton);
      
      
    removeButton.setText(Loc.get("timetable.school.button.remove"));
      removeButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      removeButtonActionPerformed(evt);
      }
      }
      );
      jPanel4.add(removeButton);
      
      
    removeAllButton.setText(Loc.get("timetable.school.button.removeall"));
      removeAllButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      removeAllButtonActionPerformed(evt);
      }
      }
      );
      jPanel4.add(removeAllButton);
      
      gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 1;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(jPanel4, gridBagConstraints2);
    
    
  allRoomScrollPane.setPreferredSize(new java.awt.Dimension(100, 120));
    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 2;
    gridBagConstraints2.weightx = 1.0;
    gridBagConstraints2.weighty = 1.0;
    resourcePanel.add(allRoomScrollPane, gridBagConstraints2);
    
    jTabbedPane1.addTab("Zdroje", resourcePanel);
  
  
specResPanel.setLayout(new java.awt.GridBagLayout());
  java.awt.GridBagConstraints gridBagConstraints3;
  
  jLabel1.setText(Loc.get("timetable.school.model.otherres"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.gridwidth = 3;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(jLabel1, gridBagConstraints3);
    
    
  jLabel2.setText(Loc.get("timetable.school.gui.selected"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(jLabel2, gridBagConstraints3);
    
    
  gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(jLabel3, gridBagConstraints3);
    
    
  jLabel11.setText(Loc.get("timetable.school.gui.notselected"));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 2;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(jLabel11, gridBagConstraints3);
    
    
  specResScrollPane.setPreferredSize(new java.awt.Dimension(100, 120));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(specResScrollPane, gridBagConstraints3);
    
    
  jPanel2.setLayout(new java.awt.GridLayout(4, 1));
    jPanel2.setPreferredSize(new java.awt.Dimension(110, 100));
    
    addAllSpecResButton.setLabel(Loc.get("timetable.school.button.addall"));
      addAllSpecResButton.setText("P\u0159idat v\u0161e");
      addAllSpecResButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      addAllSpecResButtonActionPerformed(evt);
      }
      }
      );
      jPanel2.add(addAllSpecResButton);
      
      
    addSpecResButton.setLabel(Loc.get("timetable.school.button.add"));
      addSpecResButton.setText("P\u0159idat");
      addSpecResButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      addSpecResButtonActionPerformed(evt);
      }
      }
      );
      jPanel2.add(addSpecResButton);
      
      
    removeSpecResButton.setLabel(Loc.get("timetable.school.button.remove"));
      removeSpecResButton.setText("Odebrat");
      removeSpecResButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      removeSpecResButtonActionPerformed(evt);
      }
      }
      );
      jPanel2.add(removeSpecResButton);
      
      
    removeAllSpecResButton.setLabel(Loc.get("timetable.school.button.removeall"));
      removeAllSpecResButton.setText("Odebrat v\u0161e");
      removeAllSpecResButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
      removeAllSpecResButtonActionPerformed(evt);
      }
      }
      );
      jPanel2.add(removeAllSpecResButton);
      
      gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(jPanel2, gridBagConstraints3);
    
    
  allSpecResScrollPane.setPreferredSize(new java.awt.Dimension(100, 120));
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 2;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.weighty = 1.0;
    specResPanel.add(allSpecResScrollPane, gridBagConstraints3);
    
    jTabbedPane1.addTab("Ostatn", specResPanel);
  
  
getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

}//GEN-END:initComponents

  private void removeAllSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeAllSpecResButtonActionPerformed
    specRes.removeAll();
    this.allSpecResList.updateUI();
    this.specResList.updateUI();
  }//GEN-LAST:event_removeAllSpecResButtonActionPerformed

  private void removeSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeSpecResButtonActionPerformed
    if (specResList.getSelectedIndex()<0 || specResList.getSelectedIndex()>=selSpecRes.getSize()) return;
    specRes.remove(selSpecRes.getResourceAt(specResList.getSelectedIndex()));
    this.allSpecResList.updateUI();
    this.specResList.updateUI();
  }//GEN-LAST:event_removeSpecResButtonActionPerformed

  private void addSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addSpecResButtonActionPerformed
    if (allSpecResList.getSelectedIndex()<0 || allSpecResList.getSelectedIndex()>=allSpecRes.getSize()) return;
    specRes.add(allSpecRes.getResourceAt(allSpecResList.getSelectedIndex()));
    this.allSpecResList.updateUI();
    this.specResList.updateUI();
  }//GEN-LAST:event_addSpecResButtonActionPerformed

  private void addAllSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addAllSpecResButtonActionPerformed
      while (allSpecRes.getSize()>0) {
          specRes.add(allSpecRes.getResourceAt(0));
      }
    this.allSpecResList.updateUI();
    this.specResList.updateUI();
  }//GEN-LAST:event_addAllSpecResButtonActionPerformed

  private void removeAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeAllButtonActionPerformed
    rooms.removeAll();
    this.allRoomList.updateUI();
    this.roomList.updateUI();
  }//GEN-LAST:event_removeAllButtonActionPerformed

  private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
    if (roomList.getSelectedIndex()<0 || roomList.getSelectedIndex()>=selRooms.getSize()) return;
    rooms.remove(selRooms.getResourceAt(roomList.getSelectedIndex()));
    this.allRoomList.updateUI();
    this.roomList.updateUI();
  }//GEN-LAST:event_removeButtonActionPerformed

  private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
    if (allRoomList.getSelectedIndex()<0 || allRoomList.getSelectedIndex()>=allRooms.getSize()) return;
    rooms.add(allRooms.getResourceAt(allRoomList.getSelectedIndex()));
    this.allRoomList.updateUI();
    this.roomList.updateUI();
  }//GEN-LAST:event_addButtonActionPerformed

  private void addAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addAllButtonActionPerformed
      while (allRooms.getSize()>0) {
          rooms.add(allRooms.getResourceAt(0));
      }
    this.allRoomList.updateUI();
    this.roomList.updateUI();
  }//GEN-LAST:event_addAllButtonActionPerformed

  private void stornoButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stornoButtonActionPerformed
        returnStatus=false;
        setVisible (false);
        dispose ();
  }//GEN-LAST:event_stornoButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
//      System.out.println("Size = "+this.getSize().width+" x "+this.getSize().height);
      try {  
          String msg=null;
          if (Integer.parseInt(this.lengthField.getText())<=0) msg="Chybn zadna dlka pedmtu.";
          else if (this.teacherCombo.getSelectedIndex()<0) msg="Nezadn vyuujc.";
          else if (this.classCombo.getSelectedIndex()<0) msg="Nezadna tda.";
          else if (rooms.size()<=0) msg="Nezadny uebny.";
          if (msg!=null) {
              new MessageDlg("Chyba",msg,MessageDlg.OK).show();
              return;
          }
      } catch (Exception e) {
          new MessageDlg("Chyba","Chybn zadna dlka pedmtu.",MessageDlg.OK).show();
          return;         
      }
        activity.shortCut=this.shortCutField.getText();
        activity.name=this.nameField.getText();
        activity.note=this.noteArea.getText();
        activity.length=Integer.parseInt(this.lengthField.getText());
        activity.setPreference(preference);
        activity.resources.removeAll();
        if (this.classCombo.getSelectedIndex()<problem.getAllClasses().size()) 
            activity.resources.add(problem.getAllClasses().get(this.classCombo.getSelectedIndex()));
        else
            activity.resources.add(problem.groupedClasses.getResources(this.classCombo.getSelectedIndex()-problem.getAllClasses().size()));
        activity.resources.add(problem.getAllTeachers().get(this.teacherCombo.getSelectedIndex()));
        activity.resources.add(rooms);
        if (specRes.size()!=0) activity.resources.add(specRes);
        returnStatus=true;
        setVisible (false);
        dispose ();
  }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        returnStatus=false;
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog


// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel commandPanel;
private javax.swing.JButton okButton;
private javax.swing.JButton stornoButton;
private javax.swing.JTabbedPane jTabbedPane1;
private javax.swing.JPanel dataPanel;
private javax.swing.JLabel jLabel4;
private javax.swing.JTextField shortCutField;
private javax.swing.JLabel jLabel5;
private javax.swing.JTextField nameField;
private javax.swing.JLabel jLabel6;
private javax.swing.JTextField lengthField;
private javax.swing.JLabel jLabel7;
private javax.swing.JTextArea noteArea;
private javax.swing.JLabel jLabel8;
private javax.swing.JPanel resourcePanel;
private javax.swing.JLabel jLabel9;
private javax.swing.JComboBox teacherCombo;
private javax.swing.JLabel jLabel10;
private javax.swing.JComboBox classCombo;
private javax.swing.JLabel jLabel12;
private javax.swing.JLabel jLabel13;
private javax.swing.JLabel jLabel14;
private javax.swing.JLabel jLabel15;
private javax.swing.JScrollPane roomScrollPane;
private javax.swing.JPanel jPanel4;
private javax.swing.JButton addAllButton;
private javax.swing.JButton addButton;
private javax.swing.JButton removeButton;
private javax.swing.JButton removeAllButton;
private javax.swing.JScrollPane allRoomScrollPane;
private javax.swing.JPanel specResPanel;
private javax.swing.JLabel jLabel1;
private javax.swing.JLabel jLabel2;
private javax.swing.JLabel jLabel3;
private javax.swing.JLabel jLabel11;
private javax.swing.JScrollPane specResScrollPane;
private javax.swing.JPanel jPanel2;
private javax.swing.JButton addAllSpecResButton;
private javax.swing.JButton addSpecResButton;
private javax.swing.JButton removeSpecResButton;
private javax.swing.JButton removeAllSpecResButton;
private javax.swing.JScrollPane allSpecResScrollPane;
// End of variables declaration//GEN-END:variables

  class SelRoomsModel extends javax.swing.AbstractListModel {
        public int getSize() { return rooms.size(); }
        public Object getElementAt(int index) { return rooms.get(index).name; }
        public Resource getResourceAt(int index) { return rooms.get(index); }
  }

  class AllRoomsModel extends javax.swing.AbstractListModel {
      public int getSize() { return problem.getAllRooms().size()-rooms.size(); }
      public Object getElementAt(int index) { 
          int i=0;
          while (index>=0 && i<problem.getAllRooms().size()) {
              if (rooms.indexOf(problem.getAllRooms().get(i))<0) index--;
              i++;
          }
          return problem.getAllRooms().get(i-1).name;
      }
      public Resource getResourceAt(int index) { 
          int i=0;
          while (index>=0 && i<problem.getAllRooms().size()) {
              if (rooms.indexOf(problem.getAllRooms().get(i))<0) index--;
              i++;
          }
          return problem.getAllRooms().get(i-1);
      }
  }
  class SelSpecResModel extends javax.swing.AbstractListModel {
        public int getSize() { return specRes.size(); }
        public Object getElementAt(int index) { return specRes.get(index).name; }
        public Resource getResourceAt(int index) { return specRes.get(index); }
  }

  class AllSpecResModel extends javax.swing.AbstractListModel {
      public int getSize() { return problem.getAllSpecRes().size()-specRes.size(); }
      public Object getElementAt(int index) { 
          int i=0;
          while (index>=0 && i<problem.getAllSpecRes().size()) {
              if (specRes.indexOf(problem.getAllSpecRes().get(i))<0) index--;
              i++;
          }
          return problem.getAllSpecRes().get(i-1).name;
      }
      public Resource getResourceAt(int index) { 
          int i=0;
          while (index>=0 && i<problem.getAllSpecRes().size()) {
              if (specRes.indexOf(problem.getAllSpecRes().get(i))<0) index--;
              i++;
          }
          return problem.getAllSpecRes().get(i-1);
      }
  }
}
