/*
 * EditResourceDlg.java
 *
 * Created on 25. prosinec 2000, 19:06
 */

package timetable.school;

import timetable.data.*;
import timetable.util.*;
import timetable.gui.*;
import timetable.school.data.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class EditDependenceDlg extends javax.swing.JDialog {
    private boolean returnStatus = false;
    private ActivityDependenceInterface dependence;
    private SchoolProblem problem;
    
    public boolean getReturnStatus() {
        return returnStatus;
    }

    /** Creates new form EditResourceDlg */
    public EditDependenceDlg(java.awt.Frame parent,String title,Config config,ActivityDependenceInterface dependence,SchoolProblem problem) throws TimetableException{
        super ((parent==null?new javax.swing.JFrame():parent), true);
        this.dependence = dependence;
        this.problem = problem;
        if (dependence==null) return;
        initComponents ();
        this.dataTab.setTitleAt(0,Loc.get("timetable.school.gui.tab.general"));
        pack ();
        setTitle(title);
        this.setSize(295,195);
//        this.setResizable(false);
        for (int i=0;i<problem.activities.size();i++) {
            this.firstActivityCombo.addItem(problem.activities.get(i).name);
            this.secondActivityCombo.addItem(problem.activities.get(i).name);
        }
        String types[] = dependence.getTypes();
        for (int i=0;i<types.length;i++)
            this.typeCombo.addItem(types[i]);
        this.firstActivityCombo.setSelectedIndex(problem.activities.indexOf(dependence.getFirstActivity()));
        this.secondActivityCombo.setSelectedIndex(problem.activities.indexOf(dependence.getSecondActivity()));
        this.typeCombo.setSelectedIndex(dependence.getType());
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
    }

    public void show() {
       if (dependence!=null) super.show();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        commandPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        dataTab = new javax.swing.JTabbedPane();
        dataPanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        firstActivityCombo = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        secondActivityCombo = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox();
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        commandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
        
        okButton.setText(Loc.get("timetable.button.ok"));
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed(evt);
              }
          }
          );
          commandPanel.add(okButton);
          
          
        cancelButton.setText(Loc.get("timetable.button.cancel"));
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed(evt);
              }
          }
          );
          commandPanel.add(cancelButton);
          
          
        getContentPane().add(commandPanel, java.awt.BorderLayout.SOUTH);
        
        
        
        dataPanel.setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          
          jLabel3.setText(Loc.get("timetable.school.model.firstact"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel3, gridBagConstraints1);
            
            
          firstActivityCombo.setPreferredSize(new java.awt.Dimension(150, 25));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(firstActivityCombo, gridBagConstraints1);
            
            
          jLabel4.setText(Loc.get("timetable.school.model.secondact"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel4, gridBagConstraints1);
            
            
          secondActivityCombo.setPreferredSize(new java.awt.Dimension(150, 25));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(secondActivityCombo, gridBagConstraints1);
            
            
          jLabel5.setText(Loc.get("timetable.school.model.param"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel5, gridBagConstraints1);
            
            
          typeCombo.setPreferredSize(new java.awt.Dimension(150, 25));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(typeCombo, gridBagConstraints1);
            
            dataTab.addTab("Zkladn daje", dataPanel);
          
          
        getContentPane().add(dataTab, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
//    System.out.println("Size = "+this.getSize().width+" x "+this.getSize().height);
    String msg=null;
     if (this.typeCombo.getSelectedIndex()<0) msg="Nezadn parametr.";
     else if (this.firstActivityCombo.getSelectedIndex()<0) msg="Nezadn prvn pedmt."; 
     else if (this.secondActivityCombo.getSelectedIndex()<0) msg="Nezadn druh pedmt."; 
     if (msg!=null) {
        new MessageDlg("Chyba",msg,MessageDlg.OK).show();
        return;
    }
    dependence.setType(this.typeCombo.getSelectedIndex());
    dependence.setFirstActivity(problem.activities.get(this.firstActivityCombo.getSelectedIndex()));
    dependence.setSecondActivity(problem.activities.get(this.secondActivityCombo.getSelectedIndex()));
    returnStatus=true;
    setVisible(false);
    dispose();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    returnStatus=false;
    setVisible(false);
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel commandPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTabbedPane dataTab;
    private javax.swing.JPanel dataPanel;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JComboBox firstActivityCombo;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JComboBox secondActivityCombo;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JComboBox typeCombo;
    // End of variables declaration//GEN-END:variables

}
