/*
 * EditResourceDlg.java
 *
 * Created on 25. prosinec 2000, 19:06
 */

package timetable.school;

import timetable.data.*;
import timetable.util.*;
import timetable.gui.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class EditResourceDlg extends javax.swing.JDialog {
    private boolean returnStatus = false;
    private TimePreference preference;
    private Resource resource;
    
    public boolean getReturnStatus() {
        return returnStatus;
    }

    /** Creates new form EditResourceDlg */
    public EditResourceDlg(java.awt.Frame parent, String title, Config config, Resource resource) throws TimetableException{
        super ((parent==null?new javax.swing.JFrame():parent), true);
        this.resource = resource;
        if (resource==null) return;
        initComponents ();
        this.dataTab.setTitleAt(0,Loc.get("timetable.school.gui.tab.general"));
        pack ();
        setTitle(title);
        java.awt.GridBagConstraints c = new java.awt.GridBagConstraints();
        c.gridx=1;c.gridy=3;
        c.gridheight=c.gridwidth=1;
        c.weightx=c.weighty=1;
        c.ipadx=c.ipady=3;
        this.preference = (TimePreference)resource.getPreference().clone();
        TimePreferencePanel tpp = new TimePreferencePanel(config,preference);
        this.dataPanel.add(tpp,c);
        this.setSize(timetable.util.Math.max2(200,20*(config.getInt(config.NR_SLOTS)/config.getInt(config.NR_DAYS)))+155,360);//355x360
//        this.setResizable(false);
        this.shortCutLabel.setText(resource.shortCut);
        this.nameLabel.setText(resource.name);
        this.noteArea.setText(resource.note);
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
    }

    public void show() {
       if (resource!=null) super.show();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
private void initComponents() {//GEN-BEGIN:initComponents
commandPanel = new javax.swing.JPanel();
okButton = new javax.swing.JButton();
cancelButton = new javax.swing.JButton();
dataTab = new javax.swing.JTabbedPane();
dataPanel = new javax.swing.JPanel();
jLabel3 = new javax.swing.JLabel();
shortCutLabel = new javax.swing.JTextField();
jLabel4 = new javax.swing.JLabel();
nameLabel = new javax.swing.JTextField();
jLabel5 = new javax.swing.JLabel();
noteArea = new javax.swing.JTextArea();
jLabel1 = new javax.swing.JLabel();
addWindowListener(new java.awt.event.WindowAdapter() {
public void windowClosing(java.awt.event.WindowEvent evt) {
closeDialog(evt);
}
}
);

commandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));

okButton.setLabel(Loc.get("timetable.button.ok"));
  okButton.setText(Loc.get("timetable.button.ok"));
  okButton.addActionListener(new java.awt.event.ActionListener() {
  public void actionPerformed(java.awt.event.ActionEvent evt) {
  okButtonActionPerformed(evt);
  }
  }
  );
  commandPanel.add(okButton);
  
  
cancelButton.setLabel(Loc.get("timetable.button.cancel"));
  cancelButton.setText(Loc.get("timetable.button.cancel"));
  cancelButton.addActionListener(new java.awt.event.ActionListener() {
  public void actionPerformed(java.awt.event.ActionEvent evt) {
  cancelButtonActionPerformed(evt);
  }
  }
  );
  commandPanel.add(cancelButton);
  
  
getContentPane().add(commandPanel, java.awt.BorderLayout.SOUTH);



dataPanel.setLayout(new java.awt.GridBagLayout());
  java.awt.GridBagConstraints gridBagConstraints1;
  
  jLabel3.setText(Loc.get("timetable.school.model.shortcut"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 0;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel3, gridBagConstraints1);
    
    
  shortCutLabel.setPreferredSize(new java.awt.Dimension(80, 20));
    shortCutLabel.setText("jTextField3");
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.gridy = 0;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(shortCutLabel, gridBagConstraints1);
    
    
  jLabel4.setText(Loc.get("timetable.school.model.name"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 1;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel4, gridBagConstraints1);
    
    
  nameLabel.setPreferredSize(new java.awt.Dimension(200, 20));
    nameLabel.setText("jTextField4");
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.gridy = 1;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(nameLabel, gridBagConstraints1);
    
    
  jLabel5.setText(Loc.get("timetable.school.model.note"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 2;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel5, gridBagConstraints1);
    
    
  noteArea.setPreferredSize(new java.awt.Dimension(200, 50));
    noteArea.setBorder(new javax.swing.border.EtchedBorder());
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 1;
    gridBagConstraints1.gridy = 2;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(noteArea, gridBagConstraints1);
    
    
  jLabel1.setText(Loc.get("timetable.school.model.timepreference"));
    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 3;
    gridBagConstraints1.ipadx = 3;
    gridBagConstraints1.ipady = 3;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    dataPanel.add(jLabel1, gridBagConstraints1);
    
    dataTab.addTab("Zkladn daje", dataPanel);
  
  
getContentPane().add(dataTab, java.awt.BorderLayout.CENTER);

}//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
//    System.out.println("Size = "+this.getSize().width+" x "+this.getSize().height);
    resource.name = this.nameLabel.getText();
    resource.shortCut = this.shortCutLabel.getText();
    resource.note = this.noteArea.getText();
    resource.setPreference(this.preference);
    returnStatus=true;
    setVisible(false);
    dispose();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    returnStatus=false;
    setVisible(false);
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog


// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel commandPanel;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
private javax.swing.JTabbedPane dataTab;
private javax.swing.JPanel dataPanel;
private javax.swing.JLabel jLabel3;
private javax.swing.JTextField shortCutLabel;
private javax.swing.JLabel jLabel4;
private javax.swing.JTextField nameLabel;
private javax.swing.JLabel jLabel5;
private javax.swing.JTextArea noteArea;
private javax.swing.JLabel jLabel1;
// End of variables declaration//GEN-END:variables

}
