/*
 * EditResourceDlg.java
 *
 * Created on 25. prosinec 2000, 19:06
 */

package timetable.school;

import timetable.data.*;
import timetable.util.*;
import timetable.gui.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class EditResourceGroupDlg extends javax.swing.JDialog {
    private boolean returnStatus = false;
    private ResourceGroup allRes,selRes,resources;
    private AllResModel allResModel;
    private SelResModel selResModel;
    private javax.swing.JList allResList,selResList;
    
    
    public boolean getReturnStatus() {
        return returnStatus;
    }

    /** Creates new form EditResourceDlg */
    public EditResourceGroupDlg(java.awt.Frame parent,String title,Config config,ResourceGroup resources,ResourceGroup allRes) throws TimetableException{
        super ((parent==null?new javax.swing.JFrame():parent), true);
        if (resources==null) return;
        this.selRes = (ResourceGroup)resources.clone();
        this.resources = resources;
        this.allRes = allRes;
        initComponents ();
        this.dataTab.setTitleAt(0,Loc.get("timetable.school.gui.tab.general"));
        pack ();
        setTitle(title);
        java.awt.GridBagConstraints c = new java.awt.GridBagConstraints();
        this.setSize(380,370);
//        this.setResizable(false);
        this.shortCutLabel.setText(resources.shortCut);
        this.nameLabel.setText(resources.name);
        this.noteArea.setText(resources.note);
        allResModel = new AllResModel();
        selResModel = new SelResModel();
        allResList = new javax.swing.JList(allResModel);
        selResList = new javax.swing.JList(selResModel);
        selScrollPane.getViewport().setView(selResList);
        allScrollPane.getViewport().setView(allResList);
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
    }

    public void show() {
       if (selRes!=null) super.show();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        commandPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        dataTab = new javax.swing.JTabbedPane();
        dataPanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        shortCutLabel = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        nameLabel = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        noteArea = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        selScrollPane = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        addAllButton = new javax.swing.JButton();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        removeAllButton = new javax.swing.JButton();
        allScrollPane = new javax.swing.JScrollPane();
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        commandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
        
        okButton.setText(Loc.get("timetable.button.ok"));
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed(evt);
              }
          }
          );
          commandPanel.add(okButton);
          
          
        cancelButton.setText(Loc.get("timetable.button.cancel"));
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed(evt);
              }
          }
          );
          commandPanel.add(cancelButton);
          
          
        getContentPane().add(commandPanel, java.awt.BorderLayout.SOUTH);
        
        
        
        dataPanel.setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          
          jLabel3.setText(Loc.get("timetable.school.model.shortcut"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel3, gridBagConstraints1);
            
            
          shortCutLabel.setPreferredSize(new java.awt.Dimension(80, 20));
            shortCutLabel.setText("jTextField3");
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(shortCutLabel, gridBagConstraints1);
            
            
          jLabel4.setText(Loc.get("timetable.school.model.name"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel4, gridBagConstraints1);
            
            
          nameLabel.setPreferredSize(new java.awt.Dimension(200, 20));
            nameLabel.setText("jTextField4");
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(nameLabel, gridBagConstraints1);
            
            
          jLabel5.setText(Loc.get("timetable.school.model.note"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel5, gridBagConstraints1);
            
            
          noteArea.setPreferredSize(new java.awt.Dimension(200, 50));
            noteArea.setBorder(new javax.swing.border.EtchedBorder());
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.ipadx = 3;
            gridBagConstraints1.ipady = 3;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(noteArea, gridBagConstraints1);
            
            
          jLabel2.setText(Loc.get("timetable.school.model.classes"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel2, gridBagConstraints1);
            
            
          jLabel6.setText(Loc.get("timetable.school.gui.selected"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel6, gridBagConstraints1);
            
            
          gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel7, gridBagConstraints1);
            
            
          jLabel8.setText(Loc.get("timetable.school.gui.notselected"));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jLabel8, gridBagConstraints1);
            
            
          selScrollPane.setPreferredSize(new java.awt.Dimension(100, 120));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(selScrollPane, gridBagConstraints1);
            
            
          jPanel1.setLayout(new java.awt.GridLayout(4, 1));
            jPanel1.setPreferredSize(new java.awt.Dimension(110, 100));
            
            addAllButton.setText(Loc.get("timetable.school.button.addall"));
              addAllButton.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      addAllButtonActionPerformed(evt);
                  }
              }
              );
              jPanel1.add(addAllButton);
              
              
            addButton.setText(Loc.get("timetable.school.button.add"));
              addButton.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      addButtonActionPerformed(evt);
                  }
              }
              );
              jPanel1.add(addButton);
              
              
            removeButton.setText(Loc.get("timetable.school.button.remove"));
              removeButton.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      removeButtonActionPerformed(evt);
                  }
              }
              );
              jPanel1.add(removeButton);
              
              
            removeAllButton.setText(Loc.get("timetable.school.button.removeall"));
              removeAllButton.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      removeAllButtonActionPerformed(evt);
                  }
              }
              );
              jPanel1.add(removeAllButton);
              
              gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(jPanel1, gridBagConstraints1);
            
            
          allScrollPane.setPreferredSize(new java.awt.Dimension(100, 120));
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            dataPanel.add(allScrollPane, gridBagConstraints1);
            
            dataTab.addTab("Zkladn daje", dataPanel);
          
          
        getContentPane().add(dataTab, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

  private void removeAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeAllButtonActionPerformed
    selRes.removeAll();
    this.selResList.updateUI();
    this.allResList.updateUI();
  }//GEN-LAST:event_removeAllButtonActionPerformed

  private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
    if (allResList.getSelectedIndex()<0 || allResList.getSelectedIndex()>=allResModel.getSize()) return;
    selRes.add(allResModel.getResourceAt(allResList.getSelectedIndex()));
    this.selResList.updateUI();
    this.allResList.updateUI();
  }//GEN-LAST:event_addButtonActionPerformed

  private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
    if (selResList.getSelectedIndex()<0 || selResList.getSelectedIndex()>=selResModel.getSize()) return;
    selRes.remove(selResModel.getResourceAt(selResList.getSelectedIndex()));
    this.selResList.updateUI();
    this.allResList.updateUI();
  }//GEN-LAST:event_removeButtonActionPerformed

  private void addAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addAllButtonActionPerformed
      while (allResModel.getSize()>0) {
          selRes.add(allResModel.getResourceAt(0));
      }
    this.selResList.updateUI();
    this.allResList.updateUI();
  }//GEN-LAST:event_addAllButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
//    System.out.println("Size = "+this.getSize().width+" x "+this.getSize().height);
    if (selRes.size()==0) {
        new MessageDlg("Chyba","Nezadna dn tda.",MessageDlg.OK).show();
        return;
    }
    resources.name = this.nameLabel.getText();
    resources.shortCut = this.shortCutLabel.getText();
    resources.note = this.noteArea.getText();
    resources.removeAll();
    for (int i=0;i<selRes.size();i++)
        resources.add(selRes.get(i));
    returnStatus=true;
    setVisible(false);
    dispose();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    returnStatus=false;
    setVisible(false);
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel commandPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTabbedPane dataTab;
    private javax.swing.JPanel dataPanel;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField shortCutLabel;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField nameLabel;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextArea noteArea;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JScrollPane selScrollPane;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton addAllButton;
    private javax.swing.JButton addButton;
    private javax.swing.JButton removeButton;
    private javax.swing.JButton removeAllButton;
    private javax.swing.JScrollPane allScrollPane;
    // End of variables declaration//GEN-END:variables

  class SelResModel extends javax.swing.AbstractListModel {
        public int getSize() { return selRes.size(); }
        public Object getElementAt(int index) { return selRes.get(index).name; }
        public Resource getResourceAt(int index) { return selRes.get(index); }
  }

  class AllResModel extends javax.swing.AbstractListModel {
      public int getSize() { return allRes.size()-selRes.size(); }
      public Object getElementAt(int index) { 
          int i=0;
          while (index>=0 && i<allRes.size()) {
              if (selRes.indexOf(allRes.get(i))<0) index--;
              i++;
          }
          return allRes.get(i-1).name;
      }
      public Resource getResourceAt(int index) { 
          int i=0;
          while (index>=0 && i<allRes.size()) {
              if (selRes.indexOf(allRes.get(i))<0) index--;
              i++;
          }
          return allRes.get(i-1);
      }
  }
}
