/*
 * SchoolTimetable.java
 *
 * Created on 25. prosinec 2000, 16:42
 */

package timetable.school;

import timetable.data.*;
import timetable.util.*;
import timetable.gui.*;
import timetable.solver.*;
import timetable.school.gui.*;
import timetable.school.data.*;

import javax.swing.*;
import java.awt.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class SchoolTimetable extends javax.swing.JFrame {
    public  boolean solving = false;
    private String fileName=null;
    private Solver solver = null;
    private SolverThread solverThread = null;
    private UpdateThread updateThread = null;
    private SchoolProblem problem=null;
    private Config config;
    private DNDActivityEngine engine, engine2;
        
    private DataTable teachersTable,roomsTable,specResTable,classesTable, groupedClassesTable;
    private DataTable activitiesTable, dependencesTable;
    private DataTable allResourcesTable;
    private DNDDataTable notScheduledActivitiesTable,oneResNotScheduledActivitiesTable;
    private JPopupMenu activitiesMenu;
    private JMenuItem addActMenuItem,editActMenuItem,removeActMenuItem,scheduleActMenuItem, removeActFromTableMenuItem,removeActFromORPanelMenuItem;
    
    private TimeTableTable allResourcesScheduleTable;
    private TimeTableModel allResourcesScheduleModel;
    
    private SolverRightsPanel solverRightsPanel;
    private SchoolRightsPanel schoolRightsPanel;
    
    private NotScheduledActivityTableModel notScheduledActivityTableModel,oneResNotScheduledActivityTableModel;
    private AllResourcesTableModel allResourcesTableModel;
    private TimeTablePanel oneResourceSchedulePanel;
    
    private JButton solveButton = new JButton();
    private JButton newActivityButton = new JButton();
    private JLabel statusLabel = new JLabel();


    /** Creates new form SchoolTimetable */
    public SchoolTimetable() { this(null); }
        
    public SchoolTimetable(String fileName) {
        try {
            config = new Config();
            Loc.addLocalization(config.get("LOC_SCHOOL"));
            initComponents ();
            pack ();
            this.fileName=fileName;
            this.setTitle(Loc.get("timetable.school.title")+"   ["+Loc.get("timetable.school.title.new")+"]");
            problem = new SchoolProblem(config);
            if (fileName!=null) {
              problem = (SchoolProblem)problem.load(fileName);
              config = problem.config;
              this.setTitle(Loc.get("timetable.school.title")+"   ["+fileName+"]");
            }            
            
            solveButton.setText(Loc.get("timetable.school.button.solve"));
            newActivityButton.setText(Loc.get("timetable.school.button.addNewLecture"));
            statusLabel.setText(Loc.get("timetable.school.text.state"));
            this.mainTab.setTitleAt(0,Loc.get("timetable.school.tab.resources"));
            this.mainTab.setTitleAt(1,Loc.get("timetable.school.tab.activities"));
            this.mainTab.setTitleAt(2,Loc.get("timetable.school.tab.timetable"));
            this.resourcesTab.setTitleAt(0,Loc.get("timetable.school.tab.teachers"));
            this.resourcesTab.setTitleAt(1,Loc.get("timetable.school.tab.classes"));
            this.resourcesTab.setTitleAt(2,Loc.get("timetable.school.tab.rooms"));
            this.resourcesTab.setTitleAt(3,Loc.get("timetable.school.tab.others"));
            this.classesTab.setTitleAt(0,Loc.get("timetable.school.tab.classes.single"));
            this.classesTab.setTitleAt(1,Loc.get("timetable.school.tab.classes.group"));
            this.activitiesTab.setTitleAt(0,Loc.get("timetable.school.tab.lecture"));
            this.activitiesTab.setTitleAt(1,Loc.get("timetable.school.tab.dependence"));
            this.timetableTab.setTitleAt(0,Loc.get("timetable.school.tab.wholeschedule"));
            this.timetableTab.setTitleAt(1,Loc.get("timetable.school.tab.singleschedule"));
            this.timetableTab.setTitleAt(2,Loc.get("timetable.school.tab.rights"));
            this.rightsTab.setTitleAt(0,Loc.get("timetable.school.tab.rights.general"));
            this.rightsTab.setTitleAt(1,Loc.get("timetable.school.tab.rights.specific"));
            
            toolBar.add(this.newActivityButton);
            toolBar.add(this.solveButton);
            toolBar.addSeparator();
            toolBar.add(this.statusLabel);
                        
            newActivityButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    addActivityButtomActionPerformed(evt);
                }
            });

            solveButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    try {
                        if (!solving) {
                          mainTab.getModel().setSelectedIndex(2);
                          timetableTab.getModel().setSelectedIndex(0);
                          solveButton.setText(Loc.get("timetable.school.button.stop"));
                          setStatus(Loc.get("timetable.school.state.solving"));
                              problem.saveState();
                              solver = new Solver(config,problem);
                              solver.setValueSelection(new timetable.solver.strategy.value.MinValueSelection(config,new timetable.solver.strategy.Tabu(config),
                                                       new timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation(config)));
                              solver.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(config));
                          solverThread = new SolverThread();
                          updateThread = new UpdateThread();
                          solverThread.start();
                          updateThread.start();
                          solving=true;
//                          s.solve();
                        } else {
                            solving=false;
                            solverThread.stop();updateThread.stop();
                            setStatus(Loc.get("timetable.school.state.stopped"));
                            solveButton.setText(Loc.get("timetable.school.button.solve"));
                            MessageDlg md = new MessageDlg(null,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.question.returnToPrevSched"),MessageDlg.YESNO);
                            md.show();
                            if (md.getReturnStatus()==MessageDlg.YES) problem.restoreLastState();
                            oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                            oneResNotScheduledActivitiesTable.updateUI();
                            notScheduledActivityTableModel.forceActivitiesChanged();
                            allResourcesScheduleTable.updateUI();
                            notScheduledActivitiesTable.updateUI();
                        }
                    } catch (Exception e) {
                        dispError(e);
                    };
                }
            });

            teachersTable = new DataTable(new ResourceTableModel(problem.getAllTeachers()),teachersScrollPane);
            teachersTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditResourceDlg(null,Loc.get("timetable.school.editresourcedlg.title.updateteacher"),config,problem.getAllTeachers().get(teachersTable.getSelectedRow())).show();
                          teachersTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });

            specResTable = new DataTable(new ResourceTableModel(problem.getAllSpecRes()),specResScrollPane);
            specResTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditResourceDlg(null,Loc.get("timetable.school.editresourcedlg.title.updateresource"),config,problem.getAllSpecRes().get(specResTable.getSelectedRow())).show();
                          specResTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });

            roomsTable = new DataTable(new ResourceTableModel(problem.getAllRooms()),roomsScrollPane);
            roomsTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditResourceDlg(null,Loc.get("timetable.school.editresourcedlg.title.updateroom"),config,problem.getAllRooms().get(roomsTable.getSelectedRow())).show();
                          roomsTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });

            classesTable = new DataTable(new ResourceTableModel(problem.getAllClasses()),classesScrollPane);
            classesTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditResourceDlg(null,Loc.get("timetable.school.editresourcedlg.title.updateclass"),config,problem.getAllClasses().get(classesTable.getSelectedRow())).show();
                          classesTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });
            
            groupedClassesTable = new DataTable(new GroupedClassTableModel(problem.groupedClasses),groupedClassesScrollPane);
            groupedClassesTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditResourceGroupDlg(null,Loc.get("timetable.school.editresourcegroupdlg.title.updateclassgroup"),config,problem.groupedClasses.getResources(groupedClassesTable.getSelectedRow()),problem.getAllClasses()).show();
                          groupedClassesTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });
            
            
            activitiesTable = new DataTable(new ActivityTableModel(problem.activities),activitiesScrollPane);
            activitiesTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditActivityDlg(null,Loc.get("timetable.school.editactivitydlg.title.updatelecture"),config,problem.activities.get(activitiesTable.getSelectedRow()),problem).show();
                          activitiesTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });
            
            dependencesTable = new DataTable(new DependenceTableModel(problem.dependences),dependencesScrollPane);
            dependencesTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount()>=2) {
                        try {
                          new EditDependenceDlg(null,Loc.get("timetable.school.dependencedlg.title.updatedependence"),config,problem.dependences.get(dependencesTable.getSelectedRow()),problem).show();
                          dependencesTable.updateUI();
                        } catch (Exception e) { dispError(e); };
                    }
                }
            });
            
            Solver s = new Solver(config,problem);
            s.setValueSelection(new timetable.solver.strategy.value.HumanValueSelection(config,
                                new timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation(config)));
            s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(config));
            engine = new DNDActivityEngine(problem,s);
            engine2 = new DNDActivityEngine(problem,s);

            oneResNotScheduledActivityTableModel = new NotScheduledActivityTableModel(problem);
            oneResNotScheduledActivitiesTable = new DNDDataTable(oneResNotScheduledActivityTableModel,oneResNotScheduledActivitiesScrollPane,engine2);
            oneResNotScheduledActivitiesTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent e) {
                    if ((e.getModifiers()&e.BUTTON3_MASK)>0) {
                        activitiesMenu.show(oneResNotScheduledActivitiesTable,e.getX(),e.getY());
                    };
                }
            });
            notScheduledActivityTableModel = new NotScheduledActivityTableModel(problem);
            notScheduledActivitiesTable = new DNDDataTable(notScheduledActivityTableModel,notScheduledActivitiesScrollPane,engine);
            notScheduledActivitiesTable.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent e) {
                    if ((e.getModifiers()&e.BUTTON3_MASK)>0) {
                        activitiesMenu.show(notScheduledActivitiesTable,e.getX(),e.getY());
                    };
                }
            });
            activitiesMenu = new JPopupMenu();
            addActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.activity.add"));
            editActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.activity.update"));
            removeActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.activity.remove"));
            scheduleActMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.solve"));
            activitiesMenu.add(addActMenuItem);
            activitiesMenu.add(editActMenuItem);
            activitiesMenu.add(removeActMenuItem);
            activitiesMenu.add(new javax.swing.JPopupMenu.Separator());            
            activitiesMenu.add(scheduleActMenuItem);
            scheduleActMenuItem.addActionListener( new java.awt.event.ActionListener() {
                 public void actionPerformed(final java.awt.event.ActionEvent e) {
                     try {
                         Solver s = new Solver(config,problem);
                         s.setValueSelection(new timetable.solver.strategy.value.HumanValueSelection(config,
                                             new timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation(config)));
                         s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(config));
                         Activity a = ((NotScheduledActivityTableModel)((DNDDataTable)activitiesMenu.getInvoker()).getModel()).getActivities().get(((DNDDataTable)activitiesMenu.getInvoker()).getSelectedRow());
//                         config.set("DEBUG",1);
                         s.schedule(a);
//                         config.set("DEBUG",0);
                         updateScheduleTables();
                     } catch (Exception ex) { dispError(ex); }
                 }
            });
            addActMenuItem.addActionListener( new java.awt.event.ActionListener() {
                 public void actionPerformed(final java.awt.event.ActionEvent e) {
                     addActivityButtomActionPerformed(e);
                 }
            });
            editActMenuItem.addActionListener( new java.awt.event.ActionListener() {
                 public void actionPerformed(final java.awt.event.ActionEvent e) {
                     try {
                         new EditActivityDlg(null,Loc.get("timetable.school.editactivitydlg.title.updatelecture"),config,((NotScheduledActivityTableModel)((DNDDataTable)activitiesMenu.getInvoker()).getModel()).getActivities().get(((DNDDataTable)activitiesMenu.getInvoker()).getSelectedRow()),problem).show();
                         activitiesTable.updateUI();
                         notScheduledActivityTableModel.forceActivitiesChanged();
                         notScheduledActivitiesTable.updateUI();
                         oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                         oneResNotScheduledActivitiesTable.updateUI();
                     } catch (Exception ex) { dispError(ex); };
                 }
            });
            removeActMenuItem.addActionListener( new java.awt.event.ActionListener() {
                 public void actionPerformed(final java.awt.event.ActionEvent e) {
                     try {
                         Activity a = ((NotScheduledActivityTableModel)((DNDDataTable)activitiesMenu.getInvoker()).getModel()).getActivities().get(((DNDDataTable)activitiesMenu.getInvoker()).getSelectedRow());
                         if (problem.dependences.countDependences(a)>0) {
                             new MessageDlg(null,Loc.get("timetable.school.message.activity.cannotremove"),Loc.get("timetable.school.message.activity.cannotremove.dependence"),MessageDlg.OK).show();
                             return;
                         };
                         if (a!=null && question(Loc.get("timetable.school.message.question.deleteactivity", a.name))) {
                             problem.activities.remove(a);
                             activitiesTable.updateUI();
                             oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                             oneResNotScheduledActivitiesTable.updateUI();
                             notScheduledActivityTableModel.forceActivitiesChanged();
                             notScheduledActivitiesTable.updateUI();
                         }
                     } catch (Exception ex) {  dispError(ex); }
                 }
            });
            
            allResourcesTableModel = new AllResourcesTableModel(problem.resources);
            allResourcesTable = new DataTable(allResourcesTableModel,allResourcesScrollPane);
            
            ((JTable)allResourcesTable).getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
                public void valueChanged(javax.swing.event.ListSelectionEvent e) {
                    try {
                        oneResourceSchedulePanel.setResource(allResourcesTableModel.getResource(allResourcesTable.getSelectedRow()));
                        oneResourceSchedulePanel.updateUI();
                    } catch (TimetableException err) {
                        dispError(err);
                    }
                }
            });
            
            oneResourceSchedulePanel = new TimeTablePanel(config);
            oneResourceScheduleScrollPane.setViewportView(oneResourceSchedulePanel);
            oneResourceSchedulePanel.setResource(allResourcesTableModel.getResource(allResourcesTable.getSelectedRow()));
            
            resourceCombo.addItem(Loc.get("timetable.school.resource.classes"));
            resourceCombo.addItem(Loc.get("timetable.school.resource.teachers"));
            resourceCombo.addItem(Loc.get("timetable.school.resource.rooms"));
            resourceCombo.setSelectedIndex(0);
            resourceCombo.addActionListener (new java.awt.event.ActionListener () {
                 public void actionPerformed (java.awt.event.ActionEvent evt) {
                    allResourcesScheduleModel.setResources(problem.resources[resourceCombo.getSelectedIndex()]);
                    allResourcesScheduleTable.updateUI();
                 }
            });
            allResourcesScheduleModel = new TimeTableModel(config,problem.resources[resourceCombo.getSelectedIndex()]);
            allResourcesScheduleTable = new TimeTableTable(allResourcesScheduleModel,fullScheduleScrollPane,engine);
            removeActFromTableMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.remove"));
            removeActFromORPanelMenuItem = new JMenuItem(Loc.get("timetable.school.popupmenu.remove"));
            allResourcesScheduleModel.addMenuSeparator();
            allResourcesScheduleModel.addMenuItem(removeActFromTableMenuItem);
            oneResourceSchedulePanel.addMenuSeparator();
            oneResourceSchedulePanel.addMenuItem(removeActFromORPanelMenuItem);            
            removeActFromORPanelMenuItem.addActionListener( new java.awt.event.ActionListener() {
                 public void actionPerformed(final java.awt.event.ActionEvent e) {
                     try {
                         Activity a = oneResourceSchedulePanel.selectedActivity;
                         if (a!=null) a.remove(a);
                         updateScheduleTables();
                     } catch (Exception ex) {  dispError(ex); }
                 }
            });
            removeActFromTableMenuItem.addActionListener( new java.awt.event.ActionListener() {
                 public void actionPerformed(final java.awt.event.ActionEvent e) {
                     try {
                         Activity a = allResourcesScheduleModel.getActivityAt(allResourcesScheduleModel.menuRow,allResourcesScheduleModel.menuColumn);//allResourcesScheduleTable.getSelectedRow(),allResourcesScheduleTable.getSelectedColumn());
                         a.remove(a);
                         updateScheduleTables();
                     } catch (Exception ex) {  dispError(ex); }
                 }
            });
            
            oneResourceSchedulePanel.setDNDEngine(engine2);
            
            engine2.addDNDListener(new DNDListener() {
                public void drop(DNDEvent e) {
                    try {
                        updateScheduleTables();
                    } catch (Exception ex) { dispError(ex);}
                }
                public void drag(DNDEvent e) {}
            });
            engine.addDNDListener(new DNDListener() {
                public void drop(DNDEvent e) {
                    try {
                        updateScheduleTables();
                    } catch (Exception ex) { dispError(ex);}
                }
                public void drag(DNDEvent e) {}
            });
            
            solverRightsPanel = new SolverRightsPanel();
            basicRightsScrollPane.setViewportView(solverRightsPanel);//,java.awt.BorderLayout.CENTER);
            solverRightsPanel.setConfig(config);
            
            schoolRightsPanel = new SchoolRightsPanel();
            specRightsScrollPane.setViewportView(schoolRightsPanel);//,java.awt.BorderLayout.CENTER);
            schoolRightsPanel.setConfig(config);
                       
            this.setSize(604,543);
            this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
        } catch (Exception e) {
            dispError(e);
            System.exit(1);
        }
    }
    
    public void dispError(Exception e) {
            System.err.println("Error: "+e);
            e.printStackTrace(System.err);
            new MessageDlg(this,Loc.get("timetable.school.error"),e.getClass().getName()+":"+e.getMessage(),MessageDlg.OK).show();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        menu = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        newTimetableMenuItem = new javax.swing.JMenuItem();
        loadTimetableMenuItem = new javax.swing.JMenuItem();
        saveTimetableMenuItem = new javax.swing.JMenuItem();
        saveAsTimetableMenuItem = new javax.swing.JMenuItem();
        separator1 = new javax.swing.JSeparator();
        resetMenuItem = new javax.swing.JMenuItem();
        separator2 = new javax.swing.JSeparator();
        closeMenuItem = new javax.swing.JMenuItem();
        toolBar = new javax.swing.JToolBar();
        mainTab = new javax.swing.JTabbedPane();
        resourcesPanel = new javax.swing.JPanel();
        resourcesTab = new javax.swing.JTabbedPane();
        teachersPanel = new javax.swing.JPanel();
        teachersScrollPane = new javax.swing.JScrollPane();
        teachersCommandPanel = new javax.swing.JPanel();
        addTeacherButton = new javax.swing.JButton();
        editTeacherButton = new javax.swing.JButton();
        removeTeacherButton = new javax.swing.JButton();
        classesPanel = new javax.swing.JPanel();
        classesTab = new javax.swing.JTabbedPane();
        singleClassesPanel = new javax.swing.JPanel();
        classesCommandPanel = new javax.swing.JPanel();
        addClassButton = new javax.swing.JButton();
        editClassButton = new javax.swing.JButton();
        removeClassButton = new javax.swing.JButton();
        classesScrollPane = new javax.swing.JScrollPane();
        groupedClassesPanel = new javax.swing.JPanel();
        groupedClassesCommandPanel = new javax.swing.JPanel();
        addClassGroupButton = new javax.swing.JButton();
        editClassGroupButton = new javax.swing.JButton();
        removeClassGroupButton = new javax.swing.JButton();
        groupedClassesScrollPane = new javax.swing.JScrollPane();
        roomsPanel = new javax.swing.JPanel();
        roomsScrollPane = new javax.swing.JScrollPane();
        roomsCommandPanel = new javax.swing.JPanel();
        addRoomButton = new javax.swing.JButton();
        editRoomButton = new javax.swing.JButton();
        removeRoomButton = new javax.swing.JButton();
        specResPanel = new javax.swing.JPanel();
        specResScrollPane = new javax.swing.JScrollPane();
        specResCommandPanel = new javax.swing.JPanel();
        addSpecResButton = new javax.swing.JButton();
        editSpecResButton = new javax.swing.JButton();
        removeSpecResButton = new javax.swing.JButton();
        activitiesAndDependancesPanel = new javax.swing.JPanel();
        activitiesTab = new javax.swing.JTabbedPane();
        activitiesPanel = new javax.swing.JPanel();
        activitiesScrollPane = new javax.swing.JScrollPane();
        activitiesCommandPanel = new javax.swing.JPanel();
        addActivityButtom = new javax.swing.JButton();
        editActivityButton = new javax.swing.JButton();
        removeActivityButton = new javax.swing.JButton();
        dependencesPanel = new javax.swing.JPanel();
        dependencesScrollPane = new javax.swing.JScrollPane();
        dependencesCommandPanel = new javax.swing.JPanel();
        addDependenceButton = new javax.swing.JButton();
        editDependenceButton = new javax.swing.JButton();
        removeDependenceButton = new javax.swing.JButton();
        timetablePanel = new javax.swing.JPanel();
        timetableTab = new javax.swing.JTabbedPane();
        fullTimetablePabel = new javax.swing.JPanel();
        fullTimetableCommandPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        resourceCombo = new javax.swing.JComboBox();
        fullTimetableSplitPane = new javax.swing.JSplitPane();
        fullScheduleScrollPane = new javax.swing.JScrollPane();
        notScheduledActivitiesPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        notScheduledActivitiesScrollPane = new javax.swing.JScrollPane();
        resourceTimetablePanel = new javax.swing.JPanel();
        oneResourceSplitPane = new javax.swing.JSplitPane();
        oneResourceScheduleScrollPane = new javax.swing.JScrollPane();
        resourceVsUnschedActivitiesSplitPane = new javax.swing.JSplitPane();
        notScheduledActivitiesScrollPane2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        oneResNotScheduledActivitiesScrollPane = new javax.swing.JScrollPane();
        resourceTimetableCommandPanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        allResourcesScrollPane = new javax.swing.JScrollPane();
        rightsPanel = new javax.swing.JPanel();
        rightsTab = new javax.swing.JTabbedPane();
        basicRightsScrollPane = new javax.swing.JScrollPane();
        specRightsScrollPane = new javax.swing.JScrollPane();
        
        fileMenu.setActionCommand("Rozvrh");
          fileMenu.setText(Loc.get("timetable.school.menu.file"));
          
          newTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.new"));
            newTimetableMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    newTimetableMenuItemActionPerformed(evt);
                }
            }
            );
            fileMenu.add(newTimetableMenuItem);
            
          loadTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.open"));
            loadTimetableMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    loadTimetableMenuItemActionPerformed(evt);
                }
            }
            );
            fileMenu.add(loadTimetableMenuItem);
            
          saveTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.save"));
            saveTimetableMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    saveTimetableMenuItemActionPerformed(evt);
                }
            }
            );
            fileMenu.add(saveTimetableMenuItem);
            
          saveAsTimetableMenuItem.setText(Loc.get("timetable.school.menu.file.saveas"));
            saveAsTimetableMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    saveAsTimetableMenuItemActionPerformed(evt);
                }
            }
            );
            fileMenu.add(saveAsTimetableMenuItem);
            
          fileMenu.add(separator1);
            
          resetMenuItem.setText(Loc.get("timetable.school.menu.file.reset"));
            resetMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    resetMenuItemActionPerformed(evt);
                }
            }
            );
            fileMenu.add(resetMenuItem);
            
          fileMenu.add(separator2);
            
          closeMenuItem.setText(Loc.get("timetable.school.menu.file.exit"));
            closeMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    closeMenuItemActionPerformed(evt);
                }
            }
            );
            fileMenu.add(closeMenuItem);
            menu.add(fileMenu);
          addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        }
        );
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        }
        );
        
        toolBar.setLayout(new java.awt.FlowLayout(0, 5, 0));
        toolBar.setPreferredSize(new java.awt.Dimension(600, 25));
        toolBar.setFloatable(false);
        
        getContentPane().add(toolBar, java.awt.BorderLayout.SOUTH);
        
        
        mainTab.setPreferredSize(new java.awt.Dimension(600, 400));
        mainTab.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                mainTabStateChanged(evt);
            }
        }
        );
        
        resourcesPanel.setLayout(new java.awt.BorderLayout());
          
          
            teachersPanel.setLayout(new java.awt.BorderLayout());
              
              teachersPanel.add(teachersScrollPane, java.awt.BorderLayout.CENTER);
                
                
              teachersCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                
                addTeacherButton.setText(Loc.get("timetable.school.button.add")
                  );
                  addTeacherButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          addTeacherButtonActionPerformed(evt);
                      }
                  }
                  );
                  teachersCommandPanel.add(addTeacherButton);
                  
                  
                editTeacherButton.setText(Loc.get("timetable.school.button.edit"));
                  editTeacherButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          editTeacherButtonActionPerformed(evt);
                      }
                  }
                  );
                  teachersCommandPanel.add(editTeacherButton);
                  
                  
                removeTeacherButton.setText(Loc.get("timetable.school.button.remove"));
                  removeTeacherButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          removeTeacherButtonActionPerformed(evt);
                      }
                  }
                  );
                  teachersCommandPanel.add(removeTeacherButton);
                  
                  teachersPanel.add(teachersCommandPanel, java.awt.BorderLayout.SOUTH);
                
                resourcesTab.addTab("Vyuujc", teachersPanel);
              
              
            classesPanel.setLayout(new java.awt.BorderLayout());
              
              
                singleClassesPanel.setLayout(new java.awt.BorderLayout());
                  
                  classesCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                    
                    addClassButton.setText(Loc.get("timetable.school.button.add"));
                      addClassButton.addActionListener(new java.awt.event.ActionListener() {
                          public void actionPerformed(java.awt.event.ActionEvent evt) {
                              addClassButtonActionPerformed(evt);
                          }
                      }
                      );
                      classesCommandPanel.add(addClassButton);
                      
                      
                    editClassButton.setText(Loc.get("timetable.school.button.edit"));
                      editClassButton.addActionListener(new java.awt.event.ActionListener() {
                          public void actionPerformed(java.awt.event.ActionEvent evt) {
                              editClassButtonActionPerformed(evt);
                          }
                      }
                      );
                      classesCommandPanel.add(editClassButton);
                      
                      
                    removeClassButton.setText(Loc.get("timetable.school.button.remove"));
                      removeClassButton.addActionListener(new java.awt.event.ActionListener() {
                          public void actionPerformed(java.awt.event.ActionEvent evt) {
                              removeClassButtonActionPerformed(evt);
                          }
                      }
                      );
                      classesCommandPanel.add(removeClassButton);
                      
                      singleClassesPanel.add(classesCommandPanel, java.awt.BorderLayout.SOUTH);
                    
                    
                  singleClassesPanel.add(classesScrollPane, java.awt.BorderLayout.CENTER);
                    
                    classesTab.addTab("Jednotliv tdy, podtdy", singleClassesPanel);
                  
                  
                groupedClassesPanel.setLayout(new java.awt.BorderLayout());
                  
                  groupedClassesCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                    
                    addClassGroupButton.setText(Loc.get("timetable.school.button.add"));
                      addClassGroupButton.addActionListener(new java.awt.event.ActionListener() {
                          public void actionPerformed(java.awt.event.ActionEvent evt) {
                              addClassGroupButtonActionPerformed(evt);
                          }
                      }
                      );
                      groupedClassesCommandPanel.add(addClassGroupButton);
                      
                      
                    editClassGroupButton.setText(Loc.get("timetable.school.button.edit"));
                      editClassGroupButton.addActionListener(new java.awt.event.ActionListener() {
                          public void actionPerformed(java.awt.event.ActionEvent evt) {
                              editClassGroupButtonActionPerformed(evt);
                          }
                      }
                      );
                      groupedClassesCommandPanel.add(editClassGroupButton);
                      
                      
                    removeClassGroupButton.setText(Loc.get("timetable.school.button.remove"));
                      removeClassGroupButton.addActionListener(new java.awt.event.ActionListener() {
                          public void actionPerformed(java.awt.event.ActionEvent evt) {
                              removeClassGroupButtonActionPerformed(evt);
                          }
                      }
                      );
                      groupedClassesCommandPanel.add(removeClassGroupButton);
                      
                      groupedClassesPanel.add(groupedClassesCommandPanel, java.awt.BorderLayout.SOUTH);
                    
                    
                  groupedClassesPanel.add(groupedClassesScrollPane, java.awt.BorderLayout.CENTER);
                    
                    classesTab.addTab("Skupiny td", groupedClassesPanel);
                  
                  classesPanel.add(classesTab, java.awt.BorderLayout.CENTER);
                
                resourcesTab.addTab("Tdy", classesPanel);
              
              
            roomsPanel.setLayout(new java.awt.BorderLayout());
              
              roomsPanel.add(roomsScrollPane, java.awt.BorderLayout.CENTER);
                
                
              roomsCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                
                addRoomButton.setText(Loc.get("timetable.school.button.add"));
                  addRoomButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          addRoomButtonActionPerformed(evt);
                      }
                  }
                  );
                  roomsCommandPanel.add(addRoomButton);
                  
                  
                editRoomButton.setText(Loc.get("timetable.school.button.edit"));
                  editRoomButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          editRoomButtonActionPerformed(evt);
                      }
                  }
                  );
                  roomsCommandPanel.add(editRoomButton);
                  
                  
                removeRoomButton.setText(Loc.get("timetable.school.button.remove"));
                  removeRoomButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          removeRoomButtonActionPerformed(evt);
                      }
                  }
                  );
                  roomsCommandPanel.add(removeRoomButton);
                  
                  roomsPanel.add(roomsCommandPanel, java.awt.BorderLayout.SOUTH);
                
                resourcesTab.addTab("Uebny", roomsPanel);
              
              
            specResPanel.setLayout(new java.awt.BorderLayout());
              
              specResPanel.add(specResScrollPane, java.awt.BorderLayout.CENTER);
                
                
              specResCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                
                addSpecResButton.setText(Loc.get("timetable.school.button.add"));
                  addSpecResButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          addSpecResButtonActionPerformed(evt);
                      }
                  }
                  );
                  specResCommandPanel.add(addSpecResButton);
                  
                  
                editSpecResButton.setText(Loc.get("timetable.school.button.edit"));
                  editSpecResButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          editSpecResButtonActionPerformed(evt);
                      }
                  }
                  );
                  specResCommandPanel.add(editSpecResButton);
                  
                  
                removeSpecResButton.setText(Loc.get("timetable.school.button.remove"));
                  removeSpecResButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          removeSpecResButtonActionPerformed(evt);
                      }
                  }
                  );
                  specResCommandPanel.add(removeSpecResButton);
                  
                  specResPanel.add(specResCommandPanel, java.awt.BorderLayout.SOUTH);
                
                resourcesTab.addTab("Ostatn", specResPanel);
              
              resourcesPanel.add(resourcesTab, java.awt.BorderLayout.CENTER);
            
            mainTab.addTab("Zdroje", resourcesPanel);
          
          
        activitiesAndDependancesPanel.setLayout(new java.awt.BorderLayout());
          
          
            activitiesPanel.setLayout(new java.awt.BorderLayout());
              
              activitiesPanel.add(activitiesScrollPane, java.awt.BorderLayout.CENTER);
                
                
              activitiesCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                
                addActivityButtom.setText(Loc.get("timetable.school.button.add"));
                  addActivityButtom.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          addActivityButtomActionPerformed(evt);
                      }
                  }
                  );
                  activitiesCommandPanel.add(addActivityButtom);
                  
                  
                editActivityButton.setText(Loc.get("timetable.school.button.edit"));
                  editActivityButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          editActivityButtonActionPerformed(evt);
                      }
                  }
                  );
                  activitiesCommandPanel.add(editActivityButton);
                  
                  
                removeActivityButton.setText(Loc.get("timetable.school.button.remove"));
                  removeActivityButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          removeActivityButtonActionPerformed(evt);
                      }
                  }
                  );
                  activitiesCommandPanel.add(removeActivityButton);
                  
                  activitiesPanel.add(activitiesCommandPanel, java.awt.BorderLayout.SOUTH);
                
                activitiesTab.addTab("Pedmty", activitiesPanel);
              
              
            dependencesPanel.setLayout(new java.awt.BorderLayout());
              
              dependencesPanel.add(dependencesScrollPane, java.awt.BorderLayout.CENTER);
                
                
              dependencesCommandPanel.setLayout(new java.awt.FlowLayout(2, 5, 5));
                
                addDependenceButton.setText(Loc.get("timetable.school.button.add"));
                  addDependenceButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          addDependenceButtonActionPerformed(evt);
                      }
                  }
                  );
                  dependencesCommandPanel.add(addDependenceButton);
                  
                  
                editDependenceButton.setText(Loc.get("timetable.school.button.edit"));
                  editDependenceButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          editDependenceButtonActionPerformed(evt);
                      }
                  }
                  );
                  dependencesCommandPanel.add(editDependenceButton);
                  
                  
                removeDependenceButton.setText(Loc.get("timetable.school.button.remove"));
                  removeDependenceButton.addActionListener(new java.awt.event.ActionListener() {
                      public void actionPerformed(java.awt.event.ActionEvent evt) {
                          removeDependenceButtonActionPerformed(evt);
                      }
                  }
                  );
                  dependencesCommandPanel.add(removeDependenceButton);
                  
                  dependencesPanel.add(dependencesCommandPanel, java.awt.BorderLayout.SOUTH);
                
                activitiesTab.addTab("Zvislosti mezi pedmty", dependencesPanel);
              
              activitiesAndDependancesPanel.add(activitiesTab, java.awt.BorderLayout.CENTER);
            
            mainTab.addTab("Vyuovan pedmty", activitiesAndDependancesPanel);
          
          
        timetablePanel.setLayout(new java.awt.BorderLayout());
          
          
            fullTimetablePabel.setLayout(new java.awt.BorderLayout());
              
              fullTimetableCommandPanel.setLayout(new java.awt.FlowLayout(0, 5, 5));
                
                jLabel1.setText(Loc.get("timetable.school.label.selectres"));
                  fullTimetableCommandPanel.add(jLabel1);
                  
                  
                fullTimetableCommandPanel.add(resourceCombo);
                  
                  fullTimetablePabel.add(fullTimetableCommandPanel, java.awt.BorderLayout.NORTH);
                
                
              fullTimetableSplitPane.setDividerLocation(200);
                fullTimetableSplitPane.setResizeWeight(0.5);
                fullTimetableSplitPane.setOrientation(javax.swing.SwingConstants.HORIZONTAL);
                fullTimetableSplitPane.setOneTouchExpandable(true);
                
                fullTimetableSplitPane.setTopComponent(fullScheduleScrollPane);
                  
                  
                notScheduledActivitiesPanel.setLayout(new java.awt.BorderLayout());
                  
                  jLabel2.setText(Loc.get("timetable.school.label.unschedactivities"));
                    notScheduledActivitiesPanel.add(jLabel2, java.awt.BorderLayout.NORTH);
                    
                    
                  notScheduledActivitiesScrollPane.setPreferredSize(new java.awt.Dimension(200, 150));
                    notScheduledActivitiesPanel.add(notScheduledActivitiesScrollPane, java.awt.BorderLayout.CENTER);
                    
                    fullTimetableSplitPane.setBottomComponent(notScheduledActivitiesPanel);
                  
                  fullTimetablePabel.add(fullTimetableSplitPane, java.awt.BorderLayout.CENTER);
                
                timetableTab.addTab("Cel rozvrh", fullTimetablePabel);
              
              
            resourceTimetablePanel.setLayout(new java.awt.BorderLayout());
              
              oneResourceSplitPane.setDividerLocation(100);
                oneResourceSplitPane.setOrientation(javax.swing.SwingConstants.HORIZONTAL);
                
                oneResourceSplitPane.setBottomComponent(oneResourceScheduleScrollPane);
                  
                  
                resourceVsUnschedActivitiesSplitPane.setDividerLocation(0);
                  resourceVsUnschedActivitiesSplitPane.setLastDividerLocation(0);
                  resourceVsUnschedActivitiesSplitPane.setOneTouchExpandable(true);
                  
                  notScheduledActivitiesScrollPane2.setLayout(new java.awt.BorderLayout());
                    
                    jLabel4.setText(Loc.get("timetable.school.label.unschedactivities"));
                      notScheduledActivitiesScrollPane2.add(jLabel4, java.awt.BorderLayout.NORTH);
                      
                      
                    oneResNotScheduledActivitiesScrollPane.setPreferredSize(new java.awt.Dimension(200, 150));
                      notScheduledActivitiesScrollPane2.add(oneResNotScheduledActivitiesScrollPane, java.awt.BorderLayout.CENTER);
                      
                      resourceVsUnschedActivitiesSplitPane.setLeftComponent(notScheduledActivitiesScrollPane2);
                    
                    
                  resourceTimetableCommandPanel.setLayout(new java.awt.BorderLayout());
                    
                    jLabel3.setText(Loc.get("timetable.school.label.resource"));
                      resourceTimetableCommandPanel.add(jLabel3, java.awt.BorderLayout.NORTH);
                      
                      
                    allResourcesScrollPane.setPreferredSize(new java.awt.Dimension(200, 150));
                      resourceTimetableCommandPanel.add(allResourcesScrollPane, java.awt.BorderLayout.CENTER);
                      
                      resourceVsUnschedActivitiesSplitPane.setRightComponent(resourceTimetableCommandPanel);
                    
                    oneResourceSplitPane.setTopComponent(resourceVsUnschedActivitiesSplitPane);
                  
                  resourceTimetablePanel.add(oneResourceSplitPane, java.awt.BorderLayout.CENTER);
                
                timetableTab.addTab("Rozvrh jednotlivch zdroj", resourceTimetablePanel);
              
              
            rightsPanel.setLayout(new java.awt.BorderLayout());
              
              
                basicRightsScrollPane.setAlignmentX(0.0F);
                  rightsTab.addTab("Obecn", basicRightsScrollPane);
                  
                  
                specRightsScrollPane.setAlignmentX(0.0F);
                  rightsTab.addTab("Specifick", specRightsScrollPane);
                  
                  rightsPanel.add(rightsTab, java.awt.BorderLayout.CENTER);
                
                timetableTab.addTab("Pravidla", rightsPanel);
              
              timetablePanel.add(timetableTab, java.awt.BorderLayout.CENTER);
            
            mainTab.addTab("Rozvrh", timetablePanel);
          
          
        getContentPane().add(mainTab, java.awt.BorderLayout.CENTER);
        
        setJMenuBar(menu);
        
    }//GEN-END:initComponents

  private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
//  System.out.println("Size = "+this.getSize().width+" x "+this.getSize().height);
  }//GEN-LAST:event_formComponentResized

  private void resetMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetMenuItemActionPerformed
      try {
          problem.reset();
          updateScheduleTables();
          clearStatus();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_resetMenuItemActionPerformed

  private void removeSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeSpecResButtonActionPerformed
      try {
          Resource r = problem.getAllSpecRes().get(specResTable.getSelectedRow());
          if (problem.activities.containsResource(r)>=0) {
              new MessageDlg(this,Loc.get("timetable.school.message.resource.cannotremove"),Loc.get("timetable.school.message.resource.cannotremove.used",problem.activities.get(problem.activities.containsResource(r)).name),MessageDlg.OK).show();
              return;
          }
          if (r!=null) {
            MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.message.question.resource.remove",r.name),MessageDlg.YESNO);
            md.show();
            if (md.getReturnStatus()==MessageDlg.YES) {
                problem.getAllSpecRes().remove(r);
                specResTable.updateUI();
            }
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeSpecResButtonActionPerformed

  private void editSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editSpecResButtonActionPerformed
     try {
         new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.updateresource"),config,problem.getAllSpecRes().get(specResTable.getSelectedRow())).show();
         specResTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editSpecResButtonActionPerformed

  private void addSpecResButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addSpecResButtonActionPerformed
      try {
          Resource resource = new Resource(config);
          EditResourceDlg dialog = new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.newresource"),config,resource);
          dialog.show();
          if (dialog.getReturnStatus()) {
              problem.getAllSpecRes().add(resource);
          };
          specResTable.updateUI();
          specResTable.gotoLast();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addSpecResButtonActionPerformed

  private void cancelRightsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelRightsButtonActionPerformed
     solverRightsPanel.loadData();
     schoolRightsPanel.loadData();
  }//GEN-LAST:event_cancelRightsButtonActionPerformed

  private void setRightsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setRightsButtonActionPerformed
     solverRightsPanel.storeData();
     schoolRightsPanel.storeData();
  }//GEN-LAST:event_setRightsButtonActionPerformed

  private void updateScheduleTables() throws TimetableException {
             oneResNotScheduledActivityTableModel.forceActivitiesChanged();
             oneResNotScheduledActivitiesTable.updateUI();
             notScheduledActivityTableModel.forceActivitiesChanged();
             allResourcesScheduleTable.updateUI();
             notScheduledActivitiesTable.updateUI();
             oneResourceSchedulePanel.setResource(allResourcesTableModel.getResource(allResourcesTable.getSelectedRow()));
             oneResourceSchedulePanel.updateUI();
             allResourcesTable.updateUI();
  }
  
  private void mainTabStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_mainTabStateChanged
     try {
         if (mainTab.getModel().getSelectedIndex()==2) {
             problem.checkConsistency();
             updateScheduleTables();
         }
             
     } catch (Exception e) {
         dispError(e);
     }
  }//GEN-LAST:event_mainTabStateChanged

    public void setStatus(String status) {
        statusLabel.setText(Loc.get("timetable.school.text.state")+" "+status);
        toolBar.repaint();
    }
    
    public void clearStatus() {
        setStatus("");
    }
    
  private void removeDependenceButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeDependenceButtonActionPerformed
      try {
          ActivityDependenceInterface d = problem.dependences.get(dependencesTable.getSelectedRow());
          if (d!=null && question(Loc.get("timetable.school.message.question.dependence.remove",new String[] {d.getFirstActivity().name,d.getSecondActivity().name}))) {
              problem.dependences.remove(d);
              dependencesTable.updateUI();
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeDependenceButtonActionPerformed

  private void editDependenceButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editDependenceButtonActionPerformed
     try {
         new EditDependenceDlg(this,Loc.get("timetable.school.dependencedlg.title.updatedependence"),config,problem.dependences.get(dependencesTable.getSelectedRow()),problem).show();
         dependencesTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editDependenceButtonActionPerformed

  private void addDependenceButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addDependenceButtonActionPerformed
      try {
          ActivityDependenceInterface dependence = new TimeActivityDependence(null,0,null);
          EditDependenceDlg dialog = new EditDependenceDlg(this,Loc.get("timetable.school.dependencedlg.title.newdependence"),config,dependence,problem);
          dialog.show();
          if (dialog.getReturnStatus()) {
              problem.dependences.add(dependence);
          };
          dependencesTable.updateUI();
          dependencesTable.gotoLast();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addDependenceButtonActionPerformed

  private void removeClassGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeClassGroupButtonActionPerformed
      try {
          ResourceGroup r = problem.groupedClasses.getResources(groupedClassesTable.getSelectedRow());
          if (problem.activities.containsResources(r)>=0) {
              new MessageDlg(this,Loc.get("timetable.school.message.resource.cannotremove"),Loc.get("timetable.school.message.resourcegroupisused",problem.activities.get(problem.activities.containsResources(r)).name),MessageDlg.OK).show();
              return;
          }
          if (r!=null && question(Loc.get("timetable.school.message.resourcegroup.remove",r.name))) {
              problem.groupedClasses.remove(r);
              groupedClassesTable.updateUI();
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeClassGroupButtonActionPerformed

  private void editClassGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editClassGroupButtonActionPerformed
     try {
         new EditResourceGroupDlg(this,Loc.get("timetable.school.editresourcegroupdlg.title.updateclassgroup"),config,problem.groupedClasses.getResources(groupedClassesTable.getSelectedRow()),problem.getAllClasses()).show();
         groupedClassesTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editClassGroupButtonActionPerformed

  private void addClassGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addClassGroupButtonActionPerformed
      try {
          ResourceGroup resources = new ResourceGroup();
          EditResourceGroupDlg dialog = new EditResourceGroupDlg(this,Loc.get("timetable.school.editresourcegroupdlg.title.newclassgroup"),config,resources,problem.getAllClasses());
          dialog.show();
          if (dialog.getReturnStatus()) {
              resources.conjunctive=true;
              problem.groupedClasses.add(resources);
          };
          groupedClassesTable.updateUI();
          groupedClassesTable.gotoLast();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addClassGroupButtonActionPerformed

    public boolean question(String msg) {    
         MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),msg,MessageDlg.YESNO);
         md.show();
         return (md.getReturnStatus()==MessageDlg.YES);
    }
    
  private void removeActivityButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeActivityButtonActionPerformed
      try {
          Activity a = problem.activities.get(activitiesTable.getSelectedRow());
          if (problem.dependences.countDependences(a)>0) {
              new MessageDlg(this,Loc.get("timetable.school.message.activity.cannotremove"),Loc.get("timetable.school.message.activity.cannotremove.dependence"),MessageDlg.OK).show();
              return;
          };
          if (a!=null && question(Loc.get("timetable.school.message.question.deleteactivity",a.name))) {
              problem.activities.remove(a);
              activitiesTable.updateUI();
              oneResNotScheduledActivityTableModel.forceActivitiesChanged();
              oneResNotScheduledActivitiesTable.updateUI();
              notScheduledActivityTableModel.forceActivitiesChanged();
              notScheduledActivitiesTable.updateUI();
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeActivityButtonActionPerformed

  private void editActivityButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editActivityButtonActionPerformed
     try {
         new EditActivityDlg(this,Loc.get("timetable.school.editactivitydlg.title.updatelecture"),config,problem.activities.get(activitiesTable.getSelectedRow()),problem).show();
         activitiesTable.updateUI();
          oneResNotScheduledActivityTableModel.forceActivitiesChanged();
          oneResNotScheduledActivitiesTable.updateUI();
          notScheduledActivityTableModel.forceActivitiesChanged();
          notScheduledActivitiesTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editActivityButtonActionPerformed

  private void addActivityButtomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addActivityButtomActionPerformed
      try {
          Activity activity = new Activity(config);
          EditActivityDlg dialog = new EditActivityDlg(this,Loc.get("timetable.school.editactivitydlg.title.newlecture"),config,activity,problem);
          dialog.show();
          if (dialog.getReturnStatus()) {
              problem.activities.add(activity);
          };
          activitiesTable.updateUI();
          activitiesTable.gotoLast();
          oneResNotScheduledActivityTableModel.forceActivitiesChanged();
          oneResNotScheduledActivitiesTable.updateUI();
          notScheduledActivityTableModel.forceActivitiesChanged();
          notScheduledActivitiesTable.updateUI();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addActivityButtomActionPerformed

  private void removeRoomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeRoomButtonActionPerformed
      try {
          Resource r = problem.getAllRooms().get(roomsTable.getSelectedRow());
          if (problem.activities.containsResource(r)>=0) {
              new MessageDlg(this,Loc.get("timetable.school.message.resource.cannotremove"),Loc.get("timetable.school.message.room.cannotremove.used",
                    problem.activities.get(problem.activities.containsResource(r)).name),MessageDlg.OK).show();
              return;
          }
          if (r!=null) {
            MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.message.room.remove",r.name),MessageDlg.YESNO);
            md.show();
            if (md.getReturnStatus()==MessageDlg.YES) {
                problem.getAllRooms().remove(r);
                roomsTable.updateUI();
            }
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeRoomButtonActionPerformed

  private void removeClassButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeClassButtonActionPerformed
      try {
          Resource r = problem.getAllClasses().get(classesTable.getSelectedRow());
          if (problem.groupedClasses.contains(r)>=0) {
              new MessageDlg(this,Loc.get("timetable.school.message.resource.cannotremove"),Loc.get("timetable.school.message.class.cannotremove.ingroup",problem.groupedClasses.getResources(problem.groupedClasses.contains(r)).name),MessageDlg.OK).show();
              return;
          }
          if (problem.activities.containsResource(r)>=0) {
              new MessageDlg(this,Loc.get("timetable.school.message.resource.cannotremove"),Loc.get("timetable.school.message.class.cannotremove.activity",problem.activities.get(problem.activities.containsResource(r)).name),MessageDlg.OK).show();
              return;
          }
          if (r!=null) {
            MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.message.question.deleteclass",r.name),MessageDlg.YESNO);
            md.show();
            if (md.getReturnStatus()==MessageDlg.YES) {
                problem.getAllClasses().remove(r);
                classesTable.updateUI();
            }
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeClassButtonActionPerformed

  private void editRoomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editRoomButtonActionPerformed
     try {
         new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.updateroom"),config,problem.getAllRooms().get(roomsTable.getSelectedRow())).show();
         roomsTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editRoomButtonActionPerformed

  private void editClassButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editClassButtonActionPerformed
     try {
         new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.updateclass"),config,problem.getAllClasses().get(classesTable.getSelectedRow())).show();
         classesTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editClassButtonActionPerformed

  private void addRoomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addRoomButtonActionPerformed
      try {
          Resource resource = new Resource(config);
          EditResourceDlg dialog = new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.newroom"),config,resource);
          dialog.show();
          if (dialog.getReturnStatus()) {
              problem.getAllRooms().add(resource);
          };
          roomsTable.updateUI();
          roomsTable.gotoLast();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addRoomButtonActionPerformed

  private void addClassButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addClassButtonActionPerformed
      try {
          Resource resource = new Resource(config);
          EditResourceDlg dialog = new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.newclass"),config,resource);
          dialog.show();
          if (dialog.getReturnStatus()) {
              problem.getAllClasses().add(resource);
          };
          classesTable.updateUI();
          classesTable.gotoLast();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addClassButtonActionPerformed

  private void editTeacherButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editTeacherButtonActionPerformed
     try {
         new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.updateteacher"),config,problem.getAllTeachers().get(teachersTable.getSelectedRow())).show();
         teachersTable.updateUI();
     } catch (Exception e) { dispError(e); };
  }//GEN-LAST:event_editTeacherButtonActionPerformed

  private void removeTeacherButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeTeacherButtonActionPerformed
      try {
          Resource r = problem.getAllTeachers().get(teachersTable.getSelectedRow());
          if (problem.activities.containsResource(r)>=0) {
              new MessageDlg(this,Loc.get("timetable.school.message.resource.cannotremove"),Loc.get("timetable.school.message.teacher.cannotremove.activity",
                    problem.activities.get(problem.activities.containsResource(r)).name)
                    ,MessageDlg.OK).show();
              return;
          }
          if (r!=null) {
            MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.message.question.deleteteacher",r.name),MessageDlg.YESNO);
            md.show();
            if (md.getReturnStatus()==MessageDlg.YES) {
                problem.getAllTeachers().remove(r);
                teachersTable.updateUI();
            }
          }
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_removeTeacherButtonActionPerformed

  private void addTeacherButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addTeacherButtonActionPerformed
      try {
          Resource resource = new Resource(config);
          EditResourceDlg dialog = new EditResourceDlg(this,Loc.get("timetable.school.editresourcedlg.title.newteacher"),config,resource);
          dialog.show();
          if (dialog.getReturnStatus()) {
              problem.getAllTeachers().add(resource);
          };
          teachersTable.updateUI();
          teachersTable.gotoLast();
          repaint();
      } catch (Exception e) {
          dispError(e);
      }
  }//GEN-LAST:event_addTeacherButtonActionPerformed

  private void saveAsTimetableMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveAsTimetableMenuItemActionPerformed
    save(true);
  }//GEN-LAST:event_saveAsTimetableMenuItemActionPerformed

  public void save(boolean saveAs) {
      try {
          String newFileName=fileName;
          if (fileName==null || saveAs) {              
              JFileChooser fc = new JFileChooser(".");
              fc.addChoosableFileFilter(new TimetableFilter(".shld .shd .tt .st",Loc.get("timetable.school.title")));
              fc.setDialogTitle(Loc.get("timetable.school.saveasdlg.title"));
              fc.showSaveDialog(this);
              if (fc.getSelectedFile()!=null) newFileName=fc.getSelectedFile().toString(); else return;
              if (fc.getSelectedFile().getName().indexOf('.')==-1) newFileName=newFileName+".shd";
          };
          problem.save(newFileName);
          this.setTitle(Loc.get("timetable.school.title")+"   ["+newFileName+"]");
          fileName=newFileName;
      } catch (Exception e) {
          System.err.println("Error: "+e);
          dispError(e);
      }
  }
  
  public void updateModels() {
           teachersTable.setModel(new ResourceTableModel(problem.getAllTeachers()));
          roomsTable.setModel(new ResourceTableModel(problem.getAllRooms()));
          specResTable.setModel(new ResourceTableModel(problem.getAllSpecRes()));
          classesTable.setModel(new ResourceTableModel(problem.getAllClasses()));
          activitiesTable.setModel(new ActivityTableModel(problem.activities));
          groupedClassesTable.setModel(new GroupedClassTableModel(problem.groupedClasses));
          dependencesTable.setModel(new DependenceTableModel(problem.dependences));
          oneResNotScheduledActivityTableModel = new NotScheduledActivityTableModel(problem);
          oneResNotScheduledActivitiesTable.setModel(oneResNotScheduledActivityTableModel);
          notScheduledActivityTableModel = new NotScheduledActivityTableModel(problem);
          notScheduledActivitiesTable.setModel(notScheduledActivityTableModel);
          allResourcesTableModel = new AllResourcesTableModel(problem.resources);
          allResourcesTable.setModel(allResourcesTableModel);
          allResourcesScheduleModel.setResources(problem.resources[resourceCombo.getSelectedIndex()]);
 }
  
  public void load(boolean selectFile) {
      try {
          String newFileName=fileName;
          if (selectFile) {
              JFileChooser fc = new JFileChooser(".");
              fc.setDialogTitle(Loc.get("timetable.school.opendlg.title"));
              fc.addChoosableFileFilter(new TimetableFilter(".shld .shd .tt .st",Loc.get("timetable.school.title")));
              fc.showOpenDialog(this);
              if (fc.getSelectedFile()!=null) newFileName=fc.getSelectedFile().toString(); else return;
          }
          SchoolProblem newProblem = (SchoolProblem)SchoolProblem.load(newFileName);
          config = newProblem.config;
          solverRightsPanel.setConfig(config);
          schoolRightsPanel.setConfig(config);
          oneResourceSchedulePanel.setConfig(config);
          Solver s = new Solver(config,problem);
          s.setValueSelection(new timetable.solver.strategy.value.HumanValueSelection(config,
                              new timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation(config)));
          s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(config));
          engine = new DNDActivityEngine(problem,s);
          engine2 = new DNDActivityEngine(problem,s);
          oneResNotScheduledActivitiesTable.setDNDTableEngine(engine2);
          notScheduledActivitiesTable.setDNDTableEngine(engine);
          allResourcesScheduleModel = new TimeTableModel(config,problem.resources[resourceCombo.getSelectedIndex()]);
          allResourcesScheduleTable = new TimeTableTable(allResourcesScheduleModel,fullScheduleScrollPane,engine);
          allResourcesScheduleModel.addMenuSeparator();
          allResourcesScheduleModel.addMenuItem(removeActFromTableMenuItem);
          oneResourceSchedulePanel.setDNDEngine(engine2);           
            engine2.addDNDListener(new DNDListener() {
                public void drop(DNDEvent e) {
                    try {
                        updateScheduleTables();
                    } catch (Exception ex) { dispError(ex);}
                }
                public void drag(DNDEvent e) {}
            });
            engine.addDNDListener(new DNDListener() {
                public void drop(DNDEvent e) {
                    try {
                        updateScheduleTables();
                    } catch (Exception ex) { dispError(ex);}
                }
                public void drag(DNDEvent e) {}
            });
          this.setTitle(Loc.get("timetable.school.title")+"   ["+newFileName+"]");
          fileName=newFileName;
          problem.setProblem((Problem)newProblem);
          updateModels();
      } catch (Exception e) {
          dispError(e);
      }
  }
  
  
  public void save() { save(false);}
  
  private void saveTimetableMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveTimetableMenuItemActionPerformed
    save();
  }//GEN-LAST:event_saveTimetableMenuItemActionPerformed

  private void loadTimetableMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTimetableMenuItemActionPerformed
    load(true);
  }//GEN-LAST:event_loadTimetableMenuItemActionPerformed

  private void newTimetableMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newTimetableMenuItemActionPerformed
      try {
          problem.setProblem((Problem) new SchoolProblem(new Config()));
          config = problem.config;
          solverRightsPanel.setConfig(config);
          schoolRightsPanel.setConfig(config);
          oneResourceSchedulePanel.setConfig(config);
          Solver s = new Solver(config,problem);
          s.setValueSelection(new timetable.solver.strategy.value.HumanValueSelection(config,
                              new timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation(config)));
          s.setVariableSelection(new timetable.solver.strategy.variable.WorstFirstVariableSelection(config));
          engine = new DNDActivityEngine(problem,s);
          engine2 = new DNDActivityEngine(problem,s);
          oneResNotScheduledActivitiesTable.setDNDTableEngine(engine2);
          notScheduledActivitiesTable.setDNDTableEngine(engine);
          allResourcesScheduleModel = new TimeTableModel(config,problem.resources[resourceCombo.getSelectedIndex()]);
          allResourcesScheduleTable = new TimeTableTable(allResourcesScheduleModel,fullScheduleScrollPane,engine);
          allResourcesScheduleModel.addMenuSeparator();
          allResourcesScheduleModel.addMenuItem(removeActFromTableMenuItem);
          oneResourceSchedulePanel.setDNDEngine(engine2);           
            engine2.addDNDListener(new DNDListener() {
                public void drop(DNDEvent e) {
                    try {
                        updateScheduleTables();
                    } catch (Exception ex) { dispError(ex);}
                }
                public void drag(DNDEvent e) {}
            });
            engine.addDNDListener(new DNDListener() {
                public void drop(DNDEvent e) {
                    try {
                        updateScheduleTables();
                    } catch (Exception ex) { dispError(ex);}
                }
                public void drag(DNDEvent e) {}
            });
          this.setTitle(Loc.get("timetable.school.title")+"   ["+Loc.get("timetable.school.title.new")+"]");
          fileName=null;
          updateModels();
      } catch (Exception e) {
          dispError(e);
          System.exit(1);
      }
  }//GEN-LAST:event_newTimetableMenuItemActionPerformed

  private void closeMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeMenuItemActionPerformed
      if (problem.isChanged()) {
          MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.message.saveonexit"),MessageDlg.YESNO+MessageDlg.CANCEL);
          md.show();
          if (md.getReturnStatus()==MessageDlg.YES) save();
          if (md.getReturnStatus()==MessageDlg.CANCEL) return;
      }
      dispose();
      System.exit(0);
  }//GEN-LAST:event_closeMenuItemActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
      if (problem.isChanged()) {
          MessageDlg md = new MessageDlg(this,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.message.saveonexit"),MessageDlg.YESNO);
          md.show();
          if (md.getReturnStatus()==MessageDlg.YES) save();
      }
      dispose();
      System.exit (0);
    }//GEN-LAST:event_exitForm

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        if (args!=null && args.length>=1)
          new SchoolTimetable (args[0]).show ();
        else
          new SchoolTimetable ().show ();
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar menu;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenuItem newTimetableMenuItem;
    private javax.swing.JMenuItem loadTimetableMenuItem;
    private javax.swing.JMenuItem saveTimetableMenuItem;
    private javax.swing.JMenuItem saveAsTimetableMenuItem;
    private javax.swing.JSeparator separator1;
    private javax.swing.JMenuItem resetMenuItem;
    private javax.swing.JSeparator separator2;
    private javax.swing.JMenuItem closeMenuItem;
    private javax.swing.JToolBar toolBar;
    private javax.swing.JTabbedPane mainTab;
    private javax.swing.JPanel resourcesPanel;
    private javax.swing.JTabbedPane resourcesTab;
    private javax.swing.JPanel teachersPanel;
    private javax.swing.JScrollPane teachersScrollPane;
    private javax.swing.JPanel teachersCommandPanel;
    private javax.swing.JButton addTeacherButton;
    private javax.swing.JButton editTeacherButton;
    private javax.swing.JButton removeTeacherButton;
    private javax.swing.JPanel classesPanel;
    private javax.swing.JTabbedPane classesTab;
    private javax.swing.JPanel singleClassesPanel;
    private javax.swing.JPanel classesCommandPanel;
    private javax.swing.JButton addClassButton;
    private javax.swing.JButton editClassButton;
    private javax.swing.JButton removeClassButton;
    private javax.swing.JScrollPane classesScrollPane;
    private javax.swing.JPanel groupedClassesPanel;
    private javax.swing.JPanel groupedClassesCommandPanel;
    private javax.swing.JButton addClassGroupButton;
    private javax.swing.JButton editClassGroupButton;
    private javax.swing.JButton removeClassGroupButton;
    private javax.swing.JScrollPane groupedClassesScrollPane;
    private javax.swing.JPanel roomsPanel;
    private javax.swing.JScrollPane roomsScrollPane;
    private javax.swing.JPanel roomsCommandPanel;
    private javax.swing.JButton addRoomButton;
    private javax.swing.JButton editRoomButton;
    private javax.swing.JButton removeRoomButton;
    private javax.swing.JPanel specResPanel;
    private javax.swing.JScrollPane specResScrollPane;
    private javax.swing.JPanel specResCommandPanel;
    private javax.swing.JButton addSpecResButton;
    private javax.swing.JButton editSpecResButton;
    private javax.swing.JButton removeSpecResButton;
    private javax.swing.JPanel activitiesAndDependancesPanel;
    private javax.swing.JTabbedPane activitiesTab;
    private javax.swing.JPanel activitiesPanel;
    private javax.swing.JScrollPane activitiesScrollPane;
    private javax.swing.JPanel activitiesCommandPanel;
    private javax.swing.JButton addActivityButtom;
    private javax.swing.JButton editActivityButton;
    private javax.swing.JButton removeActivityButton;
    private javax.swing.JPanel dependencesPanel;
    private javax.swing.JScrollPane dependencesScrollPane;
    private javax.swing.JPanel dependencesCommandPanel;
    private javax.swing.JButton addDependenceButton;
    private javax.swing.JButton editDependenceButton;
    private javax.swing.JButton removeDependenceButton;
    private javax.swing.JPanel timetablePanel;
    private javax.swing.JTabbedPane timetableTab;
    private javax.swing.JPanel fullTimetablePabel;
    private javax.swing.JPanel fullTimetableCommandPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JComboBox resourceCombo;
    private javax.swing.JSplitPane fullTimetableSplitPane;
    private javax.swing.JScrollPane fullScheduleScrollPane;
    private javax.swing.JPanel notScheduledActivitiesPanel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane notScheduledActivitiesScrollPane;
    private javax.swing.JPanel resourceTimetablePanel;
    private javax.swing.JSplitPane oneResourceSplitPane;
    private javax.swing.JScrollPane oneResourceScheduleScrollPane;
    private javax.swing.JSplitPane resourceVsUnschedActivitiesSplitPane;
    private javax.swing.JPanel notScheduledActivitiesScrollPane2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JScrollPane oneResNotScheduledActivitiesScrollPane;
    private javax.swing.JPanel resourceTimetableCommandPanel;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane allResourcesScrollPane;
    private javax.swing.JPanel rightsPanel;
    private javax.swing.JTabbedPane rightsTab;
    private javax.swing.JScrollPane basicRightsScrollPane;
    private javax.swing.JScrollPane specRightsScrollPane;
    // End of variables declaration//GEN-END:variables

    private class SolverThread extends Thread {
        
        public void run() {
            try {
              if (solver!=null) {
                  solver.getProblem().clearCounts();
                  solver.solve();
              }
              solving=false;
              if (problem.unscheduledActivities().size()==0) {
                setStatus(Loc.get("timetable.school.state.done"));
              } else {
                setStatus(Loc.get("timetable.school.state.solving"));
                MessageDlg md = new MessageDlg(null,Loc.get("timetable.school.message.question.title"),Loc.get("timetable.school.question.returnToPrevSched"),MessageDlg.YESNO);
                md.show();
                if (md.getReturnStatus()==MessageDlg.YES) problem.restoreLastState();
                else problem.restoreBestState();
                new MessageTableDlg(Loc.get("timetable.school.solver.fail"),Loc.get("timetable.school.solver.fail"),MessageTableDlg.OK,new javax.swing.JTable(new ProblemActivityTableModel(problem))).show();
              }
              solveButton.setText(Loc.get("timetable.school.button.solve"));
/*              oneResNotScheduledActivityTableModel.forceActivitiesChanged();
              oneResNotScheduledActivitiesTable.updateUI();
              notScheduledActivityTableModel.forceActivitiesChanged();
              allResourcesScheduleTable.updateUI();
              notScheduledActivitiesTable.updateUI();*/
            } catch (Exception e) {
                dispError(e);
            };
       }
        
    }
    
    private class UpdateThread extends Thread {
        public void run() {
            try {
//                config.set("DEBUG",1);
                while (solverThread.isAlive()) {
 //                 System.out.println("STILL ALIVE");
                  oneResNotScheduledActivityTableModel.forceActivitiesChanged();
                  oneResNotScheduledActivitiesTable.updateUI();
                  notScheduledActivityTableModel.forceActivitiesChanged();
                  allResourcesScheduleTable.updateUI();
                  notScheduledActivitiesTable.updateUI();
                  sleep(1000);
                } ;
                updateScheduleTables();
                clearStatus();
            } catch (java.lang.InterruptedException e) {}
            catch (Exception e) {dispError(e);};
        }
    }    
    
    class TimetableFilter extends javax.swing.filechooser.FileFilter {
        private String ext;
        private String desc;
        
        public TimetableFilter(String ext, String desc) {
            this.ext = ext; this.desc = desc;
        }
        
        public String getDescription() {
            return desc;
        }
        
        public boolean accept(java.io.File file) {
            if (file==null) return false;
            if (file.isDirectory()) return true;
            String name = file.getName();
            int i = name.lastIndexOf('.');
            if (i<0) return false;
            return (ext.indexOf(name.substring(i).toLowerCase())!=-1);
        }
    }
}

