/*
 * Problem.java
 *
 * Created on 27. prosinec 2000, 12:11
 */

package timetable.school.data;

import timetable.data.*;
import timetable.util.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class SchoolProblem extends timetable.data.Problem  {
    public ActivityResources groupedClasses = new ActivityResources();
    public static final int RES_ROOMS    = 2;
    public static final int RES_TEACHERS = 1;
    public static final int RES_CLASSES  = 0;
    public static final int RES_SPEC     = 3;

    /** Creates new Problem */
    public SchoolProblem(Config config) throws TimetableException {
        super(config);
        resources = new ResourceGroup[] {new ResourceGroup(),new ResourceGroup(),new ResourceGroup(),new ResourceGroup()};
    }
    
    public void setProblem(Problem problem) {
        super.setProblem(problem);
        this.groupedClasses = ((SchoolProblem)problem).groupedClasses;
    }
    
    public SchoolProblem(Problem problem) throws TimetableException {
        super(problem);
    }
    
    public ResourceGroup getAllSpecRes() {
        return resources[RES_SPEC];
    }
    
    public ResourceGroup getAllRooms() {
        return resources[RES_ROOMS];
    }
    
    public ResourceGroup getAllTeachers() {
        return resources[RES_TEACHERS];
    }
    
    public ResourceGroup getAllClasses() {
        return resources[RES_CLASSES];
    }
            
    public void save(String file) throws Exception {
           java.io.ObjectOutputStream oos = new java.io.ObjectOutputStream(new java.io.FileOutputStream(file));
           try {
                oos.writeObject(new Problem(this));
                ResourceGroup allResources = new ResourceGroup();
                for (int i=0;i<resources.length;i++) 
                  for (int j=0;j<resources[i].size();j++)
                    allResources.add(resources[i].get(j));
                groupedClasses.write(oos,allResources);
            } finally { oos.flush(); oos.close(); };
    }
    
    public static Problem load(String file) throws Exception {
           java.io.ObjectInputStream ois = new java.io.ObjectInputStream(new java.io.FileInputStream(file));
           SchoolProblem p=null;
           try {
                p = new SchoolProblem((Problem)ois.readObject());
                if (ois.available()>0) {
                    ResourceGroup allResources = new ResourceGroup();
                    for (int i=0;i<p.resources.length;i++) 
                      for (int j=0;j<p.resources[i].size();j++)
                        allResources.add(p.resources[i].get(j));
                    p.groupedClasses = ActivityResources.read(ois,allResources);
                };
                for (int i=0;i<p.groupedClasses.size();i++) {
                    ResourceGroup g = p.groupedClasses.getResources(i);
                    for (int j=0;j<p.activities.size();j++){
                        for (int k=0;k<p.activities.get(j).resources.size();k++)
                            if (p.activities.get(j).resources.isGroup(k)) {
                                if (g.equals(p.activities.get(j).resources.getResources(k))) {
                                  p.activities.get(j).resources.setAt(k,g);
                                }
                            }
                        if (p.activities.get(j).selectedResources!=null) 
                            for (int k=0;k<p.activities.get(j).selectedResources.size();k++)
                                if (p.activities.get(j).selectedResources.isGroup(k)) {
                                    if (g.equals(p.activities.get(j).selectedResources.getResources(k))) {
                                      p.activities.get(j).selectedResources.setAt(k,g);
                                    }
                                }
                        }
                }
            } finally { ois.close(); };
            return (Problem)p;
    }
    

}
