/*
 * ResourceTableModel.java
 *
 * Created on 25. prosinec 2000, 12:34
 */

package timetable.school.gui;

import timetable.util.*;
import timetable.data.*;
import timetable.school.data.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class ActivityTableModel implements timetable.util.ExtendTableModel {
    protected javax.swing.event.EventListenerList listenerList = new javax.swing.event.EventListenerList();
    ActivityGroup activities = null;

    /** Creates new ResourceTableModel */
    public ActivityTableModel(ActivityGroup activities) {
        this.activities=activities;
    }
    
    public ActivityTableModel() {
        this(null);
    }
    
    public void setResources(ActivityGroup activities) {
        this.activities=activities;
    }

    public java.lang.Class getColumnClass(int column) {
        if (column==2) return Integer.class; else return String.class;
    }
    
    public int getColumnCount() {
        return 10;
    }
    
    public java.lang.String getColumnName(int column) {
        switch (column) {
            case 0 : return Loc.get("timetable.school.model.shortcut");//"Zkratka";
            case 1 : return Loc.get("timetable.school.model.name");//"Jmno";
            case 2 : return Loc.get("timetable.school.model.length");//"Dlka";
            case 3 : return Loc.get("timetable.school.model.teacher");//"Vyuujc";
            case 4 : return Loc.get("timetable.school.model.classes");//"Tdy";
            case 5 : return Loc.get("timetable.school.model.rooms");//"Uebny";
            case 6 : return Loc.get("timetable.school.model.otherres");//"Ostatn zdroje";
            case 7 : return Loc.get("timetable.school.model.preferred");//"Preferovno";
            case 8 : return Loc.get("timetable.school.model.forbiden");//"Zakzno";
            case 9 : return Loc.get("timetable.school.model.note");//"Poznmka";
        }
        return null;
    }
    
    public int getRowCount() {
        return activities.size();
    }
    
    public java.lang.Object getValueAt(int row,int column) {
        try {  
            switch (column) {
                case 0 : return activities.get(row).shortCut;
                case 1 : return activities.get(row).name;
                case 2 : return new Integer(activities.get(row).length);
                case 3 : if (activities.get(row).resources.isGroup(SchoolProblem.RES_TEACHERS)) {
                             ResourceGroup r = activities.get(row).resources.getResources(SchoolProblem.RES_TEACHERS);
                             return (r!=null?(r.shortCut!=null?r.shortCut:r.toString()):"");
                         } else { 
                             Resource r = activities.get(row).resources.getResource(SchoolProblem.RES_TEACHERS);
                             return (r!=null?r.shortCut:"");
                         }
                case 4 : if (activities.get(row).resources.isGroup(SchoolProblem.RES_CLASSES)) {
                             ResourceGroup r = activities.get(row).resources.getResources(SchoolProblem.RES_CLASSES);
                             return (r!=null?(r.shortCut!=null?r.shortCut:r.toString()):"");
                         } else { 
                             Resource r = activities.get(row).resources.getResource(SchoolProblem.RES_CLASSES);
                             return (r!=null?r.shortCut:"");
                         }
                case 5 : return activities.get(row).resources.getResources(SchoolProblem.RES_ROOMS).toString();
                case 6 : { Object o = activities.get(row).resources.getResources(SchoolProblem.RES_SPEC);
                           return (o==null?"":o.toString());}
                case 7 : return activities.get(row).getPreference().toString(TimePreference.FREE);
                case 8 : return activities.get(row).getPreference().toString(TimePreference.HARD);
                case 9 : return activities.get(row).note;
            };
        } catch (Exception e) {
            System.err.println("Error: "+e);e.printStackTrace();
        };
        return null;
    }
    
    public boolean isCellEditable(int row,int column) {
        switch (column) {
            case 0 : return true;
            case 1 : return true;
            case 2 : return true;
            case 3 : return false;
            case 4 : return false;
            case 5 : return false;
            case 6 : return false;
            case 7 : return false;
            case 8 : return false;
            case 9 : return true;
        }
        return false;
    }
        
    public void setValueAt(final java.lang.Object value,int row,int column) {
        switch (column) {
            case 0 : { activities.get(row).shortCut = (String) value; activities.changed=true;return; }
            case 1 : { activities.get(row).name=(String) value; activities.changed=true;return; }
            case 2 : { activities.get(row).length=((Integer)value).intValue(); activities.changed=true;return; }
            case 9 : { activities.get(row).note=(String) value; activities.changed=true;return; }
        };
    }

    public int getColumnWidth(int column) {
       switch (column) {
           case 0: return 50;
           case 1: return 100; 
           case 2: return 50;
           case 3: return 50;
           case 4: return 50;
           case 5: return 150;
           case 6: return 150;
           case 7: return 200;
           case 8: return 200;
           case 9: return 200;
       };
       return 0;
    }
        
   public void addTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.add(javax.swing.event.TableModelListener.class, l);
   }
   
   public void removeTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.remove(javax.swing.event.TableModelListener.class, l);
   }

    public java.util.EventListener[] getListeners(Class listenerType) { 
	return listenerList.getListeners(listenerType); 
    }

    public void fireTableDataChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this));
    }
    public void fireTableStructureChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, javax.swing.event.TableModelEvent.HEADER_ROW));
    }
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.INSERT));
    }
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.UPDATE));
    }
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.DELETE));
    }
    public void fireTableCellUpdated(int row, int column) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(javax.swing.event.TableModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==javax.swing.event.TableModelListener.class) {
		((javax.swing.event.TableModelListener)listeners[i+1]).tableChanged(e);
	    }
	}
    }

}
