/*
 * ResourceTable.java
 *
 * Created on 15. prosinec 2000, 10:56
 */

package timetable.school.gui;

import javax.swing.*;
import timetable.gui.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class DNDDataTable extends timetable.gui.DNDTable {
    timetable.util.ExtendTableModel dataModel=null;
    javax.swing.JScrollPane scrollPane=null;
    
    /** Creates new ResourceTable */
    public DNDDataTable(timetable.util.ExtendTableModel dataModel,javax.swing.JScrollPane scrollPane,DNDTableEngine DNDengine) {
        super(dataModel);
        this.dataModel = dataModel;
        this.scrollPane=scrollPane;
        this.setDNDTableEngine(DNDengine);
        
        scrollPane.setViewportView(this);
        
        javax.swing.table.TableColumn tableColumn;
        for (int c=0;c<dataModel.getColumnCount();c++) {
	    tableColumn = this.getColumnModel().getColumn(c); //getColumn(dataModel.getColumnName(c));
	    tableColumn.setPreferredWidth(dataModel.getColumnWidth(c));
        }
        setAutoResizeMode(this.AUTO_RESIZE_OFF);
    }
    
    public void setModel(timetable.util.ExtendTableModel dataModel) {
        setModel((javax.swing.table.TableModel)dataModel);
        this.dataModel=dataModel;
        javax.swing.table.TableColumn tableColumn;
        for (int c=0;c<dataModel.getColumnCount();c++) {
	    tableColumn = this.getColumnModel().getColumn(c); //getColumn(dataModel.getColumnName(c));
	    tableColumn.setPreferredWidth(dataModel.getColumnWidth(c));
        }
        setAutoResizeMode(this.AUTO_RESIZE_OFF);
        updateUI();
    }
    
     public void scrollUp() {
         if (dataModel!=null) {
             JScrollBar sb = scrollPane.getVerticalScrollBar();
             sb.setValue(0);
         } 
     }
     
     public void scrollDown() {
         if (dataModel!=null) {
             JScrollBar sb = scrollPane.getVerticalScrollBar();
             sb.setValue(sb.getMaximum());
         }
     }

     public void gotoFirst() {
          if (dataModel.getRowCount()<=0) return;
          setRowSelectionInterval(0,0);
          scrollUp();
     }
        
      public void gotoLast() {
          int row = dataModel.getRowCount()-1;
          if (row<0) return;
          setRowSelectionInterval(row,row);
          scrollDown();
      }
      

}
