/*
 * GrouopedClassTableModel.java
 *
 * Created on 27. prosinec 2000, 13:12
 */

package timetable.school.gui;

import timetable.util.*;
import timetable.data.*;
import timetable.school.data.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class DependenceTableModel implements timetable.util.ExtendTableModel {
    protected javax.swing.event.EventListenerList listenerList = new javax.swing.event.EventListenerList();
    protected ActivityDependenceGroup dependences;

    /** Creates new GrouopedClassTableModel */
    public DependenceTableModel(ActivityDependenceGroup dependences) {
        this.dependences = dependences;
    }
    
    public java.lang.Class getColumnClass(int column) {
        return String.class;
    }
    
    public int getColumnCount() {
        return 4;
    }
    
    public java.lang.String getColumnName(int column) {
        switch (column) {
            case 0 : return Loc.get("timetable.school.model.deptype");//"Typ zvislosti";
            case 1 : return Loc.get("timetable.school.model.firstact");//"1.pedmt";
            case 2 : return Loc.get("timetable.school.model.secondact");//"2.pedmt";
            case 3 : return Loc.get("timetable.school.model.param");//"Parametr";
        }
        return null;
    }
    
    public int getRowCount() {
        return dependences.size();
    }
    
    public java.lang.Object getValueAt(int row,int column) {
        try {  
            switch (column) {
                case 0 : return dependences.get(row).getDependenceName();
                case 1 : return dependences.get(row).getFirstActivity().name;
                case 2 : return dependences.get(row).getSecondActivity().name;
                case 3 : return dependences.get(row).getTypes()[dependences.get(row).getType()];
            };
        } catch (Exception e) {
            System.err.println("Error: "+e);e.printStackTrace();
        };
        return null;
    }
    
    public boolean isCellEditable(int row,int column) {
        return false;
    }
        
    public void setValueAt(final java.lang.Object value,int row,int column) {
    }

    public int getColumnWidth(int column) {
       switch (column) {
           case 0: return 100;
           case 1: return 100; 
           case 2: return 100;
           case 3: return 100;
       };
       return 0;
    }
        
   public void addTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.add(javax.swing.event.TableModelListener.class, l);
   }
   
   public void removeTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.remove(javax.swing.event.TableModelListener.class, l);
   }

    public java.util.EventListener[] getListeners(Class listenerType) { 
	return listenerList.getListeners(listenerType); 
    }

    public void fireTableDataChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this));
    }
    public void fireTableStructureChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, javax.swing.event.TableModelEvent.HEADER_ROW));
    }
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.INSERT));
    }
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.UPDATE));
    }
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.DELETE));
    }
    public void fireTableCellUpdated(int row, int column) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(javax.swing.event.TableModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==javax.swing.event.TableModelListener.class) {
		((javax.swing.event.TableModelListener)listeners[i+1]).tableChanged(e);
	    }
	}
    }
    

}
