/*
 * ResourceTableModel.java
 *
 * Created on 25. prosinec 2000, 12:34
 */

package timetable.school.gui;

import timetable.util.*;
import timetable.data.*;
import timetable.school.data.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class NotScheduledActivityTableModel implements timetable.util.ExtendTableModel, ActivityModelInterface {
    protected javax.swing.event.EventListenerList listenerList = new javax.swing.event.EventListenerList();
    Problem problem = null;
    ActivityGroup unscheduledActivities;

    /** Creates new ResourceTableModel */
    public NotScheduledActivityTableModel(SchoolProblem problem) {
        this.problem=problem;
        unscheduledActivities=problem.unscheduledActivities();
    }
    
    public void forceActivitiesChanged() {
        unscheduledActivities=problem.unscheduledActivities();
    }
    
    public java.lang.Class getColumnClass(int column) {
        if (column==2) return Integer.class; else return String.class;
    }
    
    public int getColumnCount() {
        return 9;
    }
    
    public java.lang.String getColumnName(int column) {
        switch (column) {
            case 0 : return Loc.get("timetable.school.model.shortcut");//"Zkratka";
            case 1 : return Loc.get("timetable.school.model.name");//"Jmno";
            case 2 : return Loc.get("timetable.school.model.length");//"Dlka";
            case 3 : return Loc.get("timetable.school.model.teacher");//"Vyuujc";
            case 4 : return Loc.get("timetable.school.model.classes");//"Tdy";
            case 5 : return Loc.get("timetable.school.model.rooms");//"Uebny";
            case 6 : return Loc.get("timetable.school.model.otherres");//"Ostatn zdroje";
            case 7 : return Loc.get("timetable.school.model.preferred");//"Preferovno";
            case 8 : return Loc.get("timetable.school.model.forbiden");//"Zakzno";
            case 9 : return Loc.get("timetable.school.model.note");//"Poznmka";
        }
        return null;
    }
    
    public int getRowCount() {
        return unscheduledActivities.size();
    }
    
    public java.lang.Object getValueAt(int row,int column) {
        try {  
            switch (column) {
                case 0 : return unscheduledActivities.get(row).shortCut;
                case 1 : return unscheduledActivities.get(row).name;
                case 2 : return new Integer(unscheduledActivities.get(row).length);
                case 3 : if (unscheduledActivities.get(row).resources.isGroup(SchoolProblem.RES_TEACHERS)) {
                             ResourceGroup r = unscheduledActivities.get(row).resources.getResources(SchoolProblem.RES_TEACHERS);
                             return (r!=null?(r.shortCut!=null?r.shortCut:r.toString()):"");
                         } else { 
                             Resource r = unscheduledActivities.get(row).resources.getResource(SchoolProblem.RES_TEACHERS);
                             return (r!=null?r.shortCut:"");
                         }
                case 4 : if (unscheduledActivities.get(row).resources.isGroup(SchoolProblem.RES_CLASSES)) {
                             ResourceGroup r = unscheduledActivities.get(row).resources.getResources(SchoolProblem.RES_CLASSES);
                             return (r!=null?(r.shortCut!=null?r.shortCut:r.toString()):"");
                         } else { 
                             Resource r = unscheduledActivities.get(row).resources.getResource(SchoolProblem.RES_CLASSES);
                             return (r!=null?r.shortCut:"");
                         }
                case 5 : return unscheduledActivities.get(row).resources.getResources(SchoolProblem.RES_ROOMS).toString();
                case 6 : { Object o = unscheduledActivities.get(row).resources.getResources(SchoolProblem.RES_SPEC);
                           return (o==null?"":o.toString());}
                case 7 : return unscheduledActivities.get(row).getPreference().toString(TimePreference.FREE);
                case 8 : return unscheduledActivities.get(row).getPreference().toString(TimePreference.HARD);
                case 9 : return unscheduledActivities.get(row).note;
            };
        } catch (Exception e) {
            System.err.println("Error: "+e);e.printStackTrace();
        };
        return null;
    }
    
    public boolean isCellEditable(int row,int column) {
        return false;
    }
        
    public void setValueAt(final java.lang.Object value,int row,int column) {
    }

    public int getColumnWidth(int column) {
       switch (column) {
           case 0: return 50;
           case 1: return 100; 
           case 2: return 50;
           case 3: return 50;
           case 4: return 50;
           case 5: return 150;
           case 6: return 150;
           case 7: return 200;
           case 8: return 200;
           case 9: return 200;
       };
       return 0;
    }
        
   public void addTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.add(javax.swing.event.TableModelListener.class, l);
   }
   
   public void removeTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.remove(javax.swing.event.TableModelListener.class, l);
   }

    public java.util.EventListener[] getListeners(Class listenerType) { 
	return listenerList.getListeners(listenerType); 
    }

    public void fireTableDataChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this));
    }
    public void fireTableStructureChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, javax.swing.event.TableModelEvent.HEADER_ROW));
    }
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.INSERT));
    }
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.UPDATE));
    }
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.DELETE));
    }
    public void fireTableCellUpdated(int row, int column) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(javax.swing.event.TableModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==javax.swing.event.TableModelListener.class) {
		((javax.swing.event.TableModelListener)listeners[i+1]).tableChanged(e);
	    }
	}
    }

    public timetable.data.ActivityGroup getActivities() {
        return unscheduledActivities;
    }
    
}
