/*
 * GrouopedClassTableModel.java
 *
 * Created on 27. prosinec 2000, 13:12
 */

package timetable.school.gui;

import timetable.util.*;
import timetable.data.*;
import timetable.solver.strategy.Top10;
import timetable.school.data.*;
import java.util.Vector;
/**
 *
 * @author  Administrator
 * @version 
 */
public class ProblemActivityTableModel implements timetable.util.ExtendTableModel {
    protected javax.swing.event.EventListenerList listenerList = new javax.swing.event.EventListenerList();
    protected Top10 top = new Top10(20);

    /** Creates new GrouopedClassTableModel */
    public ProblemActivityTableModel(Problem problem) {
        for (int i=0;i<problem.activities.size();i++) 
            top.addMax(problem.activities.get(i).nrRemoves,problem.activities.get(i));            
    }
    
    public java.lang.Class getColumnClass(int column) {
        return String.class;
    }
    
    public int getColumnCount() {
        return 3;
    }
    
    public java.lang.String getColumnName(int column) {
        switch (column) {
            case 0 : return Loc.get("timetable.school.model.shortcut");//"Zkratka";
            case 1 : return Loc.get("timetable.school.model.lecture");//"Pedmt";
            case 2 : return Loc.get("timetable.school.model.nrremoves");//"#vyhozen";
        }
        return null;
    }
    
    public int getRowCount() {
        return top.size();
    }
    
    public java.lang.Object getValueAt(int row,int column) {
        try {  
            switch (column) {
                case 0 : return ((Activity)top.get(row)).shortCut;
                case 1 : return ((Activity)top.get(row)).name;
                case 2 : return String.valueOf(top.top(row));
            };
        } catch (Exception e) {
            System.err.println("Error: "+e);e.printStackTrace();
        };
        return null;
    }
    
    public boolean isCellEditable(int row,int column) {
        return false;
    }
        
    public void setValueAt(final java.lang.Object value,int row,int column) {
    }

    public int getColumnWidth(int column) {
       switch (column) {
           case 0: return 40;
           case 1: return 100;
           case 2: return 30; 
       };
       return 0;
    }
        
   public void addTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.add(javax.swing.event.TableModelListener.class, l);
   }
   
   public void removeTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.remove(javax.swing.event.TableModelListener.class, l);
   }

    public java.util.EventListener[] getListeners(Class listenerType) { 
	return listenerList.getListeners(listenerType); 
    }

    public void fireTableDataChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this));
    }
    public void fireTableStructureChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, javax.swing.event.TableModelEvent.HEADER_ROW));
    }
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.INSERT));
    }
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.UPDATE));
    }
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.DELETE));
    }
    public void fireTableCellUpdated(int row, int column) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(javax.swing.event.TableModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==javax.swing.event.TableModelListener.class) {
		((javax.swing.event.TableModelListener)listeners[i+1]).tableChanged(e);
	    }
	}
    }
    

}
