/*
 * ResourceTableModel.java
 *
 * Created on 25. prosinec 2000, 12:34
 */

package timetable.school.gui;

import timetable.util.*;
import timetable.data.*;
/**
 *
 * @author  Administrator
 * @version 
 */
public class ResourceTableModel implements timetable.util.ExtendTableModel {
    protected javax.swing.event.EventListenerList listenerList = new javax.swing.event.EventListenerList();
    ResourceGroup resources = null;

    /** Creates new ResourceTableModel */
    public ResourceTableModel(ResourceGroup resources) {
        this.resources=resources;
    }
    
    public ResourceTableModel() {
        this(null);
    }
    
    public void setResources(ResourceGroup resources) {
        this.resources=resources;
    }

    public java.lang.Class getColumnClass(int column) {
        return String.class;
    }
    
    public int getColumnCount() {
        return 5;
    }
    
    public java.lang.String getColumnName(int column) {
        switch (column) {
            case 0 : return Loc.get("timetable.school.model.shortcut");//"Zkratka";
            case 1 : return Loc.get("timetable.school.model.name");//"Jmno";
            case 2 : return Loc.get("timetable.school.model.preferred");//"Preferovno";
            case 3 : return Loc.get("timetable.school.model.forbiden");//"Zakzno";
            case 4 : return Loc.get("timetable.school.model.note");//"Poznmka";
        }
        return null;
    }
    
    public int getRowCount() {
        return resources.size();
    }
    
    public java.lang.Object getValueAt(int row,int column) {
        try {  
            switch (column) {
                case 0 : return resources.get(row).shortCut;
                case 1 : return resources.get(row).name;
                case 2 : return resources.get(row).getPreference().toString(TimePreference.FREE);
                case 3 : return resources.get(row).getPreference().toString(TimePreference.HARD);
                case 4 : return resources.get(row).note;
            };
        } catch (Exception e) {
            System.err.println("Error: "+e);e.printStackTrace();
        };
        return null;
    }
    
    public boolean isCellEditable(int row,int column) {
        switch (column) {
            case 0 : return true;
            case 1 : return true;
            case 2 : return false;
            case 3 : return false;
            case 4 : return true;
        }
        return false;
    }
        
    public void setValueAt(final java.lang.Object value,int row,int column) {
        switch (column) {
            case 0 : { resources.get(row).shortCut = (String) value; resources.changed=true;return; }
            case 1 : { resources.get(row).name=(String) value; resources.changed=true;return; }
            case 3 : { resources.get(row).note=(String) value; resources.changed=true;return; }
        };
    }

    public int getColumnWidth(int column) {
       switch (column) {
           case 0: return 50;
           case 1: return 100; 
           case 2: return 200;
           case 3: return 200;
           case 4: return 200;
       };
       return 0;
    }
        
   public void addTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.add(javax.swing.event.TableModelListener.class, l);
   }
   
   public void removeTableModelListener(final javax.swing.event.TableModelListener l) {
       listenerList.remove(javax.swing.event.TableModelListener.class, l);
   }

    public java.util.EventListener[] getListeners(Class listenerType) { 
	return listenerList.getListeners(listenerType); 
    }

    public void fireTableDataChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this));
    }
    public void fireTableStructureChanged() {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, javax.swing.event.TableModelEvent.HEADER_ROW));
    }
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.INSERT));
    }
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.UPDATE));
    }
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, firstRow, lastRow,
                             javax.swing.event.TableModelEvent.ALL_COLUMNS, javax.swing.event.TableModelEvent.DELETE));
    }
    public void fireTableCellUpdated(int row, int column) {
        fireTableChanged(new javax.swing.event.TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(javax.swing.event.TableModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==javax.swing.event.TableModelListener.class) {
		((javax.swing.event.TableModelListener)listeners[i+1]).tableChanged(e);
	    }
	}
    }

}
