/*
 * SchoolRightsPanel.java
 *
 * Created on 25. bezen 2001, 12:19
 */

package timetable.school.gui;

/**
 *
 * @author  administrator
 * @version 
 */
import timetable.util.*;

public class SchoolRightsPanel extends javax.swing.JPanel {
    private Config config = null;

    /** Creates new form SchoolRightsPanel */
    public SchoolRightsPanel() {
        initComponents ();
        timePreferencePanel.setBorder(new javax.swing.border.TitledBorder(Loc.get("timetable.school.gui.rights.timeprefweight.panel")));
        init(this);
    }

    public void setConfig(Config config) {
        try {
          this.config=config;
          this.timePreferencePanel.removeAll();
          this.timePreferencePanel.add(new timetable.gui.GlobalTimePreferencePanel(config,config.getGlobalPref()));
          loadData();
          updateUI();
        } catch (Exception e) {
            System.err.println("Error: "+e);e.printStackTrace();
        }
    }
    
    private void init(java.awt.Container container) {
        try {
            for (int i=0;i<container.getComponentCount();i++) {
                java.awt.Component c = container.getComponent(i);
                if (c instanceof javax.swing.JSlider) {
                    javax.swing.JSlider s = (javax.swing.JSlider)c;
                    s.addChangeListener(new javax.swing.event.ChangeListener() {
                        public void stateChanged(javax.swing.event.ChangeEvent e) {
                            try {
                              ((javax.swing.JSlider)e.getSource()).setToolTipText(String.valueOf(((javax.swing.JSlider)e.getSource()).getValue()));
                              config.set(((javax.swing.JSlider)e.getSource()).getName(),((javax.swing.JSlider)e.getSource()).getValue());
                            } catch (Exception ex) {
                                System.err.println("Error: "+ex);ex.printStackTrace();
                            }
                        }
                    });
                }
            }
        } catch (Exception e) {
            System.err.println("Error:"+e);e.printStackTrace();
        }
    }

    private void loadData(java.awt.Container container) {
        try {
            for (int i=0;i<container.getComponentCount();i++) {
                java.awt.Component c = container.getComponent(i);
                if (c instanceof java.awt.Container) loadData((java.awt.Container)c);
                if (c instanceof javax.swing.JTextField && c.getName()!=null)
                   ((javax.swing.JTextField)c).setText(config.get(c.getName()));
                if (c instanceof javax.swing.JCheckBox && c.getName()!=null)
                   ((javax.swing.JCheckBox)c).setSelected(config.getInt(c.getName())>0);
                if (c instanceof javax.swing.JSlider && c.getName()!=null) {
                    ((javax.swing.JSlider)c).setValue(config.getInt(c.getName()));
                    ((javax.swing.JSlider)c).setToolTipText(String.valueOf(config.getInt(c.getName())));
                }
            }
        } catch (Exception e) {
            System.err.println("Error:"+e);e.printStackTrace();
        }
    }
    
    public void loadData() {
      loadData(this);   
    }
    
    private void storeData(java.awt.Container container) {
        try {
            for (int i=0;i<container.getComponentCount();i++) {
                java.awt.Component c = container.getComponent(i);
                if (c instanceof java.awt.Container) storeData((java.awt.Container)c);
                if (c instanceof javax.swing.JTextField && c.getName()!=null)
                    config.set(c.getName(),Integer.parseInt(((javax.swing.JTextField)c).getText()));
                if (c instanceof javax.swing.JCheckBox && c.getName()!=null)
                    config.set(c.getName(),(((javax.swing.JCheckBox)c).isSelected()?1:0));
                if (c instanceof javax.swing.JSlider && c.getName()!=null)
                    config.set(c.getName(),(((javax.swing.JSlider)c).getValue()));
            }
        } catch (Exception e) {
            System.err.println("Error:"+e);e.printStackTrace();
        }
    }

    public void storeData() {
        try { 
          storeData(this);
//          config.save();
        } catch (Exception e) {
            System.err.println("Error:"+e);e.printStackTrace();
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
private void initComponents() {//GEN-BEGIN:initComponents
timePreferencePanel = new javax.swing.JPanel();
jLabel1 = new javax.swing.JLabel();
jSlider1 = new javax.swing.JSlider();
setLayout(new java.awt.GridBagLayout());
java.awt.GridBagConstraints gridBagConstraints1;

timePreferencePanel.setBorder(new javax.swing.border.TitledBorder("\u010casov\u00e9 preference"));

gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridwidth = 2;
add(timePreferencePanel, gridBagConstraints1);


jLabel1.setText(Loc.get("timetable.school.gui.rights.timeprefweight"));

gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridx = 0;
gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
add(jLabel1, gridBagConstraints1);


jSlider1.setPreferredSize(new java.awt.Dimension(100, 16));
jSlider1.setName("VAHA_CASOVA_PREFERENCE");

gridBagConstraints1 = new java.awt.GridBagConstraints();
gridBagConstraints1.gridy = 1;
add(jSlider1, gridBagConstraints1);

}//GEN-END:initComponents


// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel timePreferencePanel;
private javax.swing.JLabel jLabel1;
private javax.swing.JSlider jSlider1;
// End of variables declaration//GEN-END:variables

}
