/*
 * Top10Value.java
 *
 * Created on 22. jen 2000, 16:22
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy;
import timetable.data.*;
import timetable.util.*;
/** Tda spravujc n nejlepch umstn.
 *
 * @author Tom Mller
 * @version 1.0
 */
public class Top10Value extends timetable.solver.strategy.Top10 {

    /** Konstruktor. Poet umstn ve skupin bude 10. */
    public Top10Value() {
        super();
    }

    /** Konstruktor.
     * @param maximum poet umstn ve skupin
     */
    public Top10Value(int maximum) {
        super(maximum);
    }
    
    /** Pidn umstn do mnoiny n-nejlepch umstn
     * @param adept hodnota umstn - minimalizuje se
     * @param slot umstn - poten slot 
     * @param rg umstn - vybran zdroje
     * @param ag umstn - mnoina konfliktnch aktivit
     */
    public void add(int adept, int slot, ActivityResources rg, ActivityGroup ag) {
        Object [] a = { new Integer(slot), rg, ag };
        add(adept, a);
    }
    
    /** Vrt umstn na dan pozici ve skupin (i-t nejlep) - poten slot.
     * @param i index - poad umstn ve skupin (od 0 do maximum-1)
     * @return poten slot danho umstn
     */
    public int slot(int i) {
        return ((Integer)((Object [])(get(i)))[0]).intValue();
    }
    
    /** Vrt umstn na dan pozici ve skupin (i-t nejlep) - mnoina vybranch zdroj.
     * @param i index - poad umstn ve skupin (od 0 do maximum-1)
     * @return vybran zdroje 
     */
    public ActivityResources resources(int i) {
        return ((ActivityResources)((Object[])(get(i)))[1]);
    }
    
    /** Vrt umstn na dan pozici ve skupin (i-t nejlep) - konfliktn aktivity.
     * @param i index - poad umstn ve skupin (od 0 do maximum-1)
     * @return konfliktn aktivity
     */
    public ActivityGroup activities(int i) {
        return ((ActivityGroup)((Object[])(get(i)))[2]);
    }    

}
