/*
 * SingleActivityEvaluationInterface.java
 *
 * Created on 17. prosinec 2000, 15:38
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.price;

import timetable.data.*;
import timetable.util.TimetableException;
/** Interface funkce, kter ohodnocuje dan umstn aktivity v rozvrhu.
 *
 * @author Tom Mller
 * @version 1.0
 */
public interface SingleActivityEvaluationInterface {
    
    /** Ohodnocovac funkce.
     * @param activity aktivita, kter se umstuje
     * @param slot umstn - poten slot
     * @param selectedResources umstn - vybran zdroje
     * @param dependences mnoina vech zvislost
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu - budou se muset z rozvrhu odebrat v ppad zvolen tohoto umstn
     * @return ohodnocen danho umstn (men hodnota pedstavuje lep umstn, hledme umstn s minimln hodnotou)
     */
    public int value(Activity activity, int slot, ActivityResources selectedResources, ActivityDependenceGroup dependences, ActivityGroup conflictActivities) throws TimetableException;

}

