/*
 * AbstractValueSelection.java
 *
 * Created on 12. jen 2000, 14:28
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.value;

import timetable.data.*;
import timetable.solver.strategy.price.*;
import timetable.util.*;
/** Abstraktn tda heuristiky vbru umstn.
 * Narozdl od ValueSelectionInterface navc implementuje pouit ohodnocovac funkce.
 *
 * @author Tom Mller
 * @version 1.0
 *
 * @see timetable.solver.strategy.value.ValueSelectionInterface
 * @see timetable.solver.strategy.price.SingleActivityEvaluationInterface
 */
public abstract class AbstractValueSelection implements ValueSelectionInterface {
    /** Ohodnocovac funkce. */
    protected SingleActivityEvaluationInterface evaluation = null;
    /** Globln konfigurace */
    protected Config config  = null;    
    /** Vybran aktivita */
    protected Activity activity = null;
    
    /** Konstruktor.
     * @param config konfigurace
     * @param evaluation ohodnocovac funkce
     */
    public AbstractValueSelection(Config config,SingleActivityEvaluationInterface evaluation) {
        this.config = config;
        this.evaluation = evaluation;
    }
    
    /** Nastaven aktivity, pro kterou se bude umstn hledat. Reset heuristiky.
     * @param activity vybran aktivita
     */
    public void reset(Activity activity) {
        this.activity = activity;
    }
    
    /** Pidn monho umstn do vbru. 
     * @param slot poten slot 
     * @param selectedResources vybran zdroje
     * @param dependences mnoina vech zvislost
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu - budou se muset z rozvrhu odebrat v ppad zvolen tohoto umstn
     */
    public abstract void addValue(int slot,ActivityResources selectedResources,ActivityDependenceGroup dependences,ActivityGroup conflictActivities) throws TimetableException ;
    
    /** Metoda provede vbr umstn. */
    public abstract void select() throws TimetableException ;
    
    /** Vrac vybran umstn.
     * @return poten slot
     */
    public abstract int selectedSlot();
    
    /** Vrac vybran umstn.
     * @return vybran zdroje
     */
    public abstract ActivityResources selectedResources();

    /** Vrac vybran umstn.
     * @return konfliktn aktivity
     */
    public abstract ActivityGroup selectedConflictActivities();
    
}