/*
 * HumanValueSelectionDlg.java
 *
 * Created on 25. nor 2001, 19:08
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.value;

/** Dialog prezentujc N nejlepch umstn uivateli, kter jedno vybere.
 *
 * @author Tom Mller
 * @version 1.0
 */
import timetable.util.*;
import javax.swing.*;

public class HumanValueSelectionDlg extends javax.swing.JDialog {
    /** Konfigurace */
    private Config config;
    /** Vbr - group of radio buttons */
    private SelectButtonGroup selectButtonGroup;
    /** Nvratov hodnota */
    private int returnStatus=-1;

    /** Konstruktor.
     * @param parent rodiovsk okno
     * @param config konfigurace
     */
    public HumanValueSelectionDlg(java.awt.Frame parent, Config config) {
        super (parent, true);
        initComponents ();
        pack ();
        this.config=config;
        selectButtonGroup = new SelectButtonGroup();
    }
    
    /** Pidn umstn (adepta) do vbru - v poad od nejlepho k nejhormu
     * @param slot poten slot 
     * @param selectedResources vybran zdroje
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu
     */
    public void addAdept(int slot, String selectedResources,String conflictActivities) {
        String time;
        try{
           int nrSlotsPerDay = config.getInt(Config.NR_SLOTS)/config.getInt(Config.NR_DAYS);
           time = config.dayOfWeek(slot) + " "+((slot % nrSlotsPerDay)+1);
        } catch (Exception e) { System.err.println("Error:"+e);e.printStackTrace();time = "?";}
        JRadioButton rb = new JRadioButton(Loc.get("timetable.humanvalueselect.hour")+" "+time);
        selectButtonGroup.addButton(rb);
        JLabel l1 = new JLabel(Loc.get("timetable.humanvalueselect.resources")+" "+selectedResources);
        JLabel l2 = new JLabel(Loc.get("timetable.humanvalueselect.conflicts")+" "+conflictActivities);
        l1.setForeground(rb.getForeground());
        l1.setBorder(new javax.swing.border.EmptyBorder(0,18,0,0));
        l2.setBorder(new javax.swing.border.EmptyBorder(0,18,0,0));
        if (!conflictActivities.equals("")) l2.setForeground(new java.awt.Color(255,100,100));
        JPanel p = new JPanel();
        p.setLayout(new java.awt.GridBagLayout());
        p.setBorder(new javax.swing.border.EtchedBorder());
        java.awt.GridBagConstraints c;
        c = new java.awt.GridBagConstraints();
        c.gridx = 0;c.anchor = java.awt.GridBagConstraints.WEST;
        p.add(rb, c);
        c = new java.awt.GridBagConstraints();
        c.gridx = 0;c.anchor = java.awt.GridBagConstraints.WEST;
        p.add(l1, c);
        if (!conflictActivities.equals("")) {
          c = new java.awt.GridBagConstraints();
          c.gridx = 0;c.anchor = java.awt.GridBagConstraints.WEST;
          p.add(l2, c);
        };
        JPanel dummy = new JPanel();
        dummy.setPreferredSize(new java.awt.Dimension(300,1));
        c = new java.awt.GridBagConstraints();
        c.gridx = 0;c.anchor = java.awt.GridBagConstraints.WEST;
        p.add(dummy, c);
        c = new java.awt.GridBagConstraints();
        c.gridx = 0;c.anchor = java.awt.GridBagConstraints.WEST;
        c.fill = java.awt.GridBagConstraints.HORIZONTAL;
        solutionPanel.add(p,c);
        setSize(330,(getPreferredSize().height>250?250:getPreferredSize().height));
        setLocation(200,200);
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
    }
    
    /** Vybran umstn
     * @return poad vybranho umstn, od 0 (-1 pokud nebylo vybrno)
     */
    public int getSelected() {
        return returnStatus;
    }
        

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        solutionPanel = new javax.swing.JPanel();
        setTitle(Loc.get("timetable.humanvalueselect.title"));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        jPanel1.setLayout(new java.awt.FlowLayout(2, 5, 5));
        
        okButton.setText(Loc.get("timetable.button.select"));
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed(evt);
              }
          }
          );
          jPanel1.add(okButton);
          
          
        cancelButton.setText(Loc.get("timetable.button.cancel"));
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed(evt);
              }
          }
          );
          jPanel1.add(cancelButton);
          
          
        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);
        
        
        jScrollPane1.setMaximumSize(new java.awt.Dimension(400, 200));
        jScrollPane1.setAutoscrolls(true);
        
        solutionPanel.setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          jScrollPane1.setViewportView(solutionPanel);
          
          
        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

    /** Zmknuto tlatko CANCEL - 
     * @param evt pslun udlost
     */
  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
      setVisible(false);
      returnStatus=-1;
      dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

    /** Zmknuto tlatko OK
     * @param evt pslun udlost
     */
  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
      setVisible(false);
      returnStatus=this.selectButtonGroup.getSelected();
      dispose();
  }//GEN-LAST:event_okButtonActionPerformed

    /** Zave dialog
     * @param evt pslun udlost
     */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel solutionPanel;
    // End of variables declaration//GEN-END:variables

/** Vbr - skupina pepnacch tlatek */
private class SelectButtonGroup extends javax.swing.ButtonGroup implements java.awt.event.ActionListener {
  /** tlatka */
  private java.util.Vector buttons = new java.util.Vector();
  /** vybran */
  private int selected=0;
  /** Konstruktor */
  public SelectButtonGroup() {
    super();
  }
  /** Pidn tlatka */
  public void addButton(JRadioButton b) {
      add(b);
      b.setSelected(buttons.size()==0);
      buttons.add(b);
      b.addActionListener(this);
  }
  /** Zmknut tlatka */
  public void actionPerformed(final java.awt.event.ActionEvent e) {
      selected = buttons.indexOf(e.getSource());
  }
  /** Vrcen zmknutho tlatka.
   * @return index zmknutho tlatka
   */
  public int getSelected() {
      return selected;
  }
}
}