/*
 * MinValueSelection.java
 *
 * Created on 12. jen 2000, 14:28
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.value;

import timetable.data.*;
import timetable.solver.strategy.price.*;
import timetable.solver.strategy.*;
import timetable.util.*;

/** Tda implementujc implicitn heuristiku vbru umstn. Snahou je vybrat nejlep umstn. Soust tdy je pouit tabu-listu a nhodn vbr z n nejlepch umstn (pro zabrnn cyklan)
 *
 * @author Tom Mller
 * @version 1.0
 */
public class MinValueSelection extends AbstractValueSelection {
    /** Poet nejlepch umstnch, ze kterch se bude vybrat nhosn*/
    protected int TOP10MAX=5;
    /** Vb N nejlepch umstn */
    protected Top10Value top10 = null;
    /** Tabu-list */
    protected Tabu tabu = null;
    /** Dlka tabu-listu */
    protected int tabuSize = -1;
    /** Poet adept na umstn */
    protected int nrAdepts = 0;
    /** Minimln nalezen hodnota umstn */
    protected int min = -1;
    /** Nalezen umstn - vybran zdroje */
    protected ActivityResources solution = null;
    /** Nalezen umstn - konfliktn aktivity */
    protected ActivityGroup conflictActivities = null;
    /** Nalezen umstn - poten slot */
    protected int minSlot = -1;
    
    /** Konstruktor.
     * @param config konfigurace
     * @param tabu tabu-list
     * @param evaluation ohodnocovac funkce
     */
    public MinValueSelection(Config config,Tabu tabu,SingleActivityEvaluationInterface evaluation) throws TimetableException {
        super(config,evaluation);
        this.tabu = tabu;
        TOP10MAX=config.getInt("VYBER_HODNOTY_POCET_TOP");
        top10 = new Top10Value(TOP10MAX);        
        tabuSize = config.getInt("DELKA_TABU");
    }
    
    /** Nastaven aktivity, pro kterou se bude umstn hledat. Reset heuristiky.
     * @param activity vybran aktivita
     */
    public void reset(Activity activity) {
        top10.reset();
        nrAdepts = 0;
        min=-1;minSlot=-1;
        this.activity = activity;
    }
           
    /** Pidn monho umstn do vbru. 
     * @param slot poten slot 
     * @param selectedResources vybran zdroje
     * @param dependences mnoina vech zvislost
     * @param conflictActivities mnoina aktivit, kter jsou s danm umstnm v konfliktu - budou se muset z rozvrhu odebrat v ppad zvolen tohoto umstn
     */
    public void addValue(int slot,ActivityResources selectedResources,ActivityDependenceGroup dependences,ActivityGroup conflictActivities) throws TimetableException {
        if (tabuSize>0 && tabu.isTabuMove(activity,slot,selectedResources)) {
            if (tabu.isTabuMoveTwiceMore(activity,slot,selectedResources)) return;
            int adept = evaluation.value(activity,slot,selectedResources,dependences,conflictActivities);
            if (adept<min || minSlot==-1) {
              minSlot=slot;
              solution = (ActivityResources) selectedResources.clone();
              this.conflictActivities=conflictActivities;
              min = adept;
            };
        } else {
            int adept = evaluation.value(activity,slot,selectedResources,dependences,conflictActivities);
              config.log("      VALUE="+adept);
            if (top10.willBeAdded(adept)) {
                top10.add(adept,slot,(ActivityResources)selectedResources.clone(),conflictActivities);
                config.log("        ADDED");
            }
            nrAdepts++;
        }
    }
    
    /** Metoda provede vbr umstn. */
    public void select() throws TimetableException {
        config.log("    IN TOP10 ARE "+top10.size()+" (INTERESTING "+top10.countInteresting()+") ADEPTS FROM "+nrAdepts);
        if (top10.size()==0 && minSlot<0) return; 
        if (top10.size()>0 && !(minSlot>=0 && min<top10.top(0))) {
            int selected = timetable.util.Math.random(top10.countInteresting());
            solution = top10.resources(selected); 
            conflictActivities = top10.activities(selected);
            minSlot = top10.slot(selected);
            config.log("    SELECTED VALUE "+top10.top(selected)+" ("+(selected+1)+". best adept)");
        } else config.log("    SELECTED VALUE "+min+" (TABU)");
        
        if (tabuSize>0) tabu.add(activity,minSlot,solution);
        config.log("  REMOVED ACTIVITIES : "+conflictActivities.toString());
    }
    
    /** Vrac vybran umstn.
     * @return poten slot
     */
    public int selectedSlot() {
        if (top10.size()==0 && minSlot<0) return -1; 
        return minSlot;
    }

    /** Vrac vybran umstn.
     * @return vybran zdroje
     */
    public ActivityResources selectedResources() {
        if (top10.size()==0 && minSlot<0) return null; 
        return solution;
    }
    
    /** Vrac vybran umstn.
     * @return konfliktn aktivity
     */
    public ActivityGroup selectedConflictActivities() {
        if (top10.size()==0 && minSlot<0) return null; 
        return conflictActivities;
    }
    
}
