/*
 * RandomVariableSelection.java
 *
 * Created on 17. prosinec 2000, 15:17
 * Documented 18. 7. 2001
 */

package timetable.solver.strategy.variable;

import timetable.data.*;
import timetable.util.*;
/** Heuristika vbru nenaplnovan aktivity - nhodn vbr aktivity.
 *
 * @author Tom Mller
 * @version 1.0
 */
public class RandomVariableSelection implements VariableSelectionInterface {

    /** Konstruktor. */
    public RandomVariableSelection() {
    }

    /** Vbr nenaplnovan aktivity. Vybere jednu z aktivit nhodn.
     * @param notScheduledActivities mnoina nenaplnovanch aktivit
     * @param dependences mnoina zvislost mezi aktivitami
     * @return vybran aktivita
     */
    public Activity select(ActivityGroup notScheduledActivities,ActivityDependenceGroup dependences) throws TimetableException {
        return notScheduledActivities.get(timetable.util.Math.random(notScheduledActivities.size()));
    }
    
}
