/*
 * MessageDlg.java
 *
 * Created on 25. prosinec 2000, 16:03
 */

package timetable.util;


/**
 *
 * @author  Administrator
 * @version 
 */
public class MessageTableDlg extends javax.swing.JDialog {
    public static int OK = 1;
    public static int CANCEL = 2;
    public static int YES = 4;
    public static int NO = 8;
    public static int OKCANCEL = OK+CANCEL;
    public static int YESNO = YES+NO;
    
    protected int returnStatus = 0;

    /** Creates new form MessageDlg */
    public MessageTableDlg(java.awt.Frame parent,String title,String message,int buttons,javax.swing.JTable table) {
        super (parent, true);
        initComponents ();
        pack ();
        if ((buttons&OK)==0) buttonPanel.remove(okButton);
        if ((buttons&CANCEL)==0) buttonPanel.remove(cancelButton);
        if ((buttons&YES)==0) buttonPanel.remove(yesButton);
        if ((buttons&NO)==0) buttonPanel.remove(noButton);
        msgArea.setText(message);
        tableArea.setViewportView(table);
        setTitle(title);
        this.setSize(335,400);
        this.setLocation((this.getToolkit().getScreenSize().width-this.getSize().width)/2,(this.getToolkit().getScreenSize().height-this.getSize().height)/2);
    }
    
    public MessageTableDlg(String title,String message,int buttons,javax.swing.JTable table) {
        this(new javax.swing.JFrame (),title,message,buttons,table);
    }
    
    public int getReturnStatus() { return returnStatus; }
    
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonPanel = new javax.swing.JPanel();
        yesButton = new javax.swing.JButton();
        noButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        tableArea = new javax.swing.JScrollPane();
        msgArea = new javax.swing.JTextArea();
        getContentPane().setLayout(null);
        setName("messageDlg");
        setModal(true);
        setTitle(Loc.get("timetable.util.messagedlg.title"));
        setResizable(false);
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        }
        );
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        
        yesButton.setText(Loc.get("timetable.button.yes"));
          yesButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  yesButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(yesButton);
          
          
        noButton.setText(Loc.get("timetable.button.no"));
          noButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  noButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(noButton);
          
          
        okButton.setText(Loc.get("timetable.button.ok"));
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(okButton);
          
          
        cancelButton.setText(Loc.get("timetable.button.cancel"));
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(cancelButton);
          
          
        getContentPane().add(buttonPanel);
        buttonPanel.setLocation(70, 330);
        buttonPanel.setSize(buttonPanel.getPreferredSize());
        
        
        tableArea.setPreferredSize(new java.awt.Dimension(200, 170));
        tableArea.setMinimumSize(new java.awt.Dimension(190, 250));
        
        getContentPane().add(tableArea);
        tableArea.setBounds(10, 50, 310, 270);
        
        
        msgArea.setWrapStyleWord(true);
        msgArea.setPreferredSize(new java.awt.Dimension(190, 48));
        msgArea.setLineWrap(true);
        msgArea.setEditable(false);
        msgArea.setRows(3);
        msgArea.setBackground(new java.awt.Color (205, 205, 205));
        
        getContentPane().add(msgArea);
        msgArea.setBounds(10, 10, 320, 30);
        
    }//GEN-END:initComponents

  private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
  }//GEN-LAST:event_formComponentResized

  private void noButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noButtonActionPerformed
      doClose(NO);
  }//GEN-LAST:event_noButtonActionPerformed

  private void yesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_yesButtonActionPerformed
      doClose(YES);
  }//GEN-LAST:event_yesButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
      doClose(CANCEL);
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
      doClose(OK);
  }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog

    private void doClose(int code) {
        returnStatus=code;
        setVisible(false);
        dispose();
    }
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton yesButton;
    private javax.swing.JButton noButton;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JScrollPane tableArea;
    private javax.swing.JTextArea msgArea;
    // End of variables declaration//GEN-END:variables

}
