/*
 * Decompiled with CFR 0.152.
 */
package ttsolver;

import edu.purdue.smas.timetable.util.Constants;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.FastVector;
import ifs.util.Progress;
import ifs.util.ToolBox;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import ttsolver.TimetableLoader;
import ttsolver.TimetableModel;
import ttsolver.constraint.DepartmentSpreadConstraint;
import ttsolver.constraint.GroupConstraint;
import ttsolver.constraint.InstructorConstraint;
import ttsolver.constraint.JenrlConstraint;
import ttsolver.constraint.RoomConstraint;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;
import ttsolver.model.RoomLocation;
import ttsolver.model.TimeLocation;

public class TimetableXMLLoader
extends TimetableLoader {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$TimetableXMLLoader == null ? (class$ttsolver$TimetableXMLLoader = TimetableXMLLoader.class$("ttsolver.TimetableXMLLoader")) : class$ttsolver$TimetableXMLLoader));
    private boolean iUseDepartmentSpreadConstraints = true;
    private int iForcedPerturbances = 0;
    private boolean iInitialAssignment;
    private boolean iMppAssignment;
    private boolean iUseDistanceConstraints;
    private File iInputFile = new File(this.getModel().getProperties().getProperty("General.Input"));
    static /* synthetic */ Class class$ttsolver$TimetableXMLLoader;

    public TimetableXMLLoader(TimetableModel timetableModel) {
        super(timetableModel);
        this.iForcedPerturbances = this.getModel().getProperties().getPropertyInt("General.ForcedPerturbances", 0);
        this.iMppAssignment = this.getModel().getProperties().getPropertyBoolean("General.MPP", false);
        this.iInitialAssignment = !this.iMppAssignment && this.getModel().getProperties().getPropertyBoolean("General.InitialAssignment", false);
        this.iUseDepartmentSpreadConstraints = this.getModel().getProperties().getPropertyBoolean("General.UseDepartmentSpreadConstraints", true);
        this.iUseDistanceConstraints = this.getModel().getProperties().getPropertyBoolean("General.UseDistanceConstraints", true);
    }

    public void load(PrintWriter printWriter) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        sLogger.debug((Object)("Reading XML data from " + this.iInputFile));
        Progress.getInstance().setPhase("Reading " + this.iInputFile.getName() + " ...");
        Document document = new SAXReader().read(this.iInputFile);
        Element element = document.getRootElement();
        sLogger.debug((Object)("Root element: " + element.getName()));
        if (!"llrt".equals(element.getName())) {
            sLogger.error((Object)"Given XML file is not large lecture room timetabling problem.");
            return;
        }
        if (element.element("input") != null) {
            element = element.element("input");
        }
        sLogger.info((Object)("Going to load data " + element.attributeValue("semester") + element.attributeValue("year") + "v" + element.attributeValue("version") + " ..."));
        this.getModel().getProperties().setProperty("Data.Semester", element.attributeValue("semester"));
        this.getModel().getProperties().setProperty("Data.Year", element.attributeValue("year"));
        this.getModel().getProperties().setProperty("Data.Version", element.attributeValue("version"));
        Progress.getInstance().setPhase("Creating rooms ...", (long)element.element("rooms").elements("room").size());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        Iterator iterator = element.element("rooms").elementIterator("room");
        while (iterator.hasNext()) {
            object13 = (Element)iterator.next();
            object12 = new RoomConstraint(object13.attributeValue("id"), "r" + object13.attributeValue("id"), Constants.SLOTS_PER_DAY, Constants.DAY_CODES.length, object13.attributeValue("capacity") + " seats");
            this.getModel().addConstraint((Constraint)object12);
            Progress.getInstance().incProgress();
            hashtable.put(object13.attributeValue("id"), object13);
            hashtable2.put(object13.attributeValue("id"), object12);
        }
        Progress.getInstance().setPhase("Creating variables ...", (long)element.element("classes").elements("class").size());
        int n = element.element("classes").elements("class").size();
        object13 = new Hashtable();
        object12 = new Hashtable();
        Hashtable<Object, Placement> hashtable4 = new Hashtable<Object, Placement>();
        Hashtable<String, Object> hashtable5 = new Hashtable<String, Object>();
        Object object14 = element.element("classes").elementIterator("class");
        while (object14.hasNext()) {
            Object object15;
            object11 = (Element)object14.next();
            ((Hashtable)object13).put(object11.attributeValue("id"), object11);
            object10 = object11.element("instructor");
            object9 = null;
            if (object10 != null && (object9 = (InstructorConstraint)((Object)hashtable5.get(object10.attributeValue("id")))) == null) {
                object9 = new InstructorConstraint(object10.attributeValue("id"), "i" + object10.attributeValue("id"), Constants.SLOTS_PER_DAY, Constants.DAY_CODES.length);
                hashtable5.put(object10.attributeValue("id"), object9);
                this.getModel().addConstraint((Constraint)object9);
            }
            object8 = new FastVector();
            object7 = new FastVector();
            object6 = null;
            int n2 = Integer.MAX_VALUE;
            object5 = object11.elementIterator("room");
            while (object5.hasNext()) {
                object4 = (Element)object5.next();
                object3 = (Element)hashtable.get(object4.attributeValue("id"));
                object2 = (RoomConstraint)((Object)hashtable2.get(object4.attributeValue("id")));
                object7.add(object2);
                object = new RoomLocation(((RoomConstraint)((Object)object2)).getResourceId(), ((RoomConstraint)((Object)object2)).getName(), null, Integer.parseInt(object4.attributeValue("pref")), Integer.parseInt(object3.attributeValue("capacity")));
                if (object3.attributeValue("location") != null) {
                    object15 = object3.attributeValue("location");
                    int n3 = Integer.parseInt(((String)object15).substring(0, ((String)object15).indexOf(44)));
                    int n4 = Integer.parseInt(((String)object15).substring(((String)object15).indexOf(44) + 1));
                    ((RoomLocation)object).setCoordinates(n3, n4);
                }
                n2 = Math.min(n2, Integer.parseInt(object4.attributeValue("pref")));
                if ("true".equals(object4.attributeValue("solution"))) {
                    object6 = object;
                }
                ((Vector)object8).add(object);
            }
            if (((Vector)object8).isEmpty()) {
                sLogger.error((Object)"  ERROR: No room.");
                continue;
            }
            double d = Double.MAX_VALUE;
            object3 = new FastVector();
            object2 = null;
            object = object11.elementIterator("time");
            while (object.hasNext()) {
                object15 = (Element)object.next();
                TimeLocation timeLocation = new TimeLocation(Integer.parseInt(object15.attributeValue("days"), 2), Integer.parseInt(object15.attributeValue("start")), Integer.parseInt(object15.attributeValue("length")), Integer.parseInt(object15.attributeValue("pref")));
                d = Math.min(d, (double)Integer.parseInt(object15.attributeValue("pref")));
                if ("true".equals(object15.attributeValue("solution"))) {
                    object2 = timeLocation;
                }
                object3.add(timeLocation);
            }
            if (object3.isEmpty()) {
                sLogger.error((Object)"  ERROR: No time.");
                continue;
            }
            object = new Lecture(Long.parseLong(object11.attributeValue("id")), "c" + object11.attributeValue("id"), (Vector)object3, d, object10 == null ? null : object10.attributeValue("id"), (Vector)object8, n2, null, Integer.parseInt(object11.attributeValue("expectedCapacity")), object10 == null ? null : "i" + object10.attributeValue("id"), "?");
            if (object2 != null && object6 != null) {
                hashtable4.put(object, new Placement(null, (TimeLocation)object2, (RoomLocation)object6));
            } else {
                sLogger.debug((Object)("Lecture " + object + " has no initial placement (time=" + object2 + ", room=" + object6 + ")"));
            }
            ((Hashtable)object12).put(object11.attributeValue("id"), object);
            ((Lecture)((Object)object)).setDepartment(object11.attributeValue("department"));
            object15 = (Vector)hashtable3.get(object11.attributeValue("course"));
            if (object15 == null) {
                object15 = new FastVector();
                hashtable3.put(object11.attributeValue("course"), object15);
            }
            ((Vector)object15).addElement(object);
            this.getModel().setBestRoomPreference(this.getModel().getBestRoomPreference() + (long)n2);
            this.getModel().setBestTimePreference(this.getModel().getBestTimePreference() + d);
            this.getModel().addVariable((Variable)object);
            if (object9 != null) {
                object9.addVariable((Variable)object);
            }
            Enumeration enumeration = object7.elements();
            while (enumeration.hasMoreElements()) {
                ((Constraint)enumeration.nextElement()).addVariable((Variable)object);
            }
            if (object.getInitialAssignment() != null && this.getModel().conflictValues(object.getInitialAssignment()).isEmpty()) {
                object.assign(0L, object.getInitialAssignment());
            }
            Progress.getInstance().incProgress();
        }
        Progress.getInstance().setPhase("Creating constraints ...", (long)element.element("groupConstraints").elements("constraint").size());
        object14 = new Hashtable();
        object11 = new Hashtable();
        object10 = element.element("groupConstraints").elementIterator("constraint");
        while (object10.hasNext()) {
            object9 = (Element)object10.next();
            object8 = new GroupConstraint(Long.parseLong(object9.attributeValue("id")), object9.attributeValue("type"), object9.attributeValue("pref"));
            ((GroupConstraint)((Object)object8)).setGlobalPreference(this.getModel().getGlobalGroupConstraintPreferenceCounter());
            this.getModel().addConstraint((Constraint)object8);
            object7 = object9.elementIterator("class");
            while (object7.hasNext()) {
                object6 = ((Element)object7.next()).attributeValue("id");
                object8.addVariable((Variable)((Lecture)((Object)((Hashtable)object12).get(object6))));
            }
            ((Hashtable)object14).put(object9.attributeValue("id"), object9);
            ((Hashtable)object11).put(object9.attributeValue("id"), object8);
            Progress.getInstance().incProgress();
        }
        Progress.getInstance().setPhase("Loading students ...", (long)element.element("students").elements("student").size());
        object10 = new Hashtable();
        object9 = element.element("students").elementIterator("student");
        while (object9.hasNext()) {
            Object object16;
            object8 = (Element)object9.next();
            object7 = new Vector();
            object6 = object8.elementIterator("class");
            while (object6.hasNext()) {
                object16 = ((Element)object6.next()).attributeValue("id");
                object5 = (Lecture)((Object)((Hashtable)object12).get(object16));
                ((Lecture)((Object)object5)).addStudent(object8.attributeValue("id"));
                object7.add(object5);
            }
            object6 = object7.elements();
            while (object6.hasMoreElements()) {
                object16 = (Lecture)((Object)object6.nextElement());
                object5 = object7.elements();
                while (object5.hasMoreElements()) {
                    object4 = (Lecture)((Object)object5.nextElement());
                    if (((Lecture)((Object)object16)).getClassId() >= ((Lecture)((Object)object4)).getClassId()) continue;
                    object3 = (JenrlConstraint)((Object)((Hashtable)object10).get(((Lecture)((Object)object16)).getClassId() + "," + ((Lecture)((Object)object4)).getClassId()));
                    if (object3 == null) {
                        object3 = new JenrlConstraint(1L, this.getModel().getViolatedStudentConflictsCounter());
                        this.getModel().addConstraint((Constraint)object3);
                        object3.addVariable((Variable)object16);
                        object3.addVariable((Variable)object4);
                        ((Hashtable)object10).put(((Lecture)((Object)object16)).getClassId() + "," + ((Lecture)((Object)object4)).getClassId(), object3);
                        continue;
                    }
                    object3.incJenrl();
                }
            }
            Progress.getInstance().incProgress();
        }
        object9 = hashtable3.elements();
        while (object9.hasMoreElements()) {
            object8 = (Vector)object9.nextElement();
            object7 = ((Vector)object8).elements();
            while (object7.hasMoreElements()) {
                object6 = (Lecture)((Object)object7.nextElement());
                ((Lecture)((Object)object6)).setSameLectures((Vector)object8);
            }
        }
        if (this.iMppAssignment || this.iInitialAssignment) {
            Progress.getInstance().setPhase("Creating initial assignment ...", (long)hashtable4.size());
            object9 = hashtable4.entrySet().iterator();
            while (object9.hasNext()) {
                Hashtable hashtable6;
                object8 = (Map.Entry)object9.next();
                object7 = (Lecture)((Object)object8.getKey());
                object6 = (Placement)((Object)object8.getValue());
                object6.setVariable((Variable)object7);
                if (this.iMppAssignment) {
                    object7.setInitialAssignment(object6);
                }
                if ((hashtable6 = this.getModel().conflictConstraints((Value)object6)).isEmpty()) {
                    object7.assign(0L, object6);
                } else {
                    sLogger.warn((Object)("WARNING: Unable to assign " + object7.getName() + " := " + ((Placement)((Object)object6)).getName()));
                    sLogger.debug((Object)"  Reason:");
                    object5 = hashtable6.keys();
                    while (object5.hasMoreElements()) {
                        object4 = (Constraint)object5.nextElement();
                        object3 = (Collection)hashtable6.get(object4);
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (Value)object2.next();
                            sLogger.debug((Object)("    " + object.variable().getName() + " = " + object.getName()));
                        }
                        sLogger.debug((Object)("    in constraint " + object4));
                    }
                }
                Progress.getInstance().incProgress();
            }
        }
        if (this.iForcedPerturbances > 0) {
            Progress.getInstance().setPhase("Forcing perturbances", (long)this.iForcedPerturbances);
            for (int i = 0; i < this.iForcedPerturbances; ++i) {
                Progress.getInstance().setProgress((long)i);
                object8 = null;
                while ((object8 = (Variable)ToolBox.random((Collection)this.getModel().variables())).getInitialAssignment() == null || object8.values().size() <= 1) {
                }
                object8.removeInitialValue();
            }
        }
        if (this.iUseDepartmentSpreadConstraints) {
            Progress.getInstance().setPhase("Creating dept. spread constraints ...", (long)this.getModel().variables().size());
            Hashtable hashtable7 = new Hashtable();
            object8 = this.getModel().variables().elements();
            while (object8.hasMoreElements()) {
                object7 = (Lecture)((Object)object8.nextElement());
                if (object7.getDepartment() == null) continue;
                object6 = (DepartmentSpreadConstraint)((Object)hashtable7.get(object7.getDepartment()));
                if (object6 == null) {
                    object6 = new DepartmentSpreadConstraint(this.getModel().getProperties(), object7.getDepartment());
                    hashtable7.put(object7.getDepartment(), object6);
                    this.getModel().addConstraint((Constraint)object6);
                }
                object6.addVariable((Variable)object7);
                Progress.getInstance().incProgress();
            }
            object8 = hashtable7.elements();
            while (object8.hasMoreElements()) {
                ((DepartmentSpreadConstraint)((Object)object8.nextElement())).init();
            }
        }
        Progress.getInstance().setPhase("Done", 1L);
        Progress.getInstance().incProgress();
        sLogger.debug((Object)"Model successfully loaded.");
        printWriter.println("Model successfully loaded.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

