/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.constraint;

import edu.purdue.smas.timetable.util.Constants;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.util.DataProperties;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class DepartmentSpreadConstraint
extends Constraint {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$constraint$DepartmentSpreadConstraint == null ? (class$ttsolver$constraint$DepartmentSpreadConstraint = DepartmentSpreadConstraint.class$("ttsolver.constraint.DepartmentSpreadConstraint")) : class$ttsolver$constraint$DepartmentSpreadConstraint));
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static DecimalFormat sIntFormat = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
    private int[][] iMaxCourses = null;
    private int iCurrentPenalty = 0;
    private int iMaxAllowedPenalty = 0;
    private String iDepartment = null;
    private boolean iInitialized = false;
    private int[][] iNrCourses = null;
    private Vector[][] iCourses = null;
    private double iSpreadFactor = 1.2;
    private int iUnassignmentsToWeaken = 250;
    private long iUnassignment = 0L;
    static /* synthetic */ Class class$ttsolver$constraint$DepartmentSpreadConstraint;

    public DepartmentSpreadConstraint(DataProperties dataProperties, String string) {
        this.iDepartment = string;
        this.iSpreadFactor = dataProperties.getPropertyDouble("DepartmentSpread.SpreadFactor", this.iSpreadFactor);
        this.iUnassignmentsToWeaken = dataProperties.getPropertyInt("DepartmentSpread.Unassignments2Weaken", this.iUnassignmentsToWeaken);
        this.iNrCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.DAY_CODES.length];
        this.iCourses = new Vector[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.DAY_CODES.length];
        for (int i = 0; i < this.iNrCourses.length; ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                this.iNrCourses[i][j] = 0;
                this.iCourses[i][j] = new Vector(10, 5);
            }
        }
    }

    public void init() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.iInitialized) {
            return;
        }
        double[][] dArray = new double[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.DAY_CODES.length];
        this.iMaxCourses = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.DAY_CODES.length];
        for (n5 = 0; n5 < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++n5) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                dArray[n5][i] = 0.0;
            }
        }
        n5 = 0;
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Lecture lecture = (Lecture)((Object)enumeration.nextElement());
            Placement placement = (Placement)((Object)lecture.values().firstElement());
            if (placement != null) {
                n5 += placement.getTimeLocation().getNrHalfHoursPerMeeting() * placement.getTimeLocation().getNrMeetings();
            }
            Enumeration enumeration2 = lecture.values().elements();
            while (enumeration2.hasMoreElements()) {
                Placement placement2 = (Placement)((Object)enumeration2.nextElement());
                int n6 = placement2.getTimeLocation().getStartSlot();
                if (n6 >= Constants.SLOTS_PER_DAY_NO_EVENINGS) continue;
                n4 = n6 + placement2.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
                for (n3 = n6; n3 <= Math.min(n4, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++n3) {
                    n2 = placement2.getTimeLocation().getDayCode();
                    for (n = 0; n < Constants.DAY_CODES.length; ++n) {
                        if ((n2 & Constants.DAY_CODES[n]) == 0) continue;
                        double[] dArray2 = dArray[n3];
                        int n7 = n;
                        dArray2[n7] = dArray2[n7] + 1.0 / (double)lecture.values().size();
                    }
                }
            }
        }
        double d = this.iSpreadFactor * ((double)n5 / (5.0 * (double)Constants.SLOTS_PER_DAY_NO_EVENINGS));
        int n8 = 0;
        for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                this.iMaxCourses[i][j] = (int)(0.999 + (dArray[i][j] <= d ? this.iSpreadFactor * dArray[i][j] : dArray[i][j]));
                n8 += this.iMaxCourses[i][j];
            }
        }
        this.iCurrentPenalty = 0;
        Enumeration enumeration3 = this.variables().elements();
        while (enumeration3.hasMoreElements()) {
            Lecture lecture = (Lecture)((Object)enumeration3.nextElement());
            Placement placement = (Placement)lecture.getAssignment();
            if (placement == null || (n4 = placement.getTimeLocation().getStartSlot()) >= Constants.SLOTS_PER_DAY_NO_EVENINGS) continue;
            n3 = n4 + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
            for (n2 = n4; n2 <= Math.min(n3, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++n2) {
                for (n = 0; n < Constants.DAY_CODES.length; ++n) {
                    int n9 = Constants.DAY_CODES[n];
                    if ((n9 & placement.getTimeLocation().getDayCode()) == 0) continue;
                    int[] nArray = this.iNrCourses[n2];
                    int n10 = n;
                    nArray[n10] = nArray[n10] + 1;
                    this.iCourses[n2][n].addElement(placement);
                    this.iCurrentPenalty += Math.max(0, this.iNrCourses[n2][n] - this.iMaxCourses[n2][n]);
                }
            }
        }
        this.iMaxAllowedPenalty = this.iCurrentPenalty;
        this.iInitialized = true;
    }

    private Lecture getAdept(Placement placement, int[][] nArray, Set set) {
        Lecture lecture = null;
        int n = 0;
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            Lecture lecture2 = (Lecture)((Object)enumeration.nextElement());
            if (lecture2.getAssignment() == null || lecture2.equals(placement.variable()) || set.contains(lecture2.getAssignment()) || (n2 = this.getPenaltyIfUnassigned((Placement)lecture2.getAssignment(), nArray)) == 0 || lecture != null && n2 <= n) continue;
            lecture = lecture2;
            n = n2;
        }
        return lecture;
    }

    private int getPenaltyIfUnassigned(Placement placement, int[][] nArray) {
        int n = placement.getTimeLocation().getStartSlot();
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return 0;
        }
        int n2 = n + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        int n3 = 0;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n4 = Constants.DAY_CODES[j];
                if ((n4 & placement.getTimeLocation().getDayCode()) == 0 || nArray[i][j] <= this.iMaxCourses[i][j]) continue;
                ++n3;
            }
        }
        return n3;
    }

    private int tryUnassign(Placement placement, int[][] nArray) {
        int n = placement.getTimeLocation().getStartSlot();
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return 0;
        }
        int n2 = n + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        int n3 = 0;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n4 = Constants.DAY_CODES[j];
                if ((n4 & placement.getTimeLocation().getDayCode()) == 0) continue;
                if (nArray[i][j] > this.iMaxCourses[i][j]) {
                    ++n3;
                }
                int[] nArray2 = nArray[i];
                int n5 = j;
                nArray2[n5] = nArray2[n5] - 1;
            }
        }
        return n3;
    }

    private int tryAssign(Placement placement, int[][] nArray) {
        int n = placement.getTimeLocation().getStartSlot();
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return 0;
        }
        int n2 = n + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        int n3 = 0;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n4 = Constants.DAY_CODES[j];
                if ((n4 & placement.getTimeLocation().getDayCode()) == 0) continue;
                int[] nArray2 = nArray[i];
                int n5 = j;
                nArray2[n5] = nArray2[n5] + 1;
                if (nArray[i][j] <= this.iMaxCourses[i][j]) continue;
                ++n3;
            }
        }
        return n3;
    }

    public void computeConflicts(Value value, Set set) {
        if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
            return;
        }
        Placement placement = (Placement)value;
        int n = this.iCurrentPenalty + this.getPenalty(placement);
        if (n <= this.iMaxAllowedPenalty) {
            return;
        }
        int n2 = placement.getTimeLocation().getStartSlot();
        if (n2 >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return;
        }
        int n3 = n2 + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        int[][] nArray = new int[this.iNrCourses.length][Constants.DAY_CODES.length];
        for (int i = 0; i < this.iNrCourses.length; ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                nArray[i][j] = this.iNrCourses[i][j];
            }
        }
        this.tryAssign(placement, nArray);
        Object object = this.variables().elements();
        while (object.hasMoreElements()) {
            Lecture lecture = (Lecture)((Object)object.nextElement());
            if (set.contains((Object)lecture)) {
                n -= this.tryUnassign((Placement)lecture.getAssignment(), nArray);
            }
            if (n > this.iMaxAllowedPenalty) continue;
            return;
        }
        while (n > this.iMaxAllowedPenalty && (object = this.getAdept(placement, nArray, set)) != null) {
            set.add(object.getAssignment());
            n -= this.tryUnassign((Placement)object.getAssignment(), nArray);
        }
    }

    public boolean inConflict(Value value) {
        if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
            return false;
        }
        Placement placement = (Placement)value;
        return this.getPenalty(placement) + this.iCurrentPenalty > this.iMaxAllowedPenalty;
    }

    public boolean isConsistent(Value value, Value value2) {
        if (!this.iInitialized || this.iUnassignmentsToWeaken == 0) {
            return true;
        }
        Placement placement = (Placement)value;
        Placement placement2 = (Placement)value2;
        if (!placement.getTimeLocation().hasIntersection(placement2.getTimeLocation())) {
            return true;
        }
        int n = Math.max(placement.getTimeLocation().getStartSlot(), placement2.getTimeLocation().getStartSlot());
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return true;
        }
        int n2 = Math.min(placement.getTimeLocation().getStartSlot() + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1, placement2.getTimeLocation().getStartSlot() + placement2.getTimeLocation().getNrHalfHoursPerMeeting() - 1);
        int n3 = 0;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n4 = Constants.DAY_CODES[j];
                if ((n4 & placement.getTimeLocation().getDayCode()) == 0 || (n4 & placement2.getTimeLocation().getDayCode()) == 0) continue;
                n3 += Math.max(0, 2 - this.iMaxCourses[i][j]);
            }
        }
        return n3 < this.iMaxAllowedPenalty;
    }

    private void weaken() {
        if (!this.iInitialized) {
            return;
        }
        if (this.iUnassignmentsToWeaken == 0) {
            return;
        }
        ++this.iMaxAllowedPenalty;
    }

    public void assigned(long l, Value value) {
        super.assigned(l, value);
        if (!this.iInitialized) {
            return;
        }
        Placement placement = (Placement)value;
        int n = placement.getTimeLocation().getStartSlot();
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return;
        }
        int n2 = n + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n3 = Constants.DAY_CODES[j];
                if ((n3 & placement.getTimeLocation().getDayCode()) == 0) continue;
                int[] nArray = this.iNrCourses[i];
                int n4 = j;
                nArray[n4] = nArray[n4] + 1;
                if (this.iNrCourses[i][j] > this.iMaxCourses[i][j]) {
                    ++this.iCurrentPenalty;
                }
                this.iCourses[i][j].addElement(value);
            }
        }
    }

    public void unassigned(long l, Value value) {
        super.unassigned(l, value);
        if (!this.iInitialized) {
            return;
        }
        Placement placement = (Placement)value;
        int n = placement.getTimeLocation().getStartSlot();
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return;
        }
        int n2 = n + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n3 = Constants.DAY_CODES[j];
                if ((n3 & placement.getTimeLocation().getDayCode()) == 0) continue;
                if (this.iNrCourses[i][j] > this.iMaxCourses[i][j]) {
                    --this.iCurrentPenalty;
                }
                int[] nArray = this.iNrCourses[i];
                int n4 = j;
                nArray[n4] = nArray[n4] - 1;
                this.iCourses[i][j].removeElement(value);
            }
        }
    }

    public void incUnassignmentCounter(Value value) {
        ++this.iUnassignment;
        if (this.iUnassignment % (long)this.iUnassignmentsToWeaken == 0L) {
            this.weaken();
        }
    }

    public String toString() {
        if (!this.iInitialized) {
            return this.iDepartment + " (not initialized)";
        }
        return this.iDepartment + " (p=" + this.fmt(this.getPenalty()) + ", mx=" + this.fmt(this.iMaxCourses) + ", mp=" + this.fmt(this.iMaxAllowedPenalty) + "): " + this.fmt(this.iNrCourses);
    }

    public int getPenalty() {
        if (!this.iInitialized) {
            return 0;
        }
        return this.iCurrentPenalty;
    }

    public int getPenalty(Placement placement) {
        if (!this.iInitialized) {
            return 0;
        }
        int n = placement.getTimeLocation().getStartSlot();
        if (n >= Constants.SLOTS_PER_DAY_NO_EVENINGS) {
            return 0;
        }
        int n2 = n + placement.getTimeLocation().getNrHalfHoursPerMeeting() - 1;
        int n3 = 0;
        for (int i = n; i <= Math.min(n2, Constants.SLOTS_PER_DAY_NO_EVENINGS - 1); ++i) {
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                int n4 = Constants.DAY_CODES[j];
                if ((n4 & placement.getTimeLocation().getDayCode()) == 0 || this.iNrCourses[i][j] < this.iMaxCourses[i][j]) continue;
                ++n3;
            }
        }
        return n3;
    }

    private String fmt(double d) {
        return sDoubleFormat.format(d);
    }

    private String fmt(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < Math.min(5, dArray.length); ++i) {
            stringBuffer.append(i == 0 ? "" : ",").append(sDoubleFormat.format(dArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String fmt(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(i == 0 ? "" : ",").append(this.fmt(dArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String fmt(int n) {
        return sIntFormat.format(n);
    }

    private String fmt(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < Math.min(5, nArray.length); ++i) {
            stringBuffer.append(i == 0 ? "" : ",").append(sIntFormat.format(nArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String fmt(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(i == 0 ? "" : ",").append(this.fmt(nArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

