/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.constraint;

import edu.purdue.smas.timetable.data.GroupConstraintTypes;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.util.Constants;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.Counter;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class GroupConstraint
extends Constraint {
    private long iId;
    private int iPreference;
    private int iType;
    private boolean iIsRequired;
    private boolean iIsProhibited;
    private Counter iGlobalPreference = null;
    private int iLastPreference = 0;
    public static int TYPE_SAME_TIME = GroupConstraintTypes.getGroupConstraintType((String)"SAME_TIME").getId();
    public static int TYPE_SAME_DAYS = GroupConstraintTypes.getGroupConstraintType((String)"SAME_DAYS").getId();
    public static int TYPE_BTB = GroupConstraintTypes.getGroupConstraintType((String)"BTB").getId();
    public static int TYPE_BTB_TIME = GroupConstraintTypes.getGroupConstraintType((String)"BTB_TIME").getId();
    public static int TYPE_DIFF_TIME = GroupConstraintTypes.getGroupConstraintType((String)"DIFF_TIME").getId();
    public static int TYPE_NHB_1 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(1)").getId();
    public static int TYPE_NHB_2 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(2)").getId();
    public static int TYPE_NHB_3 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(3)").getId();
    public static int TYPE_NHB_4 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(4)").getId();
    public static int TYPE_NHB_5 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(5)").getId();
    public static int TYPE_NHB_6 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(6)").getId();
    public static int TYPE_NHB_7 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(7)").getId();
    public static int TYPE_NHB_8 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(8)").getId();
    public static int TYPE_SAME_START = GroupConstraintTypes.getGroupConstraintType((String)"SAME_START").getId();
    public static int TYPE_SAME_ROOM = GroupConstraintTypes.getGroupConstraintType((String)"SAME_ROOM").getId();
    public static int TYPE_NHB_GTE_1 = GroupConstraintTypes.getGroupConstraintType((String)"NHB_GTE(1)").getId();
    public static int TYPE_NHB_LT_6 = GroupConstraintTypes.getGroupConstraintType((String)"NHB_LT(6)").getId();
    public static int TYPE_NHB_1_5 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(1.5)").getId();
    public static int TYPE_NHB_4_5 = GroupConstraintTypes.getGroupConstraintType((String)"NHB(4.5)").getId();

    public GroupConstraint(long l, int n, String string) {
        this.iId = l;
        this.iType = n;
        this.iIsRequired = string.equals("R");
        this.iIsProhibited = string.equals("P");
        this.iPreference = this.iIsRequired ? 0 : (this.iIsProhibited ? 0 : Integer.parseInt(string));
    }

    public GroupConstraint(long l, String string, String string2) {
        this(l, GroupConstraintTypes.getGroupConstraintType((String)string).getId(), string2);
    }

    public long getId() {
        return this.iId;
    }

    public int getType() {
        return this.iType;
    }

    public String getTypeStr() {
        return GroupConstraintTypes.getGroupConstraintType((int)this.iType).getType();
    }

    public boolean isRequired() {
        return this.iIsRequired;
    }

    public boolean isProhibited() {
        return this.iIsProhibited;
    }

    public String getPrologPreference() {
        return this.iIsRequired ? "R" : (this.iIsProhibited ? "P" : String.valueOf(this.iPreference));
    }

    public void setGlobalPreference(Counter counter) {
        this.iGlobalPreference = counter;
    }

    public Counter getGlobalPreference() {
        return this.iGlobalPreference;
    }

    public boolean isConsistent(Value value, Value value2) {
        if (!this.isHard()) {
            return true;
        }
        if (!this.isSatisfiedPair((Lecture)value.variable(), (Placement)value, (Lecture)value2.variable(), (Placement)value2)) {
            return false;
        }
        if (GroupConstraint.isBackToBack(this.getType())) {
            Hashtable<Variable, Value> hashtable = new Hashtable<Variable, Value>();
            hashtable.put(value.variable(), value);
            hashtable.put(value2.variable(), value2);
            if (!this.isSatisfiedSeq(hashtable, false, null)) {
                return false;
            }
        }
        return true;
    }

    public void computeConflicts(Value value, Set set) {
        if (!this.isHard()) {
            return;
        }
        Object object = this.variables().elements();
        while (object.hasMoreElements()) {
            Variable variable = (Variable)object.nextElement();
            if (variable.equals((Object)value.variable()) || variable.getAssignment() == null || this.isSatisfiedPair((Lecture)variable, (Placement)variable.getAssignment(), (Lecture)value.variable(), (Placement)value)) continue;
            set.add(variable.getAssignment());
        }
        object = new Hashtable();
        ((Hashtable)object).put(value.variable(), value);
        this.isSatisfiedSeq((Hashtable)object, true, set);
    }

    public boolean inConflict(Value value) {
        if (!this.isHard()) {
            return false;
        }
        Object object = this.variables().elements();
        while (object.hasMoreElements()) {
            Variable variable = (Variable)object.nextElement();
            if (variable.equals((Object)value.variable()) || variable.getAssignment() == null || this.isSatisfiedPair((Lecture)variable, (Placement)variable.getAssignment(), (Lecture)value.variable(), (Placement)value)) continue;
            return true;
        }
        object = new Hashtable();
        ((Hashtable)object).put(value.variable(), value);
        return this.isSatisfiedSeq((Hashtable)object, true, null);
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int getCurrentPreference() {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables() < 2) {
            return 0;
        }
        if (this.iPreference < 0) {
            Enumeration enumeration = this.variables().elements();
            while (enumeration.hasMoreElements()) {
                Variable variable = (Variable)enumeration.nextElement();
                if (variable.getAssignment() == null) continue;
                Enumeration enumeration2 = this.variables().elements();
                while (enumeration2.hasMoreElements()) {
                    Variable variable2 = (Variable)enumeration2.nextElement();
                    if (variable2.getAssignment() == null || variable.equals((Object)variable2) || this.isSatisfiedPair((Lecture)variable, (Placement)variable.getAssignment(), (Lecture)variable2, (Placement)variable2.getAssignment())) continue;
                    return 0;
                }
            }
            if (!this.isSatisfiedSeq(null, true, null)) {
                return 0;
            }
            return this.iPreference;
        }
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getAssignment() == null) continue;
            Enumeration enumeration3 = this.variables().elements();
            while (enumeration3.hasMoreElements()) {
                Variable variable3 = (Variable)enumeration3.nextElement();
                if (variable3.getAssignment() == null || variable.equals((Object)variable3) || this.isSatisfiedPair((Lecture)variable, (Placement)variable.getAssignment(), (Lecture)variable3, (Placement)variable3.getAssignment())) continue;
                return this.iPreference;
            }
        }
        if (!this.isSatisfiedSeq(null, true, null)) {
            return this.iPreference;
        }
        return 0;
    }

    public int getCurrentPreference(Placement placement) {
        if (this.isHard()) {
            return 0;
        }
        if (this.iPreference < 0) {
            Object object = this.variables().elements();
            while (object.hasMoreElements()) {
                Variable variable = (Variable)object.nextElement();
                if (variable.getAssignment() == null || variable.equals((Object)placement.variable()) || this.isSatisfiedPair((Lecture)variable, (Placement)variable.getAssignment(), (Lecture)placement.variable(), placement)) continue;
                return 0;
            }
            if (GroupConstraint.isBackToBack(this.getType())) {
                object = new Hashtable();
                ((Hashtable)object).put(placement.variable(), placement);
                if (!this.isSatisfiedSeq((Hashtable)object, true, null)) {
                    return 0;
                }
            }
            return this.iPreference;
        }
        Object object = this.variables().elements();
        while (object.hasMoreElements()) {
            Variable variable = (Variable)object.nextElement();
            if (variable.getAssignment() == null || variable.equals((Object)placement.variable()) || this.isSatisfiedPair((Lecture)variable, (Placement)variable.getAssignment(), (Lecture)placement.variable(), placement)) continue;
            return this.iPreference;
        }
        if (GroupConstraint.isBackToBack(this.getType())) {
            object = new Hashtable();
            ((Hashtable)object).put(placement.variable(), placement);
            if (!this.isSatisfiedSeq((Hashtable)object, true, null)) {
                return this.iPreference;
            }
        }
        return 0;
    }

    public void unassigned(long l, Value value) {
        super.unassigned(l, value);
        if (this.iIsRequired || this.iIsProhibited) {
            return;
        }
        this.iGlobalPreference.dec((long)this.iLastPreference);
        this.iLastPreference = this.getCurrentPreference();
        this.iGlobalPreference.inc((long)this.iLastPreference);
    }

    public void assigned(long l, Value value) {
        super.assigned(l, value);
        if (this.iIsRequired || this.iIsProhibited) {
            return;
        }
        this.iGlobalPreference.dec((long)this.iLastPreference);
        this.iLastPreference = this.getCurrentPreference();
        this.iGlobalPreference.inc((long)this.iLastPreference);
    }

    public String toString() {
        return "GroupConstraint{id=" + this.iId + ", type=" + GroupConstraintTypes.getGroupConstraintType((int)this.iType).getType() + ", preference=" + this.getPrologPreference() + ", variables=" + this.variables().size() + ", lectures" + ToolBox.col2string((Collection)this.variables(), (int)4) + "\n      }";
    }

    public boolean isHard() {
        return this.iIsRequired || this.iIsProhibited;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(((Variable)enumeration.nextElement()).getName());
        }
        return GroupConstraintTypes.getGroupConstraintType((int)this.iType).getDescription() + " [" + stringBuffer + "]";
    }

    public String getDescription() {
        return Preferences.getPreference((String)this.getPrologPreference()).getName().toLowerCase();
    }

    private static int getGapMin(int n) {
        if (n == TYPE_BTB) {
            return 0;
        }
        if (n == TYPE_BTB_TIME) {
            return 0;
        }
        if (n == TYPE_NHB_1) {
            return 2;
        }
        if (n == TYPE_NHB_1_5) {
            return 3;
        }
        if (n == TYPE_NHB_2) {
            return 4;
        }
        if (n == TYPE_NHB_3) {
            return 6;
        }
        if (n == TYPE_NHB_4) {
            return 8;
        }
        if (n == TYPE_NHB_4_5) {
            return 9;
        }
        if (n == TYPE_NHB_5) {
            return 10;
        }
        if (n == TYPE_NHB_6) {
            return 12;
        }
        if (n == TYPE_NHB_7) {
            return 14;
        }
        if (n == TYPE_NHB_8) {
            return 16;
        }
        if (n == TYPE_NHB_GTE_1) {
            return 1;
        }
        if (n == TYPE_NHB_LT_6) {
            return 0;
        }
        return -1;
    }

    private static int getGapMax(int n) {
        if (n == TYPE_BTB) {
            return 0;
        }
        if (n == TYPE_BTB_TIME) {
            return 0;
        }
        if (n == TYPE_NHB_1) {
            return 2;
        }
        if (n == TYPE_NHB_1_5) {
            return 3;
        }
        if (n == TYPE_NHB_2) {
            return 4;
        }
        if (n == TYPE_NHB_3) {
            return 6;
        }
        if (n == TYPE_NHB_4) {
            return 8;
        }
        if (n == TYPE_NHB_4_5) {
            return 9;
        }
        if (n == TYPE_NHB_5) {
            return 10;
        }
        if (n == TYPE_NHB_6) {
            return 12;
        }
        if (n == TYPE_NHB_7) {
            return 14;
        }
        if (n == TYPE_NHB_8) {
            return 16;
        }
        if (n == TYPE_NHB_GTE_1) {
            return Constants.SLOTS_PER_DAY;
        }
        if (n == TYPE_NHB_LT_6) {
            return 11;
        }
        return -1;
    }

    private static boolean isBackToBack(int n) {
        if (n == TYPE_BTB) {
            return true;
        }
        if (n == TYPE_BTB_TIME) {
            return true;
        }
        if (n == TYPE_NHB_1) {
            return true;
        }
        if (n == TYPE_NHB_1_5) {
            return true;
        }
        if (n == TYPE_NHB_2) {
            return true;
        }
        if (n == TYPE_NHB_3) {
            return true;
        }
        if (n == TYPE_NHB_4) {
            return true;
        }
        if (n == TYPE_NHB_4_5) {
            return true;
        }
        if (n == TYPE_NHB_5) {
            return true;
        }
        if (n == TYPE_NHB_6) {
            return true;
        }
        if (n == TYPE_NHB_7) {
            return true;
        }
        if (n == TYPE_NHB_8) {
            return true;
        }
        if (n == TYPE_NHB_GTE_1) {
            return true;
        }
        return n == TYPE_NHB_LT_6;
    }

    private static boolean isBackToBackTime(int n) {
        if (n == TYPE_BTB_TIME) {
            return true;
        }
        if (n == TYPE_NHB_1) {
            return true;
        }
        if (n == TYPE_NHB_1_5) {
            return true;
        }
        if (n == TYPE_NHB_2) {
            return true;
        }
        if (n == TYPE_NHB_3) {
            return true;
        }
        if (n == TYPE_NHB_4) {
            return true;
        }
        if (n == TYPE_NHB_4_5) {
            return true;
        }
        if (n == TYPE_NHB_5) {
            return true;
        }
        if (n == TYPE_NHB_6) {
            return true;
        }
        if (n == TYPE_NHB_7) {
            return true;
        }
        if (n == TYPE_NHB_8) {
            return true;
        }
        if (n == TYPE_NHB_GTE_1) {
            return true;
        }
        return n == TYPE_NHB_LT_6;
    }

    private static boolean sameRoom(int n) {
        return n == TYPE_SAME_ROOM;
    }

    private static boolean sameStartHour(int n) {
        return n == TYPE_SAME_START;
    }

    private static boolean sameHours(int n) {
        return n == TYPE_SAME_TIME;
    }

    private static boolean sameDays(int n) {
        return n == TYPE_SAME_DAYS;
    }

    private static boolean notOverlap(int n) {
        return n == TYPE_DIFF_TIME;
    }

    private static boolean sameDays(int[] nArray, int[] nArray2) {
        if (nArray2.length < nArray.length) {
            return GroupConstraint.sameDays(nArray2, nArray);
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            block4: {
                int n2 = nArray[i] / Constants.SLOTS_PER_DAY;
                do {
                    if (n == nArray2.length) {
                        return false;
                    }
                    int n3 = nArray2[n] / Constants.SLOTS_PER_DAY;
                    if (n2 == n3) break block4;
                } while (++n != nArray2.length);
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean sameHours(int n, int n2, int n3, int n4) {
        if (n2 > n4) {
            return GroupConstraint.sameHours(n3, n4, n, n2);
        }
        return (n %= Constants.SLOTS_PER_DAY) >= (n3 %= Constants.SLOTS_PER_DAY) && n + n2 <= n3 + n4;
    }

    private static boolean canFill(int n, int n2, int n3, Vector vector) {
        if (n2 <= n && n <= n3) {
            return true;
        }
        if (n < 2 * n2) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n4 = (Integer)vector.elementAt(i);
            vector.removeElementAt(i);
            for (int j = n2; j <= n3; ++j) {
                if (!GroupConstraint.canFill(n - j - n4, n2, n3, vector)) continue;
                return true;
            }
            vector.insertElementAt(new Integer(n4), i);
        }
        return false;
    }

    private boolean isSatisfiedSeq(Hashtable hashtable, boolean bl, Set set) {
        block28: {
            Object object;
            int n;
            Placement[] placementArray;
            FastVector fastVector;
            int n2;
            int n3;
            block29: {
                n3 = GroupConstraint.getGapMin(this.getType());
                n2 = GroupConstraint.getGapMax(this.getType());
                if (n3 < 0 || n2 < 0) {
                    return true;
                }
                fastVector = new FastVector();
                placementArray = new Placement[Constants.SLOTS_PER_DAY];
                for (int i = 0; i < Constants.SLOTS_PER_DAY; ++i) {
                    placementArray[i] = null;
                }
                Vector vector = new Vector();
                n = 0;
                Object var10_11 = null;
                Enumeration enumeration = this.variables().elements();
                while (enumeration.hasMoreElements()) {
                    int n4;
                    object = (Lecture)((Object)enumeration.nextElement());
                    Placement placement = hashtable == null ? null : hashtable.get(object);
                    if (placement == null && bl) {
                        placement = (Placement)object.getAssignment();
                    }
                    if (placement == null) {
                        fastVector.addElement(new Integer(((Placement)((Object)object.values().firstElement())).getTimeLocation().getLength()));
                        continue;
                    }
                    int n5 = placement.getTimeLocation().getSlots()[0] % Constants.SLOTS_PER_DAY;
                    int n6 = placement.getTimeLocation().getLength();
                    for (n4 = n5; n4 < n5 + n6; ++n4) {
                        if (placementArray[n4] == null) continue;
                        if (set == null) {
                            return false;
                        }
                        if (!hashtable.containsKey(object)) {
                            set.add(placement);
                            continue;
                        }
                        if (hashtable.containsKey(placementArray[n4].variable())) continue;
                        set.add(placementArray[n4]);
                    }
                    for (n4 = n5; n4 < n5 + n6; ++n4) {
                        placementArray[n4] = placement;
                    }
                    ++n;
                }
                if (n <= 1) {
                    return true;
                }
                if (!this.iIsRequired && (this.iIsProhibited || this.iPreference >= 0)) break block29;
                int n7 = 0;
                object = placementArray[n7];
                while (object == null) {
                    object = placementArray[++n7];
                }
                n7 += placementArray[n7].getTimeLocation().getLength();
                --n;
                while (n > 0) {
                    int n8 = 0;
                    while (n7 < Constants.SLOTS_PER_DAY && placementArray[n7] == null) {
                        ++n8;
                        ++n7;
                    }
                    if (n7 != Constants.SLOTS_PER_DAY) {
                        if (!GroupConstraint.canFill(n8, n3, n2, (Vector)fastVector)) {
                            if (set == null) {
                                return false;
                            }
                            if (hashtable == null || !hashtable.containsKey(object.variable())) {
                                set.add(object);
                            } else if (!hashtable.containsKey(placementArray[n7].variable())) {
                                set.add(placementArray[n7]);
                            }
                        }
                        object = placementArray[n7];
                        n7 += placementArray[n7].getTimeLocation().getLength();
                        --n;
                        continue;
                    }
                    break block28;
                }
                break block28;
            }
            if (!this.iIsProhibited && (this.iIsRequired || this.iPreference <= 0)) break block28;
            int n9 = 0;
            object = placementArray[n9];
            while (object == null) {
                object = placementArray[++n9];
            }
            n9 += placementArray[n9].getTimeLocation().getLength();
            --n;
            while (n > 0) {
                int n10 = 0;
                while (n9 < Constants.SLOTS_PER_DAY && placementArray[n9] == null) {
                    ++n10;
                    ++n9;
                }
                if (n9 != Constants.SLOTS_PER_DAY) {
                    if (!(n3 != 0 && GroupConstraint.canFill(n10, 0, n3 - 1, (Vector)fastVector) || n2 < Constants.SLOTS_PER_DAY && GroupConstraint.canFill(n10, n2 + 1, Constants.SLOTS_PER_DAY, (Vector)fastVector))) {
                        if (set == null) {
                            return false;
                        }
                        if (hashtable == null || !hashtable.containsKey(object.variable())) {
                            set.add(object);
                        } else if (!hashtable.containsKey(placementArray[n9].variable())) {
                            set.add(placementArray[n9]);
                        }
                    }
                    object = placementArray[n9];
                    n9 += placementArray[n9].getTimeLocation().getLength();
                    --n;
                    continue;
                }
                break;
            }
        }
        return true;
    }

    private boolean isSatisfiedPair(Lecture lecture, Placement placement, Lecture lecture2, Placement placement2) {
        if (this.iIsRequired || !this.iIsProhibited && this.iPreference < 0) {
            if ((GroupConstraint.sameRoom(this.getType()) || GroupConstraint.isBackToBack(this.getType()) && !GroupConstraint.isBackToBackTime(this.getType())) && !placement.getRoomLocation().getId().equals(placement2.getRoomLocation().getId())) {
                return false;
            }
            if (GroupConstraint.sameStartHour(this.getType()) && placement.getTimeLocation().getStartSlot() % Constants.SLOTS_PER_DAY != placement2.getTimeLocation().getStartSlot() % Constants.SLOTS_PER_DAY) {
                return false;
            }
            if (GroupConstraint.sameHours(this.getType()) && !GroupConstraint.sameHours(placement.getTimeLocation().getStartSlot(), placement.getTimeLocation().getLength(), placement2.getTimeLocation().getStartSlot(), placement2.getTimeLocation().getLength())) {
                return false;
            }
            if ((GroupConstraint.sameDays(this.getType()) || GroupConstraint.isBackToBack(this.getType())) && !GroupConstraint.sameDays(placement.getTimeLocation().getStartSlots(), placement2.getTimeLocation().getStartSlots())) {
                return false;
            }
            if (GroupConstraint.notOverlap(this.getType()) && placement.getTimeLocation().hasIntersection(placement2.getTimeLocation())) {
                return false;
            }
        } else if (this.iIsProhibited || !this.iIsRequired && this.iPreference > 0) {
            if (GroupConstraint.sameRoom(this.getType()) && placement.getRoomLocation().getId().equals(placement2.getRoomLocation().getId())) {
                return false;
            }
            if (GroupConstraint.sameHours(this.getType()) && placement.getTimeLocation().shareHours(placement2.getTimeLocation())) {
                return false;
            }
            if (GroupConstraint.sameStartHour(this.getType()) && placement.getTimeLocation().getStartSlot() % Constants.SLOTS_PER_DAY == placement2.getTimeLocation().getStartSlot() % Constants.SLOTS_PER_DAY) {
                return false;
            }
            if (GroupConstraint.sameDays(this.getType()) && placement.getTimeLocation().shareDays(placement2.getTimeLocation())) {
                return false;
            }
            if (GroupConstraint.notOverlap(this.getType()) && !placement.getTimeLocation().hasIntersection(placement2.getTimeLocation())) {
                return false;
            }
            if (GroupConstraint.isBackToBack(this.getType())) {
                if (!GroupConstraint.sameDays(placement.getTimeLocation().getStartSlots(), placement2.getTimeLocation().getStartSlots())) {
                    return false;
                }
                if (!GroupConstraint.isBackToBackTime(this.getType()) && !placement.getRoomLocation().getId().equals(placement2.getRoomLocation().getId())) {
                    return false;
                }
            }
        }
        return true;
    }
}

