/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.constraint;

import edu.purdue.smas.timetable.util.Constants;
import ifs.model.Value;
import java.util.Set;
import ttsolver.constraint.ResourceConstraint;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class InstructorConstraint
extends ResourceConstraint {
    public static double sNoPreferenceLimit = 0.0;
    public static double sDiscouragedLimit = 5.0;
    public static double sProhibitedLimit = 20.0;

    public InstructorConstraint(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
    }

    public static int getDistancePreference(Placement placement, Placement placement2) {
        if (!Placement.shareDays(placement, placement2)) {
            return 0;
        }
        int n = placement.getTimeLocation().getStartSlot() % Constants.SLOTS_PER_DAY;
        int n2 = placement2.getTimeLocation().getStartSlot() % Constants.SLOTS_PER_DAY;
        if (n + placement.getTimeLocation().getLength() != n2 && n2 + placement2.getTimeLocation().getLength() != n) {
            return 0;
        }
        double d = Placement.getDistance(placement, placement2);
        if (d == sNoPreferenceLimit) {
            return 0;
        }
        if (d <= sDiscouragedLimit) {
            return 1;
        }
        if (d <= sProhibitedLimit) {
            return 2;
        }
        return 3;
    }

    public void computeConflicts(Value value, Set set) {
        super.computeConflicts(value, set);
        Lecture lecture = (Lecture)value.variable();
        Placement placement = (Placement)value;
        int[] nArray = placement.getTimeLocation().getStartSlots();
        for (int i = 0; i < nArray.length; ++i) {
            Lecture lecture2;
            int n;
            Lecture lecture3;
            int n2 = nArray[i] - 1;
            if (n2 >= 0 && n2 / Constants.SLOTS_PER_DAY == nArray[i] / Constants.SLOTS_PER_DAY && (lecture3 = this.iResource[n2]) != null && Placement.getDistance(placement, (Placement)lecture3.getAssignment()) > sProhibitedLimit) {
                set.add(lecture3.getAssignment());
            }
            if ((n = nArray[i] + placement.getTimeLocation().getLength()) / Constants.SLOTS_PER_DAY != nArray[i] / Constants.SLOTS_PER_DAY || (lecture2 = this.iResource[n]) == null || !(Placement.getDistance(placement, (Placement)lecture2.getAssignment()) > sProhibitedLimit)) continue;
            set.add(lecture2.getAssignment());
        }
    }

    public boolean inConflict(Value value) {
        if (super.inConflict(value)) {
            return true;
        }
        Lecture lecture = (Lecture)value.variable();
        Placement placement = (Placement)value;
        int[] nArray = placement.getTimeLocation().getStartSlots();
        for (int i = 0; i < nArray.length; ++i) {
            Lecture lecture2;
            Lecture lecture3;
            int n = nArray[i] - 1;
            if (n >= 0 && n / Constants.SLOTS_PER_DAY == nArray[i] / Constants.SLOTS_PER_DAY && (lecture3 = this.iResource[n]) != null && Placement.getDistance(placement, (Placement)lecture3.getAssignment()) > sProhibitedLimit) {
                return true;
            }
            int n2 = nArray[i] + placement.getTimeLocation().getLength();
            if (n2 / Constants.SLOTS_PER_DAY != nArray[i] / Constants.SLOTS_PER_DAY || (lecture2 = this.iResource[n2]) == null || !(Placement.getDistance(placement, (Placement)lecture2.getAssignment()) > sProhibitedLimit)) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(Value value, Value value2) {
        if (!super.isConsistent(value, value2)) {
            return false;
        }
        return InstructorConstraint.getDistancePreference((Placement)value, (Placement)value2) == 3;
    }

    public int getPreference(Value value) {
        Lecture lecture = (Lecture)value.variable();
        Placement placement = (Placement)value;
        int n = 0;
        int[] nArray = placement.getTimeLocation().getStartSlots();
        for (int i = 0; i < nArray.length; ++i) {
            double d;
            int n2;
            int n3 = nArray[i] - 1;
            if (n3 >= 0 && n3 / Constants.SLOTS_PER_DAY == nArray[i] / Constants.SLOTS_PER_DAY) {
                double d2;
                Lecture lecture2 = this.iResource[n3];
                double d3 = d2 = lecture2 == null ? 0.0 : Placement.getDistance(placement, (Placement)lecture2.getAssignment());
                if (d2 > sNoPreferenceLimit && d2 <= sProhibitedLimit) {
                    ++n;
                }
                if (d2 > sDiscouragedLimit && d2 <= sProhibitedLimit) {
                    ++n;
                }
            }
            if ((n2 = nArray[i] + placement.getTimeLocation().getLength()) / Constants.SLOTS_PER_DAY != nArray[i] / Constants.SLOTS_PER_DAY) continue;
            Lecture lecture3 = this.iResource[n2];
            double d4 = d = lecture3 == null ? 0.0 : Placement.getDistance(placement, (Placement)lecture3.getAssignment());
            if (d > sNoPreferenceLimit && d <= sProhibitedLimit) {
                ++n;
            }
            if (!(d > sDiscouragedLimit) || !(d <= sProhibitedLimit)) continue;
            ++n;
        }
        return n;
    }

    public int getPreference() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.iResource.length) {
            if (n2 % Constants.SLOTS_PER_DAY == 0 || this.iResource[n2] == null) {
                ++n2;
                continue;
            }
            if (this.iResource[n2 - 1] != null) {
                double d = Placement.getDistance((Placement)this.iResource[n2 - 1].getAssignment(), (Placement)this.iResource[n2].getAssignment());
                if (d > sNoPreferenceLimit && d <= sProhibitedLimit) {
                    ++n;
                }
                if (d > sDiscouragedLimit && d <= sProhibitedLimit) {
                    ++n;
                }
            }
            n2 += ((Placement)this.iResource[n2].getAssignment()).getTimeLocation().getLength();
        }
        return n;
    }

    public int getWorstPreference() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.iResource.length) {
            if (n2 % Constants.SLOTS_PER_DAY == 0 || this.iResource[n2] == null) {
                ++n2;
                continue;
            }
            if (this.iResource[n2 - 1] != null) {
                n += 2;
            }
            n2 += ((Placement)this.iResource[n2].getAssignment()).getTimeLocation().getLength();
        }
        return n;
    }
}

