/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.constraint;

import ifs.model.BinaryConstraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.Counter;
import java.util.Set;
import org.apache.log4j.Logger;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;
import ttsolver.model.TimeLocation;

public class JenrlConstraint
extends BinaryConstraint {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$constraint$JenrlConstraint == null ? (class$ttsolver$constraint$JenrlConstraint = JenrlConstraint.class$("ttsolver.constraint.JenrlConstraint")) : class$ttsolver$constraint$JenrlConstraint));
    private Counter iGlobalViolations;
    private long iJenrl;
    private boolean iAdded = false;
    static /* synthetic */ Class class$ttsolver$constraint$JenrlConstraint;

    public JenrlConstraint(long l, Counter counter) {
        this.iJenrl = l;
        this.iGlobalViolations = counter;
    }

    public void setViolatedCounter(Counter counter) {
        this.iGlobalViolations = counter;
    }

    public void computeConflicts(Value value, Set set) {
    }

    public boolean inConflict(Value value) {
        return false;
    }

    public boolean isConsistent(Value value, Value value2) {
        return true;
    }

    public void unassigned(long l, Value value) {
        super.unassigned(l, value);
        if (this.iAdded) {
            this.iGlobalViolations.dec(this.iJenrl);
            this.iAdded = false;
            ((Lecture)this.first()).removeActiveJenrl(this);
            ((Lecture)this.second()).removeActiveJenrl(this);
        }
    }

    public static boolean isInConflict(Placement placement, Placement placement2) {
        TimeLocation timeLocation;
        if (placement == null || placement2 == null) {
            return false;
        }
        TimeLocation timeLocation2 = placement.getTimeLocation();
        if (!timeLocation2.shareDays(timeLocation = placement2.getTimeLocation())) {
            return false;
        }
        if (timeLocation2.shareHours(timeLocation)) {
            return true;
        }
        int n = timeLocation2.getStartSlot();
        int n2 = timeLocation.getStartSlot();
        if (n + timeLocation2.getNrHalfHoursPerMeeting() != n2 && n2 + timeLocation.getNrHalfHoursPerMeeting() != n) {
            return false;
        }
        double d = Placement.getDistance(placement, placement2);
        if (d <= 67.0) {
            return false;
        }
        return !(d <= 100.0) || (timeLocation2.getLength() != 3 || n + timeLocation2.getLength() != n2) && (timeLocation.getLength() != 3 || n2 + timeLocation.getLength() != n);
    }

    public void assigned(long l, Value value) {
        super.assigned(l, value);
        if (this.second() == null || this.first().getAssignment() == null || this.second().getAssignment() == null) {
            return;
        }
        if (JenrlConstraint.isInConflict((Placement)this.first().getAssignment(), (Placement)this.second().getAssignment())) {
            this.iAdded = true;
            this.iGlobalViolations.inc(this.iJenrl);
            ((Lecture)this.first()).addActiveJenrl(this);
            ((Lecture)this.second()).addActiveJenrl(this);
        }
    }

    public long jenrl(Variable variable, Value value) {
        Lecture lecture = (Lecture)(this.first().equals((Object)variable) ? this.second() : this.first());
        if (lecture.getAssignment() == null) {
            return 0L;
        }
        Lecture lecture2 = (Lecture)variable;
        return JenrlConstraint.isInConflict((Placement)lecture.getAssignment(), (Placement)value) ? this.iJenrl : 0L;
    }

    public boolean isInConflict() {
        return this.iAdded;
    }

    public boolean isInConflictPrecise() {
        return JenrlConstraint.isInConflict((Placement)this.first().getAssignment(), (Placement)this.second().getAssignment());
    }

    public void incJenrl() {
        if (this.iJenrl == 0L) {
            ((Lecture)this.first()).addActiveJenrl(this);
            ((Lecture)this.second()).addActiveJenrl(this);
        }
        ++this.iJenrl;
        if (this.iAdded) {
            this.iGlobalViolations.inc(1L);
        }
    }

    public void decJenrl() {
        --this.iJenrl;
        if (this.iAdded) {
            this.iGlobalViolations.dec(1L);
        }
        if (this.iJenrl == 0L) {
            ((Lecture)this.first()).removeActiveJenrl(this);
            ((Lecture)this.second()).removeActiveJenrl(this);
        }
    }

    public long getJenrl() {
        return this.iJenrl;
    }

    public boolean isHard() {
        return false;
    }

    public String toString() {
        return "JENR{" + this.first().getName() + "," + this.second().getName() + "," + (this.iAdded ? this.iJenrl : 0L) + "/" + this.iJenrl + "}";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

