/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.constraint;

import edu.purdue.smas.timetable.util.Constants;
import ifs.model.Constraint;
import ifs.model.Value;
import java.util.Set;
import org.apache.log4j.Logger;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class RoomConstraint
extends Constraint {
    private static Logger sLogger = Logger.getLogger((Class)(class$ttsolver$constraint$RoomConstraint == null ? (class$ttsolver$constraint$RoomConstraint = RoomConstraint.class$("ttsolver.constraint.RoomConstraint")) : class$ttsolver$constraint$RoomConstraint));
    private Lecture[] iResource;
    private String iResourceId;
    private String iName;
    private int iSlotsPerDay;
    private int iDays;
    private long iPreference = 0L;
    private String iDescription = null;
    static /* synthetic */ Class class$ttsolver$constraint$RoomConstraint;

    public RoomConstraint(String string, String string2, int n, int n2, String string3) {
        this.iSlotsPerDay = n;
        this.iDays = n2;
        this.iResourceId = string;
        this.iName = string2;
        this.iResource = new Lecture[this.iSlotsPerDay * this.iDays];
        this.iDescription = string3;
        for (int i = 0; i < this.iResource.length; ++i) {
            this.iResource[i] = null;
        }
    }

    public String getResourceId() {
        return this.iResourceId;
    }

    public String getName() {
        return this.iName;
    }

    public int getSlotsPerDay() {
        return this.iSlotsPerDay;
    }

    public int getDays() {
        return this.iDays;
    }

    public void computeConflicts(Value value, Set set) {
        Placement placement = (Placement)value;
        if (!placement.getRoomId().equals(this.getResourceId())) {
            return;
        }
        Lecture lecture = (Lecture)value.variable();
        for (int i = 0; i < placement.getTimeLocation().getSlots().length; ++i) {
            int n = placement.getTimeLocation().getSlots()[i];
            Lecture lecture2 = this.iResource[n];
            if (lecture2 == null || lecture.equals((Object)lecture2)) continue;
            set.add(lecture2.getAssignment());
        }
    }

    public boolean inConflict(Value value) {
        Placement placement = (Placement)value;
        if (!placement.getRoomId().equals(this.getResourceId())) {
            return false;
        }
        for (int i = 0; i < placement.getTimeLocation().getSlots().length; ++i) {
            int n = placement.getTimeLocation().getSlots()[i];
            if (this.iResource[n] == null) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(Value value, Value value2) {
        Placement placement = (Placement)value;
        Placement placement2 = (Placement)value2;
        return !placement.getRoomId().equals(this.getResourceId()) || !placement.getRoomId().equals(placement2.getRoomId()) || !placement.getTimeLocation().hasIntersection(placement2.getTimeLocation());
    }

    public void assigned(long l, Value value) {
        super.assigned(l, value);
        Placement placement = (Placement)value;
        if (placement.getRoomId() == null || !placement.getRoomId().equals(this.getResourceId())) {
            return;
        }
        this.iPreference += (long)placement.getRoomLocation().getPreference();
        Lecture lecture = (Lecture)value.variable();
        for (int i = 0; i < placement.getTimeLocation().getSlots().length; ++i) {
            int n = placement.getTimeLocation().getSlots()[i];
            this.iResource[n] = lecture;
        }
    }

    public void unassigned(long l, Value value) {
        super.unassigned(l, value);
        Placement placement = (Placement)value;
        if (placement.getRoomId() == null || !placement.getRoomId().equals(this.getResourceId())) {
            return;
        }
        this.iPreference -= (long)placement.getRoomLocation().getPreference();
        Lecture lecture = (Lecture)value.variable();
        for (int i = 0; i < placement.getTimeLocation().getSlots().length; ++i) {
            int n = placement.getTimeLocation().getSlots()[i];
            this.iResource[n] = null;
        }
    }

    public Lecture[] getResource() {
        return this.iResource;
    }

    public int countUselessSlots() {
        int n = 0;
        for (int i = 0; i < this.iDays; ++i) {
            for (int j = 1; j < this.iSlotsPerDay - 1; ++j) {
                int n2 = i * this.iSlotsPerDay + j;
                if (this.iResource[n2 - 1] == null || this.iResource[n2] != null || this.iResource[n2 + 1] == null) continue;
                ++n;
            }
        }
        return n;
    }

    protected void printUsage(StringBuffer stringBuffer) {
        for (int i = 0; i < this.getResource().length; ++i) {
            if (this.getResource()[i] == null) continue;
            int n = i / Constants.SLOTS_PER_DAY;
            int n2 = 450 + 30 * (i % Constants.SLOTS_PER_DAY);
            int n3 = n2 / 60;
            int n4 = n2 % 60;
            String string = Constants.DAY_NAMES_SHORT[n];
            int n5 = ((Placement)this.getResource()[i].getAssignment()).getTimeLocation().getLength();
            int n6 = (n2 += 30 * n5) / 60;
            int n7 = n2 % 60;
            stringBuffer.append(stringBuffer.length() == 0 ? "" : ",\n        ").append("[" + string + (n3 > 12 ? n3 - 12 : n3) + ":" + (n4 < 10 ? "0" : "") + n4 + (n3 >= 12 ? "pm" : "am") + "-" + (n6 > 12 ? n6 - 12 : n6) + ":" + (n7 < 10 ? "0" : "") + n7 + (n6 >= 12 ? "pm" : "am") + "]=").append(this.iResource[i].getName());
            i += n5 - 1;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Room{name=" + this.getName() + " preference=" + this.iPreference);
        this.printUsage(stringBuffer);
        stringBuffer.append("\n      }");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return this.iDescription;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

