/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.heuristics;

import ifs.util.FastVector;
import java.util.Enumeration;
import java.util.Vector;

public class HeuristicSelector {
    private double[] iThreshKoef;
    private Vector iElements = new FastVector();
    private double iBestValueZero = 0.0;

    public HeuristicSelector(double[] dArray) {
        this.iThreshKoef = dArray;
    }

    public boolean add(double[] dArray, Object object) {
        if (this.iElements.isEmpty() || dArray[0] < this.iBestValueZero) {
            this.iBestValueZero = dArray[0];
            this.iElements.addElement(new Element(dArray, object));
            return true;
        }
        double d = dArray[0];
        double d2 = this.iBestValueZero < 0.0 ? 1.0 - this.iThreshKoef[0] : 1.0 + this.iThreshKoef[0];
        if (d <= this.iBestValueZero * d2) {
            this.iElements.addElement(new Element(dArray, object));
            return true;
        }
        return false;
    }

    public Vector selection() {
        Vector vector = this.iElements;
        double d = this.iBestValueZero;
        for (int i = 0; i < this.iThreshKoef.length; ++i) {
            FastVector fastVector = new FastVector(vector.size());
            double d2 = (d < 0.0 ? 1.0 - this.iThreshKoef[i] : 1.0 + this.iThreshKoef[i]) * d;
            double d3 = 0.0;
            boolean bl = i + 1 == this.iThreshKoef.length;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                if (!(element.getValue(i) <= d2)) continue;
                if (!bl && (fastVector.isEmpty() || element.getValue(i + 1) < d3)) {
                    d3 = element.getValue(i + 1);
                }
                fastVector.addElement(element);
            }
            vector = fastVector;
            d = d3;
        }
        return vector;
    }

    public class Element {
        private double[] iValues;
        private Object iObject;

        private Element(double[] dArray, Object object) {
            this.iValues = dArray;
            this.iObject = object;
        }

        public double[] getValues() {
            return this.iValues;
        }

        public double getValue(int n) {
            return this.iValues[n];
        }

        public Object getObject() {
            return this.iObject;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.iValues.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(this.iValues[i]);
            }
            return "[" + stringBuffer + "]:" + this.iObject;
        }
    }
}

